/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A specification about how data from the configured table can be used in a query.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnalysisRule implements SdkPojo, Serializable, ToCopyableBuilder<AnalysisRule.Builder, AnalysisRule> {
    private static final SdkField<String> COLLABORATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("collaborationId").getter(getter(AnalysisRule::collaborationId)).setter(setter(Builder::collaborationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationId").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(AnalysisRule::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(AnalysisRule::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createTime").getter(getter(AnalysisRule::createTime)).setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateTime").getter(getter(AnalysisRule::updateTime)).setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build()).build();

    private static final SdkField<AnalysisRulePolicy> POLICY_FIELD = SdkField
            .<AnalysisRulePolicy> builder(MarshallingType.SDK_POJO).memberName("policy").getter(getter(AnalysisRule::policy))
            .setter(setter(Builder::policy)).constructor(AnalysisRulePolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLABORATION_ID_FIELD,
            TYPE_FIELD, NAME_FIELD, CREATE_TIME_FIELD, UPDATE_TIME_FIELD, POLICY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String collaborationId;

    private final String type;

    private final String name;

    private final Instant createTime;

    private final Instant updateTime;

    private final AnalysisRulePolicy policy;

    private AnalysisRule(BuilderImpl builder) {
        this.collaborationId = builder.collaborationId;
        this.type = builder.type;
        this.name = builder.name;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.policy = builder.policy;
    }

    /**
     * <p>
     * The unique ID for the associated collaboration.
     * </p>
     * 
     * @return The unique ID for the associated collaboration.
     */
    public final String collaborationId() {
        return collaborationId;
    }

    /**
     * <p>
     * The type of analysis rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link AnalysisRuleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of analysis rule.
     * @see AnalysisRuleType
     */
    public final AnalysisRuleType type() {
        return AnalysisRuleType.fromValue(type);
    }

    /**
     * <p>
     * The type of analysis rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link AnalysisRuleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of analysis rule.
     * @see AnalysisRuleType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The name for the analysis rule.
     * </p>
     * 
     * @return The name for the analysis rule.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The time the analysis rule was created.
     * </p>
     * 
     * @return The time the analysis rule was created.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The time the analysis rule was last updated.
     * </p>
     * 
     * @return The time the analysis rule was last updated.
     */
    public final Instant updateTime() {
        return updateTime;
    }

    /**
     * <p>
     * A policy that describes the associated data usage limitations.
     * </p>
     * 
     * @return A policy that describes the associated data usage limitations.
     */
    public final AnalysisRulePolicy policy() {
        return policy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(collaborationId());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(policy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalysisRule)) {
            return false;
        }
        AnalysisRule other = (AnalysisRule) obj;
        return Objects.equals(collaborationId(), other.collaborationId()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(name(), other.name()) && Objects.equals(createTime(), other.createTime())
                && Objects.equals(updateTime(), other.updateTime()) && Objects.equals(policy(), other.policy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnalysisRule").add("CollaborationId", collaborationId()).add("Type", typeAsString())
                .add("Name", name()).add("CreateTime", createTime()).add("UpdateTime", updateTime()).add("Policy", policy())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "collaborationId":
            return Optional.ofNullable(clazz.cast(collaborationId()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "createTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "updateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        case "policy":
            return Optional.ofNullable(clazz.cast(policy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnalysisRule, T> g) {
        return obj -> g.apply((AnalysisRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnalysisRule> {
        /**
         * <p>
         * The unique ID for the associated collaboration.
         * </p>
         * 
         * @param collaborationId
         *        The unique ID for the associated collaboration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationId(String collaborationId);

        /**
         * <p>
         * The type of analysis rule.
         * </p>
         * 
         * @param type
         *        The type of analysis rule.
         * @see AnalysisRuleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalysisRuleType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of analysis rule.
         * </p>
         * 
         * @param type
         *        The type of analysis rule.
         * @see AnalysisRuleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalysisRuleType
         */
        Builder type(AnalysisRuleType type);

        /**
         * <p>
         * The name for the analysis rule.
         * </p>
         * 
         * @param name
         *        The name for the analysis rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The time the analysis rule was created.
         * </p>
         * 
         * @param createTime
         *        The time the analysis rule was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The time the analysis rule was last updated.
         * </p>
         * 
         * @param updateTime
         *        The time the analysis rule was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);

        /**
         * <p>
         * A policy that describes the associated data usage limitations.
         * </p>
         * 
         * @param policy
         *        A policy that describes the associated data usage limitations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policy(AnalysisRulePolicy policy);

        /**
         * <p>
         * A policy that describes the associated data usage limitations.
         * </p>
         * This is a convenience method that creates an instance of the {@link AnalysisRulePolicy.Builder} avoiding the
         * need to create one manually via {@link AnalysisRulePolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AnalysisRulePolicy.Builder#build()} is called immediately and its
         * result is passed to {@link #policy(AnalysisRulePolicy)}.
         * 
         * @param policy
         *        a consumer that will call methods on {@link AnalysisRulePolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policy(AnalysisRulePolicy)
         */
        default Builder policy(Consumer<AnalysisRulePolicy.Builder> policy) {
            return policy(AnalysisRulePolicy.builder().applyMutation(policy).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String collaborationId;

        private String type;

        private String name;

        private Instant createTime;

        private Instant updateTime;

        private AnalysisRulePolicy policy;

        private BuilderImpl() {
        }

        private BuilderImpl(AnalysisRule model) {
            collaborationId(model.collaborationId);
            type(model.type);
            name(model.name);
            createTime(model.createTime);
            updateTime(model.updateTime);
            policy(model.policy);
        }

        public final String getCollaborationId() {
            return collaborationId;
        }

        public final void setCollaborationId(String collaborationId) {
            this.collaborationId = collaborationId;
        }

        @Override
        public final Builder collaborationId(String collaborationId) {
            this.collaborationId = collaborationId;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(AnalysisRuleType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final AnalysisRulePolicy.Builder getPolicy() {
            return policy != null ? policy.toBuilder() : null;
        }

        public final void setPolicy(AnalysisRulePolicy.BuilderImpl policy) {
            this.policy = policy != null ? policy.build() : null;
        }

        @Override
        public final Builder policy(AnalysisRulePolicy policy) {
            this.policy = policy;
            return this;
        }

        @Override
        public AnalysisRule build() {
            return new AnalysisRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
