/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCollaborationResponse extends CleanRoomsResponse implements
        ToCopyableBuilder<GetCollaborationResponse.Builder, GetCollaborationResponse> {
    private static final SdkField<Collaboration> COLLABORATION_FIELD = SdkField.<Collaboration> builder(MarshallingType.SDK_POJO)
            .memberName("collaboration").getter(getter(GetCollaborationResponse::collaboration))
            .setter(setter(Builder::collaboration)).constructor(Collaboration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaboration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLABORATION_FIELD));

    private final Collaboration collaboration;

    private GetCollaborationResponse(BuilderImpl builder) {
        super(builder);
        this.collaboration = builder.collaboration;
    }

    /**
     * <p>
     * The entire collaboration for this identifier.
     * </p>
     * 
     * @return The entire collaboration for this identifier.
     */
    public final Collaboration collaboration() {
        return collaboration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(collaboration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCollaborationResponse)) {
            return false;
        }
        GetCollaborationResponse other = (GetCollaborationResponse) obj;
        return Objects.equals(collaboration(), other.collaboration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCollaborationResponse").add("Collaboration", collaboration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "collaboration":
            return Optional.ofNullable(clazz.cast(collaboration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCollaborationResponse, T> g) {
        return obj -> g.apply((GetCollaborationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CleanRoomsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetCollaborationResponse> {
        /**
         * <p>
         * The entire collaboration for this identifier.
         * </p>
         * 
         * @param collaboration
         *        The entire collaboration for this identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaboration(Collaboration collaboration);

        /**
         * <p>
         * The entire collaboration for this identifier.
         * </p>
         * This is a convenience method that creates an instance of the {@link Collaboration.Builder} avoiding the need
         * to create one manually via {@link Collaboration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Collaboration.Builder#build()} is called immediately and its
         * result is passed to {@link #collaboration(Collaboration)}.
         * 
         * @param collaboration
         *        a consumer that will call methods on {@link Collaboration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #collaboration(Collaboration)
         */
        default Builder collaboration(Consumer<Collaboration.Builder> collaboration) {
            return collaboration(Collaboration.builder().applyMutation(collaboration).build());
        }
    }

    static final class BuilderImpl extends CleanRoomsResponse.BuilderImpl implements Builder {
        private Collaboration collaboration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCollaborationResponse model) {
            super(model);
            collaboration(model.collaboration);
        }

        public final Collaboration.Builder getCollaboration() {
            return collaboration != null ? collaboration.toBuilder() : null;
        }

        public final void setCollaboration(Collaboration.BuilderImpl collaboration) {
            this.collaboration = collaboration != null ? collaboration.build() : null;
        }

        @Override
        public final Builder collaboration(Collaboration collaboration) {
            this.collaboration = collaboration;
            return this;
        }

        @Override
        public GetCollaborationResponse build() {
            return new GetCollaborationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
