/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.cleanrooms.model.AccessDeniedException;
import software.amazon.awssdk.services.cleanrooms.model.BatchGetCollaborationAnalysisTemplateRequest;
import software.amazon.awssdk.services.cleanrooms.model.BatchGetCollaborationAnalysisTemplateResponse;
import software.amazon.awssdk.services.cleanrooms.model.BatchGetSchemaRequest;
import software.amazon.awssdk.services.cleanrooms.model.BatchGetSchemaResponse;
import software.amazon.awssdk.services.cleanrooms.model.CleanRoomsException;
import software.amazon.awssdk.services.cleanrooms.model.ConflictException;
import software.amazon.awssdk.services.cleanrooms.model.CreateAnalysisTemplateRequest;
import software.amazon.awssdk.services.cleanrooms.model.CreateAnalysisTemplateResponse;
import software.amazon.awssdk.services.cleanrooms.model.CreateCollaborationRequest;
import software.amazon.awssdk.services.cleanrooms.model.CreateCollaborationResponse;
import software.amazon.awssdk.services.cleanrooms.model.CreateConfiguredTableAnalysisRuleRequest;
import software.amazon.awssdk.services.cleanrooms.model.CreateConfiguredTableAnalysisRuleResponse;
import software.amazon.awssdk.services.cleanrooms.model.CreateConfiguredTableAssociationRequest;
import software.amazon.awssdk.services.cleanrooms.model.CreateConfiguredTableAssociationResponse;
import software.amazon.awssdk.services.cleanrooms.model.CreateConfiguredTableRequest;
import software.amazon.awssdk.services.cleanrooms.model.CreateConfiguredTableResponse;
import software.amazon.awssdk.services.cleanrooms.model.CreateMembershipRequest;
import software.amazon.awssdk.services.cleanrooms.model.CreateMembershipResponse;
import software.amazon.awssdk.services.cleanrooms.model.DeleteAnalysisTemplateRequest;
import software.amazon.awssdk.services.cleanrooms.model.DeleteAnalysisTemplateResponse;
import software.amazon.awssdk.services.cleanrooms.model.DeleteCollaborationRequest;
import software.amazon.awssdk.services.cleanrooms.model.DeleteCollaborationResponse;
import software.amazon.awssdk.services.cleanrooms.model.DeleteConfiguredTableAnalysisRuleRequest;
import software.amazon.awssdk.services.cleanrooms.model.DeleteConfiguredTableAnalysisRuleResponse;
import software.amazon.awssdk.services.cleanrooms.model.DeleteConfiguredTableAssociationRequest;
import software.amazon.awssdk.services.cleanrooms.model.DeleteConfiguredTableAssociationResponse;
import software.amazon.awssdk.services.cleanrooms.model.DeleteConfiguredTableRequest;
import software.amazon.awssdk.services.cleanrooms.model.DeleteConfiguredTableResponse;
import software.amazon.awssdk.services.cleanrooms.model.DeleteMemberRequest;
import software.amazon.awssdk.services.cleanrooms.model.DeleteMemberResponse;
import software.amazon.awssdk.services.cleanrooms.model.DeleteMembershipRequest;
import software.amazon.awssdk.services.cleanrooms.model.DeleteMembershipResponse;
import software.amazon.awssdk.services.cleanrooms.model.GetAnalysisTemplateRequest;
import software.amazon.awssdk.services.cleanrooms.model.GetAnalysisTemplateResponse;
import software.amazon.awssdk.services.cleanrooms.model.GetCollaborationAnalysisTemplateRequest;
import software.amazon.awssdk.services.cleanrooms.model.GetCollaborationAnalysisTemplateResponse;
import software.amazon.awssdk.services.cleanrooms.model.GetCollaborationRequest;
import software.amazon.awssdk.services.cleanrooms.model.GetCollaborationResponse;
import software.amazon.awssdk.services.cleanrooms.model.GetConfiguredTableAnalysisRuleRequest;
import software.amazon.awssdk.services.cleanrooms.model.GetConfiguredTableAnalysisRuleResponse;
import software.amazon.awssdk.services.cleanrooms.model.GetConfiguredTableAssociationRequest;
import software.amazon.awssdk.services.cleanrooms.model.GetConfiguredTableAssociationResponse;
import software.amazon.awssdk.services.cleanrooms.model.GetConfiguredTableRequest;
import software.amazon.awssdk.services.cleanrooms.model.GetConfiguredTableResponse;
import software.amazon.awssdk.services.cleanrooms.model.GetMembershipRequest;
import software.amazon.awssdk.services.cleanrooms.model.GetMembershipResponse;
import software.amazon.awssdk.services.cleanrooms.model.GetProtectedQueryRequest;
import software.amazon.awssdk.services.cleanrooms.model.GetProtectedQueryResponse;
import software.amazon.awssdk.services.cleanrooms.model.GetSchemaAnalysisRuleRequest;
import software.amazon.awssdk.services.cleanrooms.model.GetSchemaAnalysisRuleResponse;
import software.amazon.awssdk.services.cleanrooms.model.GetSchemaRequest;
import software.amazon.awssdk.services.cleanrooms.model.GetSchemaResponse;
import software.amazon.awssdk.services.cleanrooms.model.InternalServerException;
import software.amazon.awssdk.services.cleanrooms.model.ListAnalysisTemplatesRequest;
import software.amazon.awssdk.services.cleanrooms.model.ListAnalysisTemplatesResponse;
import software.amazon.awssdk.services.cleanrooms.model.ListCollaborationAnalysisTemplatesRequest;
import software.amazon.awssdk.services.cleanrooms.model.ListCollaborationAnalysisTemplatesResponse;
import software.amazon.awssdk.services.cleanrooms.model.ListCollaborationsRequest;
import software.amazon.awssdk.services.cleanrooms.model.ListCollaborationsResponse;
import software.amazon.awssdk.services.cleanrooms.model.ListConfiguredTableAssociationsRequest;
import software.amazon.awssdk.services.cleanrooms.model.ListConfiguredTableAssociationsResponse;
import software.amazon.awssdk.services.cleanrooms.model.ListConfiguredTablesRequest;
import software.amazon.awssdk.services.cleanrooms.model.ListConfiguredTablesResponse;
import software.amazon.awssdk.services.cleanrooms.model.ListMembersRequest;
import software.amazon.awssdk.services.cleanrooms.model.ListMembersResponse;
import software.amazon.awssdk.services.cleanrooms.model.ListMembershipsRequest;
import software.amazon.awssdk.services.cleanrooms.model.ListMembershipsResponse;
import software.amazon.awssdk.services.cleanrooms.model.ListProtectedQueriesRequest;
import software.amazon.awssdk.services.cleanrooms.model.ListProtectedQueriesResponse;
import software.amazon.awssdk.services.cleanrooms.model.ListSchemasRequest;
import software.amazon.awssdk.services.cleanrooms.model.ListSchemasResponse;
import software.amazon.awssdk.services.cleanrooms.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.cleanrooms.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.cleanrooms.model.ResourceNotFoundException;
import software.amazon.awssdk.services.cleanrooms.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.cleanrooms.model.StartProtectedQueryRequest;
import software.amazon.awssdk.services.cleanrooms.model.StartProtectedQueryResponse;
import software.amazon.awssdk.services.cleanrooms.model.TagResourceRequest;
import software.amazon.awssdk.services.cleanrooms.model.TagResourceResponse;
import software.amazon.awssdk.services.cleanrooms.model.ThrottlingException;
import software.amazon.awssdk.services.cleanrooms.model.UntagResourceRequest;
import software.amazon.awssdk.services.cleanrooms.model.UntagResourceResponse;
import software.amazon.awssdk.services.cleanrooms.model.UpdateAnalysisTemplateRequest;
import software.amazon.awssdk.services.cleanrooms.model.UpdateAnalysisTemplateResponse;
import software.amazon.awssdk.services.cleanrooms.model.UpdateCollaborationRequest;
import software.amazon.awssdk.services.cleanrooms.model.UpdateCollaborationResponse;
import software.amazon.awssdk.services.cleanrooms.model.UpdateConfiguredTableAnalysisRuleRequest;
import software.amazon.awssdk.services.cleanrooms.model.UpdateConfiguredTableAnalysisRuleResponse;
import software.amazon.awssdk.services.cleanrooms.model.UpdateConfiguredTableAssociationRequest;
import software.amazon.awssdk.services.cleanrooms.model.UpdateConfiguredTableAssociationResponse;
import software.amazon.awssdk.services.cleanrooms.model.UpdateConfiguredTableRequest;
import software.amazon.awssdk.services.cleanrooms.model.UpdateConfiguredTableResponse;
import software.amazon.awssdk.services.cleanrooms.model.UpdateMembershipRequest;
import software.amazon.awssdk.services.cleanrooms.model.UpdateMembershipResponse;
import software.amazon.awssdk.services.cleanrooms.model.UpdateProtectedQueryRequest;
import software.amazon.awssdk.services.cleanrooms.model.UpdateProtectedQueryResponse;
import software.amazon.awssdk.services.cleanrooms.model.ValidationException;
import software.amazon.awssdk.services.cleanrooms.paginators.ListAnalysisTemplatesIterable;
import software.amazon.awssdk.services.cleanrooms.paginators.ListCollaborationAnalysisTemplatesIterable;
import software.amazon.awssdk.services.cleanrooms.paginators.ListCollaborationsIterable;
import software.amazon.awssdk.services.cleanrooms.paginators.ListConfiguredTableAssociationsIterable;
import software.amazon.awssdk.services.cleanrooms.paginators.ListConfiguredTablesIterable;
import software.amazon.awssdk.services.cleanrooms.paginators.ListMembersIterable;
import software.amazon.awssdk.services.cleanrooms.paginators.ListMembershipsIterable;
import software.amazon.awssdk.services.cleanrooms.paginators.ListProtectedQueriesIterable;
import software.amazon.awssdk.services.cleanrooms.paginators.ListSchemasIterable;

/**
 * Service client for accessing AWS Clean Rooms Service. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Welcome to the <i>Clean Rooms API Reference</i>.
 * </p>
 * <p>
 * Clean Rooms is an Amazon Web Services service that helps multiple parties to join their data together in a secure
 * collaboration workspace. In the collaboration, members who can query and receive results can get insights into the
 * collective datasets without either party getting access to the other party's raw data.
 * </p>
 * <p>
 * To learn more about Clean Rooms concepts, procedures, and best practices, see the <a
 * href="https://docs.aws.amazon.com/clean-rooms/latest/userguide/what-is.html">Clean Rooms User Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface CleanRoomsClient extends AwsClient {
    String SERVICE_NAME = "cleanrooms";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "cleanrooms";

    /**
     * <p>
     * Retrieves multiple analysis templates within a collaboration by their Amazon Resource Names (ARNs).
     * </p>
     *
     * @param batchGetCollaborationAnalysisTemplateRequest
     * @return Result of the BatchGetCollaborationAnalysisTemplate operation returned by the service.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.BatchGetCollaborationAnalysisTemplate
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/BatchGetCollaborationAnalysisTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetCollaborationAnalysisTemplateResponse batchGetCollaborationAnalysisTemplate(
            BatchGetCollaborationAnalysisTemplateRequest batchGetCollaborationAnalysisTemplateRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves multiple analysis templates within a collaboration by their Amazon Resource Names (ARNs).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link BatchGetCollaborationAnalysisTemplateRequest.Builder} avoiding the need to create one manually via
     * {@link BatchGetCollaborationAnalysisTemplateRequest#builder()}
     * </p>
     *
     * @param batchGetCollaborationAnalysisTemplateRequest
     *        A {@link Consumer} that will call methods on {@link BatchGetCollaborationAnalysisTemplateInput.Builder} to
     *        create a request.
     * @return Result of the BatchGetCollaborationAnalysisTemplate operation returned by the service.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.BatchGetCollaborationAnalysisTemplate
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/BatchGetCollaborationAnalysisTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetCollaborationAnalysisTemplateResponse batchGetCollaborationAnalysisTemplate(
            Consumer<BatchGetCollaborationAnalysisTemplateRequest.Builder> batchGetCollaborationAnalysisTemplateRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsException {
        return batchGetCollaborationAnalysisTemplate(BatchGetCollaborationAnalysisTemplateRequest.builder()
                .applyMutation(batchGetCollaborationAnalysisTemplateRequest).build());
    }

    /**
     * <p>
     * Retrieves multiple schemas by their identifiers.
     * </p>
     *
     * @param batchGetSchemaRequest
     * @return Result of the BatchGetSchema operation returned by the service.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.BatchGetSchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/BatchGetSchema" target="_top">AWS API
     *      Documentation</a>
     */
    default BatchGetSchemaResponse batchGetSchema(BatchGetSchemaRequest batchGetSchemaRequest) throws ResourceNotFoundException,
            InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, CleanRoomsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves multiple schemas by their identifiers.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetSchemaRequest.Builder} avoiding the need to
     * create one manually via {@link BatchGetSchemaRequest#builder()}
     * </p>
     *
     * @param batchGetSchemaRequest
     *        A {@link Consumer} that will call methods on {@link BatchGetSchemaInput.Builder} to create a request.
     * @return Result of the BatchGetSchema operation returned by the service.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.BatchGetSchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/BatchGetSchema" target="_top">AWS API
     *      Documentation</a>
     */
    default BatchGetSchemaResponse batchGetSchema(Consumer<BatchGetSchemaRequest.Builder> batchGetSchemaRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsException {
        return batchGetSchema(BatchGetSchemaRequest.builder().applyMutation(batchGetSchemaRequest).build());
    }

    /**
     * <p>
     * Creates a new analysis template.
     * </p>
     *
     * @param createAnalysisTemplateRequest
     * @return Result of the CreateAnalysisTemplate operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ServiceQuotaExceededException
     *         Request denied because service quota has been exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.CreateAnalysisTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/CreateAnalysisTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAnalysisTemplateResponse createAnalysisTemplate(CreateAnalysisTemplateRequest createAnalysisTemplateRequest)
            throws ConflictException, ServiceQuotaExceededException, ResourceNotFoundException, InternalServerException,
            ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            CleanRoomsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new analysis template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAnalysisTemplateRequest.Builder} avoiding the
     * need to create one manually via {@link CreateAnalysisTemplateRequest#builder()}
     * </p>
     *
     * @param createAnalysisTemplateRequest
     *        A {@link Consumer} that will call methods on {@link CreateAnalysisTemplateInput.Builder} to create a
     *        request.
     * @return Result of the CreateAnalysisTemplate operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ServiceQuotaExceededException
     *         Request denied because service quota has been exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.CreateAnalysisTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/CreateAnalysisTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAnalysisTemplateResponse createAnalysisTemplate(
            Consumer<CreateAnalysisTemplateRequest.Builder> createAnalysisTemplateRequest) throws ConflictException,
            ServiceQuotaExceededException, ResourceNotFoundException, InternalServerException, ValidationException,
            ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsException {
        return createAnalysisTemplate(CreateAnalysisTemplateRequest.builder().applyMutation(createAnalysisTemplateRequest)
                .build());
    }

    /**
     * <p>
     * Creates a new collaboration.
     * </p>
     *
     * @param createCollaborationRequest
     * @return Result of the CreateCollaboration operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request denied because service quota has been exceeded.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.CreateCollaboration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/CreateCollaboration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCollaborationResponse createCollaboration(CreateCollaborationRequest createCollaborationRequest)
            throws ServiceQuotaExceededException, InternalServerException, ValidationException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new collaboration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCollaborationRequest.Builder} avoiding the
     * need to create one manually via {@link CreateCollaborationRequest#builder()}
     * </p>
     *
     * @param createCollaborationRequest
     *        A {@link Consumer} that will call methods on {@link CreateCollaborationInput.Builder} to create a request.
     * @return Result of the CreateCollaboration operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request denied because service quota has been exceeded.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.CreateCollaboration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/CreateCollaboration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCollaborationResponse createCollaboration(
            Consumer<CreateCollaborationRequest.Builder> createCollaborationRequest) throws ServiceQuotaExceededException,
            InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, CleanRoomsException {
        return createCollaboration(CreateCollaborationRequest.builder().applyMutation(createCollaborationRequest).build());
    }

    /**
     * <p>
     * Creates a new configured table resource.
     * </p>
     *
     * @param createConfiguredTableRequest
     * @return Result of the CreateConfiguredTable operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ServiceQuotaExceededException
     *         Request denied because service quota has been exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.CreateConfiguredTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/CreateConfiguredTable"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateConfiguredTableResponse createConfiguredTable(CreateConfiguredTableRequest createConfiguredTableRequest)
            throws ConflictException, ServiceQuotaExceededException, ResourceNotFoundException, InternalServerException,
            ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            CleanRoomsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new configured table resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateConfiguredTableRequest.Builder} avoiding the
     * need to create one manually via {@link CreateConfiguredTableRequest#builder()}
     * </p>
     *
     * @param createConfiguredTableRequest
     *        A {@link Consumer} that will call methods on {@link CreateConfiguredTableInput.Builder} to create a
     *        request.
     * @return Result of the CreateConfiguredTable operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ServiceQuotaExceededException
     *         Request denied because service quota has been exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.CreateConfiguredTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/CreateConfiguredTable"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateConfiguredTableResponse createConfiguredTable(
            Consumer<CreateConfiguredTableRequest.Builder> createConfiguredTableRequest) throws ConflictException,
            ServiceQuotaExceededException, ResourceNotFoundException, InternalServerException, ValidationException,
            ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsException {
        return createConfiguredTable(CreateConfiguredTableRequest.builder().applyMutation(createConfiguredTableRequest).build());
    }

    /**
     * <p>
     * Creates a new analysis rule for a configured table. Currently, only one analysis rule can be created for a given
     * configured table.
     * </p>
     *
     * @param createConfiguredTableAnalysisRuleRequest
     * @return Result of the CreateConfiguredTableAnalysisRule operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.CreateConfiguredTableAnalysisRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/CreateConfiguredTableAnalysisRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateConfiguredTableAnalysisRuleResponse createConfiguredTableAnalysisRule(
            CreateConfiguredTableAnalysisRuleRequest createConfiguredTableAnalysisRuleRequest) throws ConflictException,
            ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException, AccessDeniedException,
            AwsServiceException, SdkClientException, CleanRoomsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new analysis rule for a configured table. Currently, only one analysis rule can be created for a given
     * configured table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateConfiguredTableAnalysisRuleRequest.Builder}
     * avoiding the need to create one manually via {@link CreateConfiguredTableAnalysisRuleRequest#builder()}
     * </p>
     *
     * @param createConfiguredTableAnalysisRuleRequest
     *        A {@link Consumer} that will call methods on {@link CreateConfiguredTableAnalysisRuleInput.Builder} to
     *        create a request.
     * @return Result of the CreateConfiguredTableAnalysisRule operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.CreateConfiguredTableAnalysisRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/CreateConfiguredTableAnalysisRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateConfiguredTableAnalysisRuleResponse createConfiguredTableAnalysisRule(
            Consumer<CreateConfiguredTableAnalysisRuleRequest.Builder> createConfiguredTableAnalysisRuleRequest)
            throws ConflictException, ResourceNotFoundException, InternalServerException, ValidationException,
            ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsException {
        return createConfiguredTableAnalysisRule(CreateConfiguredTableAnalysisRuleRequest.builder()
                .applyMutation(createConfiguredTableAnalysisRuleRequest).build());
    }

    /**
     * <p>
     * Creates a configured table association. A configured table association links a configured table with a
     * collaboration.
     * </p>
     *
     * @param createConfiguredTableAssociationRequest
     * @return Result of the CreateConfiguredTableAssociation operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ServiceQuotaExceededException
     *         Request denied because service quota has been exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.CreateConfiguredTableAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/CreateConfiguredTableAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateConfiguredTableAssociationResponse createConfiguredTableAssociation(
            CreateConfiguredTableAssociationRequest createConfiguredTableAssociationRequest) throws ConflictException,
            ServiceQuotaExceededException, ResourceNotFoundException, InternalServerException, ValidationException,
            ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a configured table association. A configured table association links a configured table with a
     * collaboration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateConfiguredTableAssociationRequest.Builder}
     * avoiding the need to create one manually via {@link CreateConfiguredTableAssociationRequest#builder()}
     * </p>
     *
     * @param createConfiguredTableAssociationRequest
     *        A {@link Consumer} that will call methods on {@link CreateConfiguredTableAssociationInput.Builder} to
     *        create a request.
     * @return Result of the CreateConfiguredTableAssociation operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ServiceQuotaExceededException
     *         Request denied because service quota has been exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.CreateConfiguredTableAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/CreateConfiguredTableAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateConfiguredTableAssociationResponse createConfiguredTableAssociation(
            Consumer<CreateConfiguredTableAssociationRequest.Builder> createConfiguredTableAssociationRequest)
            throws ConflictException, ServiceQuotaExceededException, ResourceNotFoundException, InternalServerException,
            ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            CleanRoomsException {
        return createConfiguredTableAssociation(CreateConfiguredTableAssociationRequest.builder()
                .applyMutation(createConfiguredTableAssociationRequest).build());
    }

    /**
     * <p>
     * Creates a membership for a specific collaboration identifier and joins the collaboration.
     * </p>
     *
     * @param createMembershipRequest
     * @return Result of the CreateMembership operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ServiceQuotaExceededException
     *         Request denied because service quota has been exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.CreateMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/CreateMembership" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateMembershipResponse createMembership(CreateMembershipRequest createMembershipRequest) throws ConflictException,
            ServiceQuotaExceededException, ResourceNotFoundException, InternalServerException, ValidationException,
            ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a membership for a specific collaboration identifier and joins the collaboration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMembershipRequest.Builder} avoiding the need
     * to create one manually via {@link CreateMembershipRequest#builder()}
     * </p>
     *
     * @param createMembershipRequest
     *        A {@link Consumer} that will call methods on {@link CreateMembershipInput.Builder} to create a request.
     * @return Result of the CreateMembership operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ServiceQuotaExceededException
     *         Request denied because service quota has been exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.CreateMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/CreateMembership" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateMembershipResponse createMembership(Consumer<CreateMembershipRequest.Builder> createMembershipRequest)
            throws ConflictException, ServiceQuotaExceededException, ResourceNotFoundException, InternalServerException,
            ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            CleanRoomsException {
        return createMembership(CreateMembershipRequest.builder().applyMutation(createMembershipRequest).build());
    }

    /**
     * <p>
     * Deletes an analysis template.
     * </p>
     *
     * @param deleteAnalysisTemplateRequest
     * @return Result of the DeleteAnalysisTemplate operation returned by the service.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.DeleteAnalysisTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/DeleteAnalysisTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAnalysisTemplateResponse deleteAnalysisTemplate(DeleteAnalysisTemplateRequest deleteAnalysisTemplateRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an analysis template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAnalysisTemplateRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteAnalysisTemplateRequest#builder()}
     * </p>
     *
     * @param deleteAnalysisTemplateRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAnalysisTemplateInput.Builder} to create a
     *        request.
     * @return Result of the DeleteAnalysisTemplate operation returned by the service.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.DeleteAnalysisTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/DeleteAnalysisTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAnalysisTemplateResponse deleteAnalysisTemplate(
            Consumer<DeleteAnalysisTemplateRequest.Builder> deleteAnalysisTemplateRequest) throws ResourceNotFoundException,
            InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, CleanRoomsException {
        return deleteAnalysisTemplate(DeleteAnalysisTemplateRequest.builder().applyMutation(deleteAnalysisTemplateRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a collaboration. It can only be called by the collaboration owner.
     * </p>
     *
     * @param deleteCollaborationRequest
     * @return Result of the DeleteCollaboration operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.DeleteCollaboration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/DeleteCollaboration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCollaborationResponse deleteCollaboration(DeleteCollaborationRequest deleteCollaborationRequest)
            throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, CleanRoomsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a collaboration. It can only be called by the collaboration owner.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCollaborationRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteCollaborationRequest#builder()}
     * </p>
     *
     * @param deleteCollaborationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteCollaborationInput.Builder} to create a request.
     * @return Result of the DeleteCollaboration operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.DeleteCollaboration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/DeleteCollaboration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCollaborationResponse deleteCollaboration(
            Consumer<DeleteCollaborationRequest.Builder> deleteCollaborationRequest) throws InternalServerException,
            ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            CleanRoomsException {
        return deleteCollaboration(DeleteCollaborationRequest.builder().applyMutation(deleteCollaborationRequest).build());
    }

    /**
     * <p>
     * Deletes a configured table.
     * </p>
     *
     * @param deleteConfiguredTableRequest
     * @return Result of the DeleteConfiguredTable operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.DeleteConfiguredTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/DeleteConfiguredTable"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConfiguredTableResponse deleteConfiguredTable(DeleteConfiguredTableRequest deleteConfiguredTableRequest)
            throws ConflictException, ResourceNotFoundException, InternalServerException, ValidationException,
            ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a configured table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConfiguredTableRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteConfiguredTableRequest#builder()}
     * </p>
     *
     * @param deleteConfiguredTableRequest
     *        A {@link Consumer} that will call methods on {@link DeleteConfiguredTableInput.Builder} to create a
     *        request.
     * @return Result of the DeleteConfiguredTable operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.DeleteConfiguredTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/DeleteConfiguredTable"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConfiguredTableResponse deleteConfiguredTable(
            Consumer<DeleteConfiguredTableRequest.Builder> deleteConfiguredTableRequest) throws ConflictException,
            ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException, AccessDeniedException,
            AwsServiceException, SdkClientException, CleanRoomsException {
        return deleteConfiguredTable(DeleteConfiguredTableRequest.builder().applyMutation(deleteConfiguredTableRequest).build());
    }

    /**
     * <p>
     * Deletes a configured table analysis rule.
     * </p>
     *
     * @param deleteConfiguredTableAnalysisRuleRequest
     * @return Result of the DeleteConfiguredTableAnalysisRule operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.DeleteConfiguredTableAnalysisRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/DeleteConfiguredTableAnalysisRule"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConfiguredTableAnalysisRuleResponse deleteConfiguredTableAnalysisRule(
            DeleteConfiguredTableAnalysisRuleRequest deleteConfiguredTableAnalysisRuleRequest) throws ConflictException,
            ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException, AccessDeniedException,
            AwsServiceException, SdkClientException, CleanRoomsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a configured table analysis rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConfiguredTableAnalysisRuleRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteConfiguredTableAnalysisRuleRequest#builder()}
     * </p>
     *
     * @param deleteConfiguredTableAnalysisRuleRequest
     *        A {@link Consumer} that will call methods on {@link DeleteConfiguredTableAnalysisRuleInput.Builder} to
     *        create a request.
     * @return Result of the DeleteConfiguredTableAnalysisRule operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.DeleteConfiguredTableAnalysisRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/DeleteConfiguredTableAnalysisRule"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConfiguredTableAnalysisRuleResponse deleteConfiguredTableAnalysisRule(
            Consumer<DeleteConfiguredTableAnalysisRuleRequest.Builder> deleteConfiguredTableAnalysisRuleRequest)
            throws ConflictException, ResourceNotFoundException, InternalServerException, ValidationException,
            ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsException {
        return deleteConfiguredTableAnalysisRule(DeleteConfiguredTableAnalysisRuleRequest.builder()
                .applyMutation(deleteConfiguredTableAnalysisRuleRequest).build());
    }

    /**
     * <p>
     * Deletes a configured table association.
     * </p>
     *
     * @param deleteConfiguredTableAssociationRequest
     * @return Result of the DeleteConfiguredTableAssociation operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.DeleteConfiguredTableAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/DeleteConfiguredTableAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConfiguredTableAssociationResponse deleteConfiguredTableAssociation(
            DeleteConfiguredTableAssociationRequest deleteConfiguredTableAssociationRequest) throws ConflictException,
            ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException, AccessDeniedException,
            AwsServiceException, SdkClientException, CleanRoomsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a configured table association.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConfiguredTableAssociationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteConfiguredTableAssociationRequest#builder()}
     * </p>
     *
     * @param deleteConfiguredTableAssociationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteConfiguredTableAssociationInput.Builder} to
     *        create a request.
     * @return Result of the DeleteConfiguredTableAssociation operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.DeleteConfiguredTableAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/DeleteConfiguredTableAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConfiguredTableAssociationResponse deleteConfiguredTableAssociation(
            Consumer<DeleteConfiguredTableAssociationRequest.Builder> deleteConfiguredTableAssociationRequest)
            throws ConflictException, ResourceNotFoundException, InternalServerException, ValidationException,
            ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsException {
        return deleteConfiguredTableAssociation(DeleteConfiguredTableAssociationRequest.builder()
                .applyMutation(deleteConfiguredTableAssociationRequest).build());
    }

    /**
     * <p>
     * Removes the specified member from a collaboration. The removed member is placed in the Removed status and can't
     * interact with the collaboration. The removed member's data is inaccessible to active members of the
     * collaboration.
     * </p>
     *
     * @param deleteMemberRequest
     * @return Result of the DeleteMember operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.DeleteMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/DeleteMember" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteMemberResponse deleteMember(DeleteMemberRequest deleteMemberRequest) throws ConflictException,
            ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException, AccessDeniedException,
            AwsServiceException, SdkClientException, CleanRoomsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified member from a collaboration. The removed member is placed in the Removed status and can't
     * interact with the collaboration. The removed member's data is inaccessible to active members of the
     * collaboration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMemberRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteMemberRequest#builder()}
     * </p>
     *
     * @param deleteMemberRequest
     *        A {@link Consumer} that will call methods on {@link DeleteMemberInput.Builder} to create a request.
     * @return Result of the DeleteMember operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.DeleteMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/DeleteMember" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteMemberResponse deleteMember(Consumer<DeleteMemberRequest.Builder> deleteMemberRequest)
            throws ConflictException, ResourceNotFoundException, InternalServerException, ValidationException,
            ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsException {
        return deleteMember(DeleteMemberRequest.builder().applyMutation(deleteMemberRequest).build());
    }

    /**
     * <p>
     * Deletes a specified membership. All resources under a membership must be deleted.
     * </p>
     *
     * @param deleteMembershipRequest
     * @return Result of the DeleteMembership operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.DeleteMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/DeleteMembership" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteMembershipResponse deleteMembership(DeleteMembershipRequest deleteMembershipRequest) throws ConflictException,
            ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException, AccessDeniedException,
            AwsServiceException, SdkClientException, CleanRoomsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specified membership. All resources under a membership must be deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMembershipRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteMembershipRequest#builder()}
     * </p>
     *
     * @param deleteMembershipRequest
     *        A {@link Consumer} that will call methods on {@link DeleteMembershipInput.Builder} to create a request.
     * @return Result of the DeleteMembership operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.DeleteMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/DeleteMembership" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteMembershipResponse deleteMembership(Consumer<DeleteMembershipRequest.Builder> deleteMembershipRequest)
            throws ConflictException, ResourceNotFoundException, InternalServerException, ValidationException,
            ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsException {
        return deleteMembership(DeleteMembershipRequest.builder().applyMutation(deleteMembershipRequest).build());
    }

    /**
     * <p>
     * Retrieves an analysis template.
     * </p>
     *
     * @param getAnalysisTemplateRequest
     * @return Result of the GetAnalysisTemplate operation returned by the service.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.GetAnalysisTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/GetAnalysisTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAnalysisTemplateResponse getAnalysisTemplate(GetAnalysisTemplateRequest getAnalysisTemplateRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves an analysis template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAnalysisTemplateRequest.Builder} avoiding the
     * need to create one manually via {@link GetAnalysisTemplateRequest#builder()}
     * </p>
     *
     * @param getAnalysisTemplateRequest
     *        A {@link Consumer} that will call methods on {@link GetAnalysisTemplateInput.Builder} to create a request.
     * @return Result of the GetAnalysisTemplate operation returned by the service.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.GetAnalysisTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/GetAnalysisTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAnalysisTemplateResponse getAnalysisTemplate(
            Consumer<GetAnalysisTemplateRequest.Builder> getAnalysisTemplateRequest) throws ResourceNotFoundException,
            InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, CleanRoomsException {
        return getAnalysisTemplate(GetAnalysisTemplateRequest.builder().applyMutation(getAnalysisTemplateRequest).build());
    }

    /**
     * <p>
     * Returns metadata about a collaboration.
     * </p>
     *
     * @param getCollaborationRequest
     * @return Result of the GetCollaboration operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.GetCollaboration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/GetCollaboration" target="_top">AWS
     *      API Documentation</a>
     */
    default GetCollaborationResponse getCollaboration(GetCollaborationRequest getCollaborationRequest)
            throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, CleanRoomsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns metadata about a collaboration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCollaborationRequest.Builder} avoiding the need
     * to create one manually via {@link GetCollaborationRequest#builder()}
     * </p>
     *
     * @param getCollaborationRequest
     *        A {@link Consumer} that will call methods on {@link GetCollaborationInput.Builder} to create a request.
     * @return Result of the GetCollaboration operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.GetCollaboration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/GetCollaboration" target="_top">AWS
     *      API Documentation</a>
     */
    default GetCollaborationResponse getCollaboration(Consumer<GetCollaborationRequest.Builder> getCollaborationRequest)
            throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, CleanRoomsException {
        return getCollaboration(GetCollaborationRequest.builder().applyMutation(getCollaborationRequest).build());
    }

    /**
     * <p>
     * Retrieves an analysis template within a collaboration.
     * </p>
     *
     * @param getCollaborationAnalysisTemplateRequest
     * @return Result of the GetCollaborationAnalysisTemplate operation returned by the service.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.GetCollaborationAnalysisTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/GetCollaborationAnalysisTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCollaborationAnalysisTemplateResponse getCollaborationAnalysisTemplate(
            GetCollaborationAnalysisTemplateRequest getCollaborationAnalysisTemplateRequest) throws ResourceNotFoundException,
            InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, CleanRoomsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves an analysis template within a collaboration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCollaborationAnalysisTemplateRequest.Builder}
     * avoiding the need to create one manually via {@link GetCollaborationAnalysisTemplateRequest#builder()}
     * </p>
     *
     * @param getCollaborationAnalysisTemplateRequest
     *        A {@link Consumer} that will call methods on {@link GetCollaborationAnalysisTemplateInput.Builder} to
     *        create a request.
     * @return Result of the GetCollaborationAnalysisTemplate operation returned by the service.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.GetCollaborationAnalysisTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/GetCollaborationAnalysisTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCollaborationAnalysisTemplateResponse getCollaborationAnalysisTemplate(
            Consumer<GetCollaborationAnalysisTemplateRequest.Builder> getCollaborationAnalysisTemplateRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsException {
        return getCollaborationAnalysisTemplate(GetCollaborationAnalysisTemplateRequest.builder()
                .applyMutation(getCollaborationAnalysisTemplateRequest).build());
    }

    /**
     * <p>
     * Retrieves a configured table.
     * </p>
     *
     * @param getConfiguredTableRequest
     * @return Result of the GetConfiguredTable operation returned by the service.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.GetConfiguredTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/GetConfiguredTable" target="_top">AWS
     *      API Documentation</a>
     */
    default GetConfiguredTableResponse getConfiguredTable(GetConfiguredTableRequest getConfiguredTableRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a configured table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConfiguredTableRequest.Builder} avoiding the
     * need to create one manually via {@link GetConfiguredTableRequest#builder()}
     * </p>
     *
     * @param getConfiguredTableRequest
     *        A {@link Consumer} that will call methods on {@link GetConfiguredTableInput.Builder} to create a request.
     * @return Result of the GetConfiguredTable operation returned by the service.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.GetConfiguredTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/GetConfiguredTable" target="_top">AWS
     *      API Documentation</a>
     */
    default GetConfiguredTableResponse getConfiguredTable(Consumer<GetConfiguredTableRequest.Builder> getConfiguredTableRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsException {
        return getConfiguredTable(GetConfiguredTableRequest.builder().applyMutation(getConfiguredTableRequest).build());
    }

    /**
     * <p>
     * Retrieves a configured table analysis rule.
     * </p>
     *
     * @param getConfiguredTableAnalysisRuleRequest
     * @return Result of the GetConfiguredTableAnalysisRule operation returned by the service.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.GetConfiguredTableAnalysisRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/GetConfiguredTableAnalysisRule"
     *      target="_top">AWS API Documentation</a>
     */
    default GetConfiguredTableAnalysisRuleResponse getConfiguredTableAnalysisRule(
            GetConfiguredTableAnalysisRuleRequest getConfiguredTableAnalysisRuleRequest) throws ResourceNotFoundException,
            InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, CleanRoomsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a configured table analysis rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConfiguredTableAnalysisRuleRequest.Builder}
     * avoiding the need to create one manually via {@link GetConfiguredTableAnalysisRuleRequest#builder()}
     * </p>
     *
     * @param getConfiguredTableAnalysisRuleRequest
     *        A {@link Consumer} that will call methods on {@link GetConfiguredTableAnalysisRuleInput.Builder} to create
     *        a request.
     * @return Result of the GetConfiguredTableAnalysisRule operation returned by the service.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.GetConfiguredTableAnalysisRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/GetConfiguredTableAnalysisRule"
     *      target="_top">AWS API Documentation</a>
     */
    default GetConfiguredTableAnalysisRuleResponse getConfiguredTableAnalysisRule(
            Consumer<GetConfiguredTableAnalysisRuleRequest.Builder> getConfiguredTableAnalysisRuleRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsException {
        return getConfiguredTableAnalysisRule(GetConfiguredTableAnalysisRuleRequest.builder()
                .applyMutation(getConfiguredTableAnalysisRuleRequest).build());
    }

    /**
     * <p>
     * Retrieves a configured table association.
     * </p>
     *
     * @param getConfiguredTableAssociationRequest
     * @return Result of the GetConfiguredTableAssociation operation returned by the service.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.GetConfiguredTableAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/GetConfiguredTableAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default GetConfiguredTableAssociationResponse getConfiguredTableAssociation(
            GetConfiguredTableAssociationRequest getConfiguredTableAssociationRequest) throws ResourceNotFoundException,
            InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, CleanRoomsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a configured table association.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConfiguredTableAssociationRequest.Builder}
     * avoiding the need to create one manually via {@link GetConfiguredTableAssociationRequest#builder()}
     * </p>
     *
     * @param getConfiguredTableAssociationRequest
     *        A {@link Consumer} that will call methods on {@link GetConfiguredTableAssociationInput.Builder} to create
     *        a request.
     * @return Result of the GetConfiguredTableAssociation operation returned by the service.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.GetConfiguredTableAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/GetConfiguredTableAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default GetConfiguredTableAssociationResponse getConfiguredTableAssociation(
            Consumer<GetConfiguredTableAssociationRequest.Builder> getConfiguredTableAssociationRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsException {
        return getConfiguredTableAssociation(GetConfiguredTableAssociationRequest.builder()
                .applyMutation(getConfiguredTableAssociationRequest).build());
    }

    /**
     * <p>
     * Retrieves a specified membership for an identifier.
     * </p>
     *
     * @param getMembershipRequest
     * @return Result of the GetMembership operation returned by the service.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.GetMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/GetMembership" target="_top">AWS API
     *      Documentation</a>
     */
    default GetMembershipResponse getMembership(GetMembershipRequest getMembershipRequest) throws ResourceNotFoundException,
            InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, CleanRoomsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a specified membership for an identifier.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMembershipRequest.Builder} avoiding the need to
     * create one manually via {@link GetMembershipRequest#builder()}
     * </p>
     *
     * @param getMembershipRequest
     *        A {@link Consumer} that will call methods on {@link GetMembershipInput.Builder} to create a request.
     * @return Result of the GetMembership operation returned by the service.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.GetMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/GetMembership" target="_top">AWS API
     *      Documentation</a>
     */
    default GetMembershipResponse getMembership(Consumer<GetMembershipRequest.Builder> getMembershipRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsException {
        return getMembership(GetMembershipRequest.builder().applyMutation(getMembershipRequest).build());
    }

    /**
     * <p>
     * Returns query processing metadata.
     * </p>
     *
     * @param getProtectedQueryRequest
     * @return Result of the GetProtectedQuery operation returned by the service.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.GetProtectedQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/GetProtectedQuery" target="_top">AWS
     *      API Documentation</a>
     */
    default GetProtectedQueryResponse getProtectedQuery(GetProtectedQueryRequest getProtectedQueryRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns query processing metadata.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetProtectedQueryRequest.Builder} avoiding the need
     * to create one manually via {@link GetProtectedQueryRequest#builder()}
     * </p>
     *
     * @param getProtectedQueryRequest
     *        A {@link Consumer} that will call methods on {@link GetProtectedQueryInput.Builder} to create a request.
     * @return Result of the GetProtectedQuery operation returned by the service.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.GetProtectedQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/GetProtectedQuery" target="_top">AWS
     *      API Documentation</a>
     */
    default GetProtectedQueryResponse getProtectedQuery(Consumer<GetProtectedQueryRequest.Builder> getProtectedQueryRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsException {
        return getProtectedQuery(GetProtectedQueryRequest.builder().applyMutation(getProtectedQueryRequest).build());
    }

    /**
     * <p>
     * Retrieves the schema for a relation within a collaboration.
     * </p>
     *
     * @param getSchemaRequest
     * @return Result of the GetSchema operation returned by the service.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.GetSchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/GetSchema" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSchemaResponse getSchema(GetSchemaRequest getSchemaRequest) throws ResourceNotFoundException,
            InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, CleanRoomsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the schema for a relation within a collaboration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSchemaRequest.Builder} avoiding the need to
     * create one manually via {@link GetSchemaRequest#builder()}
     * </p>
     *
     * @param getSchemaRequest
     *        A {@link Consumer} that will call methods on {@link GetSchemaInput.Builder} to create a request.
     * @return Result of the GetSchema operation returned by the service.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.GetSchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/GetSchema" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSchemaResponse getSchema(Consumer<GetSchemaRequest.Builder> getSchemaRequest) throws ResourceNotFoundException,
            InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, CleanRoomsException {
        return getSchema(GetSchemaRequest.builder().applyMutation(getSchemaRequest).build());
    }

    /**
     * <p>
     * Retrieves a schema analysis rule.
     * </p>
     *
     * @param getSchemaAnalysisRuleRequest
     * @return Result of the GetSchemaAnalysisRule operation returned by the service.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.GetSchemaAnalysisRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/GetSchemaAnalysisRule"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSchemaAnalysisRuleResponse getSchemaAnalysisRule(GetSchemaAnalysisRuleRequest getSchemaAnalysisRuleRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a schema analysis rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSchemaAnalysisRuleRequest.Builder} avoiding the
     * need to create one manually via {@link GetSchemaAnalysisRuleRequest#builder()}
     * </p>
     *
     * @param getSchemaAnalysisRuleRequest
     *        A {@link Consumer} that will call methods on {@link GetSchemaAnalysisRuleInput.Builder} to create a
     *        request.
     * @return Result of the GetSchemaAnalysisRule operation returned by the service.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.GetSchemaAnalysisRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/GetSchemaAnalysisRule"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSchemaAnalysisRuleResponse getSchemaAnalysisRule(
            Consumer<GetSchemaAnalysisRuleRequest.Builder> getSchemaAnalysisRuleRequest) throws ResourceNotFoundException,
            InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, CleanRoomsException {
        return getSchemaAnalysisRule(GetSchemaAnalysisRuleRequest.builder().applyMutation(getSchemaAnalysisRuleRequest).build());
    }

    /**
     * <p>
     * Lists analysis templates that the caller owns.
     * </p>
     *
     * @param listAnalysisTemplatesRequest
     * @return Result of the ListAnalysisTemplates operation returned by the service.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.ListAnalysisTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListAnalysisTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAnalysisTemplatesResponse listAnalysisTemplates(ListAnalysisTemplatesRequest listAnalysisTemplatesRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists analysis templates that the caller owns.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAnalysisTemplatesRequest.Builder} avoiding the
     * need to create one manually via {@link ListAnalysisTemplatesRequest#builder()}
     * </p>
     *
     * @param listAnalysisTemplatesRequest
     *        A {@link Consumer} that will call methods on {@link ListAnalysisTemplatesInput.Builder} to create a
     *        request.
     * @return Result of the ListAnalysisTemplates operation returned by the service.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.ListAnalysisTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListAnalysisTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAnalysisTemplatesResponse listAnalysisTemplates(
            Consumer<ListAnalysisTemplatesRequest.Builder> listAnalysisTemplatesRequest) throws ResourceNotFoundException,
            InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, CleanRoomsException {
        return listAnalysisTemplates(ListAnalysisTemplatesRequest.builder().applyMutation(listAnalysisTemplatesRequest).build());
    }

    /**
     * <p>
     * Lists analysis templates that the caller owns.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAnalysisTemplates(software.amazon.awssdk.services.cleanrooms.model.ListAnalysisTemplatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanrooms.paginators.ListAnalysisTemplatesIterable responses = client.listAnalysisTemplatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cleanrooms.paginators.ListAnalysisTemplatesIterable responses = client
     *             .listAnalysisTemplatesPaginator(request);
     *     for (software.amazon.awssdk.services.cleanrooms.model.ListAnalysisTemplatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanrooms.paginators.ListAnalysisTemplatesIterable responses = client.listAnalysisTemplatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAnalysisTemplates(software.amazon.awssdk.services.cleanrooms.model.ListAnalysisTemplatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAnalysisTemplatesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.ListAnalysisTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListAnalysisTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAnalysisTemplatesIterable listAnalysisTemplatesPaginator(ListAnalysisTemplatesRequest listAnalysisTemplatesRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsException {
        return new ListAnalysisTemplatesIterable(this, listAnalysisTemplatesRequest);
    }

    /**
     * <p>
     * Lists analysis templates that the caller owns.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAnalysisTemplates(software.amazon.awssdk.services.cleanrooms.model.ListAnalysisTemplatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanrooms.paginators.ListAnalysisTemplatesIterable responses = client.listAnalysisTemplatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cleanrooms.paginators.ListAnalysisTemplatesIterable responses = client
     *             .listAnalysisTemplatesPaginator(request);
     *     for (software.amazon.awssdk.services.cleanrooms.model.ListAnalysisTemplatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanrooms.paginators.ListAnalysisTemplatesIterable responses = client.listAnalysisTemplatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAnalysisTemplates(software.amazon.awssdk.services.cleanrooms.model.ListAnalysisTemplatesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAnalysisTemplatesRequest.Builder} avoiding the
     * need to create one manually via {@link ListAnalysisTemplatesRequest#builder()}
     * </p>
     *
     * @param listAnalysisTemplatesRequest
     *        A {@link Consumer} that will call methods on {@link ListAnalysisTemplatesInput.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.ListAnalysisTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListAnalysisTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAnalysisTemplatesIterable listAnalysisTemplatesPaginator(
            Consumer<ListAnalysisTemplatesRequest.Builder> listAnalysisTemplatesRequest) throws ResourceNotFoundException,
            InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, CleanRoomsException {
        return listAnalysisTemplatesPaginator(ListAnalysisTemplatesRequest.builder().applyMutation(listAnalysisTemplatesRequest)
                .build());
    }

    /**
     * <p>
     * Lists analysis templates within a collaboration.
     * </p>
     *
     * @param listCollaborationAnalysisTemplatesRequest
     * @return Result of the ListCollaborationAnalysisTemplates operation returned by the service.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.ListCollaborationAnalysisTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListCollaborationAnalysisTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCollaborationAnalysisTemplatesResponse listCollaborationAnalysisTemplates(
            ListCollaborationAnalysisTemplatesRequest listCollaborationAnalysisTemplatesRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists analysis templates within a collaboration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCollaborationAnalysisTemplatesRequest.Builder}
     * avoiding the need to create one manually via {@link ListCollaborationAnalysisTemplatesRequest#builder()}
     * </p>
     *
     * @param listCollaborationAnalysisTemplatesRequest
     *        A {@link Consumer} that will call methods on {@link ListCollaborationAnalysisTemplatesInput.Builder} to
     *        create a request.
     * @return Result of the ListCollaborationAnalysisTemplates operation returned by the service.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.ListCollaborationAnalysisTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListCollaborationAnalysisTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCollaborationAnalysisTemplatesResponse listCollaborationAnalysisTemplates(
            Consumer<ListCollaborationAnalysisTemplatesRequest.Builder> listCollaborationAnalysisTemplatesRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsException {
        return listCollaborationAnalysisTemplates(ListCollaborationAnalysisTemplatesRequest.builder()
                .applyMutation(listCollaborationAnalysisTemplatesRequest).build());
    }

    /**
     * <p>
     * Lists analysis templates within a collaboration.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCollaborationAnalysisTemplates(software.amazon.awssdk.services.cleanrooms.model.ListCollaborationAnalysisTemplatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanrooms.paginators.ListCollaborationAnalysisTemplatesIterable responses = client.listCollaborationAnalysisTemplatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cleanrooms.paginators.ListCollaborationAnalysisTemplatesIterable responses = client
     *             .listCollaborationAnalysisTemplatesPaginator(request);
     *     for (software.amazon.awssdk.services.cleanrooms.model.ListCollaborationAnalysisTemplatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanrooms.paginators.ListCollaborationAnalysisTemplatesIterable responses = client.listCollaborationAnalysisTemplatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCollaborationAnalysisTemplates(software.amazon.awssdk.services.cleanrooms.model.ListCollaborationAnalysisTemplatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCollaborationAnalysisTemplatesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.ListCollaborationAnalysisTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListCollaborationAnalysisTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCollaborationAnalysisTemplatesIterable listCollaborationAnalysisTemplatesPaginator(
            ListCollaborationAnalysisTemplatesRequest listCollaborationAnalysisTemplatesRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsException {
        return new ListCollaborationAnalysisTemplatesIterable(this, listCollaborationAnalysisTemplatesRequest);
    }

    /**
     * <p>
     * Lists analysis templates within a collaboration.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCollaborationAnalysisTemplates(software.amazon.awssdk.services.cleanrooms.model.ListCollaborationAnalysisTemplatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanrooms.paginators.ListCollaborationAnalysisTemplatesIterable responses = client.listCollaborationAnalysisTemplatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cleanrooms.paginators.ListCollaborationAnalysisTemplatesIterable responses = client
     *             .listCollaborationAnalysisTemplatesPaginator(request);
     *     for (software.amazon.awssdk.services.cleanrooms.model.ListCollaborationAnalysisTemplatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanrooms.paginators.ListCollaborationAnalysisTemplatesIterable responses = client.listCollaborationAnalysisTemplatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCollaborationAnalysisTemplates(software.amazon.awssdk.services.cleanrooms.model.ListCollaborationAnalysisTemplatesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCollaborationAnalysisTemplatesRequest.Builder}
     * avoiding the need to create one manually via {@link ListCollaborationAnalysisTemplatesRequest#builder()}
     * </p>
     *
     * @param listCollaborationAnalysisTemplatesRequest
     *        A {@link Consumer} that will call methods on {@link ListCollaborationAnalysisTemplatesInput.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.ListCollaborationAnalysisTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListCollaborationAnalysisTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCollaborationAnalysisTemplatesIterable listCollaborationAnalysisTemplatesPaginator(
            Consumer<ListCollaborationAnalysisTemplatesRequest.Builder> listCollaborationAnalysisTemplatesRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsException {
        return listCollaborationAnalysisTemplatesPaginator(ListCollaborationAnalysisTemplatesRequest.builder()
                .applyMutation(listCollaborationAnalysisTemplatesRequest).build());
    }

    /**
     * <p>
     * Lists collaborations the caller owns, is active in, or has been invited to.
     * </p>
     *
     * @param listCollaborationsRequest
     * @return Result of the ListCollaborations operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.ListCollaborations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListCollaborations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListCollaborationsResponse listCollaborations(ListCollaborationsRequest listCollaborationsRequest)
            throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, CleanRoomsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists collaborations the caller owns, is active in, or has been invited to.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCollaborationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListCollaborationsRequest#builder()}
     * </p>
     *
     * @param listCollaborationsRequest
     *        A {@link Consumer} that will call methods on {@link ListCollaborationsInput.Builder} to create a request.
     * @return Result of the ListCollaborations operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.ListCollaborations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListCollaborations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListCollaborationsResponse listCollaborations(Consumer<ListCollaborationsRequest.Builder> listCollaborationsRequest)
            throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, CleanRoomsException {
        return listCollaborations(ListCollaborationsRequest.builder().applyMutation(listCollaborationsRequest).build());
    }

    /**
     * <p>
     * Lists collaborations the caller owns, is active in, or has been invited to.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCollaborations(software.amazon.awssdk.services.cleanrooms.model.ListCollaborationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanrooms.paginators.ListCollaborationsIterable responses = client.listCollaborationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cleanrooms.paginators.ListCollaborationsIterable responses = client
     *             .listCollaborationsPaginator(request);
     *     for (software.amazon.awssdk.services.cleanrooms.model.ListCollaborationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanrooms.paginators.ListCollaborationsIterable responses = client.listCollaborationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCollaborations(software.amazon.awssdk.services.cleanrooms.model.ListCollaborationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCollaborationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.ListCollaborations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListCollaborations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListCollaborationsIterable listCollaborationsPaginator(ListCollaborationsRequest listCollaborationsRequest)
            throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, CleanRoomsException {
        return new ListCollaborationsIterable(this, listCollaborationsRequest);
    }

    /**
     * <p>
     * Lists collaborations the caller owns, is active in, or has been invited to.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCollaborations(software.amazon.awssdk.services.cleanrooms.model.ListCollaborationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanrooms.paginators.ListCollaborationsIterable responses = client.listCollaborationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cleanrooms.paginators.ListCollaborationsIterable responses = client
     *             .listCollaborationsPaginator(request);
     *     for (software.amazon.awssdk.services.cleanrooms.model.ListCollaborationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanrooms.paginators.ListCollaborationsIterable responses = client.listCollaborationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCollaborations(software.amazon.awssdk.services.cleanrooms.model.ListCollaborationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCollaborationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListCollaborationsRequest#builder()}
     * </p>
     *
     * @param listCollaborationsRequest
     *        A {@link Consumer} that will call methods on {@link ListCollaborationsInput.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.ListCollaborations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListCollaborations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListCollaborationsIterable listCollaborationsPaginator(
            Consumer<ListCollaborationsRequest.Builder> listCollaborationsRequest) throws InternalServerException,
            ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            CleanRoomsException {
        return listCollaborationsPaginator(ListCollaborationsRequest.builder().applyMutation(listCollaborationsRequest).build());
    }

    /**
     * <p>
     * Lists configured table associations for a membership.
     * </p>
     *
     * @param listConfiguredTableAssociationsRequest
     * @return Result of the ListConfiguredTableAssociations operation returned by the service.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.ListConfiguredTableAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListConfiguredTableAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConfiguredTableAssociationsResponse listConfiguredTableAssociations(
            ListConfiguredTableAssociationsRequest listConfiguredTableAssociationsRequest) throws ResourceNotFoundException,
            InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, CleanRoomsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists configured table associations for a membership.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConfiguredTableAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListConfiguredTableAssociationsRequest#builder()}
     * </p>
     *
     * @param listConfiguredTableAssociationsRequest
     *        A {@link Consumer} that will call methods on {@link ListConfiguredTableAssociationsInput.Builder} to
     *        create a request.
     * @return Result of the ListConfiguredTableAssociations operation returned by the service.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.ListConfiguredTableAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListConfiguredTableAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConfiguredTableAssociationsResponse listConfiguredTableAssociations(
            Consumer<ListConfiguredTableAssociationsRequest.Builder> listConfiguredTableAssociationsRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsException {
        return listConfiguredTableAssociations(ListConfiguredTableAssociationsRequest.builder()
                .applyMutation(listConfiguredTableAssociationsRequest).build());
    }

    /**
     * <p>
     * Lists configured table associations for a membership.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listConfiguredTableAssociations(software.amazon.awssdk.services.cleanrooms.model.ListConfiguredTableAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanrooms.paginators.ListConfiguredTableAssociationsIterable responses = client.listConfiguredTableAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cleanrooms.paginators.ListConfiguredTableAssociationsIterable responses = client
     *             .listConfiguredTableAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.cleanrooms.model.ListConfiguredTableAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanrooms.paginators.ListConfiguredTableAssociationsIterable responses = client.listConfiguredTableAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConfiguredTableAssociations(software.amazon.awssdk.services.cleanrooms.model.ListConfiguredTableAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listConfiguredTableAssociationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.ListConfiguredTableAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListConfiguredTableAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConfiguredTableAssociationsIterable listConfiguredTableAssociationsPaginator(
            ListConfiguredTableAssociationsRequest listConfiguredTableAssociationsRequest) throws ResourceNotFoundException,
            InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, CleanRoomsException {
        return new ListConfiguredTableAssociationsIterable(this, listConfiguredTableAssociationsRequest);
    }

    /**
     * <p>
     * Lists configured table associations for a membership.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listConfiguredTableAssociations(software.amazon.awssdk.services.cleanrooms.model.ListConfiguredTableAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanrooms.paginators.ListConfiguredTableAssociationsIterable responses = client.listConfiguredTableAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cleanrooms.paginators.ListConfiguredTableAssociationsIterable responses = client
     *             .listConfiguredTableAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.cleanrooms.model.ListConfiguredTableAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanrooms.paginators.ListConfiguredTableAssociationsIterable responses = client.listConfiguredTableAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConfiguredTableAssociations(software.amazon.awssdk.services.cleanrooms.model.ListConfiguredTableAssociationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConfiguredTableAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListConfiguredTableAssociationsRequest#builder()}
     * </p>
     *
     * @param listConfiguredTableAssociationsRequest
     *        A {@link Consumer} that will call methods on {@link ListConfiguredTableAssociationsInput.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.ListConfiguredTableAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListConfiguredTableAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConfiguredTableAssociationsIterable listConfiguredTableAssociationsPaginator(
            Consumer<ListConfiguredTableAssociationsRequest.Builder> listConfiguredTableAssociationsRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsException {
        return listConfiguredTableAssociationsPaginator(ListConfiguredTableAssociationsRequest.builder()
                .applyMutation(listConfiguredTableAssociationsRequest).build());
    }

    /**
     * <p>
     * Lists configured tables.
     * </p>
     *
     * @param listConfiguredTablesRequest
     * @return Result of the ListConfiguredTables operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.ListConfiguredTables
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListConfiguredTables"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConfiguredTablesResponse listConfiguredTables(ListConfiguredTablesRequest listConfiguredTablesRequest)
            throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, CleanRoomsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists configured tables.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConfiguredTablesRequest.Builder} avoiding the
     * need to create one manually via {@link ListConfiguredTablesRequest#builder()}
     * </p>
     *
     * @param listConfiguredTablesRequest
     *        A {@link Consumer} that will call methods on {@link ListConfiguredTablesInput.Builder} to create a
     *        request.
     * @return Result of the ListConfiguredTables operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.ListConfiguredTables
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListConfiguredTables"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConfiguredTablesResponse listConfiguredTables(
            Consumer<ListConfiguredTablesRequest.Builder> listConfiguredTablesRequest) throws InternalServerException,
            ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            CleanRoomsException {
        return listConfiguredTables(ListConfiguredTablesRequest.builder().applyMutation(listConfiguredTablesRequest).build());
    }

    /**
     * <p>
     * Lists configured tables.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listConfiguredTables(software.amazon.awssdk.services.cleanrooms.model.ListConfiguredTablesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanrooms.paginators.ListConfiguredTablesIterable responses = client.listConfiguredTablesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cleanrooms.paginators.ListConfiguredTablesIterable responses = client
     *             .listConfiguredTablesPaginator(request);
     *     for (software.amazon.awssdk.services.cleanrooms.model.ListConfiguredTablesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanrooms.paginators.ListConfiguredTablesIterable responses = client.listConfiguredTablesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConfiguredTables(software.amazon.awssdk.services.cleanrooms.model.ListConfiguredTablesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listConfiguredTablesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.ListConfiguredTables
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListConfiguredTables"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConfiguredTablesIterable listConfiguredTablesPaginator(ListConfiguredTablesRequest listConfiguredTablesRequest)
            throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, CleanRoomsException {
        return new ListConfiguredTablesIterable(this, listConfiguredTablesRequest);
    }

    /**
     * <p>
     * Lists configured tables.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listConfiguredTables(software.amazon.awssdk.services.cleanrooms.model.ListConfiguredTablesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanrooms.paginators.ListConfiguredTablesIterable responses = client.listConfiguredTablesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cleanrooms.paginators.ListConfiguredTablesIterable responses = client
     *             .listConfiguredTablesPaginator(request);
     *     for (software.amazon.awssdk.services.cleanrooms.model.ListConfiguredTablesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanrooms.paginators.ListConfiguredTablesIterable responses = client.listConfiguredTablesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConfiguredTables(software.amazon.awssdk.services.cleanrooms.model.ListConfiguredTablesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConfiguredTablesRequest.Builder} avoiding the
     * need to create one manually via {@link ListConfiguredTablesRequest#builder()}
     * </p>
     *
     * @param listConfiguredTablesRequest
     *        A {@link Consumer} that will call methods on {@link ListConfiguredTablesInput.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.ListConfiguredTables
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListConfiguredTables"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConfiguredTablesIterable listConfiguredTablesPaginator(
            Consumer<ListConfiguredTablesRequest.Builder> listConfiguredTablesRequest) throws InternalServerException,
            ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            CleanRoomsException {
        return listConfiguredTablesPaginator(ListConfiguredTablesRequest.builder().applyMutation(listConfiguredTablesRequest)
                .build());
    }

    /**
     * <p>
     * Lists all members within a collaboration.
     * </p>
     *
     * @param listMembersRequest
     * @return Result of the ListMembers operation returned by the service.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.ListMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMembersResponse listMembers(ListMembersRequest listMembersRequest) throws ResourceNotFoundException,
            InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, CleanRoomsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all members within a collaboration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMembersRequest.Builder} avoiding the need to
     * create one manually via {@link ListMembersRequest#builder()}
     * </p>
     *
     * @param listMembersRequest
     *        A {@link Consumer} that will call methods on {@link ListMembersInput.Builder} to create a request.
     * @return Result of the ListMembers operation returned by the service.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.ListMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMembersResponse listMembers(Consumer<ListMembersRequest.Builder> listMembersRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsException {
        return listMembers(ListMembersRequest.builder().applyMutation(listMembersRequest).build());
    }

    /**
     * <p>
     * Lists all members within a collaboration.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listMembers(software.amazon.awssdk.services.cleanrooms.model.ListMembersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanrooms.paginators.ListMembersIterable responses = client.listMembersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cleanrooms.paginators.ListMembersIterable responses = client.listMembersPaginator(request);
     *     for (software.amazon.awssdk.services.cleanrooms.model.ListMembersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanrooms.paginators.ListMembersIterable responses = client.listMembersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMembers(software.amazon.awssdk.services.cleanrooms.model.ListMembersRequest)} operation.</b>
     * </p>
     *
     * @param listMembersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.ListMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMembersIterable listMembersPaginator(ListMembersRequest listMembersRequest) throws ResourceNotFoundException,
            InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, CleanRoomsException {
        return new ListMembersIterable(this, listMembersRequest);
    }

    /**
     * <p>
     * Lists all members within a collaboration.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listMembers(software.amazon.awssdk.services.cleanrooms.model.ListMembersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanrooms.paginators.ListMembersIterable responses = client.listMembersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cleanrooms.paginators.ListMembersIterable responses = client.listMembersPaginator(request);
     *     for (software.amazon.awssdk.services.cleanrooms.model.ListMembersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanrooms.paginators.ListMembersIterable responses = client.listMembersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMembers(software.amazon.awssdk.services.cleanrooms.model.ListMembersRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMembersRequest.Builder} avoiding the need to
     * create one manually via {@link ListMembersRequest#builder()}
     * </p>
     *
     * @param listMembersRequest
     *        A {@link Consumer} that will call methods on {@link ListMembersInput.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.ListMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMembersIterable listMembersPaginator(Consumer<ListMembersRequest.Builder> listMembersRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsException {
        return listMembersPaginator(ListMembersRequest.builder().applyMutation(listMembersRequest).build());
    }

    /**
     * <p>
     * Lists all memberships resources within the caller's account.
     * </p>
     *
     * @param listMembershipsRequest
     * @return Result of the ListMemberships operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.ListMemberships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListMemberships" target="_top">AWS
     *      API Documentation</a>
     */
    default ListMembershipsResponse listMemberships(ListMembershipsRequest listMembershipsRequest)
            throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, CleanRoomsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all memberships resources within the caller's account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMembershipsRequest.Builder} avoiding the need
     * to create one manually via {@link ListMembershipsRequest#builder()}
     * </p>
     *
     * @param listMembershipsRequest
     *        A {@link Consumer} that will call methods on {@link ListMembershipsInput.Builder} to create a request.
     * @return Result of the ListMemberships operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.ListMemberships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListMemberships" target="_top">AWS
     *      API Documentation</a>
     */
    default ListMembershipsResponse listMemberships(Consumer<ListMembershipsRequest.Builder> listMembershipsRequest)
            throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, CleanRoomsException {
        return listMemberships(ListMembershipsRequest.builder().applyMutation(listMembershipsRequest).build());
    }

    /**
     * <p>
     * Lists all memberships resources within the caller's account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listMemberships(software.amazon.awssdk.services.cleanrooms.model.ListMembershipsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanrooms.paginators.ListMembershipsIterable responses = client.listMembershipsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cleanrooms.paginators.ListMembershipsIterable responses = client
     *             .listMembershipsPaginator(request);
     *     for (software.amazon.awssdk.services.cleanrooms.model.ListMembershipsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanrooms.paginators.ListMembershipsIterable responses = client.listMembershipsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMemberships(software.amazon.awssdk.services.cleanrooms.model.ListMembershipsRequest)} operation.</b>
     * </p>
     *
     * @param listMembershipsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.ListMemberships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListMemberships" target="_top">AWS
     *      API Documentation</a>
     */
    default ListMembershipsIterable listMembershipsPaginator(ListMembershipsRequest listMembershipsRequest)
            throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, CleanRoomsException {
        return new ListMembershipsIterable(this, listMembershipsRequest);
    }

    /**
     * <p>
     * Lists all memberships resources within the caller's account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listMemberships(software.amazon.awssdk.services.cleanrooms.model.ListMembershipsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanrooms.paginators.ListMembershipsIterable responses = client.listMembershipsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cleanrooms.paginators.ListMembershipsIterable responses = client
     *             .listMembershipsPaginator(request);
     *     for (software.amazon.awssdk.services.cleanrooms.model.ListMembershipsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanrooms.paginators.ListMembershipsIterable responses = client.listMembershipsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMemberships(software.amazon.awssdk.services.cleanrooms.model.ListMembershipsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMembershipsRequest.Builder} avoiding the need
     * to create one manually via {@link ListMembershipsRequest#builder()}
     * </p>
     *
     * @param listMembershipsRequest
     *        A {@link Consumer} that will call methods on {@link ListMembershipsInput.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.ListMemberships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListMemberships" target="_top">AWS
     *      API Documentation</a>
     */
    default ListMembershipsIterable listMembershipsPaginator(Consumer<ListMembershipsRequest.Builder> listMembershipsRequest)
            throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, CleanRoomsException {
        return listMembershipsPaginator(ListMembershipsRequest.builder().applyMutation(listMembershipsRequest).build());
    }

    /**
     * <p>
     * Lists protected queries, sorted by the most recent query.
     * </p>
     *
     * @param listProtectedQueriesRequest
     * @return Result of the ListProtectedQueries operation returned by the service.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.ListProtectedQueries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListProtectedQueries"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProtectedQueriesResponse listProtectedQueries(ListProtectedQueriesRequest listProtectedQueriesRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists protected queries, sorted by the most recent query.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProtectedQueriesRequest.Builder} avoiding the
     * need to create one manually via {@link ListProtectedQueriesRequest#builder()}
     * </p>
     *
     * @param listProtectedQueriesRequest
     *        A {@link Consumer} that will call methods on {@link ListProtectedQueriesInput.Builder} to create a
     *        request.
     * @return Result of the ListProtectedQueries operation returned by the service.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.ListProtectedQueries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListProtectedQueries"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProtectedQueriesResponse listProtectedQueries(
            Consumer<ListProtectedQueriesRequest.Builder> listProtectedQueriesRequest) throws ResourceNotFoundException,
            InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, CleanRoomsException {
        return listProtectedQueries(ListProtectedQueriesRequest.builder().applyMutation(listProtectedQueriesRequest).build());
    }

    /**
     * <p>
     * Lists protected queries, sorted by the most recent query.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listProtectedQueries(software.amazon.awssdk.services.cleanrooms.model.ListProtectedQueriesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanrooms.paginators.ListProtectedQueriesIterable responses = client.listProtectedQueriesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cleanrooms.paginators.ListProtectedQueriesIterable responses = client
     *             .listProtectedQueriesPaginator(request);
     *     for (software.amazon.awssdk.services.cleanrooms.model.ListProtectedQueriesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanrooms.paginators.ListProtectedQueriesIterable responses = client.listProtectedQueriesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProtectedQueries(software.amazon.awssdk.services.cleanrooms.model.ListProtectedQueriesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listProtectedQueriesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.ListProtectedQueries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListProtectedQueries"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProtectedQueriesIterable listProtectedQueriesPaginator(ListProtectedQueriesRequest listProtectedQueriesRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsException {
        return new ListProtectedQueriesIterable(this, listProtectedQueriesRequest);
    }

    /**
     * <p>
     * Lists protected queries, sorted by the most recent query.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listProtectedQueries(software.amazon.awssdk.services.cleanrooms.model.ListProtectedQueriesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanrooms.paginators.ListProtectedQueriesIterable responses = client.listProtectedQueriesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cleanrooms.paginators.ListProtectedQueriesIterable responses = client
     *             .listProtectedQueriesPaginator(request);
     *     for (software.amazon.awssdk.services.cleanrooms.model.ListProtectedQueriesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanrooms.paginators.ListProtectedQueriesIterable responses = client.listProtectedQueriesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProtectedQueries(software.amazon.awssdk.services.cleanrooms.model.ListProtectedQueriesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProtectedQueriesRequest.Builder} avoiding the
     * need to create one manually via {@link ListProtectedQueriesRequest#builder()}
     * </p>
     *
     * @param listProtectedQueriesRequest
     *        A {@link Consumer} that will call methods on {@link ListProtectedQueriesInput.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.ListProtectedQueries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListProtectedQueries"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProtectedQueriesIterable listProtectedQueriesPaginator(
            Consumer<ListProtectedQueriesRequest.Builder> listProtectedQueriesRequest) throws ResourceNotFoundException,
            InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, CleanRoomsException {
        return listProtectedQueriesPaginator(ListProtectedQueriesRequest.builder().applyMutation(listProtectedQueriesRequest)
                .build());
    }

    /**
     * <p>
     * Lists the schemas for relations within a collaboration.
     * </p>
     *
     * @param listSchemasRequest
     * @return Result of the ListSchemas operation returned by the service.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.ListSchemas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListSchemas" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSchemasResponse listSchemas(ListSchemasRequest listSchemasRequest) throws ResourceNotFoundException,
            InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, CleanRoomsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the schemas for relations within a collaboration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSchemasRequest.Builder} avoiding the need to
     * create one manually via {@link ListSchemasRequest#builder()}
     * </p>
     *
     * @param listSchemasRequest
     *        A {@link Consumer} that will call methods on {@link ListSchemasInput.Builder} to create a request.
     * @return Result of the ListSchemas operation returned by the service.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.ListSchemas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListSchemas" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSchemasResponse listSchemas(Consumer<ListSchemasRequest.Builder> listSchemasRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsException {
        return listSchemas(ListSchemasRequest.builder().applyMutation(listSchemasRequest).build());
    }

    /**
     * <p>
     * Lists the schemas for relations within a collaboration.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listSchemas(software.amazon.awssdk.services.cleanrooms.model.ListSchemasRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanrooms.paginators.ListSchemasIterable responses = client.listSchemasPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cleanrooms.paginators.ListSchemasIterable responses = client.listSchemasPaginator(request);
     *     for (software.amazon.awssdk.services.cleanrooms.model.ListSchemasResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanrooms.paginators.ListSchemasIterable responses = client.listSchemasPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSchemas(software.amazon.awssdk.services.cleanrooms.model.ListSchemasRequest)} operation.</b>
     * </p>
     *
     * @param listSchemasRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.ListSchemas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListSchemas" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSchemasIterable listSchemasPaginator(ListSchemasRequest listSchemasRequest) throws ResourceNotFoundException,
            InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, CleanRoomsException {
        return new ListSchemasIterable(this, listSchemasRequest);
    }

    /**
     * <p>
     * Lists the schemas for relations within a collaboration.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listSchemas(software.amazon.awssdk.services.cleanrooms.model.ListSchemasRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanrooms.paginators.ListSchemasIterable responses = client.listSchemasPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.cleanrooms.paginators.ListSchemasIterable responses = client.listSchemasPaginator(request);
     *     for (software.amazon.awssdk.services.cleanrooms.model.ListSchemasResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.cleanrooms.paginators.ListSchemasIterable responses = client.listSchemasPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSchemas(software.amazon.awssdk.services.cleanrooms.model.ListSchemasRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSchemasRequest.Builder} avoiding the need to
     * create one manually via {@link ListSchemasRequest#builder()}
     * </p>
     *
     * @param listSchemasRequest
     *        A {@link Consumer} that will call methods on {@link ListSchemasInput.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.ListSchemas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListSchemas" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSchemasIterable listSchemasPaginator(Consumer<ListSchemasRequest.Builder> listSchemasRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsException {
        return listSchemasPaginator(ListSchemasRequest.builder().applyMutation(listSchemasRequest).build());
    }

    /**
     * <p>
     * Lists all of the tags that have been added to a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, CleanRoomsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all of the tags that have been added to a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceInput.Builder} to create a request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ResourceNotFoundException,
            ValidationException, AwsServiceException, SdkClientException, CleanRoomsException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Creates a protected query that is started by Clean Rooms .
     * </p>
     *
     * @param startProtectedQueryRequest
     * @return Result of the StartProtectedQuery operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request denied because service quota has been exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.StartProtectedQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/StartProtectedQuery"
     *      target="_top">AWS API Documentation</a>
     */
    default StartProtectedQueryResponse startProtectedQuery(StartProtectedQueryRequest startProtectedQueryRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, InternalServerException, ValidationException,
            ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a protected query that is started by Clean Rooms .
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartProtectedQueryRequest.Builder} avoiding the
     * need to create one manually via {@link StartProtectedQueryRequest#builder()}
     * </p>
     *
     * @param startProtectedQueryRequest
     *        A {@link Consumer} that will call methods on {@link StartProtectedQueryInput.Builder} to create a request.
     * @return Result of the StartProtectedQuery operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request denied because service quota has been exceeded.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.StartProtectedQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/StartProtectedQuery"
     *      target="_top">AWS API Documentation</a>
     */
    default StartProtectedQueryResponse startProtectedQuery(
            Consumer<StartProtectedQueryRequest.Builder> startProtectedQueryRequest) throws ServiceQuotaExceededException,
            ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException, AccessDeniedException,
            AwsServiceException, SdkClientException, CleanRoomsException {
        return startProtectedQuery(StartProtectedQueryRequest.builder().applyMutation(startProtectedQueryRequest).build());
    }

    /**
     * <p>
     * Tags a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException,
            ValidationException, AwsServiceException, SdkClientException, CleanRoomsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Tags a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceInput.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, CleanRoomsException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes a tag or list of tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException,
            ValidationException, AwsServiceException, SdkClientException, CleanRoomsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a tag or list of tags from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceInput.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, CleanRoomsException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the analysis template metadata.
     * </p>
     *
     * @param updateAnalysisTemplateRequest
     * @return Result of the UpdateAnalysisTemplate operation returned by the service.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.UpdateAnalysisTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/UpdateAnalysisTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAnalysisTemplateResponse updateAnalysisTemplate(UpdateAnalysisTemplateRequest updateAnalysisTemplateRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the analysis template metadata.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAnalysisTemplateRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateAnalysisTemplateRequest#builder()}
     * </p>
     *
     * @param updateAnalysisTemplateRequest
     *        A {@link Consumer} that will call methods on {@link UpdateAnalysisTemplateInput.Builder} to create a
     *        request.
     * @return Result of the UpdateAnalysisTemplate operation returned by the service.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.UpdateAnalysisTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/UpdateAnalysisTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAnalysisTemplateResponse updateAnalysisTemplate(
            Consumer<UpdateAnalysisTemplateRequest.Builder> updateAnalysisTemplateRequest) throws ResourceNotFoundException,
            InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, CleanRoomsException {
        return updateAnalysisTemplate(UpdateAnalysisTemplateRequest.builder().applyMutation(updateAnalysisTemplateRequest)
                .build());
    }

    /**
     * <p>
     * Updates collaboration metadata and can only be called by the collaboration owner.
     * </p>
     *
     * @param updateCollaborationRequest
     * @return Result of the UpdateCollaboration operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.UpdateCollaboration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/UpdateCollaboration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCollaborationResponse updateCollaboration(UpdateCollaborationRequest updateCollaborationRequest)
            throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, CleanRoomsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates collaboration metadata and can only be called by the collaboration owner.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCollaborationRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateCollaborationRequest#builder()}
     * </p>
     *
     * @param updateCollaborationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateCollaborationInput.Builder} to create a request.
     * @return Result of the UpdateCollaboration operation returned by the service.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.UpdateCollaboration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/UpdateCollaboration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCollaborationResponse updateCollaboration(
            Consumer<UpdateCollaborationRequest.Builder> updateCollaborationRequest) throws InternalServerException,
            ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            CleanRoomsException {
        return updateCollaboration(UpdateCollaborationRequest.builder().applyMutation(updateCollaborationRequest).build());
    }

    /**
     * <p>
     * Updates a configured table.
     * </p>
     *
     * @param updateConfiguredTableRequest
     * @return Result of the UpdateConfiguredTable operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.UpdateConfiguredTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/UpdateConfiguredTable"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateConfiguredTableResponse updateConfiguredTable(UpdateConfiguredTableRequest updateConfiguredTableRequest)
            throws ConflictException, ResourceNotFoundException, InternalServerException, ValidationException,
            ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a configured table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateConfiguredTableRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateConfiguredTableRequest#builder()}
     * </p>
     *
     * @param updateConfiguredTableRequest
     *        A {@link Consumer} that will call methods on {@link UpdateConfiguredTableInput.Builder} to create a
     *        request.
     * @return Result of the UpdateConfiguredTable operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.UpdateConfiguredTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/UpdateConfiguredTable"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateConfiguredTableResponse updateConfiguredTable(
            Consumer<UpdateConfiguredTableRequest.Builder> updateConfiguredTableRequest) throws ConflictException,
            ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException, AccessDeniedException,
            AwsServiceException, SdkClientException, CleanRoomsException {
        return updateConfiguredTable(UpdateConfiguredTableRequest.builder().applyMutation(updateConfiguredTableRequest).build());
    }

    /**
     * <p>
     * Updates a configured table analysis rule.
     * </p>
     *
     * @param updateConfiguredTableAnalysisRuleRequest
     * @return Result of the UpdateConfiguredTableAnalysisRule operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.UpdateConfiguredTableAnalysisRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/UpdateConfiguredTableAnalysisRule"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateConfiguredTableAnalysisRuleResponse updateConfiguredTableAnalysisRule(
            UpdateConfiguredTableAnalysisRuleRequest updateConfiguredTableAnalysisRuleRequest) throws ConflictException,
            ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException, AccessDeniedException,
            AwsServiceException, SdkClientException, CleanRoomsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a configured table analysis rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateConfiguredTableAnalysisRuleRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateConfiguredTableAnalysisRuleRequest#builder()}
     * </p>
     *
     * @param updateConfiguredTableAnalysisRuleRequest
     *        A {@link Consumer} that will call methods on {@link UpdateConfiguredTableAnalysisRuleInput.Builder} to
     *        create a request.
     * @return Result of the UpdateConfiguredTableAnalysisRule operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.UpdateConfiguredTableAnalysisRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/UpdateConfiguredTableAnalysisRule"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateConfiguredTableAnalysisRuleResponse updateConfiguredTableAnalysisRule(
            Consumer<UpdateConfiguredTableAnalysisRuleRequest.Builder> updateConfiguredTableAnalysisRuleRequest)
            throws ConflictException, ResourceNotFoundException, InternalServerException, ValidationException,
            ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsException {
        return updateConfiguredTableAnalysisRule(UpdateConfiguredTableAnalysisRuleRequest.builder()
                .applyMutation(updateConfiguredTableAnalysisRuleRequest).build());
    }

    /**
     * <p>
     * Updates a configured table association.
     * </p>
     *
     * @param updateConfiguredTableAssociationRequest
     * @return Result of the UpdateConfiguredTableAssociation operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.UpdateConfiguredTableAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/UpdateConfiguredTableAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateConfiguredTableAssociationResponse updateConfiguredTableAssociation(
            UpdateConfiguredTableAssociationRequest updateConfiguredTableAssociationRequest) throws ConflictException,
            ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException, AccessDeniedException,
            AwsServiceException, SdkClientException, CleanRoomsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a configured table association.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateConfiguredTableAssociationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateConfiguredTableAssociationRequest#builder()}
     * </p>
     *
     * @param updateConfiguredTableAssociationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateConfiguredTableAssociationInput.Builder} to
     *        create a request.
     * @return Result of the UpdateConfiguredTableAssociation operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.UpdateConfiguredTableAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/UpdateConfiguredTableAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateConfiguredTableAssociationResponse updateConfiguredTableAssociation(
            Consumer<UpdateConfiguredTableAssociationRequest.Builder> updateConfiguredTableAssociationRequest)
            throws ConflictException, ResourceNotFoundException, InternalServerException, ValidationException,
            ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsException {
        return updateConfiguredTableAssociation(UpdateConfiguredTableAssociationRequest.builder()
                .applyMutation(updateConfiguredTableAssociationRequest).build());
    }

    /**
     * <p>
     * Updates a membership.
     * </p>
     *
     * @param updateMembershipRequest
     * @return Result of the UpdateMembership operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.UpdateMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/UpdateMembership" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateMembershipResponse updateMembership(UpdateMembershipRequest updateMembershipRequest) throws ConflictException,
            ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException, AccessDeniedException,
            AwsServiceException, SdkClientException, CleanRoomsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a membership.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateMembershipRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateMembershipRequest#builder()}
     * </p>
     *
     * @param updateMembershipRequest
     *        A {@link Consumer} that will call methods on {@link UpdateMembershipInput.Builder} to create a request.
     * @return Result of the UpdateMembership operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.UpdateMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/UpdateMembership" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateMembershipResponse updateMembership(Consumer<UpdateMembershipRequest.Builder> updateMembershipRequest)
            throws ConflictException, ResourceNotFoundException, InternalServerException, ValidationException,
            ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsException {
        return updateMembership(UpdateMembershipRequest.builder().applyMutation(updateMembershipRequest).build());
    }

    /**
     * <p>
     * Updates the processing of a currently running query.
     * </p>
     *
     * @param updateProtectedQueryRequest
     * @return Result of the UpdateProtectedQuery operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.UpdateProtectedQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/UpdateProtectedQuery"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateProtectedQueryResponse updateProtectedQuery(UpdateProtectedQueryRequest updateProtectedQueryRequest)
            throws ConflictException, ResourceNotFoundException, InternalServerException, ValidationException,
            ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the processing of a currently running query.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateProtectedQueryRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateProtectedQueryRequest#builder()}
     * </p>
     *
     * @param updateProtectedQueryRequest
     *        A {@link Consumer} that will call methods on {@link UpdateProtectedQueryInput.Builder} to create a
     *        request.
     * @return Result of the UpdateProtectedQuery operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         Request references a resource which does not exist.
     * @throws InternalServerException
     *         Unexpected error during processing of request.
     * @throws ValidationException
     *         The input fails to satisfy the specified constraints.
     * @throws ThrottlingException
     *         Request was denied due to request throttling.
     * @throws AccessDeniedException
     *         Caller does not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CleanRoomsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CleanRoomsClient.UpdateProtectedQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/UpdateProtectedQuery"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateProtectedQueryResponse updateProtectedQuery(
            Consumer<UpdateProtectedQueryRequest.Builder> updateProtectedQueryRequest) throws ConflictException,
            ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException, AccessDeniedException,
            AwsServiceException, SdkClientException, CleanRoomsException {
        return updateProtectedQuery(UpdateProtectedQueryRequest.builder().applyMutation(updateProtectedQueryRequest).build());
    }

    /**
     * Create a {@link CleanRoomsClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static CleanRoomsClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link CleanRoomsClient}.
     */
    static CleanRoomsClientBuilder builder() {
        return new DefaultCleanRoomsClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default CleanRoomsServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
