/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkvoice.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutVoiceConnectorEmergencyCallingConfigurationResponse extends ChimeSdkVoiceResponse
        implements
        ToCopyableBuilder<PutVoiceConnectorEmergencyCallingConfigurationResponse.Builder, PutVoiceConnectorEmergencyCallingConfigurationResponse> {
    private static final SdkField<EmergencyCallingConfiguration> EMERGENCY_CALLING_CONFIGURATION_FIELD = SdkField
            .<EmergencyCallingConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("EmergencyCallingConfiguration")
            .getter(getter(PutVoiceConnectorEmergencyCallingConfigurationResponse::emergencyCallingConfiguration))
            .setter(setter(Builder::emergencyCallingConfiguration))
            .constructor(EmergencyCallingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmergencyCallingConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(EMERGENCY_CALLING_CONFIGURATION_FIELD));

    private final EmergencyCallingConfiguration emergencyCallingConfiguration;

    private PutVoiceConnectorEmergencyCallingConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.emergencyCallingConfiguration = builder.emergencyCallingConfiguration;
    }

    /**
     * <p>
     * The updated configuration.
     * </p>
     * 
     * @return The updated configuration.
     */
    public final EmergencyCallingConfiguration emergencyCallingConfiguration() {
        return emergencyCallingConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(emergencyCallingConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutVoiceConnectorEmergencyCallingConfigurationResponse)) {
            return false;
        }
        PutVoiceConnectorEmergencyCallingConfigurationResponse other = (PutVoiceConnectorEmergencyCallingConfigurationResponse) obj;
        return Objects.equals(emergencyCallingConfiguration(), other.emergencyCallingConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutVoiceConnectorEmergencyCallingConfigurationResponse")
                .add("EmergencyCallingConfiguration", emergencyCallingConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EmergencyCallingConfiguration":
            return Optional.ofNullable(clazz.cast(emergencyCallingConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutVoiceConnectorEmergencyCallingConfigurationResponse, T> g) {
        return obj -> g.apply((PutVoiceConnectorEmergencyCallingConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkVoiceResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, PutVoiceConnectorEmergencyCallingConfigurationResponse> {
        /**
         * <p>
         * The updated configuration.
         * </p>
         * 
         * @param emergencyCallingConfiguration
         *        The updated configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emergencyCallingConfiguration(EmergencyCallingConfiguration emergencyCallingConfiguration);

        /**
         * <p>
         * The updated configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link EmergencyCallingConfiguration.Builder}
         * avoiding the need to create one manually via {@link EmergencyCallingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EmergencyCallingConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #emergencyCallingConfiguration(EmergencyCallingConfiguration)}.
         * 
         * @param emergencyCallingConfiguration
         *        a consumer that will call methods on {@link EmergencyCallingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #emergencyCallingConfiguration(EmergencyCallingConfiguration)
         */
        default Builder emergencyCallingConfiguration(
                Consumer<EmergencyCallingConfiguration.Builder> emergencyCallingConfiguration) {
            return emergencyCallingConfiguration(EmergencyCallingConfiguration.builder()
                    .applyMutation(emergencyCallingConfiguration).build());
        }
    }

    static final class BuilderImpl extends ChimeSdkVoiceResponse.BuilderImpl implements Builder {
        private EmergencyCallingConfiguration emergencyCallingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(PutVoiceConnectorEmergencyCallingConfigurationResponse model) {
            super(model);
            emergencyCallingConfiguration(model.emergencyCallingConfiguration);
        }

        public final EmergencyCallingConfiguration.Builder getEmergencyCallingConfiguration() {
            return emergencyCallingConfiguration != null ? emergencyCallingConfiguration.toBuilder() : null;
        }

        public final void setEmergencyCallingConfiguration(EmergencyCallingConfiguration.BuilderImpl emergencyCallingConfiguration) {
            this.emergencyCallingConfiguration = emergencyCallingConfiguration != null ? emergencyCallingConfiguration.build()
                    : null;
        }

        @Override
        public final Builder emergencyCallingConfiguration(EmergencyCallingConfiguration emergencyCallingConfiguration) {
            this.emergencyCallingConfiguration = emergencyCallingConfiguration;
            return this;
        }

        @Override
        public PutVoiceConnectorEmergencyCallingConfigurationResponse build() {
            return new PutVoiceConnectorEmergencyCallingConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
