/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkvoice.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetVoiceConnectorStreamingConfigurationResponse extends ChimeSdkVoiceResponse
        implements
        ToCopyableBuilder<GetVoiceConnectorStreamingConfigurationResponse.Builder, GetVoiceConnectorStreamingConfigurationResponse> {
    private static final SdkField<StreamingConfiguration> STREAMING_CONFIGURATION_FIELD = SdkField
            .<StreamingConfiguration> builder(MarshallingType.SDK_POJO).memberName("StreamingConfiguration")
            .getter(getter(GetVoiceConnectorStreamingConfigurationResponse::streamingConfiguration))
            .setter(setter(Builder::streamingConfiguration)).constructor(StreamingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamingConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(STREAMING_CONFIGURATION_FIELD));

    private final StreamingConfiguration streamingConfiguration;

    private GetVoiceConnectorStreamingConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.streamingConfiguration = builder.streamingConfiguration;
    }

    /**
     * <p>
     * The details of the streaming configuration.
     * </p>
     * 
     * @return The details of the streaming configuration.
     */
    public final StreamingConfiguration streamingConfiguration() {
        return streamingConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(streamingConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetVoiceConnectorStreamingConfigurationResponse)) {
            return false;
        }
        GetVoiceConnectorStreamingConfigurationResponse other = (GetVoiceConnectorStreamingConfigurationResponse) obj;
        return Objects.equals(streamingConfiguration(), other.streamingConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetVoiceConnectorStreamingConfigurationResponse")
                .add("StreamingConfiguration", streamingConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamingConfiguration":
            return Optional.ofNullable(clazz.cast(streamingConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetVoiceConnectorStreamingConfigurationResponse, T> g) {
        return obj -> g.apply((GetVoiceConnectorStreamingConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkVoiceResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetVoiceConnectorStreamingConfigurationResponse> {
        /**
         * <p>
         * The details of the streaming configuration.
         * </p>
         * 
         * @param streamingConfiguration
         *        The details of the streaming configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamingConfiguration(StreamingConfiguration streamingConfiguration);

        /**
         * <p>
         * The details of the streaming configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link StreamingConfiguration.Builder} avoiding
         * the need to create one manually via {@link StreamingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StreamingConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #streamingConfiguration(StreamingConfiguration)}.
         * 
         * @param streamingConfiguration
         *        a consumer that will call methods on {@link StreamingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #streamingConfiguration(StreamingConfiguration)
         */
        default Builder streamingConfiguration(Consumer<StreamingConfiguration.Builder> streamingConfiguration) {
            return streamingConfiguration(StreamingConfiguration.builder().applyMutation(streamingConfiguration).build());
        }
    }

    static final class BuilderImpl extends ChimeSdkVoiceResponse.BuilderImpl implements Builder {
        private StreamingConfiguration streamingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetVoiceConnectorStreamingConfigurationResponse model) {
            super(model);
            streamingConfiguration(model.streamingConfiguration);
        }

        public final StreamingConfiguration.Builder getStreamingConfiguration() {
            return streamingConfiguration != null ? streamingConfiguration.toBuilder() : null;
        }

        public final void setStreamingConfiguration(StreamingConfiguration.BuilderImpl streamingConfiguration) {
            this.streamingConfiguration = streamingConfiguration != null ? streamingConfiguration.build() : null;
        }

        @Override
        public final Builder streamingConfiguration(StreamingConfiguration streamingConfiguration) {
            this.streamingConfiguration = streamingConfiguration;
            return this;
        }

        @Override
        public GetVoiceConnectorStreamingConfigurationResponse build() {
            return new GetVoiceConnectorStreamingConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
