/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkvoice.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Dialed Number Identification Service (DNIS) emergency calling configuration details associated with an Amazon
 * Chime SDK Voice Connector's emergency calling configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DNISEmergencyCallingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DNISEmergencyCallingConfiguration.Builder, DNISEmergencyCallingConfiguration> {
    private static final SdkField<String> EMERGENCY_PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EmergencyPhoneNumber").getter(getter(DNISEmergencyCallingConfiguration::emergencyPhoneNumber))
            .setter(setter(Builder::emergencyPhoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmergencyPhoneNumber").build())
            .build();

    private static final SdkField<String> TEST_PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TestPhoneNumber").getter(getter(DNISEmergencyCallingConfiguration::testPhoneNumber))
            .setter(setter(Builder::testPhoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TestPhoneNumber").build()).build();

    private static final SdkField<String> CALLING_COUNTRY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CallingCountry").getter(getter(DNISEmergencyCallingConfiguration::callingCountry))
            .setter(setter(Builder::callingCountry))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallingCountry").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EMERGENCY_PHONE_NUMBER_FIELD,
            TEST_PHONE_NUMBER_FIELD, CALLING_COUNTRY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String emergencyPhoneNumber;

    private final String testPhoneNumber;

    private final String callingCountry;

    private DNISEmergencyCallingConfiguration(BuilderImpl builder) {
        this.emergencyPhoneNumber = builder.emergencyPhoneNumber;
        this.testPhoneNumber = builder.testPhoneNumber;
        this.callingCountry = builder.callingCountry;
    }

    /**
     * <p>
     * The DNIS phone number that you route emergency calls to, in E.164 format.
     * </p>
     * 
     * @return The DNIS phone number that you route emergency calls to, in E.164 format.
     */
    public final String emergencyPhoneNumber() {
        return emergencyPhoneNumber;
    }

    /**
     * <p>
     * The DNIS phone number for routing test emergency calls to, in E.164 format.
     * </p>
     * 
     * @return The DNIS phone number for routing test emergency calls to, in E.164 format.
     */
    public final String testPhoneNumber() {
        return testPhoneNumber;
    }

    /**
     * <p>
     * The country from which emergency calls are allowed, in ISO 3166-1 alpha-2 format.
     * </p>
     * 
     * @return The country from which emergency calls are allowed, in ISO 3166-1 alpha-2 format.
     */
    public final String callingCountry() {
        return callingCountry;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(emergencyPhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(testPhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(callingCountry());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DNISEmergencyCallingConfiguration)) {
            return false;
        }
        DNISEmergencyCallingConfiguration other = (DNISEmergencyCallingConfiguration) obj;
        return Objects.equals(emergencyPhoneNumber(), other.emergencyPhoneNumber())
                && Objects.equals(testPhoneNumber(), other.testPhoneNumber())
                && Objects.equals(callingCountry(), other.callingCountry());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DNISEmergencyCallingConfiguration")
                .add("EmergencyPhoneNumber", emergencyPhoneNumber() == null ? null : "*** Sensitive Data Redacted ***")
                .add("TestPhoneNumber", testPhoneNumber() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CallingCountry", callingCountry()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EmergencyPhoneNumber":
            return Optional.ofNullable(clazz.cast(emergencyPhoneNumber()));
        case "TestPhoneNumber":
            return Optional.ofNullable(clazz.cast(testPhoneNumber()));
        case "CallingCountry":
            return Optional.ofNullable(clazz.cast(callingCountry()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DNISEmergencyCallingConfiguration, T> g) {
        return obj -> g.apply((DNISEmergencyCallingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DNISEmergencyCallingConfiguration> {
        /**
         * <p>
         * The DNIS phone number that you route emergency calls to, in E.164 format.
         * </p>
         * 
         * @param emergencyPhoneNumber
         *        The DNIS phone number that you route emergency calls to, in E.164 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emergencyPhoneNumber(String emergencyPhoneNumber);

        /**
         * <p>
         * The DNIS phone number for routing test emergency calls to, in E.164 format.
         * </p>
         * 
         * @param testPhoneNumber
         *        The DNIS phone number for routing test emergency calls to, in E.164 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testPhoneNumber(String testPhoneNumber);

        /**
         * <p>
         * The country from which emergency calls are allowed, in ISO 3166-1 alpha-2 format.
         * </p>
         * 
         * @param callingCountry
         *        The country from which emergency calls are allowed, in ISO 3166-1 alpha-2 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callingCountry(String callingCountry);
    }

    static final class BuilderImpl implements Builder {
        private String emergencyPhoneNumber;

        private String testPhoneNumber;

        private String callingCountry;

        private BuilderImpl() {
        }

        private BuilderImpl(DNISEmergencyCallingConfiguration model) {
            emergencyPhoneNumber(model.emergencyPhoneNumber);
            testPhoneNumber(model.testPhoneNumber);
            callingCountry(model.callingCountry);
        }

        public final String getEmergencyPhoneNumber() {
            return emergencyPhoneNumber;
        }

        public final void setEmergencyPhoneNumber(String emergencyPhoneNumber) {
            this.emergencyPhoneNumber = emergencyPhoneNumber;
        }

        @Override
        public final Builder emergencyPhoneNumber(String emergencyPhoneNumber) {
            this.emergencyPhoneNumber = emergencyPhoneNumber;
            return this;
        }

        public final String getTestPhoneNumber() {
            return testPhoneNumber;
        }

        public final void setTestPhoneNumber(String testPhoneNumber) {
            this.testPhoneNumber = testPhoneNumber;
        }

        @Override
        public final Builder testPhoneNumber(String testPhoneNumber) {
            this.testPhoneNumber = testPhoneNumber;
            return this;
        }

        public final String getCallingCountry() {
            return callingCountry;
        }

        public final void setCallingCountry(String callingCountry) {
            this.callingCountry = callingCountry;
        }

        @Override
        public final Builder callingCountry(String callingCountry) {
            this.callingCountry = callingCountry;
            return this;
        }

        @Override
        public DNISEmergencyCallingConfiguration build() {
            return new DNISEmergencyCallingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
