/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkvoice.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of an Amazon Chime SDK Voice Connector call.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CallDetails implements SdkPojo, Serializable, ToCopyableBuilder<CallDetails.Builder, CallDetails> {
    private static final SdkField<String> VOICE_CONNECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VoiceConnectorId").getter(getter(CallDetails::voiceConnectorId))
            .setter(setter(Builder::voiceConnectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceConnectorId").build()).build();

    private static final SdkField<String> TRANSACTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TransactionId").getter(getter(CallDetails::transactionId)).setter(setter(Builder::transactionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransactionId").build()).build();

    private static final SdkField<Boolean> IS_CALLER_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsCaller").getter(getter(CallDetails::isCaller)).setter(setter(Builder::isCaller))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsCaller").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOICE_CONNECTOR_ID_FIELD,
            TRANSACTION_ID_FIELD, IS_CALLER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String voiceConnectorId;

    private final String transactionId;

    private final Boolean isCaller;

    private CallDetails(BuilderImpl builder) {
        this.voiceConnectorId = builder.voiceConnectorId;
        this.transactionId = builder.transactionId;
        this.isCaller = builder.isCaller;
    }

    /**
     * <p>
     * The Voice Connector ID.
     * </p>
     * 
     * @return The Voice Connector ID.
     */
    public final String voiceConnectorId() {
        return voiceConnectorId;
    }

    /**
     * <p>
     * The transaction ID of a Voice Connector call.
     * </p>
     * 
     * @return The transaction ID of a Voice Connector call.
     */
    public final String transactionId() {
        return transactionId;
    }

    /**
     * <p>
     * Identifies a person as the caller or the callee.
     * </p>
     * 
     * @return Identifies a person as the caller or the callee.
     */
    public final Boolean isCaller() {
        return isCaller;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(voiceConnectorId());
        hashCode = 31 * hashCode + Objects.hashCode(transactionId());
        hashCode = 31 * hashCode + Objects.hashCode(isCaller());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CallDetails)) {
            return false;
        }
        CallDetails other = (CallDetails) obj;
        return Objects.equals(voiceConnectorId(), other.voiceConnectorId())
                && Objects.equals(transactionId(), other.transactionId()) && Objects.equals(isCaller(), other.isCaller());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CallDetails").add("VoiceConnectorId", voiceConnectorId()).add("TransactionId", transactionId())
                .add("IsCaller", isCaller()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VoiceConnectorId":
            return Optional.ofNullable(clazz.cast(voiceConnectorId()));
        case "TransactionId":
            return Optional.ofNullable(clazz.cast(transactionId()));
        case "IsCaller":
            return Optional.ofNullable(clazz.cast(isCaller()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CallDetails, T> g) {
        return obj -> g.apply((CallDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CallDetails> {
        /**
         * <p>
         * The Voice Connector ID.
         * </p>
         * 
         * @param voiceConnectorId
         *        The Voice Connector ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceConnectorId(String voiceConnectorId);

        /**
         * <p>
         * The transaction ID of a Voice Connector call.
         * </p>
         * 
         * @param transactionId
         *        The transaction ID of a Voice Connector call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transactionId(String transactionId);

        /**
         * <p>
         * Identifies a person as the caller or the callee.
         * </p>
         * 
         * @param isCaller
         *        Identifies a person as the caller or the callee.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isCaller(Boolean isCaller);
    }

    static final class BuilderImpl implements Builder {
        private String voiceConnectorId;

        private String transactionId;

        private Boolean isCaller;

        private BuilderImpl() {
        }

        private BuilderImpl(CallDetails model) {
            voiceConnectorId(model.voiceConnectorId);
            transactionId(model.transactionId);
            isCaller(model.isCaller);
        }

        public final String getVoiceConnectorId() {
            return voiceConnectorId;
        }

        public final void setVoiceConnectorId(String voiceConnectorId) {
            this.voiceConnectorId = voiceConnectorId;
        }

        @Override
        public final Builder voiceConnectorId(String voiceConnectorId) {
            this.voiceConnectorId = voiceConnectorId;
            return this;
        }

        public final String getTransactionId() {
            return transactionId;
        }

        public final void setTransactionId(String transactionId) {
            this.transactionId = transactionId;
        }

        @Override
        public final Builder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public final Boolean getIsCaller() {
            return isCaller;
        }

        public final void setIsCaller(Boolean isCaller) {
            this.isCaller = isCaller;
        }

        @Override
        public final Builder isCaller(Boolean isCaller) {
            this.isCaller = isCaller;
            return this;
        }

        @Override
        public CallDetails build() {
            return new CallDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
