/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkvoice;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.chimesdkvoice.model.AssociatePhoneNumbersWithVoiceConnectorGroupRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.AssociatePhoneNumbersWithVoiceConnectorGroupResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.AssociatePhoneNumbersWithVoiceConnectorRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.AssociatePhoneNumbersWithVoiceConnectorResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.BatchDeletePhoneNumberRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.BatchDeletePhoneNumberResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.BatchUpdatePhoneNumberRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.BatchUpdatePhoneNumberResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.CreatePhoneNumberOrderRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.CreatePhoneNumberOrderResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.CreateProxySessionRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.CreateProxySessionResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.CreateSipMediaApplicationCallRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.CreateSipMediaApplicationCallResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.CreateSipMediaApplicationRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.CreateSipMediaApplicationResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.CreateSipRuleRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.CreateSipRuleResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.CreateVoiceConnectorGroupRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.CreateVoiceConnectorGroupResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.CreateVoiceConnectorRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.CreateVoiceConnectorResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.CreateVoiceProfileDomainRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.CreateVoiceProfileDomainResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.CreateVoiceProfileRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.CreateVoiceProfileResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.DeletePhoneNumberRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.DeletePhoneNumberResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.DeleteProxySessionRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.DeleteProxySessionResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.DeleteSipMediaApplicationRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.DeleteSipMediaApplicationResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.DeleteSipRuleRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.DeleteSipRuleResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorEmergencyCallingConfigurationRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorEmergencyCallingConfigurationResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorGroupRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorGroupResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorOriginationRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorOriginationResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorProxyRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorProxyResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorStreamingConfigurationRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorStreamingConfigurationResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorTerminationCredentialsRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorTerminationCredentialsResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorTerminationRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceConnectorTerminationResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceProfileDomainRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceProfileDomainResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceProfileRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.DeleteVoiceProfileResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.DisassociatePhoneNumbersFromVoiceConnectorGroupRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.DisassociatePhoneNumbersFromVoiceConnectorGroupResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.DisassociatePhoneNumbersFromVoiceConnectorRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.DisassociatePhoneNumbersFromVoiceConnectorResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.GetGlobalSettingsRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.GetGlobalSettingsResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.GetPhoneNumberOrderRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.GetPhoneNumberOrderResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.GetPhoneNumberRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.GetPhoneNumberResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.GetPhoneNumberSettingsRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.GetPhoneNumberSettingsResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.GetProxySessionRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.GetProxySessionResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.GetSipMediaApplicationAlexaSkillConfigurationRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.GetSipMediaApplicationAlexaSkillConfigurationResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.GetSipMediaApplicationLoggingConfigurationRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.GetSipMediaApplicationLoggingConfigurationResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.GetSipMediaApplicationRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.GetSipMediaApplicationResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.GetSipRuleRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.GetSipRuleResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.GetSpeakerSearchTaskRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.GetSpeakerSearchTaskResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorEmergencyCallingConfigurationRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorEmergencyCallingConfigurationResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorGroupRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorGroupResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorLoggingConfigurationRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorLoggingConfigurationResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorOriginationRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorOriginationResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorProxyRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorProxyResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorStreamingConfigurationRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorStreamingConfigurationResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorTerminationHealthRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorTerminationHealthResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorTerminationRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceConnectorTerminationResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceProfileDomainRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceProfileDomainResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceProfileRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceProfileResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceToneAnalysisTaskRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.GetVoiceToneAnalysisTaskResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.ListAvailableVoiceConnectorRegionsRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.ListAvailableVoiceConnectorRegionsResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.ListPhoneNumberOrdersRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.ListPhoneNumberOrdersResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.ListPhoneNumbersRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.ListPhoneNumbersResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.ListProxySessionsRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.ListProxySessionsResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.ListSipMediaApplicationsRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.ListSipMediaApplicationsResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.ListSipRulesRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.ListSipRulesResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.ListSupportedPhoneNumberCountriesRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.ListSupportedPhoneNumberCountriesResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceConnectorGroupsRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceConnectorGroupsResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceConnectorTerminationCredentialsRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceConnectorTerminationCredentialsResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceConnectorsRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceConnectorsResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceProfileDomainsRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceProfileDomainsResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceProfilesRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceProfilesResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.PutSipMediaApplicationAlexaSkillConfigurationRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.PutSipMediaApplicationAlexaSkillConfigurationResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.PutSipMediaApplicationLoggingConfigurationRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.PutSipMediaApplicationLoggingConfigurationResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorEmergencyCallingConfigurationRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorEmergencyCallingConfigurationResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorLoggingConfigurationRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorLoggingConfigurationResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorOriginationRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorOriginationResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorProxyRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorProxyResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorStreamingConfigurationRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorStreamingConfigurationResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorTerminationCredentialsRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorTerminationCredentialsResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorTerminationRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.PutVoiceConnectorTerminationResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.RestorePhoneNumberRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.RestorePhoneNumberResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.SearchAvailablePhoneNumbersRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.SearchAvailablePhoneNumbersResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.StartSpeakerSearchTaskRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.StartSpeakerSearchTaskResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.StartVoiceToneAnalysisTaskRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.StartVoiceToneAnalysisTaskResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.StopSpeakerSearchTaskRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.StopSpeakerSearchTaskResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.StopVoiceToneAnalysisTaskRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.StopVoiceToneAnalysisTaskResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.TagResourceRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.TagResourceResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.UntagResourceRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.UntagResourceResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.UpdateGlobalSettingsRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.UpdateGlobalSettingsResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.UpdatePhoneNumberRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.UpdatePhoneNumberResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.UpdatePhoneNumberSettingsRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.UpdatePhoneNumberSettingsResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.UpdateProxySessionRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.UpdateProxySessionResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.UpdateSipMediaApplicationCallRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.UpdateSipMediaApplicationCallResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.UpdateSipMediaApplicationRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.UpdateSipMediaApplicationResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.UpdateSipRuleRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.UpdateSipRuleResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.UpdateVoiceConnectorGroupRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.UpdateVoiceConnectorGroupResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.UpdateVoiceConnectorRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.UpdateVoiceConnectorResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.UpdateVoiceProfileDomainRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.UpdateVoiceProfileDomainResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.UpdateVoiceProfileRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.UpdateVoiceProfileResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.ValidateE911AddressRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.ValidateE911AddressResponse;
import software.amazon.awssdk.services.chimesdkvoice.paginators.ListPhoneNumberOrdersPublisher;
import software.amazon.awssdk.services.chimesdkvoice.paginators.ListPhoneNumbersPublisher;
import software.amazon.awssdk.services.chimesdkvoice.paginators.ListProxySessionsPublisher;
import software.amazon.awssdk.services.chimesdkvoice.paginators.ListSipMediaApplicationsPublisher;
import software.amazon.awssdk.services.chimesdkvoice.paginators.ListSipRulesPublisher;
import software.amazon.awssdk.services.chimesdkvoice.paginators.ListVoiceConnectorGroupsPublisher;
import software.amazon.awssdk.services.chimesdkvoice.paginators.ListVoiceConnectorsPublisher;
import software.amazon.awssdk.services.chimesdkvoice.paginators.ListVoiceProfileDomainsPublisher;
import software.amazon.awssdk.services.chimesdkvoice.paginators.ListVoiceProfilesPublisher;
import software.amazon.awssdk.services.chimesdkvoice.paginators.SearchAvailablePhoneNumbersPublisher;

/**
 * Service client for accessing Amazon Chime SDK Voice asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * The Amazon Chime SDK telephony APIs in this section enable developers to create PSTN calling solutions that use
 * Amazon Chime SDK Voice Connectors, and Amazon Chime SDK SIP media applications. Developers can also order and manage
 * phone numbers, create and manage Voice Connectors and SIP media applications, and run voice analytics.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface ChimeSdkVoiceAsyncClient extends AwsClient {
    String SERVICE_NAME = "chime";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "voice-chime";

    /**
     * <p>
     * Associates phone numbers with the specified Amazon Chime SDK Voice Connector.
     * </p>
     *
     * @param associatePhoneNumbersWithVoiceConnectorRequest
     * @return A Java Future containing the result of the AssociatePhoneNumbersWithVoiceConnector operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>AccessDeniedException You don't have the permissions needed to run this action.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.AssociatePhoneNumbersWithVoiceConnector
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/AssociatePhoneNumbersWithVoiceConnector"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociatePhoneNumbersWithVoiceConnectorResponse> associatePhoneNumbersWithVoiceConnector(
            AssociatePhoneNumbersWithVoiceConnectorRequest associatePhoneNumbersWithVoiceConnectorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates phone numbers with the specified Amazon Chime SDK Voice Connector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link AssociatePhoneNumbersWithVoiceConnectorRequest.Builder} avoiding the need to create one manually via
     * {@link AssociatePhoneNumbersWithVoiceConnectorRequest#builder()}
     * </p>
     *
     * @param associatePhoneNumbersWithVoiceConnectorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link AssociatePhoneNumbersWithVoiceConnectorRequest.Builder} to create a request.
     * @return A Java Future containing the result of the AssociatePhoneNumbersWithVoiceConnector operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>AccessDeniedException You don't have the permissions needed to run this action.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.AssociatePhoneNumbersWithVoiceConnector
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/AssociatePhoneNumbersWithVoiceConnector"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociatePhoneNumbersWithVoiceConnectorResponse> associatePhoneNumbersWithVoiceConnector(
            Consumer<AssociatePhoneNumbersWithVoiceConnectorRequest.Builder> associatePhoneNumbersWithVoiceConnectorRequest) {
        return associatePhoneNumbersWithVoiceConnector(AssociatePhoneNumbersWithVoiceConnectorRequest.builder()
                .applyMutation(associatePhoneNumbersWithVoiceConnectorRequest).build());
    }

    /**
     * <p>
     * Associates phone numbers with the specified Amazon Chime SDK Voice Connector group.
     * </p>
     *
     * @param associatePhoneNumbersWithVoiceConnectorGroupRequest
     * @return A Java Future containing the result of the AssociatePhoneNumbersWithVoiceConnectorGroup operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>AccessDeniedException You don't have the permissions needed to run this action.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.AssociatePhoneNumbersWithVoiceConnectorGroup
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/AssociatePhoneNumbersWithVoiceConnectorGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociatePhoneNumbersWithVoiceConnectorGroupResponse> associatePhoneNumbersWithVoiceConnectorGroup(
            AssociatePhoneNumbersWithVoiceConnectorGroupRequest associatePhoneNumbersWithVoiceConnectorGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates phone numbers with the specified Amazon Chime SDK Voice Connector group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link AssociatePhoneNumbersWithVoiceConnectorGroupRequest.Builder} avoiding the need to create one manually via
     * {@link AssociatePhoneNumbersWithVoiceConnectorGroupRequest#builder()}
     * </p>
     *
     * @param associatePhoneNumbersWithVoiceConnectorGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link AssociatePhoneNumbersWithVoiceConnectorGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the AssociatePhoneNumbersWithVoiceConnectorGroup operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>AccessDeniedException You don't have the permissions needed to run this action.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.AssociatePhoneNumbersWithVoiceConnectorGroup
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/AssociatePhoneNumbersWithVoiceConnectorGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociatePhoneNumbersWithVoiceConnectorGroupResponse> associatePhoneNumbersWithVoiceConnectorGroup(
            Consumer<AssociatePhoneNumbersWithVoiceConnectorGroupRequest.Builder> associatePhoneNumbersWithVoiceConnectorGroupRequest) {
        return associatePhoneNumbersWithVoiceConnectorGroup(AssociatePhoneNumbersWithVoiceConnectorGroupRequest.builder()
                .applyMutation(associatePhoneNumbersWithVoiceConnectorGroupRequest).build());
    }

    /**
     * <p>
     * Moves phone numbers into the <b>Deletion queue</b>. Phone numbers must be disassociated from any users or Amazon
     * Chime SDK Voice Connectors before they can be deleted.
     * </p>
     * <p>
     * Phone numbers remain in the <b>Deletion queue</b> for 7 days before they are deleted permanently.
     * </p>
     *
     * @param batchDeletePhoneNumberRequest
     * @return A Java Future containing the result of the BatchDeletePhoneNumber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.BatchDeletePhoneNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/BatchDeletePhoneNumber"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchDeletePhoneNumberResponse> batchDeletePhoneNumber(
            BatchDeletePhoneNumberRequest batchDeletePhoneNumberRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Moves phone numbers into the <b>Deletion queue</b>. Phone numbers must be disassociated from any users or Amazon
     * Chime SDK Voice Connectors before they can be deleted.
     * </p>
     * <p>
     * Phone numbers remain in the <b>Deletion queue</b> for 7 days before they are deleted permanently.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDeletePhoneNumberRequest.Builder} avoiding the
     * need to create one manually via {@link BatchDeletePhoneNumberRequest#builder()}
     * </p>
     *
     * @param batchDeletePhoneNumberRequest
     *        A {@link Consumer} that will call methods on {@link BatchDeletePhoneNumberRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchDeletePhoneNumber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.BatchDeletePhoneNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/BatchDeletePhoneNumber"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchDeletePhoneNumberResponse> batchDeletePhoneNumber(
            Consumer<BatchDeletePhoneNumberRequest.Builder> batchDeletePhoneNumberRequest) {
        return batchDeletePhoneNumber(BatchDeletePhoneNumberRequest.builder().applyMutation(batchDeletePhoneNumberRequest)
                .build());
    }

    /**
     * <p>
     * Updates one or more phone numbers.
     * </p>
     *
     * @param batchUpdatePhoneNumberRequest
     * @return A Java Future containing the result of the BatchUpdatePhoneNumber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.BatchUpdatePhoneNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/BatchUpdatePhoneNumber"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchUpdatePhoneNumberResponse> batchUpdatePhoneNumber(
            BatchUpdatePhoneNumberRequest batchUpdatePhoneNumberRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates one or more phone numbers.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchUpdatePhoneNumberRequest.Builder} avoiding the
     * need to create one manually via {@link BatchUpdatePhoneNumberRequest#builder()}
     * </p>
     *
     * @param batchUpdatePhoneNumberRequest
     *        A {@link Consumer} that will call methods on {@link BatchUpdatePhoneNumberRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchUpdatePhoneNumber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.BatchUpdatePhoneNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/BatchUpdatePhoneNumber"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchUpdatePhoneNumberResponse> batchUpdatePhoneNumber(
            Consumer<BatchUpdatePhoneNumberRequest.Builder> batchUpdatePhoneNumberRequest) {
        return batchUpdatePhoneNumber(BatchUpdatePhoneNumberRequest.builder().applyMutation(batchUpdatePhoneNumberRequest)
                .build());
    }

    /**
     * <p>
     * Creates an order for phone numbers to be provisioned. For numbers outside the U.S., you must use the Amazon Chime
     * SDK SIP media application dial-in product type.
     * </p>
     *
     * @param createPhoneNumberOrderRequest
     * @return A Java Future containing the result of the CreatePhoneNumberOrder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>AccessDeniedException You don't have the permissions needed to run this action.</li>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ResourceLimitExceededException The request exceeds the resource limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.CreatePhoneNumberOrder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/CreatePhoneNumberOrder"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreatePhoneNumberOrderResponse> createPhoneNumberOrder(
            CreatePhoneNumberOrderRequest createPhoneNumberOrderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an order for phone numbers to be provisioned. For numbers outside the U.S., you must use the Amazon Chime
     * SDK SIP media application dial-in product type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePhoneNumberOrderRequest.Builder} avoiding the
     * need to create one manually via {@link CreatePhoneNumberOrderRequest#builder()}
     * </p>
     *
     * @param createPhoneNumberOrderRequest
     *        A {@link Consumer} that will call methods on {@link CreatePhoneNumberOrderRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreatePhoneNumberOrder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>AccessDeniedException You don't have the permissions needed to run this action.</li>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ResourceLimitExceededException The request exceeds the resource limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.CreatePhoneNumberOrder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/CreatePhoneNumberOrder"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreatePhoneNumberOrderResponse> createPhoneNumberOrder(
            Consumer<CreatePhoneNumberOrderRequest.Builder> createPhoneNumberOrderRequest) {
        return createPhoneNumberOrder(CreatePhoneNumberOrderRequest.builder().applyMutation(createPhoneNumberOrderRequest)
                .build());
    }

    /**
     * <p>
     * Creates a proxy session for the specified Amazon Chime SDK Voice Connector for the specified participant phone
     * numbers.
     * </p>
     *
     * @param createProxySessionRequest
     * @return A Java Future containing the result of the CreateProxySession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.CreateProxySession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/CreateProxySession"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateProxySessionResponse> createProxySession(CreateProxySessionRequest createProxySessionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a proxy session for the specified Amazon Chime SDK Voice Connector for the specified participant phone
     * numbers.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateProxySessionRequest.Builder} avoiding the
     * need to create one manually via {@link CreateProxySessionRequest#builder()}
     * </p>
     *
     * @param createProxySessionRequest
     *        A {@link Consumer} that will call methods on {@link CreateProxySessionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateProxySession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.CreateProxySession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/CreateProxySession"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateProxySessionResponse> createProxySession(
            Consumer<CreateProxySessionRequest.Builder> createProxySessionRequest) {
        return createProxySession(CreateProxySessionRequest.builder().applyMutation(createProxySessionRequest).build());
    }

    /**
     * <p>
     * Creates a SIP media application. For more information about SIP media applications, see <a
     * href="https://docs.aws.amazon.com/chime-sdk/latest/ag/manage-sip-applications.html">Managing SIP media
     * applications and rules</a> in the <i>Amazon Chime SDK Administrator Guide</i>.
     * </p>
     *
     * @param createSipMediaApplicationRequest
     * @return A Java Future containing the result of the CreateSipMediaApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>AccessDeniedException You don't have the permissions needed to run this action.</li>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ResourceLimitExceededException The request exceeds the resource limit.</li>
     *         <li>ConflictException Multiple instances of the same request were made simultaneously.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.CreateSipMediaApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/CreateSipMediaApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSipMediaApplicationResponse> createSipMediaApplication(
            CreateSipMediaApplicationRequest createSipMediaApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a SIP media application. For more information about SIP media applications, see <a
     * href="https://docs.aws.amazon.com/chime-sdk/latest/ag/manage-sip-applications.html">Managing SIP media
     * applications and rules</a> in the <i>Amazon Chime SDK Administrator Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSipMediaApplicationRequest.Builder} avoiding
     * the need to create one manually via {@link CreateSipMediaApplicationRequest#builder()}
     * </p>
     *
     * @param createSipMediaApplicationRequest
     *        A {@link Consumer} that will call methods on {@link CreateSipMediaApplicationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateSipMediaApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>AccessDeniedException You don't have the permissions needed to run this action.</li>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ResourceLimitExceededException The request exceeds the resource limit.</li>
     *         <li>ConflictException Multiple instances of the same request were made simultaneously.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.CreateSipMediaApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/CreateSipMediaApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSipMediaApplicationResponse> createSipMediaApplication(
            Consumer<CreateSipMediaApplicationRequest.Builder> createSipMediaApplicationRequest) {
        return createSipMediaApplication(CreateSipMediaApplicationRequest.builder()
                .applyMutation(createSipMediaApplicationRequest).build());
    }

    /**
     * <p>
     * Creates an outbound call to a phone number from the phone number specified in the request, and it invokes the
     * endpoint of the specified <code>sipMediaApplicationId</code>.
     * </p>
     *
     * @param createSipMediaApplicationCallRequest
     * @return A Java Future containing the result of the CreateSipMediaApplicationCall operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>ResourceLimitExceededException The request exceeds the resource limit.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>AccessDeniedException You don't have the permissions needed to run this action.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.CreateSipMediaApplicationCall
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/CreateSipMediaApplicationCall"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSipMediaApplicationCallResponse> createSipMediaApplicationCall(
            CreateSipMediaApplicationCallRequest createSipMediaApplicationCallRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an outbound call to a phone number from the phone number specified in the request, and it invokes the
     * endpoint of the specified <code>sipMediaApplicationId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSipMediaApplicationCallRequest.Builder}
     * avoiding the need to create one manually via {@link CreateSipMediaApplicationCallRequest#builder()}
     * </p>
     *
     * @param createSipMediaApplicationCallRequest
     *        A {@link Consumer} that will call methods on {@link CreateSipMediaApplicationCallRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateSipMediaApplicationCall operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>ResourceLimitExceededException The request exceeds the resource limit.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>AccessDeniedException You don't have the permissions needed to run this action.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.CreateSipMediaApplicationCall
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/CreateSipMediaApplicationCall"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSipMediaApplicationCallResponse> createSipMediaApplicationCall(
            Consumer<CreateSipMediaApplicationCallRequest.Builder> createSipMediaApplicationCallRequest) {
        return createSipMediaApplicationCall(CreateSipMediaApplicationCallRequest.builder()
                .applyMutation(createSipMediaApplicationCallRequest).build());
    }

    /**
     * <p>
     * Creates a SIP rule, which can be used to run a SIP media application as a target for a specific trigger type. For
     * more information about SIP rules, see <a
     * href="https://docs.aws.amazon.com/chime-sdk/latest/ag/manage-sip-applications.html">Managing SIP media
     * applications and rules</a> in the <i>Amazon Chime SDK Administrator Guide</i>.
     * </p>
     *
     * @param createSipRuleRequest
     * @return A Java Future containing the result of the CreateSipRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>AccessDeniedException You don't have the permissions needed to run this action.</li>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ResourceLimitExceededException The request exceeds the resource limit.</li>
     *         <li>ConflictException Multiple instances of the same request were made simultaneously.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.CreateSipRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/CreateSipRule" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateSipRuleResponse> createSipRule(CreateSipRuleRequest createSipRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a SIP rule, which can be used to run a SIP media application as a target for a specific trigger type. For
     * more information about SIP rules, see <a
     * href="https://docs.aws.amazon.com/chime-sdk/latest/ag/manage-sip-applications.html">Managing SIP media
     * applications and rules</a> in the <i>Amazon Chime SDK Administrator Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSipRuleRequest.Builder} avoiding the need to
     * create one manually via {@link CreateSipRuleRequest#builder()}
     * </p>
     *
     * @param createSipRuleRequest
     *        A {@link Consumer} that will call methods on {@link CreateSipRuleRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateSipRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>AccessDeniedException You don't have the permissions needed to run this action.</li>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ResourceLimitExceededException The request exceeds the resource limit.</li>
     *         <li>ConflictException Multiple instances of the same request were made simultaneously.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.CreateSipRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/CreateSipRule" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateSipRuleResponse> createSipRule(Consumer<CreateSipRuleRequest.Builder> createSipRuleRequest) {
        return createSipRule(CreateSipRuleRequest.builder().applyMutation(createSipRuleRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon Chime SDK Voice Connector. For more information about Voice Connectors, see <a
     * href="https://docs.aws.amazon.com/chime-sdk/latest/ag/voice-connector-groups.html">Managing Amazon Chime SDK
     * Voice Connector groups</a> in the <i>Amazon Chime SDK Administrator Guide</i>.
     * </p>
     *
     * @param createVoiceConnectorRequest
     * @return A Java Future containing the result of the CreateVoiceConnector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>AccessDeniedException You don't have the permissions needed to run this action.</li>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ResourceLimitExceededException The request exceeds the resource limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.CreateVoiceConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/CreateVoiceConnector"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateVoiceConnectorResponse> createVoiceConnector(
            CreateVoiceConnectorRequest createVoiceConnectorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon Chime SDK Voice Connector. For more information about Voice Connectors, see <a
     * href="https://docs.aws.amazon.com/chime-sdk/latest/ag/voice-connector-groups.html">Managing Amazon Chime SDK
     * Voice Connector groups</a> in the <i>Amazon Chime SDK Administrator Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVoiceConnectorRequest.Builder} avoiding the
     * need to create one manually via {@link CreateVoiceConnectorRequest#builder()}
     * </p>
     *
     * @param createVoiceConnectorRequest
     *        A {@link Consumer} that will call methods on {@link CreateVoiceConnectorRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateVoiceConnector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>AccessDeniedException You don't have the permissions needed to run this action.</li>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ResourceLimitExceededException The request exceeds the resource limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.CreateVoiceConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/CreateVoiceConnector"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateVoiceConnectorResponse> createVoiceConnector(
            Consumer<CreateVoiceConnectorRequest.Builder> createVoiceConnectorRequest) {
        return createVoiceConnector(CreateVoiceConnectorRequest.builder().applyMutation(createVoiceConnectorRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon Chime SDK Voice Connector group under the administrator's AWS account. You can associate Amazon
     * Chime SDK Voice Connectors with the Voice Connector group by including <code>VoiceConnectorItems</code> in the
     * request.
     * </p>
     * <p>
     * You can include Voice Connectors from different AWS Regions in your group. This creates a fault tolerant
     * mechanism for fallback in case of availability events.
     * </p>
     *
     * @param createVoiceConnectorGroupRequest
     * @return A Java Future containing the result of the CreateVoiceConnectorGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>AccessDeniedException You don't have the permissions needed to run this action.</li>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ResourceLimitExceededException The request exceeds the resource limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.CreateVoiceConnectorGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/CreateVoiceConnectorGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateVoiceConnectorGroupResponse> createVoiceConnectorGroup(
            CreateVoiceConnectorGroupRequest createVoiceConnectorGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon Chime SDK Voice Connector group under the administrator's AWS account. You can associate Amazon
     * Chime SDK Voice Connectors with the Voice Connector group by including <code>VoiceConnectorItems</code> in the
     * request.
     * </p>
     * <p>
     * You can include Voice Connectors from different AWS Regions in your group. This creates a fault tolerant
     * mechanism for fallback in case of availability events.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVoiceConnectorGroupRequest.Builder} avoiding
     * the need to create one manually via {@link CreateVoiceConnectorGroupRequest#builder()}
     * </p>
     *
     * @param createVoiceConnectorGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateVoiceConnectorGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateVoiceConnectorGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>AccessDeniedException You don't have the permissions needed to run this action.</li>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ResourceLimitExceededException The request exceeds the resource limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.CreateVoiceConnectorGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/CreateVoiceConnectorGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateVoiceConnectorGroupResponse> createVoiceConnectorGroup(
            Consumer<CreateVoiceConnectorGroupRequest.Builder> createVoiceConnectorGroupRequest) {
        return createVoiceConnectorGroup(CreateVoiceConnectorGroupRequest.builder()
                .applyMutation(createVoiceConnectorGroupRequest).build());
    }

    /**
     * <p>
     * Creates a voice profile, which consists of an enrolled user and their latest voice print.
     * </p>
     * <important>
     * <p>
     * Before creating any voice profiles, you must provide all notices and obtain all consents from the speaker as
     * required under applicable privacy and biometrics laws, and as required under the <a
     * href="https://aws.amazon.com/service-terms/">AWS service terms</a> for the Amazon Chime SDK.
     * </p>
     * </important>
     * <p>
     * For more information about voice profiles and voice analytics, see <a
     * href="https://docs.aws.amazon.com/chime-sdk/latest/dg/pstn-voice-analytics.html">Using Amazon Chime SDK Voice
     * Analytics</a> in the <i>Amazon Chime SDK Developer Guide</i>.
     * </p>
     *
     * @param createVoiceProfileRequest
     * @return A Java Future containing the result of the CreateVoiceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ResourceLimitExceededException The request exceeds the resource limit.</li>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>AccessDeniedException You don't have the permissions needed to run this action.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ConflictException Multiple instances of the same request were made simultaneously.</li>
     *         <li>GoneException Access to the target resource is no longer available at the origin server. This
     *         condition is likely to be permanent.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.CreateVoiceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/CreateVoiceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateVoiceProfileResponse> createVoiceProfile(CreateVoiceProfileRequest createVoiceProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a voice profile, which consists of an enrolled user and their latest voice print.
     * </p>
     * <important>
     * <p>
     * Before creating any voice profiles, you must provide all notices and obtain all consents from the speaker as
     * required under applicable privacy and biometrics laws, and as required under the <a
     * href="https://aws.amazon.com/service-terms/">AWS service terms</a> for the Amazon Chime SDK.
     * </p>
     * </important>
     * <p>
     * For more information about voice profiles and voice analytics, see <a
     * href="https://docs.aws.amazon.com/chime-sdk/latest/dg/pstn-voice-analytics.html">Using Amazon Chime SDK Voice
     * Analytics</a> in the <i>Amazon Chime SDK Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVoiceProfileRequest.Builder} avoiding the
     * need to create one manually via {@link CreateVoiceProfileRequest#builder()}
     * </p>
     *
     * @param createVoiceProfileRequest
     *        A {@link Consumer} that will call methods on {@link CreateVoiceProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateVoiceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ResourceLimitExceededException The request exceeds the resource limit.</li>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>AccessDeniedException You don't have the permissions needed to run this action.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ConflictException Multiple instances of the same request were made simultaneously.</li>
     *         <li>GoneException Access to the target resource is no longer available at the origin server. This
     *         condition is likely to be permanent.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.CreateVoiceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/CreateVoiceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateVoiceProfileResponse> createVoiceProfile(
            Consumer<CreateVoiceProfileRequest.Builder> createVoiceProfileRequest) {
        return createVoiceProfile(CreateVoiceProfileRequest.builder().applyMutation(createVoiceProfileRequest).build());
    }

    /**
     * <p>
     * Creates a voice profile domain, a collection of voice profiles, their voice prints, and encrypted enrollment
     * audio.
     * </p>
     * <important>
     * <p>
     * Before creating any voice profiles, you must provide all notices and obtain all consents from the speaker as
     * required under applicable privacy and biometrics laws, and as required under the <a
     * href="https://aws.amazon.com/service-terms/">AWS service terms</a> for the Amazon Chime SDK.
     * </p>
     * </important>
     * <p>
     * For more information about voice profile domains, see <a
     * href="https://docs.aws.amazon.com/chime-sdk/latest/dg/pstn-voice-analytics.html">Using Amazon Chime SDK Voice
     * Analytics</a> in the <i>Amazon Chime SDK Developer Guide</i>.
     * </p>
     *
     * @param createVoiceProfileDomainRequest
     * @return A Java Future containing the result of the CreateVoiceProfileDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>AccessDeniedException You don't have the permissions needed to run this action.</li>
     *         <li>ConflictException Multiple instances of the same request were made simultaneously.</li>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ResourceLimitExceededException The request exceeds the resource limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.CreateVoiceProfileDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/CreateVoiceProfileDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateVoiceProfileDomainResponse> createVoiceProfileDomain(
            CreateVoiceProfileDomainRequest createVoiceProfileDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a voice profile domain, a collection of voice profiles, their voice prints, and encrypted enrollment
     * audio.
     * </p>
     * <important>
     * <p>
     * Before creating any voice profiles, you must provide all notices and obtain all consents from the speaker as
     * required under applicable privacy and biometrics laws, and as required under the <a
     * href="https://aws.amazon.com/service-terms/">AWS service terms</a> for the Amazon Chime SDK.
     * </p>
     * </important>
     * <p>
     * For more information about voice profile domains, see <a
     * href="https://docs.aws.amazon.com/chime-sdk/latest/dg/pstn-voice-analytics.html">Using Amazon Chime SDK Voice
     * Analytics</a> in the <i>Amazon Chime SDK Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVoiceProfileDomainRequest.Builder} avoiding
     * the need to create one manually via {@link CreateVoiceProfileDomainRequest#builder()}
     * </p>
     *
     * @param createVoiceProfileDomainRequest
     *        A {@link Consumer} that will call methods on {@link CreateVoiceProfileDomainRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateVoiceProfileDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>AccessDeniedException You don't have the permissions needed to run this action.</li>
     *         <li>ConflictException Multiple instances of the same request were made simultaneously.</li>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ResourceLimitExceededException The request exceeds the resource limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.CreateVoiceProfileDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/CreateVoiceProfileDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateVoiceProfileDomainResponse> createVoiceProfileDomain(
            Consumer<CreateVoiceProfileDomainRequest.Builder> createVoiceProfileDomainRequest) {
        return createVoiceProfileDomain(CreateVoiceProfileDomainRequest.builder().applyMutation(createVoiceProfileDomainRequest)
                .build());
    }

    /**
     * <p>
     * Moves the specified phone number into the <b>Deletion queue</b>. A phone number must be disassociated from any
     * users or Amazon Chime SDK Voice Connectors before it can be deleted.
     * </p>
     * <p>
     * Deleted phone numbers remain in the <b>Deletion queue</b> queue for 7 days before they are deleted permanently.
     * </p>
     *
     * @param deletePhoneNumberRequest
     * @return A Java Future containing the result of the DeletePhoneNumber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.DeletePhoneNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DeletePhoneNumber"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeletePhoneNumberResponse> deletePhoneNumber(DeletePhoneNumberRequest deletePhoneNumberRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Moves the specified phone number into the <b>Deletion queue</b>. A phone number must be disassociated from any
     * users or Amazon Chime SDK Voice Connectors before it can be deleted.
     * </p>
     * <p>
     * Deleted phone numbers remain in the <b>Deletion queue</b> queue for 7 days before they are deleted permanently.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePhoneNumberRequest.Builder} avoiding the need
     * to create one manually via {@link DeletePhoneNumberRequest#builder()}
     * </p>
     *
     * @param deletePhoneNumberRequest
     *        A {@link Consumer} that will call methods on {@link DeletePhoneNumberRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeletePhoneNumber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.DeletePhoneNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DeletePhoneNumber"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeletePhoneNumberResponse> deletePhoneNumber(
            Consumer<DeletePhoneNumberRequest.Builder> deletePhoneNumberRequest) {
        return deletePhoneNumber(DeletePhoneNumberRequest.builder().applyMutation(deletePhoneNumberRequest).build());
    }

    /**
     * <p>
     * Deletes the specified proxy session from the specified Amazon Chime SDK Voice Connector.
     * </p>
     *
     * @param deleteProxySessionRequest
     * @return A Java Future containing the result of the DeleteProxySession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.DeleteProxySession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DeleteProxySession"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteProxySessionResponse> deleteProxySession(DeleteProxySessionRequest deleteProxySessionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified proxy session from the specified Amazon Chime SDK Voice Connector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProxySessionRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteProxySessionRequest#builder()}
     * </p>
     *
     * @param deleteProxySessionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteProxySessionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteProxySession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.DeleteProxySession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DeleteProxySession"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteProxySessionResponse> deleteProxySession(
            Consumer<DeleteProxySessionRequest.Builder> deleteProxySessionRequest) {
        return deleteProxySession(DeleteProxySessionRequest.builder().applyMutation(deleteProxySessionRequest).build());
    }

    /**
     * <p>
     * Deletes a SIP media application.
     * </p>
     *
     * @param deleteSipMediaApplicationRequest
     * @return A Java Future containing the result of the DeleteSipMediaApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ConflictException Multiple instances of the same request were made simultaneously.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.DeleteSipMediaApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DeleteSipMediaApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSipMediaApplicationResponse> deleteSipMediaApplication(
            DeleteSipMediaApplicationRequest deleteSipMediaApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a SIP media application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSipMediaApplicationRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteSipMediaApplicationRequest#builder()}
     * </p>
     *
     * @param deleteSipMediaApplicationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSipMediaApplicationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteSipMediaApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ConflictException Multiple instances of the same request were made simultaneously.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.DeleteSipMediaApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DeleteSipMediaApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSipMediaApplicationResponse> deleteSipMediaApplication(
            Consumer<DeleteSipMediaApplicationRequest.Builder> deleteSipMediaApplicationRequest) {
        return deleteSipMediaApplication(DeleteSipMediaApplicationRequest.builder()
                .applyMutation(deleteSipMediaApplicationRequest).build());
    }

    /**
     * <p>
     * Deletes a SIP rule.
     * </p>
     *
     * @param deleteSipRuleRequest
     * @return A Java Future containing the result of the DeleteSipRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ConflictException Multiple instances of the same request were made simultaneously.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.DeleteSipRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DeleteSipRule" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteSipRuleResponse> deleteSipRule(DeleteSipRuleRequest deleteSipRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a SIP rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSipRuleRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteSipRuleRequest#builder()}
     * </p>
     *
     * @param deleteSipRuleRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSipRuleRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteSipRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ConflictException Multiple instances of the same request were made simultaneously.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.DeleteSipRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DeleteSipRule" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteSipRuleResponse> deleteSipRule(Consumer<DeleteSipRuleRequest.Builder> deleteSipRuleRequest) {
        return deleteSipRule(DeleteSipRuleRequest.builder().applyMutation(deleteSipRuleRequest).build());
    }

    /**
     * <p>
     * Deletes an Amazon Chime SDK Voice Connector. Any phone numbers associated with the Amazon Chime SDK Voice
     * Connector must be disassociated from it before it can be deleted.
     * </p>
     *
     * @param deleteVoiceConnectorRequest
     * @return A Java Future containing the result of the DeleteVoiceConnector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ConflictException Multiple instances of the same request were made simultaneously.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.DeleteVoiceConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DeleteVoiceConnector"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteVoiceConnectorResponse> deleteVoiceConnector(
            DeleteVoiceConnectorRequest deleteVoiceConnectorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Amazon Chime SDK Voice Connector. Any phone numbers associated with the Amazon Chime SDK Voice
     * Connector must be disassociated from it before it can be deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVoiceConnectorRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteVoiceConnectorRequest#builder()}
     * </p>
     *
     * @param deleteVoiceConnectorRequest
     *        A {@link Consumer} that will call methods on {@link DeleteVoiceConnectorRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteVoiceConnector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ConflictException Multiple instances of the same request were made simultaneously.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.DeleteVoiceConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DeleteVoiceConnector"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteVoiceConnectorResponse> deleteVoiceConnector(
            Consumer<DeleteVoiceConnectorRequest.Builder> deleteVoiceConnectorRequest) {
        return deleteVoiceConnector(DeleteVoiceConnectorRequest.builder().applyMutation(deleteVoiceConnectorRequest).build());
    }

    /**
     * <p>
     * Deletes the emergency calling details from the specified Amazon Chime SDK Voice Connector.
     * </p>
     *
     * @param deleteVoiceConnectorEmergencyCallingConfigurationRequest
     * @return A Java Future containing the result of the DeleteVoiceConnectorEmergencyCallingConfiguration operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.DeleteVoiceConnectorEmergencyCallingConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DeleteVoiceConnectorEmergencyCallingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteVoiceConnectorEmergencyCallingConfigurationResponse> deleteVoiceConnectorEmergencyCallingConfiguration(
            DeleteVoiceConnectorEmergencyCallingConfigurationRequest deleteVoiceConnectorEmergencyCallingConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the emergency calling details from the specified Amazon Chime SDK Voice Connector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteVoiceConnectorEmergencyCallingConfigurationRequest.Builder} avoiding the need to create one manually
     * via {@link DeleteVoiceConnectorEmergencyCallingConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteVoiceConnectorEmergencyCallingConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DeleteVoiceConnectorEmergencyCallingConfigurationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteVoiceConnectorEmergencyCallingConfiguration operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.DeleteVoiceConnectorEmergencyCallingConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DeleteVoiceConnectorEmergencyCallingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteVoiceConnectorEmergencyCallingConfigurationResponse> deleteVoiceConnectorEmergencyCallingConfiguration(
            Consumer<DeleteVoiceConnectorEmergencyCallingConfigurationRequest.Builder> deleteVoiceConnectorEmergencyCallingConfigurationRequest) {
        return deleteVoiceConnectorEmergencyCallingConfiguration(DeleteVoiceConnectorEmergencyCallingConfigurationRequest
                .builder().applyMutation(deleteVoiceConnectorEmergencyCallingConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes an Amazon Chime SDK Voice Connector group. Any <code>VoiceConnectorItems</code> and phone numbers
     * associated with the group must be removed before it can be deleted.
     * </p>
     *
     * @param deleteVoiceConnectorGroupRequest
     * @return A Java Future containing the result of the DeleteVoiceConnectorGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ConflictException Multiple instances of the same request were made simultaneously.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.DeleteVoiceConnectorGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DeleteVoiceConnectorGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteVoiceConnectorGroupResponse> deleteVoiceConnectorGroup(
            DeleteVoiceConnectorGroupRequest deleteVoiceConnectorGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Amazon Chime SDK Voice Connector group. Any <code>VoiceConnectorItems</code> and phone numbers
     * associated with the group must be removed before it can be deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVoiceConnectorGroupRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteVoiceConnectorGroupRequest#builder()}
     * </p>
     *
     * @param deleteVoiceConnectorGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteVoiceConnectorGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteVoiceConnectorGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ConflictException Multiple instances of the same request were made simultaneously.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.DeleteVoiceConnectorGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DeleteVoiceConnectorGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteVoiceConnectorGroupResponse> deleteVoiceConnectorGroup(
            Consumer<DeleteVoiceConnectorGroupRequest.Builder> deleteVoiceConnectorGroupRequest) {
        return deleteVoiceConnectorGroup(DeleteVoiceConnectorGroupRequest.builder()
                .applyMutation(deleteVoiceConnectorGroupRequest).build());
    }

    /**
     * <p>
     * Deletes the origination settings for the specified Amazon Chime SDK Voice Connector.
     * </p>
     * <note>
     * <p>
     * If emergency calling is configured for the Voice Connector, it must be deleted prior to deleting the origination
     * settings.
     * </p>
     * </note>
     *
     * @param deleteVoiceConnectorOriginationRequest
     * @return A Java Future containing the result of the DeleteVoiceConnectorOrigination operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.DeleteVoiceConnectorOrigination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DeleteVoiceConnectorOrigination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteVoiceConnectorOriginationResponse> deleteVoiceConnectorOrigination(
            DeleteVoiceConnectorOriginationRequest deleteVoiceConnectorOriginationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the origination settings for the specified Amazon Chime SDK Voice Connector.
     * </p>
     * <note>
     * <p>
     * If emergency calling is configured for the Voice Connector, it must be deleted prior to deleting the origination
     * settings.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVoiceConnectorOriginationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteVoiceConnectorOriginationRequest#builder()}
     * </p>
     *
     * @param deleteVoiceConnectorOriginationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteVoiceConnectorOriginationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteVoiceConnectorOrigination operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.DeleteVoiceConnectorOrigination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DeleteVoiceConnectorOrigination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteVoiceConnectorOriginationResponse> deleteVoiceConnectorOrigination(
            Consumer<DeleteVoiceConnectorOriginationRequest.Builder> deleteVoiceConnectorOriginationRequest) {
        return deleteVoiceConnectorOrigination(DeleteVoiceConnectorOriginationRequest.builder()
                .applyMutation(deleteVoiceConnectorOriginationRequest).build());
    }

    /**
     * <p>
     * Deletes the proxy configuration from the specified Amazon Chime SDK Voice Connector.
     * </p>
     *
     * @param deleteVoiceConnectorProxyRequest
     * @return A Java Future containing the result of the DeleteVoiceConnectorProxy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.DeleteVoiceConnectorProxy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DeleteVoiceConnectorProxy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteVoiceConnectorProxyResponse> deleteVoiceConnectorProxy(
            DeleteVoiceConnectorProxyRequest deleteVoiceConnectorProxyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the proxy configuration from the specified Amazon Chime SDK Voice Connector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVoiceConnectorProxyRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteVoiceConnectorProxyRequest#builder()}
     * </p>
     *
     * @param deleteVoiceConnectorProxyRequest
     *        A {@link Consumer} that will call methods on {@link DeleteVoiceConnectorProxyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteVoiceConnectorProxy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.DeleteVoiceConnectorProxy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DeleteVoiceConnectorProxy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteVoiceConnectorProxyResponse> deleteVoiceConnectorProxy(
            Consumer<DeleteVoiceConnectorProxyRequest.Builder> deleteVoiceConnectorProxyRequest) {
        return deleteVoiceConnectorProxy(DeleteVoiceConnectorProxyRequest.builder()
                .applyMutation(deleteVoiceConnectorProxyRequest).build());
    }

    /**
     * <p>
     * Deletes a Voice Connector's streaming configuration.
     * </p>
     *
     * @param deleteVoiceConnectorStreamingConfigurationRequest
     * @return A Java Future containing the result of the DeleteVoiceConnectorStreamingConfiguration operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.DeleteVoiceConnectorStreamingConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DeleteVoiceConnectorStreamingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteVoiceConnectorStreamingConfigurationResponse> deleteVoiceConnectorStreamingConfiguration(
            DeleteVoiceConnectorStreamingConfigurationRequest deleteVoiceConnectorStreamingConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Voice Connector's streaming configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteVoiceConnectorStreamingConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteVoiceConnectorStreamingConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteVoiceConnectorStreamingConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DeleteVoiceConnectorStreamingConfigurationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteVoiceConnectorStreamingConfiguration operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.DeleteVoiceConnectorStreamingConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DeleteVoiceConnectorStreamingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteVoiceConnectorStreamingConfigurationResponse> deleteVoiceConnectorStreamingConfiguration(
            Consumer<DeleteVoiceConnectorStreamingConfigurationRequest.Builder> deleteVoiceConnectorStreamingConfigurationRequest) {
        return deleteVoiceConnectorStreamingConfiguration(DeleteVoiceConnectorStreamingConfigurationRequest.builder()
                .applyMutation(deleteVoiceConnectorStreamingConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes the termination settings for the specified Amazon Chime SDK Voice Connector.
     * </p>
     * <note>
     * <p>
     * If emergency calling is configured for the Voice Connector, it must be deleted prior to deleting the termination
     * settings.
     * </p>
     * </note>
     *
     * @param deleteVoiceConnectorTerminationRequest
     * @return A Java Future containing the result of the DeleteVoiceConnectorTermination operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.DeleteVoiceConnectorTermination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DeleteVoiceConnectorTermination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteVoiceConnectorTerminationResponse> deleteVoiceConnectorTermination(
            DeleteVoiceConnectorTerminationRequest deleteVoiceConnectorTerminationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the termination settings for the specified Amazon Chime SDK Voice Connector.
     * </p>
     * <note>
     * <p>
     * If emergency calling is configured for the Voice Connector, it must be deleted prior to deleting the termination
     * settings.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVoiceConnectorTerminationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteVoiceConnectorTerminationRequest#builder()}
     * </p>
     *
     * @param deleteVoiceConnectorTerminationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteVoiceConnectorTerminationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteVoiceConnectorTermination operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.DeleteVoiceConnectorTermination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DeleteVoiceConnectorTermination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteVoiceConnectorTerminationResponse> deleteVoiceConnectorTermination(
            Consumer<DeleteVoiceConnectorTerminationRequest.Builder> deleteVoiceConnectorTerminationRequest) {
        return deleteVoiceConnectorTermination(DeleteVoiceConnectorTerminationRequest.builder()
                .applyMutation(deleteVoiceConnectorTerminationRequest).build());
    }

    /**
     * <p>
     * Deletes the specified SIP credentials used by your equipment to authenticate during call termination.
     * </p>
     *
     * @param deleteVoiceConnectorTerminationCredentialsRequest
     * @return A Java Future containing the result of the DeleteVoiceConnectorTerminationCredentials operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.DeleteVoiceConnectorTerminationCredentials
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DeleteVoiceConnectorTerminationCredentials"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteVoiceConnectorTerminationCredentialsResponse> deleteVoiceConnectorTerminationCredentials(
            DeleteVoiceConnectorTerminationCredentialsRequest deleteVoiceConnectorTerminationCredentialsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified SIP credentials used by your equipment to authenticate during call termination.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteVoiceConnectorTerminationCredentialsRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteVoiceConnectorTerminationCredentialsRequest#builder()}
     * </p>
     *
     * @param deleteVoiceConnectorTerminationCredentialsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DeleteVoiceConnectorTerminationCredentialsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteVoiceConnectorTerminationCredentials operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.DeleteVoiceConnectorTerminationCredentials
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DeleteVoiceConnectorTerminationCredentials"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteVoiceConnectorTerminationCredentialsResponse> deleteVoiceConnectorTerminationCredentials(
            Consumer<DeleteVoiceConnectorTerminationCredentialsRequest.Builder> deleteVoiceConnectorTerminationCredentialsRequest) {
        return deleteVoiceConnectorTerminationCredentials(DeleteVoiceConnectorTerminationCredentialsRequest.builder()
                .applyMutation(deleteVoiceConnectorTerminationCredentialsRequest).build());
    }

    /**
     * <p>
     * Deletes a voice profile, including its voice print and enrollment data. WARNING: This action is not reversible.
     * </p>
     *
     * @param deleteVoiceProfileRequest
     * @return A Java Future containing the result of the DeleteVoiceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>AccessDeniedException You don't have the permissions needed to run this action.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ConflictException Multiple instances of the same request were made simultaneously.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.DeleteVoiceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DeleteVoiceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteVoiceProfileResponse> deleteVoiceProfile(DeleteVoiceProfileRequest deleteVoiceProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a voice profile, including its voice print and enrollment data. WARNING: This action is not reversible.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVoiceProfileRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteVoiceProfileRequest#builder()}
     * </p>
     *
     * @param deleteVoiceProfileRequest
     *        A {@link Consumer} that will call methods on {@link DeleteVoiceProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteVoiceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>AccessDeniedException You don't have the permissions needed to run this action.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ConflictException Multiple instances of the same request were made simultaneously.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.DeleteVoiceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DeleteVoiceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteVoiceProfileResponse> deleteVoiceProfile(
            Consumer<DeleteVoiceProfileRequest.Builder> deleteVoiceProfileRequest) {
        return deleteVoiceProfile(DeleteVoiceProfileRequest.builder().applyMutation(deleteVoiceProfileRequest).build());
    }

    /**
     * <p>
     * Deletes all voice profiles in the domain. WARNING: This action is not reversible.
     * </p>
     *
     * @param deleteVoiceProfileDomainRequest
     * @return A Java Future containing the result of the DeleteVoiceProfileDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>AccessDeniedException You don't have the permissions needed to run this action.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ConflictException Multiple instances of the same request were made simultaneously.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.DeleteVoiceProfileDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DeleteVoiceProfileDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteVoiceProfileDomainResponse> deleteVoiceProfileDomain(
            DeleteVoiceProfileDomainRequest deleteVoiceProfileDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes all voice profiles in the domain. WARNING: This action is not reversible.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVoiceProfileDomainRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteVoiceProfileDomainRequest#builder()}
     * </p>
     *
     * @param deleteVoiceProfileDomainRequest
     *        A {@link Consumer} that will call methods on {@link DeleteVoiceProfileDomainRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteVoiceProfileDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>AccessDeniedException You don't have the permissions needed to run this action.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ConflictException Multiple instances of the same request were made simultaneously.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.DeleteVoiceProfileDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DeleteVoiceProfileDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteVoiceProfileDomainResponse> deleteVoiceProfileDomain(
            Consumer<DeleteVoiceProfileDomainRequest.Builder> deleteVoiceProfileDomainRequest) {
        return deleteVoiceProfileDomain(DeleteVoiceProfileDomainRequest.builder().applyMutation(deleteVoiceProfileDomainRequest)
                .build());
    }

    /**
     * <p>
     * Disassociates the specified phone numbers from the specified Amazon Chime SDK Voice Connector.
     * </p>
     *
     * @param disassociatePhoneNumbersFromVoiceConnectorRequest
     * @return A Java Future containing the result of the DisassociatePhoneNumbersFromVoiceConnector operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.DisassociatePhoneNumbersFromVoiceConnector
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DisassociatePhoneNumbersFromVoiceConnector"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociatePhoneNumbersFromVoiceConnectorResponse> disassociatePhoneNumbersFromVoiceConnector(
            DisassociatePhoneNumbersFromVoiceConnectorRequest disassociatePhoneNumbersFromVoiceConnectorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates the specified phone numbers from the specified Amazon Chime SDK Voice Connector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DisassociatePhoneNumbersFromVoiceConnectorRequest.Builder} avoiding the need to create one manually via
     * {@link DisassociatePhoneNumbersFromVoiceConnectorRequest#builder()}
     * </p>
     *
     * @param disassociatePhoneNumbersFromVoiceConnectorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DisassociatePhoneNumbersFromVoiceConnectorRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DisassociatePhoneNumbersFromVoiceConnector operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.DisassociatePhoneNumbersFromVoiceConnector
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DisassociatePhoneNumbersFromVoiceConnector"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociatePhoneNumbersFromVoiceConnectorResponse> disassociatePhoneNumbersFromVoiceConnector(
            Consumer<DisassociatePhoneNumbersFromVoiceConnectorRequest.Builder> disassociatePhoneNumbersFromVoiceConnectorRequest) {
        return disassociatePhoneNumbersFromVoiceConnector(DisassociatePhoneNumbersFromVoiceConnectorRequest.builder()
                .applyMutation(disassociatePhoneNumbersFromVoiceConnectorRequest).build());
    }

    /**
     * <p>
     * Disassociates the specified phone numbers from the specified Amazon Chime SDK Voice Connector group.
     * </p>
     *
     * @param disassociatePhoneNumbersFromVoiceConnectorGroupRequest
     * @return A Java Future containing the result of the DisassociatePhoneNumbersFromVoiceConnectorGroup operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.DisassociatePhoneNumbersFromVoiceConnectorGroup
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DisassociatePhoneNumbersFromVoiceConnectorGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociatePhoneNumbersFromVoiceConnectorGroupResponse> disassociatePhoneNumbersFromVoiceConnectorGroup(
            DisassociatePhoneNumbersFromVoiceConnectorGroupRequest disassociatePhoneNumbersFromVoiceConnectorGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates the specified phone numbers from the specified Amazon Chime SDK Voice Connector group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DisassociatePhoneNumbersFromVoiceConnectorGroupRequest.Builder} avoiding the need to create one manually
     * via {@link DisassociatePhoneNumbersFromVoiceConnectorGroupRequest#builder()}
     * </p>
     *
     * @param disassociatePhoneNumbersFromVoiceConnectorGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DisassociatePhoneNumbersFromVoiceConnectorGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DisassociatePhoneNumbersFromVoiceConnectorGroup operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.DisassociatePhoneNumbersFromVoiceConnectorGroup
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/DisassociatePhoneNumbersFromVoiceConnectorGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociatePhoneNumbersFromVoiceConnectorGroupResponse> disassociatePhoneNumbersFromVoiceConnectorGroup(
            Consumer<DisassociatePhoneNumbersFromVoiceConnectorGroupRequest.Builder> disassociatePhoneNumbersFromVoiceConnectorGroupRequest) {
        return disassociatePhoneNumbersFromVoiceConnectorGroup(DisassociatePhoneNumbersFromVoiceConnectorGroupRequest.builder()
                .applyMutation(disassociatePhoneNumbersFromVoiceConnectorGroupRequest).build());
    }

    /**
     * <p>
     * Retrieves the global settings for the Amazon Chime SDK Voice Connectors in an AWS account.
     * </p>
     *
     * @param getGlobalSettingsRequest
     * @return A Java Future containing the result of the GetGlobalSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.GetGlobalSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetGlobalSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetGlobalSettingsResponse> getGlobalSettings(GetGlobalSettingsRequest getGlobalSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the global settings for the Amazon Chime SDK Voice Connectors in an AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGlobalSettingsRequest.Builder} avoiding the need
     * to create one manually via {@link GetGlobalSettingsRequest#builder()}
     * </p>
     *
     * @param getGlobalSettingsRequest
     *        A {@link Consumer} that will call methods on {@link GetGlobalSettingsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetGlobalSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.GetGlobalSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetGlobalSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetGlobalSettingsResponse> getGlobalSettings(
            Consumer<GetGlobalSettingsRequest.Builder> getGlobalSettingsRequest) {
        return getGlobalSettings(GetGlobalSettingsRequest.builder().applyMutation(getGlobalSettingsRequest).build());
    }

    /**
     * <p>
     * Retrieves details for the specified phone number ID, such as associations, capabilities, and product type.
     * </p>
     *
     * @param getPhoneNumberRequest
     * @return A Java Future containing the result of the GetPhoneNumber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.GetPhoneNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetPhoneNumber"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetPhoneNumberResponse> getPhoneNumber(GetPhoneNumberRequest getPhoneNumberRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details for the specified phone number ID, such as associations, capabilities, and product type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPhoneNumberRequest.Builder} avoiding the need to
     * create one manually via {@link GetPhoneNumberRequest#builder()}
     * </p>
     *
     * @param getPhoneNumberRequest
     *        A {@link Consumer} that will call methods on {@link GetPhoneNumberRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetPhoneNumber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.GetPhoneNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetPhoneNumber"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetPhoneNumberResponse> getPhoneNumber(Consumer<GetPhoneNumberRequest.Builder> getPhoneNumberRequest) {
        return getPhoneNumber(GetPhoneNumberRequest.builder().applyMutation(getPhoneNumberRequest).build());
    }

    /**
     * <p>
     * Retrieves details for the specified phone number order, such as the order creation timestamp, phone numbers in
     * E.164 format, product type, and order status.
     * </p>
     *
     * @param getPhoneNumberOrderRequest
     * @return A Java Future containing the result of the GetPhoneNumberOrder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.GetPhoneNumberOrder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetPhoneNumberOrder"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetPhoneNumberOrderResponse> getPhoneNumberOrder(
            GetPhoneNumberOrderRequest getPhoneNumberOrderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details for the specified phone number order, such as the order creation timestamp, phone numbers in
     * E.164 format, product type, and order status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPhoneNumberOrderRequest.Builder} avoiding the
     * need to create one manually via {@link GetPhoneNumberOrderRequest#builder()}
     * </p>
     *
     * @param getPhoneNumberOrderRequest
     *        A {@link Consumer} that will call methods on {@link GetPhoneNumberOrderRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetPhoneNumberOrder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.GetPhoneNumberOrder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetPhoneNumberOrder"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetPhoneNumberOrderResponse> getPhoneNumberOrder(
            Consumer<GetPhoneNumberOrderRequest.Builder> getPhoneNumberOrderRequest) {
        return getPhoneNumberOrder(GetPhoneNumberOrderRequest.builder().applyMutation(getPhoneNumberOrderRequest).build());
    }

    /**
     * <p>
     * Retrieves the phone number settings for the administrator's AWS account, such as the default outbound calling
     * name.
     * </p>
     *
     * @param getPhoneNumberSettingsRequest
     * @return A Java Future containing the result of the GetPhoneNumberSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.GetPhoneNumberSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetPhoneNumberSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetPhoneNumberSettingsResponse> getPhoneNumberSettings(
            GetPhoneNumberSettingsRequest getPhoneNumberSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the phone number settings for the administrator's AWS account, such as the default outbound calling
     * name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPhoneNumberSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link GetPhoneNumberSettingsRequest#builder()}
     * </p>
     *
     * @param getPhoneNumberSettingsRequest
     *        A {@link Consumer} that will call methods on {@link GetPhoneNumberSettingsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetPhoneNumberSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.GetPhoneNumberSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetPhoneNumberSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetPhoneNumberSettingsResponse> getPhoneNumberSettings(
            Consumer<GetPhoneNumberSettingsRequest.Builder> getPhoneNumberSettingsRequest) {
        return getPhoneNumberSettings(GetPhoneNumberSettingsRequest.builder().applyMutation(getPhoneNumberSettingsRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the specified proxy session details for the specified Amazon Chime SDK Voice Connector.
     * </p>
     *
     * @param getProxySessionRequest
     * @return A Java Future containing the result of the GetProxySession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.GetProxySession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetProxySession"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetProxySessionResponse> getProxySession(GetProxySessionRequest getProxySessionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the specified proxy session details for the specified Amazon Chime SDK Voice Connector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetProxySessionRequest.Builder} avoiding the need
     * to create one manually via {@link GetProxySessionRequest#builder()}
     * </p>
     *
     * @param getProxySessionRequest
     *        A {@link Consumer} that will call methods on {@link GetProxySessionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetProxySession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.GetProxySession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetProxySession"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetProxySessionResponse> getProxySession(
            Consumer<GetProxySessionRequest.Builder> getProxySessionRequest) {
        return getProxySession(GetProxySessionRequest.builder().applyMutation(getProxySessionRequest).build());
    }

    /**
     * <p>
     * Retrieves the information for a SIP media application, including name, AWS Region, and endpoints.
     * </p>
     *
     * @param getSipMediaApplicationRequest
     * @return A Java Future containing the result of the GetSipMediaApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.GetSipMediaApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetSipMediaApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSipMediaApplicationResponse> getSipMediaApplication(
            GetSipMediaApplicationRequest getSipMediaApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the information for a SIP media application, including name, AWS Region, and endpoints.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSipMediaApplicationRequest.Builder} avoiding the
     * need to create one manually via {@link GetSipMediaApplicationRequest#builder()}
     * </p>
     *
     * @param getSipMediaApplicationRequest
     *        A {@link Consumer} that will call methods on {@link GetSipMediaApplicationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetSipMediaApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.GetSipMediaApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetSipMediaApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSipMediaApplicationResponse> getSipMediaApplication(
            Consumer<GetSipMediaApplicationRequest.Builder> getSipMediaApplicationRequest) {
        return getSipMediaApplication(GetSipMediaApplicationRequest.builder().applyMutation(getSipMediaApplicationRequest)
                .build());
    }

    /**
     * <p>
     * Gets the Alexa Skill configuration for the SIP media application.
     * </p>
     *
     * @param getSipMediaApplicationAlexaSkillConfigurationRequest
     * @return A Java Future containing the result of the GetSipMediaApplicationAlexaSkillConfiguration operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.GetSipMediaApplicationAlexaSkillConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetSipMediaApplicationAlexaSkillConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSipMediaApplicationAlexaSkillConfigurationResponse> getSipMediaApplicationAlexaSkillConfiguration(
            GetSipMediaApplicationAlexaSkillConfigurationRequest getSipMediaApplicationAlexaSkillConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the Alexa Skill configuration for the SIP media application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetSipMediaApplicationAlexaSkillConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link GetSipMediaApplicationAlexaSkillConfigurationRequest#builder()}
     * </p>
     *
     * @param getSipMediaApplicationAlexaSkillConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link GetSipMediaApplicationAlexaSkillConfigurationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetSipMediaApplicationAlexaSkillConfiguration operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.GetSipMediaApplicationAlexaSkillConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetSipMediaApplicationAlexaSkillConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSipMediaApplicationAlexaSkillConfigurationResponse> getSipMediaApplicationAlexaSkillConfiguration(
            Consumer<GetSipMediaApplicationAlexaSkillConfigurationRequest.Builder> getSipMediaApplicationAlexaSkillConfigurationRequest) {
        return getSipMediaApplicationAlexaSkillConfiguration(GetSipMediaApplicationAlexaSkillConfigurationRequest.builder()
                .applyMutation(getSipMediaApplicationAlexaSkillConfigurationRequest).build());
    }

    /**
     * <p>
     * Retrieves the logging configuration for the specified SIP media application.
     * </p>
     *
     * @param getSipMediaApplicationLoggingConfigurationRequest
     * @return A Java Future containing the result of the GetSipMediaApplicationLoggingConfiguration operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.GetSipMediaApplicationLoggingConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetSipMediaApplicationLoggingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSipMediaApplicationLoggingConfigurationResponse> getSipMediaApplicationLoggingConfiguration(
            GetSipMediaApplicationLoggingConfigurationRequest getSipMediaApplicationLoggingConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the logging configuration for the specified SIP media application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetSipMediaApplicationLoggingConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link GetSipMediaApplicationLoggingConfigurationRequest#builder()}
     * </p>
     *
     * @param getSipMediaApplicationLoggingConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link GetSipMediaApplicationLoggingConfigurationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetSipMediaApplicationLoggingConfiguration operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.GetSipMediaApplicationLoggingConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetSipMediaApplicationLoggingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSipMediaApplicationLoggingConfigurationResponse> getSipMediaApplicationLoggingConfiguration(
            Consumer<GetSipMediaApplicationLoggingConfigurationRequest.Builder> getSipMediaApplicationLoggingConfigurationRequest) {
        return getSipMediaApplicationLoggingConfiguration(GetSipMediaApplicationLoggingConfigurationRequest.builder()
                .applyMutation(getSipMediaApplicationLoggingConfigurationRequest).build());
    }

    /**
     * <p>
     * Retrieves the details of a SIP rule, such as the rule ID, name, triggers, and target endpoints.
     * </p>
     *
     * @param getSipRuleRequest
     * @return A Java Future containing the result of the GetSipRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.GetSipRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetSipRule" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetSipRuleResponse> getSipRule(GetSipRuleRequest getSipRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the details of a SIP rule, such as the rule ID, name, triggers, and target endpoints.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSipRuleRequest.Builder} avoiding the need to
     * create one manually via {@link GetSipRuleRequest#builder()}
     * </p>
     *
     * @param getSipRuleRequest
     *        A {@link Consumer} that will call methods on {@link GetSipRuleRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetSipRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.GetSipRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetSipRule" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetSipRuleResponse> getSipRule(Consumer<GetSipRuleRequest.Builder> getSipRuleRequest) {
        return getSipRule(GetSipRuleRequest.builder().applyMutation(getSipRuleRequest).build());
    }

    /**
     * <p>
     * Retrieves the details of the specified speaker search task.
     * </p>
     *
     * @param getSpeakerSearchTaskRequest
     * @return A Java Future containing the result of the GetSpeakerSearchTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ConflictException Multiple instances of the same request were made simultaneously.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>AccessDeniedException You don't have the permissions needed to run this action.</li>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.GetSpeakerSearchTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetSpeakerSearchTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSpeakerSearchTaskResponse> getSpeakerSearchTask(
            GetSpeakerSearchTaskRequest getSpeakerSearchTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the details of the specified speaker search task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSpeakerSearchTaskRequest.Builder} avoiding the
     * need to create one manually via {@link GetSpeakerSearchTaskRequest#builder()}
     * </p>
     *
     * @param getSpeakerSearchTaskRequest
     *        A {@link Consumer} that will call methods on {@link GetSpeakerSearchTaskRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetSpeakerSearchTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ConflictException Multiple instances of the same request were made simultaneously.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>AccessDeniedException You don't have the permissions needed to run this action.</li>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.GetSpeakerSearchTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetSpeakerSearchTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSpeakerSearchTaskResponse> getSpeakerSearchTask(
            Consumer<GetSpeakerSearchTaskRequest.Builder> getSpeakerSearchTaskRequest) {
        return getSpeakerSearchTask(GetSpeakerSearchTaskRequest.builder().applyMutation(getSpeakerSearchTaskRequest).build());
    }

    /**
     * <p>
     * Retrieves details for the specified Amazon Chime SDK Voice Connector, such as timestamps,name, outbound host, and
     * encryption requirements.
     * </p>
     *
     * @param getVoiceConnectorRequest
     * @return A Java Future containing the result of the GetVoiceConnector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.GetVoiceConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetVoiceConnector"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetVoiceConnectorResponse> getVoiceConnector(GetVoiceConnectorRequest getVoiceConnectorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details for the specified Amazon Chime SDK Voice Connector, such as timestamps,name, outbound host, and
     * encryption requirements.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetVoiceConnectorRequest.Builder} avoiding the need
     * to create one manually via {@link GetVoiceConnectorRequest#builder()}
     * </p>
     *
     * @param getVoiceConnectorRequest
     *        A {@link Consumer} that will call methods on {@link GetVoiceConnectorRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetVoiceConnector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.GetVoiceConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetVoiceConnector"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetVoiceConnectorResponse> getVoiceConnector(
            Consumer<GetVoiceConnectorRequest.Builder> getVoiceConnectorRequest) {
        return getVoiceConnector(GetVoiceConnectorRequest.builder().applyMutation(getVoiceConnectorRequest).build());
    }

    /**
     * <p>
     * Retrieves the emergency calling configuration details for the specified Voice Connector.
     * </p>
     *
     * @param getVoiceConnectorEmergencyCallingConfigurationRequest
     * @return A Java Future containing the result of the GetVoiceConnectorEmergencyCallingConfiguration operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.GetVoiceConnectorEmergencyCallingConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetVoiceConnectorEmergencyCallingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetVoiceConnectorEmergencyCallingConfigurationResponse> getVoiceConnectorEmergencyCallingConfiguration(
            GetVoiceConnectorEmergencyCallingConfigurationRequest getVoiceConnectorEmergencyCallingConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the emergency calling configuration details for the specified Voice Connector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetVoiceConnectorEmergencyCallingConfigurationRequest.Builder} avoiding the need to create one manually
     * via {@link GetVoiceConnectorEmergencyCallingConfigurationRequest#builder()}
     * </p>
     *
     * @param getVoiceConnectorEmergencyCallingConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link GetVoiceConnectorEmergencyCallingConfigurationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetVoiceConnectorEmergencyCallingConfiguration operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.GetVoiceConnectorEmergencyCallingConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetVoiceConnectorEmergencyCallingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetVoiceConnectorEmergencyCallingConfigurationResponse> getVoiceConnectorEmergencyCallingConfiguration(
            Consumer<GetVoiceConnectorEmergencyCallingConfigurationRequest.Builder> getVoiceConnectorEmergencyCallingConfigurationRequest) {
        return getVoiceConnectorEmergencyCallingConfiguration(GetVoiceConnectorEmergencyCallingConfigurationRequest.builder()
                .applyMutation(getVoiceConnectorEmergencyCallingConfigurationRequest).build());
    }

    /**
     * <p>
     * Retrieves details for the specified Amazon Chime SDK Voice Connector group, such as timestamps,name, and
     * associated <code>VoiceConnectorItems</code>.
     * </p>
     *
     * @param getVoiceConnectorGroupRequest
     * @return A Java Future containing the result of the GetVoiceConnectorGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.GetVoiceConnectorGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetVoiceConnectorGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetVoiceConnectorGroupResponse> getVoiceConnectorGroup(
            GetVoiceConnectorGroupRequest getVoiceConnectorGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details for the specified Amazon Chime SDK Voice Connector group, such as timestamps,name, and
     * associated <code>VoiceConnectorItems</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetVoiceConnectorGroupRequest.Builder} avoiding the
     * need to create one manually via {@link GetVoiceConnectorGroupRequest#builder()}
     * </p>
     *
     * @param getVoiceConnectorGroupRequest
     *        A {@link Consumer} that will call methods on {@link GetVoiceConnectorGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetVoiceConnectorGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.GetVoiceConnectorGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetVoiceConnectorGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetVoiceConnectorGroupResponse> getVoiceConnectorGroup(
            Consumer<GetVoiceConnectorGroupRequest.Builder> getVoiceConnectorGroupRequest) {
        return getVoiceConnectorGroup(GetVoiceConnectorGroupRequest.builder().applyMutation(getVoiceConnectorGroupRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the logging configuration settings for the specified Voice Connector. Shows whether SIP message logs
     * are enabled for sending to Amazon CloudWatch Logs.
     * </p>
     *
     * @param getVoiceConnectorLoggingConfigurationRequest
     * @return A Java Future containing the result of the GetVoiceConnectorLoggingConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.GetVoiceConnectorLoggingConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetVoiceConnectorLoggingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetVoiceConnectorLoggingConfigurationResponse> getVoiceConnectorLoggingConfiguration(
            GetVoiceConnectorLoggingConfigurationRequest getVoiceConnectorLoggingConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the logging configuration settings for the specified Voice Connector. Shows whether SIP message logs
     * are enabled for sending to Amazon CloudWatch Logs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetVoiceConnectorLoggingConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link GetVoiceConnectorLoggingConfigurationRequest#builder()}
     * </p>
     *
     * @param getVoiceConnectorLoggingConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link GetVoiceConnectorLoggingConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetVoiceConnectorLoggingConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.GetVoiceConnectorLoggingConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetVoiceConnectorLoggingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetVoiceConnectorLoggingConfigurationResponse> getVoiceConnectorLoggingConfiguration(
            Consumer<GetVoiceConnectorLoggingConfigurationRequest.Builder> getVoiceConnectorLoggingConfigurationRequest) {
        return getVoiceConnectorLoggingConfiguration(GetVoiceConnectorLoggingConfigurationRequest.builder()
                .applyMutation(getVoiceConnectorLoggingConfigurationRequest).build());
    }

    /**
     * <p>
     * Retrieves the origination settings for the specified Voice Connector.
     * </p>
     *
     * @param getVoiceConnectorOriginationRequest
     * @return A Java Future containing the result of the GetVoiceConnectorOrigination operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.GetVoiceConnectorOrigination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetVoiceConnectorOrigination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetVoiceConnectorOriginationResponse> getVoiceConnectorOrigination(
            GetVoiceConnectorOriginationRequest getVoiceConnectorOriginationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the origination settings for the specified Voice Connector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetVoiceConnectorOriginationRequest.Builder}
     * avoiding the need to create one manually via {@link GetVoiceConnectorOriginationRequest#builder()}
     * </p>
     *
     * @param getVoiceConnectorOriginationRequest
     *        A {@link Consumer} that will call methods on {@link GetVoiceConnectorOriginationRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetVoiceConnectorOrigination operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.GetVoiceConnectorOrigination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetVoiceConnectorOrigination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetVoiceConnectorOriginationResponse> getVoiceConnectorOrigination(
            Consumer<GetVoiceConnectorOriginationRequest.Builder> getVoiceConnectorOriginationRequest) {
        return getVoiceConnectorOrigination(GetVoiceConnectorOriginationRequest.builder()
                .applyMutation(getVoiceConnectorOriginationRequest).build());
    }

    /**
     * <p>
     * Retrieves the proxy configuration details for the specified Amazon Chime SDK Voice Connector.
     * </p>
     *
     * @param getVoiceConnectorProxyRequest
     * @return A Java Future containing the result of the GetVoiceConnectorProxy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.GetVoiceConnectorProxy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetVoiceConnectorProxy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetVoiceConnectorProxyResponse> getVoiceConnectorProxy(
            GetVoiceConnectorProxyRequest getVoiceConnectorProxyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the proxy configuration details for the specified Amazon Chime SDK Voice Connector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetVoiceConnectorProxyRequest.Builder} avoiding the
     * need to create one manually via {@link GetVoiceConnectorProxyRequest#builder()}
     * </p>
     *
     * @param getVoiceConnectorProxyRequest
     *        A {@link Consumer} that will call methods on {@link GetVoiceConnectorProxyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetVoiceConnectorProxy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.GetVoiceConnectorProxy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetVoiceConnectorProxy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetVoiceConnectorProxyResponse> getVoiceConnectorProxy(
            Consumer<GetVoiceConnectorProxyRequest.Builder> getVoiceConnectorProxyRequest) {
        return getVoiceConnectorProxy(GetVoiceConnectorProxyRequest.builder().applyMutation(getVoiceConnectorProxyRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the streaming configuration details for the specified Amazon Chime SDK Voice Connector. Shows whether
     * media streaming is enabled for sending to Amazon Kinesis. It also shows the retention period, in hours, for the
     * Amazon Kinesis data.
     * </p>
     *
     * @param getVoiceConnectorStreamingConfigurationRequest
     * @return A Java Future containing the result of the GetVoiceConnectorStreamingConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.GetVoiceConnectorStreamingConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetVoiceConnectorStreamingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetVoiceConnectorStreamingConfigurationResponse> getVoiceConnectorStreamingConfiguration(
            GetVoiceConnectorStreamingConfigurationRequest getVoiceConnectorStreamingConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the streaming configuration details for the specified Amazon Chime SDK Voice Connector. Shows whether
     * media streaming is enabled for sending to Amazon Kinesis. It also shows the retention period, in hours, for the
     * Amazon Kinesis data.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetVoiceConnectorStreamingConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link GetVoiceConnectorStreamingConfigurationRequest#builder()}
     * </p>
     *
     * @param getVoiceConnectorStreamingConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link GetVoiceConnectorStreamingConfigurationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetVoiceConnectorStreamingConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.GetVoiceConnectorStreamingConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetVoiceConnectorStreamingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetVoiceConnectorStreamingConfigurationResponse> getVoiceConnectorStreamingConfiguration(
            Consumer<GetVoiceConnectorStreamingConfigurationRequest.Builder> getVoiceConnectorStreamingConfigurationRequest) {
        return getVoiceConnectorStreamingConfiguration(GetVoiceConnectorStreamingConfigurationRequest.builder()
                .applyMutation(getVoiceConnectorStreamingConfigurationRequest).build());
    }

    /**
     * <p>
     * Retrieves the termination setting details for the specified Voice Connector.
     * </p>
     *
     * @param getVoiceConnectorTerminationRequest
     * @return A Java Future containing the result of the GetVoiceConnectorTermination operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.GetVoiceConnectorTermination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetVoiceConnectorTermination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetVoiceConnectorTerminationResponse> getVoiceConnectorTermination(
            GetVoiceConnectorTerminationRequest getVoiceConnectorTerminationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the termination setting details for the specified Voice Connector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetVoiceConnectorTerminationRequest.Builder}
     * avoiding the need to create one manually via {@link GetVoiceConnectorTerminationRequest#builder()}
     * </p>
     *
     * @param getVoiceConnectorTerminationRequest
     *        A {@link Consumer} that will call methods on {@link GetVoiceConnectorTerminationRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetVoiceConnectorTermination operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.GetVoiceConnectorTermination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetVoiceConnectorTermination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetVoiceConnectorTerminationResponse> getVoiceConnectorTermination(
            Consumer<GetVoiceConnectorTerminationRequest.Builder> getVoiceConnectorTerminationRequest) {
        return getVoiceConnectorTermination(GetVoiceConnectorTerminationRequest.builder()
                .applyMutation(getVoiceConnectorTerminationRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the last time a <code>SIP OPTIONS</code> ping was received from your SIP
     * infrastructure for the specified Amazon Chime SDK Voice Connector.
     * </p>
     *
     * @param getVoiceConnectorTerminationHealthRequest
     * @return A Java Future containing the result of the GetVoiceConnectorTerminationHealth operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.GetVoiceConnectorTerminationHealth
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetVoiceConnectorTerminationHealth"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetVoiceConnectorTerminationHealthResponse> getVoiceConnectorTerminationHealth(
            GetVoiceConnectorTerminationHealthRequest getVoiceConnectorTerminationHealthRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the last time a <code>SIP OPTIONS</code> ping was received from your SIP
     * infrastructure for the specified Amazon Chime SDK Voice Connector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetVoiceConnectorTerminationHealthRequest.Builder}
     * avoiding the need to create one manually via {@link GetVoiceConnectorTerminationHealthRequest#builder()}
     * </p>
     *
     * @param getVoiceConnectorTerminationHealthRequest
     *        A {@link Consumer} that will call methods on {@link GetVoiceConnectorTerminationHealthRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetVoiceConnectorTerminationHealth operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.GetVoiceConnectorTerminationHealth
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetVoiceConnectorTerminationHealth"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetVoiceConnectorTerminationHealthResponse> getVoiceConnectorTerminationHealth(
            Consumer<GetVoiceConnectorTerminationHealthRequest.Builder> getVoiceConnectorTerminationHealthRequest) {
        return getVoiceConnectorTerminationHealth(GetVoiceConnectorTerminationHealthRequest.builder()
                .applyMutation(getVoiceConnectorTerminationHealthRequest).build());
    }

    /**
     * <p>
     * Retrieves the details of the specified voice profile.
     * </p>
     *
     * @param getVoiceProfileRequest
     * @return A Java Future containing the result of the GetVoiceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>AccessDeniedException You don't have the permissions needed to run this action.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.GetVoiceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetVoiceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetVoiceProfileResponse> getVoiceProfile(GetVoiceProfileRequest getVoiceProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the details of the specified voice profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetVoiceProfileRequest.Builder} avoiding the need
     * to create one manually via {@link GetVoiceProfileRequest#builder()}
     * </p>
     *
     * @param getVoiceProfileRequest
     *        A {@link Consumer} that will call methods on {@link GetVoiceProfileRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetVoiceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>AccessDeniedException You don't have the permissions needed to run this action.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.GetVoiceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetVoiceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetVoiceProfileResponse> getVoiceProfile(
            Consumer<GetVoiceProfileRequest.Builder> getVoiceProfileRequest) {
        return getVoiceProfile(GetVoiceProfileRequest.builder().applyMutation(getVoiceProfileRequest).build());
    }

    /**
     * <p>
     * Retrieves the details of the specified voice profile domain.
     * </p>
     *
     * @param getVoiceProfileDomainRequest
     * @return A Java Future containing the result of the GetVoiceProfileDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>AccessDeniedException You don't have the permissions needed to run this action.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.GetVoiceProfileDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetVoiceProfileDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetVoiceProfileDomainResponse> getVoiceProfileDomain(
            GetVoiceProfileDomainRequest getVoiceProfileDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the details of the specified voice profile domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetVoiceProfileDomainRequest.Builder} avoiding the
     * need to create one manually via {@link GetVoiceProfileDomainRequest#builder()}
     * </p>
     *
     * @param getVoiceProfileDomainRequest
     *        A {@link Consumer} that will call methods on {@link GetVoiceProfileDomainRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetVoiceProfileDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>AccessDeniedException You don't have the permissions needed to run this action.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.GetVoiceProfileDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetVoiceProfileDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetVoiceProfileDomainResponse> getVoiceProfileDomain(
            Consumer<GetVoiceProfileDomainRequest.Builder> getVoiceProfileDomainRequest) {
        return getVoiceProfileDomain(GetVoiceProfileDomainRequest.builder().applyMutation(getVoiceProfileDomainRequest).build());
    }

    /**
     * <p>
     * Retrieves the details of a voice tone analysis task.
     * </p>
     *
     * @param getVoiceToneAnalysisTaskRequest
     * @return A Java Future containing the result of the GetVoiceToneAnalysisTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ConflictException Multiple instances of the same request were made simultaneously.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>AccessDeniedException You don't have the permissions needed to run this action.</li>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.GetVoiceToneAnalysisTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetVoiceToneAnalysisTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetVoiceToneAnalysisTaskResponse> getVoiceToneAnalysisTask(
            GetVoiceToneAnalysisTaskRequest getVoiceToneAnalysisTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the details of a voice tone analysis task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetVoiceToneAnalysisTaskRequest.Builder} avoiding
     * the need to create one manually via {@link GetVoiceToneAnalysisTaskRequest#builder()}
     * </p>
     *
     * @param getVoiceToneAnalysisTaskRequest
     *        A {@link Consumer} that will call methods on {@link GetVoiceToneAnalysisTaskRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetVoiceToneAnalysisTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ConflictException Multiple instances of the same request were made simultaneously.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>AccessDeniedException You don't have the permissions needed to run this action.</li>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.GetVoiceToneAnalysisTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/GetVoiceToneAnalysisTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetVoiceToneAnalysisTaskResponse> getVoiceToneAnalysisTask(
            Consumer<GetVoiceToneAnalysisTaskRequest.Builder> getVoiceToneAnalysisTaskRequest) {
        return getVoiceToneAnalysisTask(GetVoiceToneAnalysisTaskRequest.builder().applyMutation(getVoiceToneAnalysisTaskRequest)
                .build());
    }

    /**
     * <p>
     * Lists the available AWS Regions in which you can create an Amazon Chime SDK Voice Connector.
     * </p>
     *
     * @param listAvailableVoiceConnectorRegionsRequest
     * @return A Java Future containing the result of the ListAvailableVoiceConnectorRegions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.ListAvailableVoiceConnectorRegions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListAvailableVoiceConnectorRegions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAvailableVoiceConnectorRegionsResponse> listAvailableVoiceConnectorRegions(
            ListAvailableVoiceConnectorRegionsRequest listAvailableVoiceConnectorRegionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the available AWS Regions in which you can create an Amazon Chime SDK Voice Connector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAvailableVoiceConnectorRegionsRequest.Builder}
     * avoiding the need to create one manually via {@link ListAvailableVoiceConnectorRegionsRequest#builder()}
     * </p>
     *
     * @param listAvailableVoiceConnectorRegionsRequest
     *        A {@link Consumer} that will call methods on {@link ListAvailableVoiceConnectorRegionsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListAvailableVoiceConnectorRegions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.ListAvailableVoiceConnectorRegions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListAvailableVoiceConnectorRegions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAvailableVoiceConnectorRegionsResponse> listAvailableVoiceConnectorRegions(
            Consumer<ListAvailableVoiceConnectorRegionsRequest.Builder> listAvailableVoiceConnectorRegionsRequest) {
        return listAvailableVoiceConnectorRegions(ListAvailableVoiceConnectorRegionsRequest.builder()
                .applyMutation(listAvailableVoiceConnectorRegionsRequest).build());
    }

    /**
     * <p>
     * Lists the phone numbers for an administrator's Amazon Chime SDK account.
     * </p>
     *
     * @param listPhoneNumberOrdersRequest
     * @return A Java Future containing the result of the ListPhoneNumberOrders operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.ListPhoneNumberOrders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListPhoneNumberOrders"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPhoneNumberOrdersResponse> listPhoneNumberOrders(
            ListPhoneNumberOrdersRequest listPhoneNumberOrdersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the phone numbers for an administrator's Amazon Chime SDK account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPhoneNumberOrdersRequest.Builder} avoiding the
     * need to create one manually via {@link ListPhoneNumberOrdersRequest#builder()}
     * </p>
     *
     * @param listPhoneNumberOrdersRequest
     *        A {@link Consumer} that will call methods on {@link ListPhoneNumberOrdersRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListPhoneNumberOrders operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.ListPhoneNumberOrders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListPhoneNumberOrders"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPhoneNumberOrdersResponse> listPhoneNumberOrders(
            Consumer<ListPhoneNumberOrdersRequest.Builder> listPhoneNumberOrdersRequest) {
        return listPhoneNumberOrders(ListPhoneNumberOrdersRequest.builder().applyMutation(listPhoneNumberOrdersRequest).build());
    }

    /**
     * <p>
     * Lists the phone numbers for an administrator's Amazon Chime SDK account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPhoneNumberOrders(software.amazon.awssdk.services.chimesdkvoice.model.ListPhoneNumberOrdersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chimesdkvoice.paginators.ListPhoneNumberOrdersPublisher publisher = client.listPhoneNumberOrdersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chimesdkvoice.paginators.ListPhoneNumberOrdersPublisher publisher = client.listPhoneNumberOrdersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.chimesdkvoice.model.ListPhoneNumberOrdersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.chimesdkvoice.model.ListPhoneNumberOrdersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPhoneNumberOrders(software.amazon.awssdk.services.chimesdkvoice.model.ListPhoneNumberOrdersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPhoneNumberOrdersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.ListPhoneNumberOrders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListPhoneNumberOrders"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPhoneNumberOrdersPublisher listPhoneNumberOrdersPaginator(
            ListPhoneNumberOrdersRequest listPhoneNumberOrdersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the phone numbers for an administrator's Amazon Chime SDK account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPhoneNumberOrders(software.amazon.awssdk.services.chimesdkvoice.model.ListPhoneNumberOrdersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chimesdkvoice.paginators.ListPhoneNumberOrdersPublisher publisher = client.listPhoneNumberOrdersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chimesdkvoice.paginators.ListPhoneNumberOrdersPublisher publisher = client.listPhoneNumberOrdersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.chimesdkvoice.model.ListPhoneNumberOrdersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.chimesdkvoice.model.ListPhoneNumberOrdersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPhoneNumberOrders(software.amazon.awssdk.services.chimesdkvoice.model.ListPhoneNumberOrdersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPhoneNumberOrdersRequest.Builder} avoiding the
     * need to create one manually via {@link ListPhoneNumberOrdersRequest#builder()}
     * </p>
     *
     * @param listPhoneNumberOrdersRequest
     *        A {@link Consumer} that will call methods on {@link ListPhoneNumberOrdersRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.ListPhoneNumberOrders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListPhoneNumberOrders"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPhoneNumberOrdersPublisher listPhoneNumberOrdersPaginator(
            Consumer<ListPhoneNumberOrdersRequest.Builder> listPhoneNumberOrdersRequest) {
        return listPhoneNumberOrdersPaginator(ListPhoneNumberOrdersRequest.builder().applyMutation(listPhoneNumberOrdersRequest)
                .build());
    }

    /**
     * <p>
     * Lists the phone numbers for the specified Amazon Chime SDK account, Amazon Chime SDK user, Amazon Chime SDK Voice
     * Connector, or Amazon Chime SDK Voice Connector group.
     * </p>
     *
     * @param listPhoneNumbersRequest
     * @return A Java Future containing the result of the ListPhoneNumbers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.ListPhoneNumbers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListPhoneNumbers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPhoneNumbersResponse> listPhoneNumbers(ListPhoneNumbersRequest listPhoneNumbersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the phone numbers for the specified Amazon Chime SDK account, Amazon Chime SDK user, Amazon Chime SDK Voice
     * Connector, or Amazon Chime SDK Voice Connector group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPhoneNumbersRequest.Builder} avoiding the need
     * to create one manually via {@link ListPhoneNumbersRequest#builder()}
     * </p>
     *
     * @param listPhoneNumbersRequest
     *        A {@link Consumer} that will call methods on {@link ListPhoneNumbersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListPhoneNumbers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.ListPhoneNumbers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListPhoneNumbers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPhoneNumbersResponse> listPhoneNumbers(
            Consumer<ListPhoneNumbersRequest.Builder> listPhoneNumbersRequest) {
        return listPhoneNumbers(ListPhoneNumbersRequest.builder().applyMutation(listPhoneNumbersRequest).build());
    }

    /**
     * <p>
     * Lists the phone numbers for the specified Amazon Chime SDK account, Amazon Chime SDK user, Amazon Chime SDK Voice
     * Connector, or Amazon Chime SDK Voice Connector group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPhoneNumbers(software.amazon.awssdk.services.chimesdkvoice.model.ListPhoneNumbersRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chimesdkvoice.paginators.ListPhoneNumbersPublisher publisher = client.listPhoneNumbersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chimesdkvoice.paginators.ListPhoneNumbersPublisher publisher = client.listPhoneNumbersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.chimesdkvoice.model.ListPhoneNumbersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.chimesdkvoice.model.ListPhoneNumbersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPhoneNumbers(software.amazon.awssdk.services.chimesdkvoice.model.ListPhoneNumbersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPhoneNumbersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.ListPhoneNumbers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListPhoneNumbers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPhoneNumbersPublisher listPhoneNumbersPaginator(ListPhoneNumbersRequest listPhoneNumbersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the phone numbers for the specified Amazon Chime SDK account, Amazon Chime SDK user, Amazon Chime SDK Voice
     * Connector, or Amazon Chime SDK Voice Connector group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPhoneNumbers(software.amazon.awssdk.services.chimesdkvoice.model.ListPhoneNumbersRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chimesdkvoice.paginators.ListPhoneNumbersPublisher publisher = client.listPhoneNumbersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chimesdkvoice.paginators.ListPhoneNumbersPublisher publisher = client.listPhoneNumbersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.chimesdkvoice.model.ListPhoneNumbersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.chimesdkvoice.model.ListPhoneNumbersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPhoneNumbers(software.amazon.awssdk.services.chimesdkvoice.model.ListPhoneNumbersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPhoneNumbersRequest.Builder} avoiding the need
     * to create one manually via {@link ListPhoneNumbersRequest#builder()}
     * </p>
     *
     * @param listPhoneNumbersRequest
     *        A {@link Consumer} that will call methods on {@link ListPhoneNumbersRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.ListPhoneNumbers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListPhoneNumbers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPhoneNumbersPublisher listPhoneNumbersPaginator(Consumer<ListPhoneNumbersRequest.Builder> listPhoneNumbersRequest) {
        return listPhoneNumbersPaginator(ListPhoneNumbersRequest.builder().applyMutation(listPhoneNumbersRequest).build());
    }

    /**
     * <p>
     * Lists the proxy sessions for the specified Amazon Chime SDK Voice Connector.
     * </p>
     *
     * @param listProxySessionsRequest
     * @return A Java Future containing the result of the ListProxySessions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.ListProxySessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListProxySessions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListProxySessionsResponse> listProxySessions(ListProxySessionsRequest listProxySessionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the proxy sessions for the specified Amazon Chime SDK Voice Connector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProxySessionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListProxySessionsRequest#builder()}
     * </p>
     *
     * @param listProxySessionsRequest
     *        A {@link Consumer} that will call methods on {@link ListProxySessionsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListProxySessions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.ListProxySessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListProxySessions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListProxySessionsResponse> listProxySessions(
            Consumer<ListProxySessionsRequest.Builder> listProxySessionsRequest) {
        return listProxySessions(ListProxySessionsRequest.builder().applyMutation(listProxySessionsRequest).build());
    }

    /**
     * <p>
     * Lists the proxy sessions for the specified Amazon Chime SDK Voice Connector.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listProxySessions(software.amazon.awssdk.services.chimesdkvoice.model.ListProxySessionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chimesdkvoice.paginators.ListProxySessionsPublisher publisher = client.listProxySessionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chimesdkvoice.paginators.ListProxySessionsPublisher publisher = client.listProxySessionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.chimesdkvoice.model.ListProxySessionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.chimesdkvoice.model.ListProxySessionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProxySessions(software.amazon.awssdk.services.chimesdkvoice.model.ListProxySessionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listProxySessionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.ListProxySessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListProxySessions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProxySessionsPublisher listProxySessionsPaginator(ListProxySessionsRequest listProxySessionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the proxy sessions for the specified Amazon Chime SDK Voice Connector.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listProxySessions(software.amazon.awssdk.services.chimesdkvoice.model.ListProxySessionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chimesdkvoice.paginators.ListProxySessionsPublisher publisher = client.listProxySessionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chimesdkvoice.paginators.ListProxySessionsPublisher publisher = client.listProxySessionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.chimesdkvoice.model.ListProxySessionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.chimesdkvoice.model.ListProxySessionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProxySessions(software.amazon.awssdk.services.chimesdkvoice.model.ListProxySessionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProxySessionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListProxySessionsRequest#builder()}
     * </p>
     *
     * @param listProxySessionsRequest
     *        A {@link Consumer} that will call methods on {@link ListProxySessionsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.ListProxySessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListProxySessions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProxySessionsPublisher listProxySessionsPaginator(
            Consumer<ListProxySessionsRequest.Builder> listProxySessionsRequest) {
        return listProxySessionsPaginator(ListProxySessionsRequest.builder().applyMutation(listProxySessionsRequest).build());
    }

    /**
     * <p>
     * Lists the SIP media applications under the administrator's AWS account.
     * </p>
     *
     * @param listSipMediaApplicationsRequest
     * @return A Java Future containing the result of the ListSipMediaApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.ListSipMediaApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListSipMediaApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSipMediaApplicationsResponse> listSipMediaApplications(
            ListSipMediaApplicationsRequest listSipMediaApplicationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the SIP media applications under the administrator's AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSipMediaApplicationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListSipMediaApplicationsRequest#builder()}
     * </p>
     *
     * @param listSipMediaApplicationsRequest
     *        A {@link Consumer} that will call methods on {@link ListSipMediaApplicationsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListSipMediaApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.ListSipMediaApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListSipMediaApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSipMediaApplicationsResponse> listSipMediaApplications(
            Consumer<ListSipMediaApplicationsRequest.Builder> listSipMediaApplicationsRequest) {
        return listSipMediaApplications(ListSipMediaApplicationsRequest.builder().applyMutation(listSipMediaApplicationsRequest)
                .build());
    }

    /**
     * <p>
     * Lists the SIP media applications under the administrator's AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSipMediaApplications(software.amazon.awssdk.services.chimesdkvoice.model.ListSipMediaApplicationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chimesdkvoice.paginators.ListSipMediaApplicationsPublisher publisher = client.listSipMediaApplicationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chimesdkvoice.paginators.ListSipMediaApplicationsPublisher publisher = client.listSipMediaApplicationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.chimesdkvoice.model.ListSipMediaApplicationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.chimesdkvoice.model.ListSipMediaApplicationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSipMediaApplications(software.amazon.awssdk.services.chimesdkvoice.model.ListSipMediaApplicationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSipMediaApplicationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.ListSipMediaApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListSipMediaApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSipMediaApplicationsPublisher listSipMediaApplicationsPaginator(
            ListSipMediaApplicationsRequest listSipMediaApplicationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the SIP media applications under the administrator's AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSipMediaApplications(software.amazon.awssdk.services.chimesdkvoice.model.ListSipMediaApplicationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chimesdkvoice.paginators.ListSipMediaApplicationsPublisher publisher = client.listSipMediaApplicationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chimesdkvoice.paginators.ListSipMediaApplicationsPublisher publisher = client.listSipMediaApplicationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.chimesdkvoice.model.ListSipMediaApplicationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.chimesdkvoice.model.ListSipMediaApplicationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSipMediaApplications(software.amazon.awssdk.services.chimesdkvoice.model.ListSipMediaApplicationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSipMediaApplicationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListSipMediaApplicationsRequest#builder()}
     * </p>
     *
     * @param listSipMediaApplicationsRequest
     *        A {@link Consumer} that will call methods on {@link ListSipMediaApplicationsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.ListSipMediaApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListSipMediaApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSipMediaApplicationsPublisher listSipMediaApplicationsPaginator(
            Consumer<ListSipMediaApplicationsRequest.Builder> listSipMediaApplicationsRequest) {
        return listSipMediaApplicationsPaginator(ListSipMediaApplicationsRequest.builder()
                .applyMutation(listSipMediaApplicationsRequest).build());
    }

    /**
     * <p>
     * Lists the SIP rules under the administrator's AWS account.
     * </p>
     *
     * @param listSipRulesRequest
     * @return A Java Future containing the result of the ListSipRules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.ListSipRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListSipRules" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListSipRulesResponse> listSipRules(ListSipRulesRequest listSipRulesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the SIP rules under the administrator's AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSipRulesRequest.Builder} avoiding the need to
     * create one manually via {@link ListSipRulesRequest#builder()}
     * </p>
     *
     * @param listSipRulesRequest
     *        A {@link Consumer} that will call methods on {@link ListSipRulesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListSipRules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.ListSipRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListSipRules" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListSipRulesResponse> listSipRules(Consumer<ListSipRulesRequest.Builder> listSipRulesRequest) {
        return listSipRules(ListSipRulesRequest.builder().applyMutation(listSipRulesRequest).build());
    }

    /**
     * <p>
     * Lists the SIP rules under the administrator's AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSipRules(software.amazon.awssdk.services.chimesdkvoice.model.ListSipRulesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chimesdkvoice.paginators.ListSipRulesPublisher publisher = client.listSipRulesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chimesdkvoice.paginators.ListSipRulesPublisher publisher = client.listSipRulesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.chimesdkvoice.model.ListSipRulesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.chimesdkvoice.model.ListSipRulesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSipRules(software.amazon.awssdk.services.chimesdkvoice.model.ListSipRulesRequest)} operation.</b>
     * </p>
     *
     * @param listSipRulesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.ListSipRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListSipRules" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSipRulesPublisher listSipRulesPaginator(ListSipRulesRequest listSipRulesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the SIP rules under the administrator's AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSipRules(software.amazon.awssdk.services.chimesdkvoice.model.ListSipRulesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chimesdkvoice.paginators.ListSipRulesPublisher publisher = client.listSipRulesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chimesdkvoice.paginators.ListSipRulesPublisher publisher = client.listSipRulesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.chimesdkvoice.model.ListSipRulesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.chimesdkvoice.model.ListSipRulesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSipRules(software.amazon.awssdk.services.chimesdkvoice.model.ListSipRulesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSipRulesRequest.Builder} avoiding the need to
     * create one manually via {@link ListSipRulesRequest#builder()}
     * </p>
     *
     * @param listSipRulesRequest
     *        A {@link Consumer} that will call methods on {@link ListSipRulesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.ListSipRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListSipRules" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSipRulesPublisher listSipRulesPaginator(Consumer<ListSipRulesRequest.Builder> listSipRulesRequest) {
        return listSipRulesPaginator(ListSipRulesRequest.builder().applyMutation(listSipRulesRequest).build());
    }

    /**
     * <p>
     * Lists the countries that you can order phone numbers from.
     * </p>
     *
     * @param listSupportedPhoneNumberCountriesRequest
     * @return A Java Future containing the result of the ListSupportedPhoneNumberCountries operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>AccessDeniedException You don't have the permissions needed to run this action.</li>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.ListSupportedPhoneNumberCountries
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListSupportedPhoneNumberCountries"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSupportedPhoneNumberCountriesResponse> listSupportedPhoneNumberCountries(
            ListSupportedPhoneNumberCountriesRequest listSupportedPhoneNumberCountriesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the countries that you can order phone numbers from.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSupportedPhoneNumberCountriesRequest.Builder}
     * avoiding the need to create one manually via {@link ListSupportedPhoneNumberCountriesRequest#builder()}
     * </p>
     *
     * @param listSupportedPhoneNumberCountriesRequest
     *        A {@link Consumer} that will call methods on {@link ListSupportedPhoneNumberCountriesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListSupportedPhoneNumberCountries operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>AccessDeniedException You don't have the permissions needed to run this action.</li>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.ListSupportedPhoneNumberCountries
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListSupportedPhoneNumberCountries"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSupportedPhoneNumberCountriesResponse> listSupportedPhoneNumberCountries(
            Consumer<ListSupportedPhoneNumberCountriesRequest.Builder> listSupportedPhoneNumberCountriesRequest) {
        return listSupportedPhoneNumberCountries(ListSupportedPhoneNumberCountriesRequest.builder()
                .applyMutation(listSupportedPhoneNumberCountriesRequest).build());
    }

    /**
     * <p>
     * Returns a list of the tags in a given resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the tags in a given resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists the Amazon Chime SDK Voice Connector groups in the administrator's AWS account.
     * </p>
     *
     * @param listVoiceConnectorGroupsRequest
     * @return A Java Future containing the result of the ListVoiceConnectorGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.ListVoiceConnectorGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListVoiceConnectorGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListVoiceConnectorGroupsResponse> listVoiceConnectorGroups(
            ListVoiceConnectorGroupsRequest listVoiceConnectorGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the Amazon Chime SDK Voice Connector groups in the administrator's AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVoiceConnectorGroupsRequest.Builder} avoiding
     * the need to create one manually via {@link ListVoiceConnectorGroupsRequest#builder()}
     * </p>
     *
     * @param listVoiceConnectorGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListVoiceConnectorGroupsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListVoiceConnectorGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.ListVoiceConnectorGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListVoiceConnectorGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListVoiceConnectorGroupsResponse> listVoiceConnectorGroups(
            Consumer<ListVoiceConnectorGroupsRequest.Builder> listVoiceConnectorGroupsRequest) {
        return listVoiceConnectorGroups(ListVoiceConnectorGroupsRequest.builder().applyMutation(listVoiceConnectorGroupsRequest)
                .build());
    }

    /**
     * <p>
     * Lists the Amazon Chime SDK Voice Connector groups in the administrator's AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listVoiceConnectorGroups(software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceConnectorGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chimesdkvoice.paginators.ListVoiceConnectorGroupsPublisher publisher = client.listVoiceConnectorGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chimesdkvoice.paginators.ListVoiceConnectorGroupsPublisher publisher = client.listVoiceConnectorGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceConnectorGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceConnectorGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVoiceConnectorGroups(software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceConnectorGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listVoiceConnectorGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.ListVoiceConnectorGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListVoiceConnectorGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListVoiceConnectorGroupsPublisher listVoiceConnectorGroupsPaginator(
            ListVoiceConnectorGroupsRequest listVoiceConnectorGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the Amazon Chime SDK Voice Connector groups in the administrator's AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listVoiceConnectorGroups(software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceConnectorGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chimesdkvoice.paginators.ListVoiceConnectorGroupsPublisher publisher = client.listVoiceConnectorGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chimesdkvoice.paginators.ListVoiceConnectorGroupsPublisher publisher = client.listVoiceConnectorGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceConnectorGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceConnectorGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVoiceConnectorGroups(software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceConnectorGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVoiceConnectorGroupsRequest.Builder} avoiding
     * the need to create one manually via {@link ListVoiceConnectorGroupsRequest#builder()}
     * </p>
     *
     * @param listVoiceConnectorGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListVoiceConnectorGroupsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.ListVoiceConnectorGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListVoiceConnectorGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListVoiceConnectorGroupsPublisher listVoiceConnectorGroupsPaginator(
            Consumer<ListVoiceConnectorGroupsRequest.Builder> listVoiceConnectorGroupsRequest) {
        return listVoiceConnectorGroupsPaginator(ListVoiceConnectorGroupsRequest.builder()
                .applyMutation(listVoiceConnectorGroupsRequest).build());
    }

    /**
     * <p>
     * Lists the SIP credentials for the specified Amazon Chime SDK Voice Connector.
     * </p>
     *
     * @param listVoiceConnectorTerminationCredentialsRequest
     * @return A Java Future containing the result of the ListVoiceConnectorTerminationCredentials operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.ListVoiceConnectorTerminationCredentials
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListVoiceConnectorTerminationCredentials"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListVoiceConnectorTerminationCredentialsResponse> listVoiceConnectorTerminationCredentials(
            ListVoiceConnectorTerminationCredentialsRequest listVoiceConnectorTerminationCredentialsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the SIP credentials for the specified Amazon Chime SDK Voice Connector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListVoiceConnectorTerminationCredentialsRequest.Builder} avoiding the need to create one manually via
     * {@link ListVoiceConnectorTerminationCredentialsRequest#builder()}
     * </p>
     *
     * @param listVoiceConnectorTerminationCredentialsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link ListVoiceConnectorTerminationCredentialsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListVoiceConnectorTerminationCredentials operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.ListVoiceConnectorTerminationCredentials
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListVoiceConnectorTerminationCredentials"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListVoiceConnectorTerminationCredentialsResponse> listVoiceConnectorTerminationCredentials(
            Consumer<ListVoiceConnectorTerminationCredentialsRequest.Builder> listVoiceConnectorTerminationCredentialsRequest) {
        return listVoiceConnectorTerminationCredentials(ListVoiceConnectorTerminationCredentialsRequest.builder()
                .applyMutation(listVoiceConnectorTerminationCredentialsRequest).build());
    }

    /**
     * <p>
     * Lists the Amazon Chime SDK Voice Connectors in the administrators AWS account.
     * </p>
     *
     * @param listVoiceConnectorsRequest
     * @return A Java Future containing the result of the ListVoiceConnectors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.ListVoiceConnectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListVoiceConnectors"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListVoiceConnectorsResponse> listVoiceConnectors(
            ListVoiceConnectorsRequest listVoiceConnectorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the Amazon Chime SDK Voice Connectors in the administrators AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVoiceConnectorsRequest.Builder} avoiding the
     * need to create one manually via {@link ListVoiceConnectorsRequest#builder()}
     * </p>
     *
     * @param listVoiceConnectorsRequest
     *        A {@link Consumer} that will call methods on {@link ListVoiceConnectorsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListVoiceConnectors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.ListVoiceConnectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListVoiceConnectors"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListVoiceConnectorsResponse> listVoiceConnectors(
            Consumer<ListVoiceConnectorsRequest.Builder> listVoiceConnectorsRequest) {
        return listVoiceConnectors(ListVoiceConnectorsRequest.builder().applyMutation(listVoiceConnectorsRequest).build());
    }

    /**
     * <p>
     * Lists the Amazon Chime SDK Voice Connectors in the administrators AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listVoiceConnectors(software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceConnectorsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chimesdkvoice.paginators.ListVoiceConnectorsPublisher publisher = client.listVoiceConnectorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chimesdkvoice.paginators.ListVoiceConnectorsPublisher publisher = client.listVoiceConnectorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceConnectorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceConnectorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVoiceConnectors(software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceConnectorsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listVoiceConnectorsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.ListVoiceConnectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListVoiceConnectors"
     *      target="_top">AWS API Documentation</a>
     */
    default ListVoiceConnectorsPublisher listVoiceConnectorsPaginator(ListVoiceConnectorsRequest listVoiceConnectorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the Amazon Chime SDK Voice Connectors in the administrators AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listVoiceConnectors(software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceConnectorsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chimesdkvoice.paginators.ListVoiceConnectorsPublisher publisher = client.listVoiceConnectorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chimesdkvoice.paginators.ListVoiceConnectorsPublisher publisher = client.listVoiceConnectorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceConnectorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceConnectorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVoiceConnectors(software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceConnectorsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVoiceConnectorsRequest.Builder} avoiding the
     * need to create one manually via {@link ListVoiceConnectorsRequest#builder()}
     * </p>
     *
     * @param listVoiceConnectorsRequest
     *        A {@link Consumer} that will call methods on {@link ListVoiceConnectorsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.ListVoiceConnectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListVoiceConnectors"
     *      target="_top">AWS API Documentation</a>
     */
    default ListVoiceConnectorsPublisher listVoiceConnectorsPaginator(
            Consumer<ListVoiceConnectorsRequest.Builder> listVoiceConnectorsRequest) {
        return listVoiceConnectorsPaginator(ListVoiceConnectorsRequest.builder().applyMutation(listVoiceConnectorsRequest)
                .build());
    }

    /**
     * <p>
     * Lists the specified voice profile domains in the administrator's AWS account.
     * </p>
     *
     * @param listVoiceProfileDomainsRequest
     * @return A Java Future containing the result of the ListVoiceProfileDomains operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.ListVoiceProfileDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListVoiceProfileDomains"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListVoiceProfileDomainsResponse> listVoiceProfileDomains(
            ListVoiceProfileDomainsRequest listVoiceProfileDomainsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the specified voice profile domains in the administrator's AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVoiceProfileDomainsRequest.Builder} avoiding
     * the need to create one manually via {@link ListVoiceProfileDomainsRequest#builder()}
     * </p>
     *
     * @param listVoiceProfileDomainsRequest
     *        A {@link Consumer} that will call methods on {@link ListVoiceProfileDomainsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListVoiceProfileDomains operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.ListVoiceProfileDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListVoiceProfileDomains"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListVoiceProfileDomainsResponse> listVoiceProfileDomains(
            Consumer<ListVoiceProfileDomainsRequest.Builder> listVoiceProfileDomainsRequest) {
        return listVoiceProfileDomains(ListVoiceProfileDomainsRequest.builder().applyMutation(listVoiceProfileDomainsRequest)
                .build());
    }

    /**
     * <p>
     * Lists the specified voice profile domains in the administrator's AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listVoiceProfileDomains(software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceProfileDomainsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chimesdkvoice.paginators.ListVoiceProfileDomainsPublisher publisher = client.listVoiceProfileDomainsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chimesdkvoice.paginators.ListVoiceProfileDomainsPublisher publisher = client.listVoiceProfileDomainsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceProfileDomainsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceProfileDomainsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVoiceProfileDomains(software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceProfileDomainsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listVoiceProfileDomainsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.ListVoiceProfileDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListVoiceProfileDomains"
     *      target="_top">AWS API Documentation</a>
     */
    default ListVoiceProfileDomainsPublisher listVoiceProfileDomainsPaginator(
            ListVoiceProfileDomainsRequest listVoiceProfileDomainsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the specified voice profile domains in the administrator's AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listVoiceProfileDomains(software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceProfileDomainsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chimesdkvoice.paginators.ListVoiceProfileDomainsPublisher publisher = client.listVoiceProfileDomainsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chimesdkvoice.paginators.ListVoiceProfileDomainsPublisher publisher = client.listVoiceProfileDomainsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceProfileDomainsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceProfileDomainsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVoiceProfileDomains(software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceProfileDomainsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVoiceProfileDomainsRequest.Builder} avoiding
     * the need to create one manually via {@link ListVoiceProfileDomainsRequest#builder()}
     * </p>
     *
     * @param listVoiceProfileDomainsRequest
     *        A {@link Consumer} that will call methods on {@link ListVoiceProfileDomainsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.ListVoiceProfileDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListVoiceProfileDomains"
     *      target="_top">AWS API Documentation</a>
     */
    default ListVoiceProfileDomainsPublisher listVoiceProfileDomainsPaginator(
            Consumer<ListVoiceProfileDomainsRequest.Builder> listVoiceProfileDomainsRequest) {
        return listVoiceProfileDomainsPaginator(ListVoiceProfileDomainsRequest.builder()
                .applyMutation(listVoiceProfileDomainsRequest).build());
    }

    /**
     * <p>
     * Lists the voice profiles in a voice profile domain.
     * </p>
     *
     * @param listVoiceProfilesRequest
     * @return A Java Future containing the result of the ListVoiceProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.ListVoiceProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListVoiceProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListVoiceProfilesResponse> listVoiceProfiles(ListVoiceProfilesRequest listVoiceProfilesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the voice profiles in a voice profile domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVoiceProfilesRequest.Builder} avoiding the need
     * to create one manually via {@link ListVoiceProfilesRequest#builder()}
     * </p>
     *
     * @param listVoiceProfilesRequest
     *        A {@link Consumer} that will call methods on {@link ListVoiceProfilesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListVoiceProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.ListVoiceProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListVoiceProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListVoiceProfilesResponse> listVoiceProfiles(
            Consumer<ListVoiceProfilesRequest.Builder> listVoiceProfilesRequest) {
        return listVoiceProfiles(ListVoiceProfilesRequest.builder().applyMutation(listVoiceProfilesRequest).build());
    }

    /**
     * <p>
     * Lists the voice profiles in a voice profile domain.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listVoiceProfiles(software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceProfilesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chimesdkvoice.paginators.ListVoiceProfilesPublisher publisher = client.listVoiceProfilesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chimesdkvoice.paginators.ListVoiceProfilesPublisher publisher = client.listVoiceProfilesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceProfilesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceProfilesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVoiceProfiles(software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceProfilesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listVoiceProfilesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.ListVoiceProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListVoiceProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default ListVoiceProfilesPublisher listVoiceProfilesPaginator(ListVoiceProfilesRequest listVoiceProfilesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the voice profiles in a voice profile domain.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listVoiceProfiles(software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceProfilesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chimesdkvoice.paginators.ListVoiceProfilesPublisher publisher = client.listVoiceProfilesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chimesdkvoice.paginators.ListVoiceProfilesPublisher publisher = client.listVoiceProfilesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceProfilesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceProfilesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVoiceProfiles(software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceProfilesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVoiceProfilesRequest.Builder} avoiding the need
     * to create one manually via {@link ListVoiceProfilesRequest#builder()}
     * </p>
     *
     * @param listVoiceProfilesRequest
     *        A {@link Consumer} that will call methods on {@link ListVoiceProfilesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.ListVoiceProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListVoiceProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default ListVoiceProfilesPublisher listVoiceProfilesPaginator(
            Consumer<ListVoiceProfilesRequest.Builder> listVoiceProfilesRequest) {
        return listVoiceProfilesPaginator(ListVoiceProfilesRequest.builder().applyMutation(listVoiceProfilesRequest).build());
    }

    /**
     * <p>
     * Updates the Alexa Skill configuration for the SIP media application.
     * </p>
     *
     * @param putSipMediaApplicationAlexaSkillConfigurationRequest
     * @return A Java Future containing the result of the PutSipMediaApplicationAlexaSkillConfiguration operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.PutSipMediaApplicationAlexaSkillConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/PutSipMediaApplicationAlexaSkillConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutSipMediaApplicationAlexaSkillConfigurationResponse> putSipMediaApplicationAlexaSkillConfiguration(
            PutSipMediaApplicationAlexaSkillConfigurationRequest putSipMediaApplicationAlexaSkillConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the Alexa Skill configuration for the SIP media application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link PutSipMediaApplicationAlexaSkillConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link PutSipMediaApplicationAlexaSkillConfigurationRequest#builder()}
     * </p>
     *
     * @param putSipMediaApplicationAlexaSkillConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link PutSipMediaApplicationAlexaSkillConfigurationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PutSipMediaApplicationAlexaSkillConfiguration operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.PutSipMediaApplicationAlexaSkillConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/PutSipMediaApplicationAlexaSkillConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutSipMediaApplicationAlexaSkillConfigurationResponse> putSipMediaApplicationAlexaSkillConfiguration(
            Consumer<PutSipMediaApplicationAlexaSkillConfigurationRequest.Builder> putSipMediaApplicationAlexaSkillConfigurationRequest) {
        return putSipMediaApplicationAlexaSkillConfiguration(PutSipMediaApplicationAlexaSkillConfigurationRequest.builder()
                .applyMutation(putSipMediaApplicationAlexaSkillConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates the logging configuration for the specified SIP media application.
     * </p>
     *
     * @param putSipMediaApplicationLoggingConfigurationRequest
     * @return A Java Future containing the result of the PutSipMediaApplicationLoggingConfiguration operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.PutSipMediaApplicationLoggingConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/PutSipMediaApplicationLoggingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutSipMediaApplicationLoggingConfigurationResponse> putSipMediaApplicationLoggingConfiguration(
            PutSipMediaApplicationLoggingConfigurationRequest putSipMediaApplicationLoggingConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the logging configuration for the specified SIP media application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link PutSipMediaApplicationLoggingConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link PutSipMediaApplicationLoggingConfigurationRequest#builder()}
     * </p>
     *
     * @param putSipMediaApplicationLoggingConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link PutSipMediaApplicationLoggingConfigurationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PutSipMediaApplicationLoggingConfiguration operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.PutSipMediaApplicationLoggingConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/PutSipMediaApplicationLoggingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutSipMediaApplicationLoggingConfigurationResponse> putSipMediaApplicationLoggingConfiguration(
            Consumer<PutSipMediaApplicationLoggingConfigurationRequest.Builder> putSipMediaApplicationLoggingConfigurationRequest) {
        return putSipMediaApplicationLoggingConfiguration(PutSipMediaApplicationLoggingConfigurationRequest.builder()
                .applyMutation(putSipMediaApplicationLoggingConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates a Voice Connector's emergency calling configuration.
     * </p>
     *
     * @param putVoiceConnectorEmergencyCallingConfigurationRequest
     * @return A Java Future containing the result of the PutVoiceConnectorEmergencyCallingConfiguration operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.PutVoiceConnectorEmergencyCallingConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/PutVoiceConnectorEmergencyCallingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutVoiceConnectorEmergencyCallingConfigurationResponse> putVoiceConnectorEmergencyCallingConfiguration(
            PutVoiceConnectorEmergencyCallingConfigurationRequest putVoiceConnectorEmergencyCallingConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a Voice Connector's emergency calling configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link PutVoiceConnectorEmergencyCallingConfigurationRequest.Builder} avoiding the need to create one manually
     * via {@link PutVoiceConnectorEmergencyCallingConfigurationRequest#builder()}
     * </p>
     *
     * @param putVoiceConnectorEmergencyCallingConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link PutVoiceConnectorEmergencyCallingConfigurationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PutVoiceConnectorEmergencyCallingConfiguration operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.PutVoiceConnectorEmergencyCallingConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/PutVoiceConnectorEmergencyCallingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutVoiceConnectorEmergencyCallingConfigurationResponse> putVoiceConnectorEmergencyCallingConfiguration(
            Consumer<PutVoiceConnectorEmergencyCallingConfigurationRequest.Builder> putVoiceConnectorEmergencyCallingConfigurationRequest) {
        return putVoiceConnectorEmergencyCallingConfiguration(PutVoiceConnectorEmergencyCallingConfigurationRequest.builder()
                .applyMutation(putVoiceConnectorEmergencyCallingConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates a Voice Connector's logging configuration.
     * </p>
     *
     * @param putVoiceConnectorLoggingConfigurationRequest
     * @return A Java Future containing the result of the PutVoiceConnectorLoggingConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.PutVoiceConnectorLoggingConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/PutVoiceConnectorLoggingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutVoiceConnectorLoggingConfigurationResponse> putVoiceConnectorLoggingConfiguration(
            PutVoiceConnectorLoggingConfigurationRequest putVoiceConnectorLoggingConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a Voice Connector's logging configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link PutVoiceConnectorLoggingConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link PutVoiceConnectorLoggingConfigurationRequest#builder()}
     * </p>
     *
     * @param putVoiceConnectorLoggingConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link PutVoiceConnectorLoggingConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the PutVoiceConnectorLoggingConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.PutVoiceConnectorLoggingConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/PutVoiceConnectorLoggingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutVoiceConnectorLoggingConfigurationResponse> putVoiceConnectorLoggingConfiguration(
            Consumer<PutVoiceConnectorLoggingConfigurationRequest.Builder> putVoiceConnectorLoggingConfigurationRequest) {
        return putVoiceConnectorLoggingConfiguration(PutVoiceConnectorLoggingConfigurationRequest.builder()
                .applyMutation(putVoiceConnectorLoggingConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates a Voice Connector's origination settings.
     * </p>
     *
     * @param putVoiceConnectorOriginationRequest
     * @return A Java Future containing the result of the PutVoiceConnectorOrigination operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.PutVoiceConnectorOrigination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/PutVoiceConnectorOrigination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutVoiceConnectorOriginationResponse> putVoiceConnectorOrigination(
            PutVoiceConnectorOriginationRequest putVoiceConnectorOriginationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a Voice Connector's origination settings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutVoiceConnectorOriginationRequest.Builder}
     * avoiding the need to create one manually via {@link PutVoiceConnectorOriginationRequest#builder()}
     * </p>
     *
     * @param putVoiceConnectorOriginationRequest
     *        A {@link Consumer} that will call methods on {@link PutVoiceConnectorOriginationRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the PutVoiceConnectorOrigination operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.PutVoiceConnectorOrigination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/PutVoiceConnectorOrigination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutVoiceConnectorOriginationResponse> putVoiceConnectorOrigination(
            Consumer<PutVoiceConnectorOriginationRequest.Builder> putVoiceConnectorOriginationRequest) {
        return putVoiceConnectorOrigination(PutVoiceConnectorOriginationRequest.builder()
                .applyMutation(putVoiceConnectorOriginationRequest).build());
    }

    /**
     * <p>
     * Puts the specified proxy configuration to the specified Amazon Chime SDK Voice Connector.
     * </p>
     *
     * @param putVoiceConnectorProxyRequest
     * @return A Java Future containing the result of the PutVoiceConnectorProxy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>AccessDeniedException You don't have the permissions needed to run this action.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.PutVoiceConnectorProxy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/PutVoiceConnectorProxy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutVoiceConnectorProxyResponse> putVoiceConnectorProxy(
            PutVoiceConnectorProxyRequest putVoiceConnectorProxyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Puts the specified proxy configuration to the specified Amazon Chime SDK Voice Connector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutVoiceConnectorProxyRequest.Builder} avoiding the
     * need to create one manually via {@link PutVoiceConnectorProxyRequest#builder()}
     * </p>
     *
     * @param putVoiceConnectorProxyRequest
     *        A {@link Consumer} that will call methods on {@link PutVoiceConnectorProxyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutVoiceConnectorProxy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>AccessDeniedException You don't have the permissions needed to run this action.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.PutVoiceConnectorProxy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/PutVoiceConnectorProxy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutVoiceConnectorProxyResponse> putVoiceConnectorProxy(
            Consumer<PutVoiceConnectorProxyRequest.Builder> putVoiceConnectorProxyRequest) {
        return putVoiceConnectorProxy(PutVoiceConnectorProxyRequest.builder().applyMutation(putVoiceConnectorProxyRequest)
                .build());
    }

    /**
     * <p>
     * Updates a Voice Connector's streaming configuration settings.
     * </p>
     *
     * @param putVoiceConnectorStreamingConfigurationRequest
     * @return A Java Future containing the result of the PutVoiceConnectorStreamingConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.PutVoiceConnectorStreamingConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/PutVoiceConnectorStreamingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutVoiceConnectorStreamingConfigurationResponse> putVoiceConnectorStreamingConfiguration(
            PutVoiceConnectorStreamingConfigurationRequest putVoiceConnectorStreamingConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a Voice Connector's streaming configuration settings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link PutVoiceConnectorStreamingConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link PutVoiceConnectorStreamingConfigurationRequest#builder()}
     * </p>
     *
     * @param putVoiceConnectorStreamingConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link PutVoiceConnectorStreamingConfigurationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PutVoiceConnectorStreamingConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.PutVoiceConnectorStreamingConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/PutVoiceConnectorStreamingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutVoiceConnectorStreamingConfigurationResponse> putVoiceConnectorStreamingConfiguration(
            Consumer<PutVoiceConnectorStreamingConfigurationRequest.Builder> putVoiceConnectorStreamingConfigurationRequest) {
        return putVoiceConnectorStreamingConfiguration(PutVoiceConnectorStreamingConfigurationRequest.builder()
                .applyMutation(putVoiceConnectorStreamingConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates a Voice Connector's termination settings.
     * </p>
     *
     * @param putVoiceConnectorTerminationRequest
     * @return A Java Future containing the result of the PutVoiceConnectorTermination operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>AccessDeniedException You don't have the permissions needed to run this action.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.PutVoiceConnectorTermination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/PutVoiceConnectorTermination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutVoiceConnectorTerminationResponse> putVoiceConnectorTermination(
            PutVoiceConnectorTerminationRequest putVoiceConnectorTerminationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a Voice Connector's termination settings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutVoiceConnectorTerminationRequest.Builder}
     * avoiding the need to create one manually via {@link PutVoiceConnectorTerminationRequest#builder()}
     * </p>
     *
     * @param putVoiceConnectorTerminationRequest
     *        A {@link Consumer} that will call methods on {@link PutVoiceConnectorTerminationRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the PutVoiceConnectorTermination operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>AccessDeniedException You don't have the permissions needed to run this action.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.PutVoiceConnectorTermination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/PutVoiceConnectorTermination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutVoiceConnectorTerminationResponse> putVoiceConnectorTermination(
            Consumer<PutVoiceConnectorTerminationRequest.Builder> putVoiceConnectorTerminationRequest) {
        return putVoiceConnectorTermination(PutVoiceConnectorTerminationRequest.builder()
                .applyMutation(putVoiceConnectorTerminationRequest).build());
    }

    /**
     * <p>
     * Updates a Voice Connector's termination credentials.
     * </p>
     *
     * @param putVoiceConnectorTerminationCredentialsRequest
     * @return A Java Future containing the result of the PutVoiceConnectorTerminationCredentials operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.PutVoiceConnectorTerminationCredentials
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/PutVoiceConnectorTerminationCredentials"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutVoiceConnectorTerminationCredentialsResponse> putVoiceConnectorTerminationCredentials(
            PutVoiceConnectorTerminationCredentialsRequest putVoiceConnectorTerminationCredentialsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a Voice Connector's termination credentials.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link PutVoiceConnectorTerminationCredentialsRequest.Builder} avoiding the need to create one manually via
     * {@link PutVoiceConnectorTerminationCredentialsRequest#builder()}
     * </p>
     *
     * @param putVoiceConnectorTerminationCredentialsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link PutVoiceConnectorTerminationCredentialsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PutVoiceConnectorTerminationCredentials operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.PutVoiceConnectorTerminationCredentials
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/PutVoiceConnectorTerminationCredentials"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutVoiceConnectorTerminationCredentialsResponse> putVoiceConnectorTerminationCredentials(
            Consumer<PutVoiceConnectorTerminationCredentialsRequest.Builder> putVoiceConnectorTerminationCredentialsRequest) {
        return putVoiceConnectorTerminationCredentials(PutVoiceConnectorTerminationCredentialsRequest.builder()
                .applyMutation(putVoiceConnectorTerminationCredentialsRequest).build());
    }

    /**
     * <p>
     * Restores a deleted phone number.
     * </p>
     *
     * @param restorePhoneNumberRequest
     * @return A Java Future containing the result of the RestorePhoneNumber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ResourceLimitExceededException The request exceeds the resource limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.RestorePhoneNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/RestorePhoneNumber"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RestorePhoneNumberResponse> restorePhoneNumber(RestorePhoneNumberRequest restorePhoneNumberRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Restores a deleted phone number.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RestorePhoneNumberRequest.Builder} avoiding the
     * need to create one manually via {@link RestorePhoneNumberRequest#builder()}
     * </p>
     *
     * @param restorePhoneNumberRequest
     *        A {@link Consumer} that will call methods on {@link RestorePhoneNumberRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RestorePhoneNumber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ResourceLimitExceededException The request exceeds the resource limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.RestorePhoneNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/RestorePhoneNumber"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RestorePhoneNumberResponse> restorePhoneNumber(
            Consumer<RestorePhoneNumberRequest.Builder> restorePhoneNumberRequest) {
        return restorePhoneNumber(RestorePhoneNumberRequest.builder().applyMutation(restorePhoneNumberRequest).build());
    }

    /**
     * <p>
     * Searches the provisioned phone numbers in an organization.
     * </p>
     *
     * @param searchAvailablePhoneNumbersRequest
     * @return A Java Future containing the result of the SearchAvailablePhoneNumbers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>AccessDeniedException You don't have the permissions needed to run this action.</li>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.SearchAvailablePhoneNumbers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/SearchAvailablePhoneNumbers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SearchAvailablePhoneNumbersResponse> searchAvailablePhoneNumbers(
            SearchAvailablePhoneNumbersRequest searchAvailablePhoneNumbersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches the provisioned phone numbers in an organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchAvailablePhoneNumbersRequest.Builder}
     * avoiding the need to create one manually via {@link SearchAvailablePhoneNumbersRequest#builder()}
     * </p>
     *
     * @param searchAvailablePhoneNumbersRequest
     *        A {@link Consumer} that will call methods on {@link SearchAvailablePhoneNumbersRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the SearchAvailablePhoneNumbers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>AccessDeniedException You don't have the permissions needed to run this action.</li>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.SearchAvailablePhoneNumbers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/SearchAvailablePhoneNumbers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SearchAvailablePhoneNumbersResponse> searchAvailablePhoneNumbers(
            Consumer<SearchAvailablePhoneNumbersRequest.Builder> searchAvailablePhoneNumbersRequest) {
        return searchAvailablePhoneNumbers(SearchAvailablePhoneNumbersRequest.builder()
                .applyMutation(searchAvailablePhoneNumbersRequest).build());
    }

    /**
     * <p>
     * Searches the provisioned phone numbers in an organization.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchAvailablePhoneNumbers(software.amazon.awssdk.services.chimesdkvoice.model.SearchAvailablePhoneNumbersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chimesdkvoice.paginators.SearchAvailablePhoneNumbersPublisher publisher = client.searchAvailablePhoneNumbersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chimesdkvoice.paginators.SearchAvailablePhoneNumbersPublisher publisher = client.searchAvailablePhoneNumbersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.chimesdkvoice.model.SearchAvailablePhoneNumbersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.chimesdkvoice.model.SearchAvailablePhoneNumbersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchAvailablePhoneNumbers(software.amazon.awssdk.services.chimesdkvoice.model.SearchAvailablePhoneNumbersRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchAvailablePhoneNumbersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>AccessDeniedException You don't have the permissions needed to run this action.</li>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.SearchAvailablePhoneNumbers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/SearchAvailablePhoneNumbers"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchAvailablePhoneNumbersPublisher searchAvailablePhoneNumbersPaginator(
            SearchAvailablePhoneNumbersRequest searchAvailablePhoneNumbersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches the provisioned phone numbers in an organization.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchAvailablePhoneNumbers(software.amazon.awssdk.services.chimesdkvoice.model.SearchAvailablePhoneNumbersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chimesdkvoice.paginators.SearchAvailablePhoneNumbersPublisher publisher = client.searchAvailablePhoneNumbersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.chimesdkvoice.paginators.SearchAvailablePhoneNumbersPublisher publisher = client.searchAvailablePhoneNumbersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.chimesdkvoice.model.SearchAvailablePhoneNumbersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.chimesdkvoice.model.SearchAvailablePhoneNumbersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchAvailablePhoneNumbers(software.amazon.awssdk.services.chimesdkvoice.model.SearchAvailablePhoneNumbersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchAvailablePhoneNumbersRequest.Builder}
     * avoiding the need to create one manually via {@link SearchAvailablePhoneNumbersRequest#builder()}
     * </p>
     *
     * @param searchAvailablePhoneNumbersRequest
     *        A {@link Consumer} that will call methods on {@link SearchAvailablePhoneNumbersRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>AccessDeniedException You don't have the permissions needed to run this action.</li>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.SearchAvailablePhoneNumbers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/SearchAvailablePhoneNumbers"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchAvailablePhoneNumbersPublisher searchAvailablePhoneNumbersPaginator(
            Consumer<SearchAvailablePhoneNumbersRequest.Builder> searchAvailablePhoneNumbersRequest) {
        return searchAvailablePhoneNumbersPaginator(SearchAvailablePhoneNumbersRequest.builder()
                .applyMutation(searchAvailablePhoneNumbersRequest).build());
    }

    /**
     * <p>
     * Starts a speaker search task.
     * </p>
     * <important>
     * <p>
     * Before starting any speaker search tasks, you must provide all notices and obtain all consents from the speaker
     * as required under applicable privacy and biometrics laws, and as required under the <a
     * href="https://aws.amazon.com/service-terms/">AWS service terms</a> for the Amazon Chime SDK.
     * </p>
     * </important>
     *
     * @param startSpeakerSearchTaskRequest
     * @return A Java Future containing the result of the StartSpeakerSearchTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ResourceLimitExceededException The request exceeds the resource limit.</li>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>AccessDeniedException You don't have the permissions needed to run this action.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ConflictException Multiple instances of the same request were made simultaneously.</li>
     *         <li>GoneException Access to the target resource is no longer available at the origin server. This
     *         condition is likely to be permanent.</li>
     *         <li>UnprocessableEntityException A well-formed request couldn't be followed due to semantic errors.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.StartSpeakerSearchTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/StartSpeakerSearchTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartSpeakerSearchTaskResponse> startSpeakerSearchTask(
            StartSpeakerSearchTaskRequest startSpeakerSearchTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a speaker search task.
     * </p>
     * <important>
     * <p>
     * Before starting any speaker search tasks, you must provide all notices and obtain all consents from the speaker
     * as required under applicable privacy and biometrics laws, and as required under the <a
     * href="https://aws.amazon.com/service-terms/">AWS service terms</a> for the Amazon Chime SDK.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartSpeakerSearchTaskRequest.Builder} avoiding the
     * need to create one manually via {@link StartSpeakerSearchTaskRequest#builder()}
     * </p>
     *
     * @param startSpeakerSearchTaskRequest
     *        A {@link Consumer} that will call methods on {@link StartSpeakerSearchTaskRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartSpeakerSearchTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ResourceLimitExceededException The request exceeds the resource limit.</li>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>AccessDeniedException You don't have the permissions needed to run this action.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ConflictException Multiple instances of the same request were made simultaneously.</li>
     *         <li>GoneException Access to the target resource is no longer available at the origin server. This
     *         condition is likely to be permanent.</li>
     *         <li>UnprocessableEntityException A well-formed request couldn't be followed due to semantic errors.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.StartSpeakerSearchTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/StartSpeakerSearchTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartSpeakerSearchTaskResponse> startSpeakerSearchTask(
            Consumer<StartSpeakerSearchTaskRequest.Builder> startSpeakerSearchTaskRequest) {
        return startSpeakerSearchTask(StartSpeakerSearchTaskRequest.builder().applyMutation(startSpeakerSearchTaskRequest)
                .build());
    }

    /**
     * <p>
     * Starts a voice tone analysis task. For more information about voice tone analysis, see <a
     * href="https://docs.aws.amazon.com/chime-sdk/latest/dg/pstn-voice-analytics.html">Using Amazon Chime SDK voice
     * analytics</a> in the <i>Amazon Chime SDK Developer Guide</i>.
     * </p>
     * <important>
     * <p>
     * Before starting any voice tone analysis tasks, you must provide all notices and obtain all consents from the
     * speaker as required under applicable privacy and biometrics laws, and as required under the <a
     * href="https://aws.amazon.com/service-terms/">AWS service terms</a> for the Amazon Chime SDK.
     * </p>
     * </important>
     *
     * @param startVoiceToneAnalysisTaskRequest
     * @return A Java Future containing the result of the StartVoiceToneAnalysisTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ResourceLimitExceededException The request exceeds the resource limit.</li>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>AccessDeniedException You don't have the permissions needed to run this action.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ConflictException Multiple instances of the same request were made simultaneously.</li>
     *         <li>GoneException Access to the target resource is no longer available at the origin server. This
     *         condition is likely to be permanent.</li>
     *         <li>UnprocessableEntityException A well-formed request couldn't be followed due to semantic errors.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.StartVoiceToneAnalysisTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/StartVoiceToneAnalysisTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartVoiceToneAnalysisTaskResponse> startVoiceToneAnalysisTask(
            StartVoiceToneAnalysisTaskRequest startVoiceToneAnalysisTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a voice tone analysis task. For more information about voice tone analysis, see <a
     * href="https://docs.aws.amazon.com/chime-sdk/latest/dg/pstn-voice-analytics.html">Using Amazon Chime SDK voice
     * analytics</a> in the <i>Amazon Chime SDK Developer Guide</i>.
     * </p>
     * <important>
     * <p>
     * Before starting any voice tone analysis tasks, you must provide all notices and obtain all consents from the
     * speaker as required under applicable privacy and biometrics laws, and as required under the <a
     * href="https://aws.amazon.com/service-terms/">AWS service terms</a> for the Amazon Chime SDK.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartVoiceToneAnalysisTaskRequest.Builder} avoiding
     * the need to create one manually via {@link StartVoiceToneAnalysisTaskRequest#builder()}
     * </p>
     *
     * @param startVoiceToneAnalysisTaskRequest
     *        A {@link Consumer} that will call methods on {@link StartVoiceToneAnalysisTaskRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartVoiceToneAnalysisTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ResourceLimitExceededException The request exceeds the resource limit.</li>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>AccessDeniedException You don't have the permissions needed to run this action.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ConflictException Multiple instances of the same request were made simultaneously.</li>
     *         <li>GoneException Access to the target resource is no longer available at the origin server. This
     *         condition is likely to be permanent.</li>
     *         <li>UnprocessableEntityException A well-formed request couldn't be followed due to semantic errors.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.StartVoiceToneAnalysisTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/StartVoiceToneAnalysisTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartVoiceToneAnalysisTaskResponse> startVoiceToneAnalysisTask(
            Consumer<StartVoiceToneAnalysisTaskRequest.Builder> startVoiceToneAnalysisTaskRequest) {
        return startVoiceToneAnalysisTask(StartVoiceToneAnalysisTaskRequest.builder()
                .applyMutation(startVoiceToneAnalysisTaskRequest).build());
    }

    /**
     * <p>
     * Stops a speaker search task.
     * </p>
     *
     * @param stopSpeakerSearchTaskRequest
     * @return A Java Future containing the result of the StopSpeakerSearchTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>AccessDeniedException You don't have the permissions needed to run this action.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ConflictException Multiple instances of the same request were made simultaneously.</li>
     *         <li>UnprocessableEntityException A well-formed request couldn't be followed due to semantic errors.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.StopSpeakerSearchTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/StopSpeakerSearchTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopSpeakerSearchTaskResponse> stopSpeakerSearchTask(
            StopSpeakerSearchTaskRequest stopSpeakerSearchTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a speaker search task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopSpeakerSearchTaskRequest.Builder} avoiding the
     * need to create one manually via {@link StopSpeakerSearchTaskRequest#builder()}
     * </p>
     *
     * @param stopSpeakerSearchTaskRequest
     *        A {@link Consumer} that will call methods on {@link StopSpeakerSearchTaskRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StopSpeakerSearchTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>AccessDeniedException You don't have the permissions needed to run this action.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ConflictException Multiple instances of the same request were made simultaneously.</li>
     *         <li>UnprocessableEntityException A well-formed request couldn't be followed due to semantic errors.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.StopSpeakerSearchTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/StopSpeakerSearchTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopSpeakerSearchTaskResponse> stopSpeakerSearchTask(
            Consumer<StopSpeakerSearchTaskRequest.Builder> stopSpeakerSearchTaskRequest) {
        return stopSpeakerSearchTask(StopSpeakerSearchTaskRequest.builder().applyMutation(stopSpeakerSearchTaskRequest).build());
    }

    /**
     * <p>
     * Stops a voice tone analysis task.
     * </p>
     *
     * @param stopVoiceToneAnalysisTaskRequest
     * @return A Java Future containing the result of the StopVoiceToneAnalysisTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>AccessDeniedException You don't have the permissions needed to run this action.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ConflictException Multiple instances of the same request were made simultaneously.</li>
     *         <li>UnprocessableEntityException A well-formed request couldn't be followed due to semantic errors.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.StopVoiceToneAnalysisTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/StopVoiceToneAnalysisTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopVoiceToneAnalysisTaskResponse> stopVoiceToneAnalysisTask(
            StopVoiceToneAnalysisTaskRequest stopVoiceToneAnalysisTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a voice tone analysis task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopVoiceToneAnalysisTaskRequest.Builder} avoiding
     * the need to create one manually via {@link StopVoiceToneAnalysisTaskRequest#builder()}
     * </p>
     *
     * @param stopVoiceToneAnalysisTaskRequest
     *        A {@link Consumer} that will call methods on {@link StopVoiceToneAnalysisTaskRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StopVoiceToneAnalysisTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>AccessDeniedException You don't have the permissions needed to run this action.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ConflictException Multiple instances of the same request were made simultaneously.</li>
     *         <li>UnprocessableEntityException A well-formed request couldn't be followed due to semantic errors.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.StopVoiceToneAnalysisTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/StopVoiceToneAnalysisTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopVoiceToneAnalysisTaskResponse> stopVoiceToneAnalysisTask(
            Consumer<StopVoiceToneAnalysisTaskRequest.Builder> stopVoiceToneAnalysisTaskRequest) {
        return stopVoiceToneAnalysisTask(StopVoiceToneAnalysisTaskRequest.builder()
                .applyMutation(stopVoiceToneAnalysisTaskRequest).build());
    }

    /**
     * <p>
     * Adds a tag to the specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ResourceLimitExceededException The request exceeds the resource limit.</li>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a tag to the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ResourceLimitExceededException The request exceeds the resource limit.</li>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates global settings for the Amazon Chime SDK Voice Connectors in an AWS account.
     * </p>
     *
     * @param updateGlobalSettingsRequest
     * @return A Java Future containing the result of the UpdateGlobalSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.UpdateGlobalSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/UpdateGlobalSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateGlobalSettingsResponse> updateGlobalSettings(
            UpdateGlobalSettingsRequest updateGlobalSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates global settings for the Amazon Chime SDK Voice Connectors in an AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateGlobalSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateGlobalSettingsRequest#builder()}
     * </p>
     *
     * @param updateGlobalSettingsRequest
     *        A {@link Consumer} that will call methods on {@link UpdateGlobalSettingsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateGlobalSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.UpdateGlobalSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/UpdateGlobalSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateGlobalSettingsResponse> updateGlobalSettings(
            Consumer<UpdateGlobalSettingsRequest.Builder> updateGlobalSettingsRequest) {
        return updateGlobalSettings(UpdateGlobalSettingsRequest.builder().applyMutation(updateGlobalSettingsRequest).build());
    }

    /**
     * <p>
     * Updates phone number details, such as product type or calling name, for the specified phone number ID. You can
     * update one phone number detail at a time. For example, you can update either the product type or the calling name
     * in one action.
     * </p>
     * <p>
     * For numbers outside the U.S., you must use the Amazon Chime SDK SIP Media Application Dial-In product type.
     * </p>
     * <p>
     * Updates to outbound calling names can take 72 hours to complete. Pending updates to outbound calling names must
     * be complete before you can request another update.
     * </p>
     *
     * @param updatePhoneNumberRequest
     * @return A Java Future containing the result of the UpdatePhoneNumber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ConflictException Multiple instances of the same request were made simultaneously.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.UpdatePhoneNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/UpdatePhoneNumber"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdatePhoneNumberResponse> updatePhoneNumber(UpdatePhoneNumberRequest updatePhoneNumberRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates phone number details, such as product type or calling name, for the specified phone number ID. You can
     * update one phone number detail at a time. For example, you can update either the product type or the calling name
     * in one action.
     * </p>
     * <p>
     * For numbers outside the U.S., you must use the Amazon Chime SDK SIP Media Application Dial-In product type.
     * </p>
     * <p>
     * Updates to outbound calling names can take 72 hours to complete. Pending updates to outbound calling names must
     * be complete before you can request another update.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePhoneNumberRequest.Builder} avoiding the need
     * to create one manually via {@link UpdatePhoneNumberRequest#builder()}
     * </p>
     *
     * @param updatePhoneNumberRequest
     *        A {@link Consumer} that will call methods on {@link UpdatePhoneNumberRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdatePhoneNumber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ConflictException Multiple instances of the same request were made simultaneously.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.UpdatePhoneNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/UpdatePhoneNumber"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdatePhoneNumberResponse> updatePhoneNumber(
            Consumer<UpdatePhoneNumberRequest.Builder> updatePhoneNumberRequest) {
        return updatePhoneNumber(UpdatePhoneNumberRequest.builder().applyMutation(updatePhoneNumberRequest).build());
    }

    /**
     * <p>
     * Updates the phone number settings for the administrator's AWS account, such as the default outbound calling name.
     * You can update the default outbound calling name once every seven days. Outbound calling names can take up to 72
     * hours to update.
     * </p>
     *
     * @param updatePhoneNumberSettingsRequest
     * @return A Java Future containing the result of the UpdatePhoneNumberSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.UpdatePhoneNumberSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/UpdatePhoneNumberSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdatePhoneNumberSettingsResponse> updatePhoneNumberSettings(
            UpdatePhoneNumberSettingsRequest updatePhoneNumberSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the phone number settings for the administrator's AWS account, such as the default outbound calling name.
     * You can update the default outbound calling name once every seven days. Outbound calling names can take up to 72
     * hours to update.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePhoneNumberSettingsRequest.Builder} avoiding
     * the need to create one manually via {@link UpdatePhoneNumberSettingsRequest#builder()}
     * </p>
     *
     * @param updatePhoneNumberSettingsRequest
     *        A {@link Consumer} that will call methods on {@link UpdatePhoneNumberSettingsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdatePhoneNumberSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.UpdatePhoneNumberSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/UpdatePhoneNumberSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdatePhoneNumberSettingsResponse> updatePhoneNumberSettings(
            Consumer<UpdatePhoneNumberSettingsRequest.Builder> updatePhoneNumberSettingsRequest) {
        return updatePhoneNumberSettings(UpdatePhoneNumberSettingsRequest.builder()
                .applyMutation(updatePhoneNumberSettingsRequest).build());
    }

    /**
     * <p>
     * Updates the specified proxy session details, such as voice or SMS capabilities.
     * </p>
     *
     * @param updateProxySessionRequest
     * @return A Java Future containing the result of the UpdateProxySession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.UpdateProxySession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/UpdateProxySession"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateProxySessionResponse> updateProxySession(UpdateProxySessionRequest updateProxySessionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified proxy session details, such as voice or SMS capabilities.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateProxySessionRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateProxySessionRequest#builder()}
     * </p>
     *
     * @param updateProxySessionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateProxySessionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateProxySession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.UpdateProxySession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/UpdateProxySession"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateProxySessionResponse> updateProxySession(
            Consumer<UpdateProxySessionRequest.Builder> updateProxySessionRequest) {
        return updateProxySession(UpdateProxySessionRequest.builder().applyMutation(updateProxySessionRequest).build());
    }

    /**
     * <p>
     * Updates the details of the specified SIP media application.
     * </p>
     *
     * @param updateSipMediaApplicationRequest
     * @return A Java Future containing the result of the UpdateSipMediaApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ConflictException Multiple instances of the same request were made simultaneously.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.UpdateSipMediaApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/UpdateSipMediaApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateSipMediaApplicationResponse> updateSipMediaApplication(
            UpdateSipMediaApplicationRequest updateSipMediaApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the details of the specified SIP media application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSipMediaApplicationRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateSipMediaApplicationRequest#builder()}
     * </p>
     *
     * @param updateSipMediaApplicationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateSipMediaApplicationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateSipMediaApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ConflictException Multiple instances of the same request were made simultaneously.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.UpdateSipMediaApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/UpdateSipMediaApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateSipMediaApplicationResponse> updateSipMediaApplication(
            Consumer<UpdateSipMediaApplicationRequest.Builder> updateSipMediaApplicationRequest) {
        return updateSipMediaApplication(UpdateSipMediaApplicationRequest.builder()
                .applyMutation(updateSipMediaApplicationRequest).build());
    }

    /**
     * <p>
     * Invokes the AWS Lambda function associated with the SIP media application and transaction ID in an update
     * request. The Lambda function can then return a new set of actions.
     * </p>
     *
     * @param updateSipMediaApplicationCallRequest
     * @return A Java Future containing the result of the UpdateSipMediaApplicationCall operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>ResourceLimitExceededException The request exceeds the resource limit.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.UpdateSipMediaApplicationCall
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/UpdateSipMediaApplicationCall"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateSipMediaApplicationCallResponse> updateSipMediaApplicationCall(
            UpdateSipMediaApplicationCallRequest updateSipMediaApplicationCallRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Invokes the AWS Lambda function associated with the SIP media application and transaction ID in an update
     * request. The Lambda function can then return a new set of actions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSipMediaApplicationCallRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateSipMediaApplicationCallRequest#builder()}
     * </p>
     *
     * @param updateSipMediaApplicationCallRequest
     *        A {@link Consumer} that will call methods on {@link UpdateSipMediaApplicationCallRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateSipMediaApplicationCall operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>ResourceLimitExceededException The request exceeds the resource limit.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.UpdateSipMediaApplicationCall
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/UpdateSipMediaApplicationCall"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateSipMediaApplicationCallResponse> updateSipMediaApplicationCall(
            Consumer<UpdateSipMediaApplicationCallRequest.Builder> updateSipMediaApplicationCallRequest) {
        return updateSipMediaApplicationCall(UpdateSipMediaApplicationCallRequest.builder()
                .applyMutation(updateSipMediaApplicationCallRequest).build());
    }

    /**
     * <p>
     * Updates the details of the specified SIP rule.
     * </p>
     *
     * @param updateSipRuleRequest
     * @return A Java Future containing the result of the UpdateSipRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ConflictException Multiple instances of the same request were made simultaneously.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ResourceLimitExceededException The request exceeds the resource limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.UpdateSipRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/UpdateSipRule" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateSipRuleResponse> updateSipRule(UpdateSipRuleRequest updateSipRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the details of the specified SIP rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSipRuleRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateSipRuleRequest#builder()}
     * </p>
     *
     * @param updateSipRuleRequest
     *        A {@link Consumer} that will call methods on {@link UpdateSipRuleRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateSipRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ConflictException Multiple instances of the same request were made simultaneously.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ResourceLimitExceededException The request exceeds the resource limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.UpdateSipRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/UpdateSipRule" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateSipRuleResponse> updateSipRule(Consumer<UpdateSipRuleRequest.Builder> updateSipRuleRequest) {
        return updateSipRule(UpdateSipRuleRequest.builder().applyMutation(updateSipRuleRequest).build());
    }

    /**
     * <p>
     * Updates the details for the specified Amazon Chime SDK Voice Connector.
     * </p>
     *
     * @param updateVoiceConnectorRequest
     * @return A Java Future containing the result of the UpdateVoiceConnector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.UpdateVoiceConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/UpdateVoiceConnector"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateVoiceConnectorResponse> updateVoiceConnector(
            UpdateVoiceConnectorRequest updateVoiceConnectorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the details for the specified Amazon Chime SDK Voice Connector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateVoiceConnectorRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateVoiceConnectorRequest#builder()}
     * </p>
     *
     * @param updateVoiceConnectorRequest
     *        A {@link Consumer} that will call methods on {@link UpdateVoiceConnectorRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateVoiceConnector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.UpdateVoiceConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/UpdateVoiceConnector"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateVoiceConnectorResponse> updateVoiceConnector(
            Consumer<UpdateVoiceConnectorRequest.Builder> updateVoiceConnectorRequest) {
        return updateVoiceConnector(UpdateVoiceConnectorRequest.builder().applyMutation(updateVoiceConnectorRequest).build());
    }

    /**
     * <p>
     * Updates the settings for the specified Amazon Chime SDK Voice Connector group.
     * </p>
     *
     * @param updateVoiceConnectorGroupRequest
     * @return A Java Future containing the result of the UpdateVoiceConnectorGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ConflictException Multiple instances of the same request were made simultaneously.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.UpdateVoiceConnectorGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/UpdateVoiceConnectorGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateVoiceConnectorGroupResponse> updateVoiceConnectorGroup(
            UpdateVoiceConnectorGroupRequest updateVoiceConnectorGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the settings for the specified Amazon Chime SDK Voice Connector group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateVoiceConnectorGroupRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateVoiceConnectorGroupRequest#builder()}
     * </p>
     *
     * @param updateVoiceConnectorGroupRequest
     *        A {@link Consumer} that will call methods on {@link UpdateVoiceConnectorGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateVoiceConnectorGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ConflictException Multiple instances of the same request were made simultaneously.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.UpdateVoiceConnectorGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/UpdateVoiceConnectorGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateVoiceConnectorGroupResponse> updateVoiceConnectorGroup(
            Consumer<UpdateVoiceConnectorGroupRequest.Builder> updateVoiceConnectorGroupRequest) {
        return updateVoiceConnectorGroup(UpdateVoiceConnectorGroupRequest.builder()
                .applyMutation(updateVoiceConnectorGroupRequest).build());
    }

    /**
     * <p>
     * Updates the specified voice profile’s voice print and refreshes its expiration timestamp.
     * </p>
     * <important>
     * <p>
     * As a condition of using this feature, you acknowledge that the collection, use, storage, and retention of your
     * caller’s biometric identifiers and biometric information (“biometric data”) in the form of a digital voiceprint
     * requires the caller’s informed consent via a written release. Such consent is required under various state laws,
     * including biometrics laws in Illinois, Texas, Washington and other state privacy laws.
     * </p>
     * <p>
     * You must provide a written release to each caller through a process that clearly reflects each caller’s informed
     * consent before using Amazon Chime SDK Voice Insights service, as required under the terms of your agreement with
     * AWS governing your use of the service.
     * </p>
     * </important>
     *
     * @param updateVoiceProfileRequest
     * @return A Java Future containing the result of the UpdateVoiceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>AccessDeniedException You don't have the permissions needed to run this action.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ConflictException Multiple instances of the same request were made simultaneously.</li>
     *         <li>GoneException Access to the target resource is no longer available at the origin server. This
     *         condition is likely to be permanent.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.UpdateVoiceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/UpdateVoiceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateVoiceProfileResponse> updateVoiceProfile(UpdateVoiceProfileRequest updateVoiceProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified voice profile’s voice print and refreshes its expiration timestamp.
     * </p>
     * <important>
     * <p>
     * As a condition of using this feature, you acknowledge that the collection, use, storage, and retention of your
     * caller’s biometric identifiers and biometric information (“biometric data”) in the form of a digital voiceprint
     * requires the caller’s informed consent via a written release. Such consent is required under various state laws,
     * including biometrics laws in Illinois, Texas, Washington and other state privacy laws.
     * </p>
     * <p>
     * You must provide a written release to each caller through a process that clearly reflects each caller’s informed
     * consent before using Amazon Chime SDK Voice Insights service, as required under the terms of your agreement with
     * AWS governing your use of the service.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateVoiceProfileRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateVoiceProfileRequest#builder()}
     * </p>
     *
     * @param updateVoiceProfileRequest
     *        A {@link Consumer} that will call methods on {@link UpdateVoiceProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateVoiceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>AccessDeniedException You don't have the permissions needed to run this action.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ConflictException Multiple instances of the same request were made simultaneously.</li>
     *         <li>GoneException Access to the target resource is no longer available at the origin server. This
     *         condition is likely to be permanent.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.UpdateVoiceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/UpdateVoiceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateVoiceProfileResponse> updateVoiceProfile(
            Consumer<UpdateVoiceProfileRequest.Builder> updateVoiceProfileRequest) {
        return updateVoiceProfile(UpdateVoiceProfileRequest.builder().applyMutation(updateVoiceProfileRequest).build());
    }

    /**
     * <p>
     * Updates the settings for the specified voice profile domain.
     * </p>
     *
     * @param updateVoiceProfileDomainRequest
     * @return A Java Future containing the result of the UpdateVoiceProfileDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>AccessDeniedException You don't have the permissions needed to run this action.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.UpdateVoiceProfileDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/UpdateVoiceProfileDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateVoiceProfileDomainResponse> updateVoiceProfileDomain(
            UpdateVoiceProfileDomainRequest updateVoiceProfileDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the settings for the specified voice profile domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateVoiceProfileDomainRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateVoiceProfileDomainRequest#builder()}
     * </p>
     *
     * @param updateVoiceProfileDomainRequest
     *        A {@link Consumer} that will call methods on {@link UpdateVoiceProfileDomainRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateVoiceProfileDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>AccessDeniedException You don't have the permissions needed to run this action.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.UpdateVoiceProfileDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/UpdateVoiceProfileDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateVoiceProfileDomainResponse> updateVoiceProfileDomain(
            Consumer<UpdateVoiceProfileDomainRequest.Builder> updateVoiceProfileDomainRequest) {
        return updateVoiceProfileDomain(UpdateVoiceProfileDomainRequest.builder().applyMutation(updateVoiceProfileDomainRequest)
                .build());
    }

    /**
     * <p>
     * Validates an address to be used for 911 calls made with Amazon Chime SDK Voice Connectors. You can use validated
     * addresses in a Presence Information Data Format Location Object file that you include in SIP requests. That helps
     * ensure that addresses are routed to the appropriate Public Safety Answering Point.
     * </p>
     *
     * @param validateE911AddressRequest
     * @return A Java Future containing the result of the ValidateE911Address operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.ValidateE911Address
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ValidateE911Address"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ValidateE911AddressResponse> validateE911Address(
            ValidateE911AddressRequest validateE911AddressRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Validates an address to be used for 911 calls made with Amazon Chime SDK Voice Connectors. You can use validated
     * addresses in a Presence Information Data Format Location Object file that you include in SIP requests. That helps
     * ensure that addresses are routed to the appropriate Public Safety Answering Point.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ValidateE911AddressRequest.Builder} avoiding the
     * need to create one manually via {@link ValidateE911AddressRequest#builder()}
     * </p>
     *
     * @param validateE911AddressRequest
     *        A {@link Consumer} that will call methods on {@link ValidateE911AddressRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ValidateE911Address operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedClientException The client isn't authorized to request a resource.</li>
     *         <li>NotFoundException The requested resource couldn't be found.</li>
     *         <li>ForbiddenException The client is permanently forbidden from making the request.</li>
     *         <li>BadRequestException The input parameters don't match the service's restrictions.</li>
     *         <li>ThrottledClientException The number of customer requests exceeds the request rate limit.</li>
     *         <li>ServiceUnavailableException The service is currently unavailable.</li>
     *         <li>ServiceFailureException The service encountered an unexpected error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ChimeSdkVoiceException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ChimeSdkVoiceAsyncClient.ValidateE911Address
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ValidateE911Address"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ValidateE911AddressResponse> validateE911Address(
            Consumer<ValidateE911AddressRequest.Builder> validateE911AddressRequest) {
        return validateE911Address(ValidateE911AddressRequest.builder().applyMutation(validateE911AddressRequest).build());
    }

    @Override
    default ChimeSdkVoiceServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link ChimeSdkVoiceAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ChimeSdkVoiceAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ChimeSdkVoiceAsyncClient}.
     */
    static ChimeSdkVoiceAsyncClientBuilder builder() {
        return new DefaultChimeSdkVoiceAsyncClientBuilder();
    }
}
