/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmessaging.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The target of a message, a sender, a user, or a bot. Only the target and the sender can view targeted messages. Only
 * users who can see targeted messages can take actions on them. However, administrators can delete targeted messages
 * that they can’t see.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Target implements SdkPojo, Serializable, ToCopyableBuilder<Target.Builder, Target> {
    private static final SdkField<String> MEMBER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MemberArn").getter(getter(Target::memberArn)).setter(setter(Builder::memberArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBER_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String memberArn;

    private Target(BuilderImpl builder) {
        this.memberArn = builder.memberArn;
    }

    /**
     * <p>
     * The ARN of the target channel member.
     * </p>
     * 
     * @return The ARN of the target channel member.
     */
    public final String memberArn() {
        return memberArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(memberArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Target)) {
            return false;
        }
        Target other = (Target) obj;
        return Objects.equals(memberArn(), other.memberArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Target").add("MemberArn", memberArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MemberArn":
            return Optional.ofNullable(clazz.cast(memberArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Target, T> g) {
        return obj -> g.apply((Target) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Target> {
        /**
         * <p>
         * The ARN of the target channel member.
         * </p>
         * 
         * @param memberArn
         *        The ARN of the target channel member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberArn(String memberArn);
    }

    static final class BuilderImpl implements Builder {
        private String memberArn;

        private BuilderImpl() {
        }

        private BuilderImpl(Target model) {
            memberArn(model.memberArn);
        }

        public final String getMemberArn() {
            return memberArn;
        }

        public final void setMemberArn(String memberArn) {
            this.memberArn = memberArn;
        }

        @Override
        public final Builder memberArn(String memberArn) {
            this.memberArn = memberArn;
            return this;
        }

        @Override
        public Target build() {
            return new Target(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
