/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmessaging.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The information about a processor in a channel flow.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Processor implements SdkPojo, Serializable, ToCopyableBuilder<Processor.Builder, Processor> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Processor::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<ProcessorConfiguration> CONFIGURATION_FIELD = SdkField
            .<ProcessorConfiguration> builder(MarshallingType.SDK_POJO).memberName("Configuration")
            .getter(getter(Processor::configuration)).setter(setter(Builder::configuration))
            .constructor(ProcessorConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configuration").build()).build();

    private static final SdkField<Integer> EXECUTION_ORDER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ExecutionOrder").getter(getter(Processor::executionOrder)).setter(setter(Builder::executionOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionOrder").build()).build();

    private static final SdkField<String> FALLBACK_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FallbackAction").getter(getter(Processor::fallbackActionAsString))
            .setter(setter(Builder::fallbackAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FallbackAction").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            CONFIGURATION_FIELD, EXECUTION_ORDER_FIELD, FALLBACK_ACTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final ProcessorConfiguration configuration;

    private final Integer executionOrder;

    private final String fallbackAction;

    private Processor(BuilderImpl builder) {
        this.name = builder.name;
        this.configuration = builder.configuration;
        this.executionOrder = builder.executionOrder;
        this.fallbackAction = builder.fallbackAction;
    }

    /**
     * <p>
     * The name of the channel flow.
     * </p>
     * 
     * @return The name of the channel flow.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The information about the type of processor and its identifier.
     * </p>
     * 
     * @return The information about the type of processor and its identifier.
     */
    public final ProcessorConfiguration configuration() {
        return configuration;
    }

    /**
     * <p>
     * The sequence in which processors run. If you have multiple processors in a channel flow, message processing goes
     * through each processor in the sequence. The value determines the sequence. At this point, we support only 1
     * processor within a flow.
     * </p>
     * 
     * @return The sequence in which processors run. If you have multiple processors in a channel flow, message
     *         processing goes through each processor in the sequence. The value determines the sequence. At this point,
     *         we support only 1 processor within a flow.
     */
    public final Integer executionOrder() {
        return executionOrder;
    }

    /**
     * <p>
     * Determines whether to continue with message processing or stop it in cases where communication with a processor
     * fails. If a processor has a fallback action of <code>ABORT</code> and communication with it fails, the processor
     * sets the message status to <code>FAILED</code> and does not send the message to any recipients. Note that if the
     * last processor in the channel flow sequence has a fallback action of <code>CONTINUE</code> and communication with
     * the processor fails, then the message is considered processed and sent to recipients of the channel.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fallbackAction}
     * will return {@link FallbackAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #fallbackActionAsString}.
     * </p>
     * 
     * @return Determines whether to continue with message processing or stop it in cases where communication with a
     *         processor fails. If a processor has a fallback action of <code>ABORT</code> and communication with it
     *         fails, the processor sets the message status to <code>FAILED</code> and does not send the message to any
     *         recipients. Note that if the last processor in the channel flow sequence has a fallback action of
     *         <code>CONTINUE</code> and communication with the processor fails, then the message is considered
     *         processed and sent to recipients of the channel.
     * @see FallbackAction
     */
    public final FallbackAction fallbackAction() {
        return FallbackAction.fromValue(fallbackAction);
    }

    /**
     * <p>
     * Determines whether to continue with message processing or stop it in cases where communication with a processor
     * fails. If a processor has a fallback action of <code>ABORT</code> and communication with it fails, the processor
     * sets the message status to <code>FAILED</code> and does not send the message to any recipients. Note that if the
     * last processor in the channel flow sequence has a fallback action of <code>CONTINUE</code> and communication with
     * the processor fails, then the message is considered processed and sent to recipients of the channel.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fallbackAction}
     * will return {@link FallbackAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #fallbackActionAsString}.
     * </p>
     * 
     * @return Determines whether to continue with message processing or stop it in cases where communication with a
     *         processor fails. If a processor has a fallback action of <code>ABORT</code> and communication with it
     *         fails, the processor sets the message status to <code>FAILED</code> and does not send the message to any
     *         recipients. Note that if the last processor in the channel flow sequence has a fallback action of
     *         <code>CONTINUE</code> and communication with the processor fails, then the message is considered
     *         processed and sent to recipients of the channel.
     * @see FallbackAction
     */
    public final String fallbackActionAsString() {
        return fallbackAction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(executionOrder());
        hashCode = 31 * hashCode + Objects.hashCode(fallbackActionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Processor)) {
            return false;
        }
        Processor other = (Processor) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(configuration(), other.configuration())
                && Objects.equals(executionOrder(), other.executionOrder())
                && Objects.equals(fallbackActionAsString(), other.fallbackActionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Processor").add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Configuration", configuration()).add("ExecutionOrder", executionOrder())
                .add("FallbackAction", fallbackActionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "ExecutionOrder":
            return Optional.ofNullable(clazz.cast(executionOrder()));
        case "FallbackAction":
            return Optional.ofNullable(clazz.cast(fallbackActionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Processor, T> g) {
        return obj -> g.apply((Processor) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Processor> {
        /**
         * <p>
         * The name of the channel flow.
         * </p>
         * 
         * @param name
         *        The name of the channel flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The information about the type of processor and its identifier.
         * </p>
         * 
         * @param configuration
         *        The information about the type of processor and its identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(ProcessorConfiguration configuration);

        /**
         * <p>
         * The information about the type of processor and its identifier.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProcessorConfiguration.Builder} avoiding
         * the need to create one manually via {@link ProcessorConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProcessorConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #configuration(ProcessorConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link ProcessorConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(ProcessorConfiguration)
         */
        default Builder configuration(Consumer<ProcessorConfiguration.Builder> configuration) {
            return configuration(ProcessorConfiguration.builder().applyMutation(configuration).build());
        }

        /**
         * <p>
         * The sequence in which processors run. If you have multiple processors in a channel flow, message processing
         * goes through each processor in the sequence. The value determines the sequence. At this point, we support
         * only 1 processor within a flow.
         * </p>
         * 
         * @param executionOrder
         *        The sequence in which processors run. If you have multiple processors in a channel flow, message
         *        processing goes through each processor in the sequence. The value determines the sequence. At this
         *        point, we support only 1 processor within a flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionOrder(Integer executionOrder);

        /**
         * <p>
         * Determines whether to continue with message processing or stop it in cases where communication with a
         * processor fails. If a processor has a fallback action of <code>ABORT</code> and communication with it fails,
         * the processor sets the message status to <code>FAILED</code> and does not send the message to any recipients.
         * Note that if the last processor in the channel flow sequence has a fallback action of <code>CONTINUE</code>
         * and communication with the processor fails, then the message is considered processed and sent to recipients
         * of the channel.
         * </p>
         * 
         * @param fallbackAction
         *        Determines whether to continue with message processing or stop it in cases where communication with a
         *        processor fails. If a processor has a fallback action of <code>ABORT</code> and communication with it
         *        fails, the processor sets the message status to <code>FAILED</code> and does not send the message to
         *        any recipients. Note that if the last processor in the channel flow sequence has a fallback action of
         *        <code>CONTINUE</code> and communication with the processor fails, then the message is considered
         *        processed and sent to recipients of the channel.
         * @see FallbackAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FallbackAction
         */
        Builder fallbackAction(String fallbackAction);

        /**
         * <p>
         * Determines whether to continue with message processing or stop it in cases where communication with a
         * processor fails. If a processor has a fallback action of <code>ABORT</code> and communication with it fails,
         * the processor sets the message status to <code>FAILED</code> and does not send the message to any recipients.
         * Note that if the last processor in the channel flow sequence has a fallback action of <code>CONTINUE</code>
         * and communication with the processor fails, then the message is considered processed and sent to recipients
         * of the channel.
         * </p>
         * 
         * @param fallbackAction
         *        Determines whether to continue with message processing or stop it in cases where communication with a
         *        processor fails. If a processor has a fallback action of <code>ABORT</code> and communication with it
         *        fails, the processor sets the message status to <code>FAILED</code> and does not send the message to
         *        any recipients. Note that if the last processor in the channel flow sequence has a fallback action of
         *        <code>CONTINUE</code> and communication with the processor fails, then the message is considered
         *        processed and sent to recipients of the channel.
         * @see FallbackAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FallbackAction
         */
        Builder fallbackAction(FallbackAction fallbackAction);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private ProcessorConfiguration configuration;

        private Integer executionOrder;

        private String fallbackAction;

        private BuilderImpl() {
        }

        private BuilderImpl(Processor model) {
            name(model.name);
            configuration(model.configuration);
            executionOrder(model.executionOrder);
            fallbackAction(model.fallbackAction);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final ProcessorConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(ProcessorConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(ProcessorConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final Integer getExecutionOrder() {
            return executionOrder;
        }

        public final void setExecutionOrder(Integer executionOrder) {
            this.executionOrder = executionOrder;
        }

        @Override
        public final Builder executionOrder(Integer executionOrder) {
            this.executionOrder = executionOrder;
            return this;
        }

        public final String getFallbackAction() {
            return fallbackAction;
        }

        public final void setFallbackAction(String fallbackAction) {
            this.fallbackAction = fallbackAction;
        }

        @Override
        public final Builder fallbackAction(String fallbackAction) {
            this.fallbackAction = fallbackAction;
            return this;
        }

        @Override
        public final Builder fallbackAction(FallbackAction fallbackAction) {
            this.fallbackAction(fallbackAction == null ? null : fallbackAction.toString());
            return this;
        }

        @Override
        public Processor build() {
            return new Processor(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
