/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmessaging.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of message attribute values.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MessageAttributeValue implements SdkPojo, Serializable,
        ToCopyableBuilder<MessageAttributeValue.Builder, MessageAttributeValue> {
    private static final SdkField<List<String>> STRING_VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("StringValues")
            .getter(getter(MessageAttributeValue::stringValues))
            .setter(setter(Builder::stringValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STRING_VALUES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> stringValues;

    private MessageAttributeValue(BuilderImpl builder) {
        this.stringValues = builder.stringValues;
    }

    /**
     * For responses, this returns true if the service returned a value for the StringValues property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStringValues() {
        return stringValues != null && !(stringValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The strings in a message attribute value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStringValues} method.
     * </p>
     * 
     * @return The strings in a message attribute value.
     */
    public final List<String> stringValues() {
        return stringValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasStringValues() ? stringValues() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageAttributeValue)) {
            return false;
        }
        MessageAttributeValue other = (MessageAttributeValue) obj;
        return hasStringValues() == other.hasStringValues() && Objects.equals(stringValues(), other.stringValues());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MessageAttributeValue")
                .add("StringValues", stringValues() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StringValues":
            return Optional.ofNullable(clazz.cast(stringValues()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MessageAttributeValue, T> g) {
        return obj -> g.apply((MessageAttributeValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MessageAttributeValue> {
        /**
         * <p>
         * The strings in a message attribute value.
         * </p>
         * 
         * @param stringValues
         *        The strings in a message attribute value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringValues(Collection<String> stringValues);

        /**
         * <p>
         * The strings in a message attribute value.
         * </p>
         * 
         * @param stringValues
         *        The strings in a message attribute value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringValues(String... stringValues);
    }

    static final class BuilderImpl implements Builder {
        private List<String> stringValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MessageAttributeValue model) {
            stringValues(model.stringValues);
        }

        public final Collection<String> getStringValues() {
            if (stringValues instanceof SdkAutoConstructList) {
                return null;
            }
            return stringValues;
        }

        public final void setStringValues(Collection<String> stringValues) {
            this.stringValues = MessageAttributeStringValuesCopier.copy(stringValues);
        }

        @Override
        public final Builder stringValues(Collection<String> stringValues) {
            this.stringValues = MessageAttributeStringValuesCopier.copy(stringValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stringValues(String... stringValues) {
            stringValues(Arrays.asList(stringValues));
            return this;
        }

        @Override
        public MessageAttributeValue build() {
            return new MessageAttributeValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
