/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmessaging.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chimesdkmessaging.model.AllowNotifications;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PushNotificationPreferences
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PushNotificationPreferences> {
    private static final SdkField<String> ALLOW_NOTIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AllowNotifications").getter(PushNotificationPreferences.getter(PushNotificationPreferences::allowNotificationsAsString)).setter(PushNotificationPreferences.setter(Builder::allowNotifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowNotifications").build()}).build();
    private static final SdkField<String> FILTER_RULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FilterRule").getter(PushNotificationPreferences.getter(PushNotificationPreferences::filterRule)).setter(PushNotificationPreferences.setter(Builder::filterRule)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterRule").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOW_NOTIFICATIONS_FIELD, FILTER_RULE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String allowNotifications;
    private final String filterRule;

    private PushNotificationPreferences(BuilderImpl builder) {
        this.allowNotifications = builder.allowNotifications;
        this.filterRule = builder.filterRule;
    }

    public final AllowNotifications allowNotifications() {
        return AllowNotifications.fromValue(this.allowNotifications);
    }

    public final String allowNotificationsAsString() {
        return this.allowNotifications;
    }

    public final String filterRule() {
        return this.filterRule;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.allowNotificationsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterRule());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PushNotificationPreferences)) {
            return false;
        }
        PushNotificationPreferences other = (PushNotificationPreferences)obj;
        return Objects.equals(this.allowNotificationsAsString(), other.allowNotificationsAsString()) && Objects.equals(this.filterRule(), other.filterRule());
    }

    public final String toString() {
        return ToString.builder((String)"PushNotificationPreferences").add("AllowNotifications", (Object)this.allowNotificationsAsString()).add("FilterRule", (Object)(this.filterRule() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AllowNotifications": {
                return Optional.ofNullable(clazz.cast(this.allowNotificationsAsString()));
            }
            case "FilterRule": {
                return Optional.ofNullable(clazz.cast(this.filterRule()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PushNotificationPreferences, T> g) {
        return obj -> g.apply((PushNotificationPreferences)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String allowNotifications;
        private String filterRule;

        private BuilderImpl() {
        }

        private BuilderImpl(PushNotificationPreferences model) {
            this.allowNotifications(model.allowNotifications);
            this.filterRule(model.filterRule);
        }

        public final String getAllowNotifications() {
            return this.allowNotifications;
        }

        public final void setAllowNotifications(String allowNotifications) {
            this.allowNotifications = allowNotifications;
        }

        @Override
        public final Builder allowNotifications(String allowNotifications) {
            this.allowNotifications = allowNotifications;
            return this;
        }

        @Override
        public final Builder allowNotifications(AllowNotifications allowNotifications) {
            this.allowNotifications(allowNotifications == null ? null : allowNotifications.toString());
            return this;
        }

        public final String getFilterRule() {
            return this.filterRule;
        }

        public final void setFilterRule(String filterRule) {
            this.filterRule = filterRule;
        }

        @Override
        public final Builder filterRule(String filterRule) {
            this.filterRule = filterRule;
            return this;
        }

        public PushNotificationPreferences build() {
            return new PushNotificationPreferences(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PushNotificationPreferences> {
        public Builder allowNotifications(String var1);

        public Builder allowNotifications(AllowNotifications var1);

        public Builder filterRule(String var1);
    }
}

