/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmediapipelines.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chimesdkmediapipelines.ChimeSdkMediaPipelinesAsyncClient;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.ListMediaCapturePipelinesRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.ListMediaCapturePipelinesResponse;

public class ListMediaCapturePipelinesPublisher
implements SdkPublisher<ListMediaCapturePipelinesResponse> {
    private final ChimeSdkMediaPipelinesAsyncClient client;
    private final ListMediaCapturePipelinesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListMediaCapturePipelinesPublisher(ChimeSdkMediaPipelinesAsyncClient client, ListMediaCapturePipelinesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListMediaCapturePipelinesPublisher(ChimeSdkMediaPipelinesAsyncClient client, ListMediaCapturePipelinesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListMediaCapturePipelinesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListMediaCapturePipelinesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListMediaCapturePipelinesResponseFetcher
    implements AsyncPageFetcher<ListMediaCapturePipelinesResponse> {
        private ListMediaCapturePipelinesResponseFetcher() {
        }

        public boolean hasNextPage(ListMediaCapturePipelinesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListMediaCapturePipelinesResponse> nextPage(ListMediaCapturePipelinesResponse previousPage) {
            if (previousPage == null) {
                return ListMediaCapturePipelinesPublisher.this.client.listMediaCapturePipelines(ListMediaCapturePipelinesPublisher.this.firstRequest);
            }
            return ListMediaCapturePipelinesPublisher.this.client.listMediaCapturePipelines((ListMediaCapturePipelinesRequest)((Object)ListMediaCapturePipelinesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

