/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmediapipelines.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chimesdkmediapipelines.ChimeSdkMediaPipelinesClient;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.ListMediaCapturePipelinesRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.ListMediaCapturePipelinesResponse;

public class ListMediaCapturePipelinesIterable
implements SdkIterable<ListMediaCapturePipelinesResponse> {
    private final ChimeSdkMediaPipelinesClient client;
    private final ListMediaCapturePipelinesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListMediaCapturePipelinesIterable(ChimeSdkMediaPipelinesClient client, ListMediaCapturePipelinesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListMediaCapturePipelinesResponseFetcher();
    }

    public Iterator<ListMediaCapturePipelinesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListMediaCapturePipelinesResponseFetcher
    implements SyncPageFetcher<ListMediaCapturePipelinesResponse> {
        private ListMediaCapturePipelinesResponseFetcher() {
        }

        public boolean hasNextPage(ListMediaCapturePipelinesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListMediaCapturePipelinesResponse nextPage(ListMediaCapturePipelinesResponse previousPage) {
            if (previousPage == null) {
                return ListMediaCapturePipelinesIterable.this.client.listMediaCapturePipelines(ListMediaCapturePipelinesIterable.this.firstRequest);
            }
            return ListMediaCapturePipelinesIterable.this.client.listMediaCapturePipelines((ListMediaCapturePipelinesRequest)((Object)ListMediaCapturePipelinesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

