/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkidentity.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chimesdkidentity.ChimeSdkIdentityClient;
import software.amazon.awssdk.services.chimesdkidentity.internal.UserAgentUtils;
import software.amazon.awssdk.services.chimesdkidentity.model.ListAppInstanceAdminsRequest;
import software.amazon.awssdk.services.chimesdkidentity.model.ListAppInstanceAdminsResponse;

public class ListAppInstanceAdminsIterable
implements SdkIterable<ListAppInstanceAdminsResponse> {
    private final ChimeSdkIdentityClient client;
    private final ListAppInstanceAdminsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAppInstanceAdminsIterable(ChimeSdkIdentityClient client, ListAppInstanceAdminsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAppInstanceAdminsResponseFetcher();
    }

    public Iterator<ListAppInstanceAdminsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListAppInstanceAdminsResponseFetcher
    implements SyncPageFetcher<ListAppInstanceAdminsResponse> {
        private ListAppInstanceAdminsResponseFetcher() {
        }

        public boolean hasNextPage(ListAppInstanceAdminsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAppInstanceAdminsResponse nextPage(ListAppInstanceAdminsResponse previousPage) {
            if (previousPage == null) {
                return ListAppInstanceAdminsIterable.this.client.listAppInstanceAdmins(ListAppInstanceAdminsIterable.this.firstRequest);
            }
            return ListAppInstanceAdminsIterable.this.client.listAppInstanceAdmins((ListAppInstanceAdminsRequest)((Object)ListAppInstanceAdminsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

