/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkidentity.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum StandardMessages {
    AUTO("AUTO"),
    ALL("ALL"),
    MENTIONS("MENTIONS"),
    NONE("NONE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, StandardMessages> VALUE_MAP;
    private final String value;

    private StandardMessages(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StandardMessages fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StandardMessages> knownValues() {
        EnumSet<StandardMessages> knownValues = EnumSet.allOf(StandardMessages.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(StandardMessages.class, StandardMessages::toString);
    }
}

