/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkidentity.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EndpointStatusReason {
    INVALID_DEVICE_TOKEN("INVALID_DEVICE_TOKEN"),
    INVALID_PINPOINT_ARN("INVALID_PINPOINT_ARN"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EndpointStatusReason> VALUE_MAP;
    private final String value;

    private EndpointStatusReason(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EndpointStatusReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EndpointStatusReason> knownValues() {
        EnumSet<EndpointStatusReason> knownValues = EnumSet.allOf(EndpointStatusReason.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EndpointStatusReason.class, EndpointStatusReason::toString);
    }
}

