/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.budgets.BudgetsClient;
import software.amazon.awssdk.services.budgets.BudgetsClientBuilder;
import software.amazon.awssdk.services.budgets.BudgetsServiceClientConfiguration;
import software.amazon.awssdk.services.budgets.DefaultBudgetsBaseClientBuilder;
import software.amazon.awssdk.services.budgets.DefaultBudgetsClient;
import software.amazon.awssdk.services.budgets.endpoints.BudgetsEndpointProvider;

@SdkInternalApi
final class DefaultBudgetsClientBuilder
extends DefaultBudgetsBaseClientBuilder<BudgetsClientBuilder, BudgetsClient>
implements BudgetsClientBuilder {
    DefaultBudgetsClientBuilder() {
    }

    @Override
    public DefaultBudgetsClientBuilder endpointProvider(BudgetsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final BudgetsClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultBudgetsClientBuilder.validateClientOptions(clientConfiguration);
        BudgetsServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultBudgetsClient client = new DefaultBudgetsClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private BudgetsServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return BudgetsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

