/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.braket.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.JsonValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateQuantumTaskRequest extends BraketRequest implements
        ToCopyableBuilder<CreateQuantumTaskRequest.Builder, CreateQuantumTaskRequest> {
    private static final SdkField<String> ACTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("action")
            .getter(getter(CreateQuantumTaskRequest::action))
            .setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build(),
                    JsonValueTrait.create()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateQuantumTaskRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> DEVICE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deviceArn").getter(getter(CreateQuantumTaskRequest::deviceArn)).setter(setter(Builder::deviceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceArn").build()).build();

    private static final SdkField<String> DEVICE_PARAMETERS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("deviceParameters")
            .getter(getter(CreateQuantumTaskRequest::deviceParameters))
            .setter(setter(Builder::deviceParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceParameters").build(),
                    JsonValueTrait.create()).build();

    private static final SdkField<String> JOB_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobToken").getter(getter(CreateQuantumTaskRequest::jobToken)).setter(setter(Builder::jobToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobToken").build()).build();

    private static final SdkField<String> OUTPUT_S3_BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("outputS3Bucket").getter(getter(CreateQuantumTaskRequest::outputS3Bucket))
            .setter(setter(Builder::outputS3Bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputS3Bucket").build()).build();

    private static final SdkField<String> OUTPUT_S3_KEY_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("outputS3KeyPrefix").getter(getter(CreateQuantumTaskRequest::outputS3KeyPrefix))
            .setter(setter(Builder::outputS3KeyPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputS3KeyPrefix").build()).build();

    private static final SdkField<Long> SHOTS_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("shots")
            .getter(getter(CreateQuantumTaskRequest::shots)).setter(setter(Builder::shots))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shots").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateQuantumTaskRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD,
            CLIENT_TOKEN_FIELD, DEVICE_ARN_FIELD, DEVICE_PARAMETERS_FIELD, JOB_TOKEN_FIELD, OUTPUT_S3_BUCKET_FIELD,
            OUTPUT_S3_KEY_PREFIX_FIELD, SHOTS_FIELD, TAGS_FIELD));

    private final String action;

    private final String clientToken;

    private final String deviceArn;

    private final String deviceParameters;

    private final String jobToken;

    private final String outputS3Bucket;

    private final String outputS3KeyPrefix;

    private final Long shots;

    private final Map<String, String> tags;

    private CreateQuantumTaskRequest(BuilderImpl builder) {
        super(builder);
        this.action = builder.action;
        this.clientToken = builder.clientToken;
        this.deviceArn = builder.deviceArn;
        this.deviceParameters = builder.deviceParameters;
        this.jobToken = builder.jobToken;
        this.outputS3Bucket = builder.outputS3Bucket;
        this.outputS3KeyPrefix = builder.outputS3KeyPrefix;
        this.shots = builder.shots;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The action associated with the task.
     * </p>
     * 
     * @return The action associated with the task.
     */
    public final String action() {
        return action;
    }

    /**
     * <p>
     * The client token associated with the request.
     * </p>
     * 
     * @return The client token associated with the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The ARN of the device to run the task on.
     * </p>
     * 
     * @return The ARN of the device to run the task on.
     */
    public final String deviceArn() {
        return deviceArn;
    }

    /**
     * <p>
     * The parameters for the device to run the task on.
     * </p>
     * 
     * @return The parameters for the device to run the task on.
     */
    public final String deviceParameters() {
        return deviceParameters;
    }

    /**
     * <p>
     * The token for an Amazon Braket job that associates it with the quantum task.
     * </p>
     * 
     * @return The token for an Amazon Braket job that associates it with the quantum task.
     */
    public final String jobToken() {
        return jobToken;
    }

    /**
     * <p>
     * The S3 bucket to store task result files in.
     * </p>
     * 
     * @return The S3 bucket to store task result files in.
     */
    public final String outputS3Bucket() {
        return outputS3Bucket;
    }

    /**
     * <p>
     * The key prefix for the location in the S3 bucket to store task results in.
     * </p>
     * 
     * @return The key prefix for the location in the S3 bucket to store task results in.
     */
    public final String outputS3KeyPrefix() {
        return outputS3KeyPrefix;
    }

    /**
     * <p>
     * The number of shots to use for the task.
     * </p>
     * 
     * @return The number of shots to use for the task.
     */
    public final Long shots() {
        return shots;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags to be added to the quantum task you're creating.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags to be added to the quantum task you're creating.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(action());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(deviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(deviceParameters());
        hashCode = 31 * hashCode + Objects.hashCode(jobToken());
        hashCode = 31 * hashCode + Objects.hashCode(outputS3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(outputS3KeyPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(shots());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateQuantumTaskRequest)) {
            return false;
        }
        CreateQuantumTaskRequest other = (CreateQuantumTaskRequest) obj;
        return Objects.equals(action(), other.action()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(deviceArn(), other.deviceArn()) && Objects.equals(deviceParameters(), other.deviceParameters())
                && Objects.equals(jobToken(), other.jobToken()) && Objects.equals(outputS3Bucket(), other.outputS3Bucket())
                && Objects.equals(outputS3KeyPrefix(), other.outputS3KeyPrefix()) && Objects.equals(shots(), other.shots())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateQuantumTaskRequest").add("Action", action()).add("ClientToken", clientToken())
                .add("DeviceArn", deviceArn()).add("DeviceParameters", deviceParameters()).add("JobToken", jobToken())
                .add("OutputS3Bucket", outputS3Bucket()).add("OutputS3KeyPrefix", outputS3KeyPrefix()).add("Shots", shots())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "action":
            return Optional.ofNullable(clazz.cast(action()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "deviceArn":
            return Optional.ofNullable(clazz.cast(deviceArn()));
        case "deviceParameters":
            return Optional.ofNullable(clazz.cast(deviceParameters()));
        case "jobToken":
            return Optional.ofNullable(clazz.cast(jobToken()));
        case "outputS3Bucket":
            return Optional.ofNullable(clazz.cast(outputS3Bucket()));
        case "outputS3KeyPrefix":
            return Optional.ofNullable(clazz.cast(outputS3KeyPrefix()));
        case "shots":
            return Optional.ofNullable(clazz.cast(shots()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateQuantumTaskRequest, T> g) {
        return obj -> g.apply((CreateQuantumTaskRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BraketRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateQuantumTaskRequest> {
        /**
         * <p>
         * The action associated with the task.
         * </p>
         * 
         * @param action
         *        The action associated with the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(String action);

        /**
         * <p>
         * The client token associated with the request.
         * </p>
         * 
         * @param clientToken
         *        The client token associated with the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The ARN of the device to run the task on.
         * </p>
         * 
         * @param deviceArn
         *        The ARN of the device to run the task on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceArn(String deviceArn);

        /**
         * <p>
         * The parameters for the device to run the task on.
         * </p>
         * 
         * @param deviceParameters
         *        The parameters for the device to run the task on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceParameters(String deviceParameters);

        /**
         * <p>
         * The token for an Amazon Braket job that associates it with the quantum task.
         * </p>
         * 
         * @param jobToken
         *        The token for an Amazon Braket job that associates it with the quantum task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobToken(String jobToken);

        /**
         * <p>
         * The S3 bucket to store task result files in.
         * </p>
         * 
         * @param outputS3Bucket
         *        The S3 bucket to store task result files in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputS3Bucket(String outputS3Bucket);

        /**
         * <p>
         * The key prefix for the location in the S3 bucket to store task results in.
         * </p>
         * 
         * @param outputS3KeyPrefix
         *        The key prefix for the location in the S3 bucket to store task results in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputS3KeyPrefix(String outputS3KeyPrefix);

        /**
         * <p>
         * The number of shots to use for the task.
         * </p>
         * 
         * @param shots
         *        The number of shots to use for the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shots(Long shots);

        /**
         * <p>
         * Tags to be added to the quantum task you're creating.
         * </p>
         * 
         * @param tags
         *        Tags to be added to the quantum task you're creating.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BraketRequest.BuilderImpl implements Builder {
        private String action;

        private String clientToken;

        private String deviceArn;

        private String deviceParameters;

        private String jobToken;

        private String outputS3Bucket;

        private String outputS3KeyPrefix;

        private Long shots;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateQuantumTaskRequest model) {
            super(model);
            action(model.action);
            clientToken(model.clientToken);
            deviceArn(model.deviceArn);
            deviceParameters(model.deviceParameters);
            jobToken(model.jobToken);
            outputS3Bucket(model.outputS3Bucket);
            outputS3KeyPrefix(model.outputS3KeyPrefix);
            shots(model.shots);
            tags(model.tags);
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDeviceArn() {
            return deviceArn;
        }

        public final void setDeviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
        }

        @Override
        public final Builder deviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
            return this;
        }

        public final String getDeviceParameters() {
            return deviceParameters;
        }

        public final void setDeviceParameters(String deviceParameters) {
            this.deviceParameters = deviceParameters;
        }

        @Override
        public final Builder deviceParameters(String deviceParameters) {
            this.deviceParameters = deviceParameters;
            return this;
        }

        public final String getJobToken() {
            return jobToken;
        }

        public final void setJobToken(String jobToken) {
            this.jobToken = jobToken;
        }

        @Override
        public final Builder jobToken(String jobToken) {
            this.jobToken = jobToken;
            return this;
        }

        public final String getOutputS3Bucket() {
            return outputS3Bucket;
        }

        public final void setOutputS3Bucket(String outputS3Bucket) {
            this.outputS3Bucket = outputS3Bucket;
        }

        @Override
        public final Builder outputS3Bucket(String outputS3Bucket) {
            this.outputS3Bucket = outputS3Bucket;
            return this;
        }

        public final String getOutputS3KeyPrefix() {
            return outputS3KeyPrefix;
        }

        public final void setOutputS3KeyPrefix(String outputS3KeyPrefix) {
            this.outputS3KeyPrefix = outputS3KeyPrefix;
        }

        @Override
        public final Builder outputS3KeyPrefix(String outputS3KeyPrefix) {
            this.outputS3KeyPrefix = outputS3KeyPrefix;
            return this;
        }

        public final Long getShots() {
            return shots;
        }

        public final void setShots(Long shots) {
            this.shots = shots;
        }

        @Override
        public final Builder shots(Long shots) {
            this.shots = shots;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateQuantumTaskRequest build() {
            return new CreateQuantumTaskRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
