/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billingconductor;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.billingconductor.BillingconductorClient;
import software.amazon.awssdk.services.billingconductor.BillingconductorClientBuilder;
import software.amazon.awssdk.services.billingconductor.BillingconductorServiceClientConfiguration;
import software.amazon.awssdk.services.billingconductor.DefaultBillingconductorBaseClientBuilder;
import software.amazon.awssdk.services.billingconductor.DefaultBillingconductorClient;
import software.amazon.awssdk.services.billingconductor.endpoints.BillingconductorEndpointProvider;

@SdkInternalApi
final class DefaultBillingconductorClientBuilder
extends DefaultBillingconductorBaseClientBuilder<BillingconductorClientBuilder, BillingconductorClient>
implements BillingconductorClientBuilder {
    DefaultBillingconductorClientBuilder() {
    }

    @Override
    public DefaultBillingconductorClientBuilder endpointProvider(BillingconductorEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final BillingconductorClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultBillingconductorClientBuilder.validateClientOptions(clientConfiguration);
        BillingconductorServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultBillingconductorClient client = new DefaultBillingconductorClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private BillingconductorServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return BillingconductorServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

