/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.billingconductor;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.billingconductor.model.AccessDeniedException;
import software.amazon.awssdk.services.billingconductor.model.AssociateAccountsRequest;
import software.amazon.awssdk.services.billingconductor.model.AssociateAccountsResponse;
import software.amazon.awssdk.services.billingconductor.model.AssociatePricingRulesRequest;
import software.amazon.awssdk.services.billingconductor.model.AssociatePricingRulesResponse;
import software.amazon.awssdk.services.billingconductor.model.BatchAssociateResourcesToCustomLineItemRequest;
import software.amazon.awssdk.services.billingconductor.model.BatchAssociateResourcesToCustomLineItemResponse;
import software.amazon.awssdk.services.billingconductor.model.BatchDisassociateResourcesFromCustomLineItemRequest;
import software.amazon.awssdk.services.billingconductor.model.BatchDisassociateResourcesFromCustomLineItemResponse;
import software.amazon.awssdk.services.billingconductor.model.BillingconductorException;
import software.amazon.awssdk.services.billingconductor.model.ConflictException;
import software.amazon.awssdk.services.billingconductor.model.CreateBillingGroupRequest;
import software.amazon.awssdk.services.billingconductor.model.CreateBillingGroupResponse;
import software.amazon.awssdk.services.billingconductor.model.CreateCustomLineItemRequest;
import software.amazon.awssdk.services.billingconductor.model.CreateCustomLineItemResponse;
import software.amazon.awssdk.services.billingconductor.model.CreatePricingPlanRequest;
import software.amazon.awssdk.services.billingconductor.model.CreatePricingPlanResponse;
import software.amazon.awssdk.services.billingconductor.model.CreatePricingRuleRequest;
import software.amazon.awssdk.services.billingconductor.model.CreatePricingRuleResponse;
import software.amazon.awssdk.services.billingconductor.model.DeleteBillingGroupRequest;
import software.amazon.awssdk.services.billingconductor.model.DeleteBillingGroupResponse;
import software.amazon.awssdk.services.billingconductor.model.DeleteCustomLineItemRequest;
import software.amazon.awssdk.services.billingconductor.model.DeleteCustomLineItemResponse;
import software.amazon.awssdk.services.billingconductor.model.DeletePricingPlanRequest;
import software.amazon.awssdk.services.billingconductor.model.DeletePricingPlanResponse;
import software.amazon.awssdk.services.billingconductor.model.DeletePricingRuleRequest;
import software.amazon.awssdk.services.billingconductor.model.DeletePricingRuleResponse;
import software.amazon.awssdk.services.billingconductor.model.DisassociateAccountsRequest;
import software.amazon.awssdk.services.billingconductor.model.DisassociateAccountsResponse;
import software.amazon.awssdk.services.billingconductor.model.DisassociatePricingRulesRequest;
import software.amazon.awssdk.services.billingconductor.model.DisassociatePricingRulesResponse;
import software.amazon.awssdk.services.billingconductor.model.InternalServerException;
import software.amazon.awssdk.services.billingconductor.model.ListAccountAssociationsRequest;
import software.amazon.awssdk.services.billingconductor.model.ListAccountAssociationsResponse;
import software.amazon.awssdk.services.billingconductor.model.ListBillingGroupCostReportsRequest;
import software.amazon.awssdk.services.billingconductor.model.ListBillingGroupCostReportsResponse;
import software.amazon.awssdk.services.billingconductor.model.ListBillingGroupsRequest;
import software.amazon.awssdk.services.billingconductor.model.ListBillingGroupsResponse;
import software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemVersionsRequest;
import software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemVersionsResponse;
import software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemsRequest;
import software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemsResponse;
import software.amazon.awssdk.services.billingconductor.model.ListPricingPlansAssociatedWithPricingRuleRequest;
import software.amazon.awssdk.services.billingconductor.model.ListPricingPlansAssociatedWithPricingRuleResponse;
import software.amazon.awssdk.services.billingconductor.model.ListPricingPlansRequest;
import software.amazon.awssdk.services.billingconductor.model.ListPricingPlansResponse;
import software.amazon.awssdk.services.billingconductor.model.ListPricingRulesAssociatedToPricingPlanRequest;
import software.amazon.awssdk.services.billingconductor.model.ListPricingRulesAssociatedToPricingPlanResponse;
import software.amazon.awssdk.services.billingconductor.model.ListPricingRulesRequest;
import software.amazon.awssdk.services.billingconductor.model.ListPricingRulesResponse;
import software.amazon.awssdk.services.billingconductor.model.ListResourcesAssociatedToCustomLineItemRequest;
import software.amazon.awssdk.services.billingconductor.model.ListResourcesAssociatedToCustomLineItemResponse;
import software.amazon.awssdk.services.billingconductor.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.billingconductor.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.billingconductor.model.ResourceNotFoundException;
import software.amazon.awssdk.services.billingconductor.model.ServiceLimitExceededException;
import software.amazon.awssdk.services.billingconductor.model.TagResourceRequest;
import software.amazon.awssdk.services.billingconductor.model.TagResourceResponse;
import software.amazon.awssdk.services.billingconductor.model.ThrottlingException;
import software.amazon.awssdk.services.billingconductor.model.UntagResourceRequest;
import software.amazon.awssdk.services.billingconductor.model.UntagResourceResponse;
import software.amazon.awssdk.services.billingconductor.model.UpdateBillingGroupRequest;
import software.amazon.awssdk.services.billingconductor.model.UpdateBillingGroupResponse;
import software.amazon.awssdk.services.billingconductor.model.UpdateCustomLineItemRequest;
import software.amazon.awssdk.services.billingconductor.model.UpdateCustomLineItemResponse;
import software.amazon.awssdk.services.billingconductor.model.UpdatePricingPlanRequest;
import software.amazon.awssdk.services.billingconductor.model.UpdatePricingPlanResponse;
import software.amazon.awssdk.services.billingconductor.model.UpdatePricingRuleRequest;
import software.amazon.awssdk.services.billingconductor.model.UpdatePricingRuleResponse;
import software.amazon.awssdk.services.billingconductor.model.ValidationException;
import software.amazon.awssdk.services.billingconductor.paginators.ListAccountAssociationsIterable;
import software.amazon.awssdk.services.billingconductor.paginators.ListBillingGroupCostReportsIterable;
import software.amazon.awssdk.services.billingconductor.paginators.ListBillingGroupsIterable;
import software.amazon.awssdk.services.billingconductor.paginators.ListCustomLineItemVersionsIterable;
import software.amazon.awssdk.services.billingconductor.paginators.ListCustomLineItemsIterable;
import software.amazon.awssdk.services.billingconductor.paginators.ListPricingPlansAssociatedWithPricingRuleIterable;
import software.amazon.awssdk.services.billingconductor.paginators.ListPricingPlansIterable;
import software.amazon.awssdk.services.billingconductor.paginators.ListPricingRulesAssociatedToPricingPlanIterable;
import software.amazon.awssdk.services.billingconductor.paginators.ListPricingRulesIterable;
import software.amazon.awssdk.services.billingconductor.paginators.ListResourcesAssociatedToCustomLineItemIterable;

/**
 * Service client for accessing AWSBillingConductor. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Amazon Web Services Billing Conductor is a fully managed service that you can use to customize a <a
 * href="https://docs.aws.amazon.com/billingconductor/latest/userguide/understanding-eb.html#eb-other-definitions">pro
 * forma</a> version of your billing data each month, to accurately show or chargeback your end customers. Amazon Web
 * Services Billing Conductor doesn't change the way you're billed by Amazon Web Services each month by design. Instead,
 * it provides you with a mechanism to configure, generate, and display rates to certain customers over a given billing
 * period. You can also analyze the difference between the rates you apply to your accounting groupings relative to your
 * actual rates from Amazon Web Services. As a result of your Amazon Web Services Billing Conductor configuration, the
 * payer account can also see the custom rate applied on the billing details page of the <a
 * href="https://console.aws.amazon.com/billing">Amazon Web Services Billing console</a>, or configure a cost and usage
 * report per billing group.
 * </p>
 * <p>
 * This documentation shows how you can configure Amazon Web Services Billing Conductor using its API. For more
 * information about using the <a href="https://console.aws.amazon.com/billingconductor/">Amazon Web Services Billing
 * Conductor</a> user interface, see the <a
 * href="https://docs.aws.amazon.com/billingconductor/latest/userguide/what-is-billingconductor.html"> Amazon Web
 * Services Billing Conductor User Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface BillingconductorClient extends AwsClient {
    String SERVICE_NAME = "billingconductor";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "billingconductor";

    /**
     * <p>
     * Connects an array of account IDs in a consolidated billing family to a predefined billing group. The account IDs
     * must be a part of the consolidated billing family during the current month, and not already associated with
     * another billing group. The maximum number of accounts that can be associated in one call is 30.
     * </p>
     *
     * @param associateAccountsRequest
     * @return Result of the AssociateAccounts operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         You can cause an inconsistent state by updating or deleting a resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws ServiceLimitExceededException
     *         The request would cause a service limit to exceed.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.AssociateAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/AssociateAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateAccountsResponse associateAccounts(AssociateAccountsRequest associateAccountsRequest)
            throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException,
            ServiceLimitExceededException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, BillingconductorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Connects an array of account IDs in a consolidated billing family to a predefined billing group. The account IDs
     * must be a part of the consolidated billing family during the current month, and not already associated with
     * another billing group. The maximum number of accounts that can be associated in one call is 30.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateAccountsRequest.Builder} avoiding the need
     * to create one manually via {@link AssociateAccountsRequest#builder()}
     * </p>
     *
     * @param associateAccountsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.billingconductor.model.AssociateAccountsRequest.Builder} to create
     *        a request.
     * @return Result of the AssociateAccounts operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         You can cause an inconsistent state by updating or deleting a resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws ServiceLimitExceededException
     *         The request would cause a service limit to exceed.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.AssociateAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/AssociateAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateAccountsResponse associateAccounts(Consumer<AssociateAccountsRequest.Builder> associateAccountsRequest)
            throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException,
            ServiceLimitExceededException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, BillingconductorException {
        return associateAccounts(AssociateAccountsRequest.builder().applyMutation(associateAccountsRequest).build());
    }

    /**
     * <p>
     * Connects an array of <code>PricingRuleArns</code> to a defined <code>PricingPlan</code>. The maximum number
     * <code>PricingRuleArn</code> that can be associated in one call is 30.
     * </p>
     *
     * @param associatePricingRulesRequest
     * @return Result of the AssociatePricingRules operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         You can cause an inconsistent state by updating or deleting a resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws ServiceLimitExceededException
     *         The request would cause a service limit to exceed.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.AssociatePricingRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/AssociatePricingRules"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociatePricingRulesResponse associatePricingRules(AssociatePricingRulesRequest associatePricingRulesRequest)
            throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException,
            ServiceLimitExceededException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, BillingconductorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Connects an array of <code>PricingRuleArns</code> to a defined <code>PricingPlan</code>. The maximum number
     * <code>PricingRuleArn</code> that can be associated in one call is 30.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociatePricingRulesRequest.Builder} avoiding the
     * need to create one manually via {@link AssociatePricingRulesRequest#builder()}
     * </p>
     *
     * @param associatePricingRulesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.billingconductor.model.AssociatePricingRulesRequest.Builder} to
     *        create a request.
     * @return Result of the AssociatePricingRules operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         You can cause an inconsistent state by updating or deleting a resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws ServiceLimitExceededException
     *         The request would cause a service limit to exceed.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.AssociatePricingRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/AssociatePricingRules"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociatePricingRulesResponse associatePricingRules(
            Consumer<AssociatePricingRulesRequest.Builder> associatePricingRulesRequest) throws ThrottlingException,
            ConflictException, AccessDeniedException, ValidationException, ServiceLimitExceededException,
            InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            BillingconductorException {
        return associatePricingRules(AssociatePricingRulesRequest.builder().applyMutation(associatePricingRulesRequest).build());
    }

    /**
     * <p>
     * Associates a batch of resources to a percentage custom line item.
     * </p>
     *
     * @param batchAssociateResourcesToCustomLineItemRequest
     * @return Result of the BatchAssociateResourcesToCustomLineItem operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         You can cause an inconsistent state by updating or deleting a resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws ServiceLimitExceededException
     *         The request would cause a service limit to exceed.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.BatchAssociateResourcesToCustomLineItem
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/BatchAssociateResourcesToCustomLineItem"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchAssociateResourcesToCustomLineItemResponse batchAssociateResourcesToCustomLineItem(
            BatchAssociateResourcesToCustomLineItemRequest batchAssociateResourcesToCustomLineItemRequest)
            throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException,
            ServiceLimitExceededException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, BillingconductorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a batch of resources to a percentage custom line item.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link BatchAssociateResourcesToCustomLineItemRequest.Builder} avoiding the need to create one manually via
     * {@link BatchAssociateResourcesToCustomLineItemRequest#builder()}
     * </p>
     *
     * @param batchAssociateResourcesToCustomLineItemRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.billingconductor.model.BatchAssociateResourcesToCustomLineItemRequest.Builder}
     *        to create a request.
     * @return Result of the BatchAssociateResourcesToCustomLineItem operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         You can cause an inconsistent state by updating or deleting a resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws ServiceLimitExceededException
     *         The request would cause a service limit to exceed.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.BatchAssociateResourcesToCustomLineItem
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/BatchAssociateResourcesToCustomLineItem"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchAssociateResourcesToCustomLineItemResponse batchAssociateResourcesToCustomLineItem(
            Consumer<BatchAssociateResourcesToCustomLineItemRequest.Builder> batchAssociateResourcesToCustomLineItemRequest)
            throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException,
            ServiceLimitExceededException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, BillingconductorException {
        return batchAssociateResourcesToCustomLineItem(BatchAssociateResourcesToCustomLineItemRequest.builder()
                .applyMutation(batchAssociateResourcesToCustomLineItemRequest).build());
    }

    /**
     * <p>
     * Disassociates a batch of resources from a percentage custom line item.
     * </p>
     *
     * @param batchDisassociateResourcesFromCustomLineItemRequest
     * @return Result of the BatchDisassociateResourcesFromCustomLineItem operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         You can cause an inconsistent state by updating or deleting a resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.BatchDisassociateResourcesFromCustomLineItem
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/BatchDisassociateResourcesFromCustomLineItem"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDisassociateResourcesFromCustomLineItemResponse batchDisassociateResourcesFromCustomLineItem(
            BatchDisassociateResourcesFromCustomLineItemRequest batchDisassociateResourcesFromCustomLineItemRequest)
            throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a batch of resources from a percentage custom line item.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link BatchDisassociateResourcesFromCustomLineItemRequest.Builder} avoiding the need to create one manually via
     * {@link BatchDisassociateResourcesFromCustomLineItemRequest#builder()}
     * </p>
     *
     * @param batchDisassociateResourcesFromCustomLineItemRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.billingconductor.model.BatchDisassociateResourcesFromCustomLineItemRequest.Builder}
     *        to create a request.
     * @return Result of the BatchDisassociateResourcesFromCustomLineItem operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         You can cause an inconsistent state by updating or deleting a resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.BatchDisassociateResourcesFromCustomLineItem
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/BatchDisassociateResourcesFromCustomLineItem"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDisassociateResourcesFromCustomLineItemResponse batchDisassociateResourcesFromCustomLineItem(
            Consumer<BatchDisassociateResourcesFromCustomLineItemRequest.Builder> batchDisassociateResourcesFromCustomLineItemRequest)
            throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        return batchDisassociateResourcesFromCustomLineItem(BatchDisassociateResourcesFromCustomLineItemRequest.builder()
                .applyMutation(batchDisassociateResourcesFromCustomLineItemRequest).build());
    }

    /**
     * <p>
     * Creates a billing group that resembles a consolidated billing family that Amazon Web Services charges, based off
     * of the predefined pricing plan computation.
     * </p>
     *
     * @param createBillingGroupRequest
     * @return Result of the CreateBillingGroup operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         You can cause an inconsistent state by updating or deleting a resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws ServiceLimitExceededException
     *         The request would cause a service limit to exceed.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.CreateBillingGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/CreateBillingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateBillingGroupResponse createBillingGroup(CreateBillingGroupRequest createBillingGroupRequest)
            throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException,
            ServiceLimitExceededException, InternalServerException, AwsServiceException, SdkClientException,
            BillingconductorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a billing group that resembles a consolidated billing family that Amazon Web Services charges, based off
     * of the predefined pricing plan computation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBillingGroupRequest.Builder} avoiding the
     * need to create one manually via {@link CreateBillingGroupRequest#builder()}
     * </p>
     *
     * @param createBillingGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.billingconductor.model.CreateBillingGroupRequest.Builder} to create
     *        a request.
     * @return Result of the CreateBillingGroup operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         You can cause an inconsistent state by updating or deleting a resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws ServiceLimitExceededException
     *         The request would cause a service limit to exceed.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.CreateBillingGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/CreateBillingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateBillingGroupResponse createBillingGroup(Consumer<CreateBillingGroupRequest.Builder> createBillingGroupRequest)
            throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException,
            ServiceLimitExceededException, InternalServerException, AwsServiceException, SdkClientException,
            BillingconductorException {
        return createBillingGroup(CreateBillingGroupRequest.builder().applyMutation(createBillingGroupRequest).build());
    }

    /**
     * <p>
     * Creates a custom line item that can be used to create a one-time fixed charge that can be applied to a single
     * billing group for the current or previous billing period. The one-time fixed charge is either a fee or discount.
     * </p>
     *
     * @param createCustomLineItemRequest
     * @return Result of the CreateCustomLineItem operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         You can cause an inconsistent state by updating or deleting a resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws ServiceLimitExceededException
     *         The request would cause a service limit to exceed.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.CreateCustomLineItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/CreateCustomLineItem"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCustomLineItemResponse createCustomLineItem(CreateCustomLineItemRequest createCustomLineItemRequest)
            throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException,
            ServiceLimitExceededException, InternalServerException, AwsServiceException, SdkClientException,
            BillingconductorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a custom line item that can be used to create a one-time fixed charge that can be applied to a single
     * billing group for the current or previous billing period. The one-time fixed charge is either a fee or discount.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCustomLineItemRequest.Builder} avoiding the
     * need to create one manually via {@link CreateCustomLineItemRequest#builder()}
     * </p>
     *
     * @param createCustomLineItemRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.billingconductor.model.CreateCustomLineItemRequest.Builder} to
     *        create a request.
     * @return Result of the CreateCustomLineItem operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         You can cause an inconsistent state by updating or deleting a resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws ServiceLimitExceededException
     *         The request would cause a service limit to exceed.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.CreateCustomLineItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/CreateCustomLineItem"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCustomLineItemResponse createCustomLineItem(
            Consumer<CreateCustomLineItemRequest.Builder> createCustomLineItemRequest) throws ThrottlingException,
            ConflictException, AccessDeniedException, ValidationException, ServiceLimitExceededException,
            InternalServerException, AwsServiceException, SdkClientException, BillingconductorException {
        return createCustomLineItem(CreateCustomLineItemRequest.builder().applyMutation(createCustomLineItemRequest).build());
    }

    /**
     * <p>
     * Creates a pricing plan that is used for computing Amazon Web Services charges for billing groups.
     * </p>
     *
     * @param createPricingPlanRequest
     * @return Result of the CreatePricingPlan operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         You can cause an inconsistent state by updating or deleting a resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws ServiceLimitExceededException
     *         The request would cause a service limit to exceed.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.CreatePricingPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/CreatePricingPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default CreatePricingPlanResponse createPricingPlan(CreatePricingPlanRequest createPricingPlanRequest)
            throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException,
            ServiceLimitExceededException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, BillingconductorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a pricing plan that is used for computing Amazon Web Services charges for billing groups.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePricingPlanRequest.Builder} avoiding the need
     * to create one manually via {@link CreatePricingPlanRequest#builder()}
     * </p>
     *
     * @param createPricingPlanRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.billingconductor.model.CreatePricingPlanRequest.Builder} to create
     *        a request.
     * @return Result of the CreatePricingPlan operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         You can cause an inconsistent state by updating or deleting a resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws ServiceLimitExceededException
     *         The request would cause a service limit to exceed.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.CreatePricingPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/CreatePricingPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default CreatePricingPlanResponse createPricingPlan(Consumer<CreatePricingPlanRequest.Builder> createPricingPlanRequest)
            throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException,
            ServiceLimitExceededException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, BillingconductorException {
        return createPricingPlan(CreatePricingPlanRequest.builder().applyMutation(createPricingPlanRequest).build());
    }

    /**
     * <p>
     * Creates a pricing rule can be associated to a pricing plan, or a set of pricing plans.
     * </p>
     *
     * @param createPricingRuleRequest
     * @return Result of the CreatePricingRule operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         You can cause an inconsistent state by updating or deleting a resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws ServiceLimitExceededException
     *         The request would cause a service limit to exceed.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.CreatePricingRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/CreatePricingRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CreatePricingRuleResponse createPricingRule(CreatePricingRuleRequest createPricingRuleRequest)
            throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException,
            ServiceLimitExceededException, InternalServerException, AwsServiceException, SdkClientException,
            BillingconductorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a pricing rule can be associated to a pricing plan, or a set of pricing plans.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePricingRuleRequest.Builder} avoiding the need
     * to create one manually via {@link CreatePricingRuleRequest#builder()}
     * </p>
     *
     * @param createPricingRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.billingconductor.model.CreatePricingRuleRequest.Builder} to create
     *        a request.
     * @return Result of the CreatePricingRule operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         You can cause an inconsistent state by updating or deleting a resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws ServiceLimitExceededException
     *         The request would cause a service limit to exceed.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.CreatePricingRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/CreatePricingRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CreatePricingRuleResponse createPricingRule(Consumer<CreatePricingRuleRequest.Builder> createPricingRuleRequest)
            throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException,
            ServiceLimitExceededException, InternalServerException, AwsServiceException, SdkClientException,
            BillingconductorException {
        return createPricingRule(CreatePricingRuleRequest.builder().applyMutation(createPricingRuleRequest).build());
    }

    /**
     * <p>
     * Deletes a billing group.
     * </p>
     *
     * @param deleteBillingGroupRequest
     * @return Result of the DeleteBillingGroup operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.DeleteBillingGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/DeleteBillingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteBillingGroupResponse deleteBillingGroup(DeleteBillingGroupRequest deleteBillingGroupRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, BillingconductorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a billing group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBillingGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteBillingGroupRequest#builder()}
     * </p>
     *
     * @param deleteBillingGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.billingconductor.model.DeleteBillingGroupRequest.Builder} to create
     *        a request.
     * @return Result of the DeleteBillingGroup operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.DeleteBillingGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/DeleteBillingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteBillingGroupResponse deleteBillingGroup(Consumer<DeleteBillingGroupRequest.Builder> deleteBillingGroupRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, BillingconductorException {
        return deleteBillingGroup(DeleteBillingGroupRequest.builder().applyMutation(deleteBillingGroupRequest).build());
    }

    /**
     * <p>
     * Deletes the custom line item identified by the given ARN in the current, or previous billing period.
     * </p>
     *
     * @param deleteCustomLineItemRequest
     * @return Result of the DeleteCustomLineItem operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         You can cause an inconsistent state by updating or deleting a resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.DeleteCustomLineItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/DeleteCustomLineItem"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCustomLineItemResponse deleteCustomLineItem(DeleteCustomLineItemRequest deleteCustomLineItemRequest)
            throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, BillingconductorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the custom line item identified by the given ARN in the current, or previous billing period.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCustomLineItemRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteCustomLineItemRequest#builder()}
     * </p>
     *
     * @param deleteCustomLineItemRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.billingconductor.model.DeleteCustomLineItemRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteCustomLineItem operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         You can cause an inconsistent state by updating or deleting a resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.DeleteCustomLineItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/DeleteCustomLineItem"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCustomLineItemResponse deleteCustomLineItem(
            Consumer<DeleteCustomLineItemRequest.Builder> deleteCustomLineItemRequest) throws ThrottlingException,
            ConflictException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, BillingconductorException {
        return deleteCustomLineItem(DeleteCustomLineItemRequest.builder().applyMutation(deleteCustomLineItemRequest).build());
    }

    /**
     * <p>
     * Deletes a pricing plan. The pricing plan must not be associated with any billing groups to delete successfully.
     * </p>
     *
     * @param deletePricingPlanRequest
     * @return Result of the DeletePricingPlan operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         You can cause an inconsistent state by updating or deleting a resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.DeletePricingPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/DeletePricingPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default DeletePricingPlanResponse deletePricingPlan(DeletePricingPlanRequest deletePricingPlanRequest)
            throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, BillingconductorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a pricing plan. The pricing plan must not be associated with any billing groups to delete successfully.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePricingPlanRequest.Builder} avoiding the need
     * to create one manually via {@link DeletePricingPlanRequest#builder()}
     * </p>
     *
     * @param deletePricingPlanRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.billingconductor.model.DeletePricingPlanRequest.Builder} to create
     *        a request.
     * @return Result of the DeletePricingPlan operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         You can cause an inconsistent state by updating or deleting a resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.DeletePricingPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/DeletePricingPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default DeletePricingPlanResponse deletePricingPlan(Consumer<DeletePricingPlanRequest.Builder> deletePricingPlanRequest)
            throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, BillingconductorException {
        return deletePricingPlan(DeletePricingPlanRequest.builder().applyMutation(deletePricingPlanRequest).build());
    }

    /**
     * <p>
     * Deletes the pricing rule that's identified by the input Amazon Resource Name (ARN).
     * </p>
     *
     * @param deletePricingRuleRequest
     * @return Result of the DeletePricingRule operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         You can cause an inconsistent state by updating or deleting a resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.DeletePricingRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/DeletePricingRule"
     *      target="_top">AWS API Documentation</a>
     */
    default DeletePricingRuleResponse deletePricingRule(DeletePricingRuleRequest deletePricingRuleRequest)
            throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, BillingconductorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the pricing rule that's identified by the input Amazon Resource Name (ARN).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePricingRuleRequest.Builder} avoiding the need
     * to create one manually via {@link DeletePricingRuleRequest#builder()}
     * </p>
     *
     * @param deletePricingRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.billingconductor.model.DeletePricingRuleRequest.Builder} to create
     *        a request.
     * @return Result of the DeletePricingRule operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         You can cause an inconsistent state by updating or deleting a resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.DeletePricingRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/DeletePricingRule"
     *      target="_top">AWS API Documentation</a>
     */
    default DeletePricingRuleResponse deletePricingRule(Consumer<DeletePricingRuleRequest.Builder> deletePricingRuleRequest)
            throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, BillingconductorException {
        return deletePricingRule(DeletePricingRuleRequest.builder().applyMutation(deletePricingRuleRequest).build());
    }

    /**
     * <p>
     * Removes the specified list of account IDs from the given billing group.
     * </p>
     *
     * @param disassociateAccountsRequest
     * @return Result of the DisassociateAccounts operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         You can cause an inconsistent state by updating or deleting a resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.DisassociateAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/DisassociateAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateAccountsResponse disassociateAccounts(DisassociateAccountsRequest disassociateAccountsRequest)
            throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified list of account IDs from the given billing group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateAccountsRequest.Builder} avoiding the
     * need to create one manually via {@link DisassociateAccountsRequest#builder()}
     * </p>
     *
     * @param disassociateAccountsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.billingconductor.model.DisassociateAccountsRequest.Builder} to
     *        create a request.
     * @return Result of the DisassociateAccounts operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         You can cause an inconsistent state by updating or deleting a resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.DisassociateAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/DisassociateAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateAccountsResponse disassociateAccounts(
            Consumer<DisassociateAccountsRequest.Builder> disassociateAccountsRequest) throws ThrottlingException,
            ConflictException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, BillingconductorException {
        return disassociateAccounts(DisassociateAccountsRequest.builder().applyMutation(disassociateAccountsRequest).build());
    }

    /**
     * <p>
     * Disassociates a list of pricing rules from a pricing plan.
     * </p>
     *
     * @param disassociatePricingRulesRequest
     * @return Result of the DisassociatePricingRules operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         You can cause an inconsistent state by updating or deleting a resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.DisassociatePricingRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/DisassociatePricingRules"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociatePricingRulesResponse disassociatePricingRules(
            DisassociatePricingRulesRequest disassociatePricingRulesRequest) throws ThrottlingException, ConflictException,
            AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, BillingconductorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a list of pricing rules from a pricing plan.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociatePricingRulesRequest.Builder} avoiding
     * the need to create one manually via {@link DisassociatePricingRulesRequest#builder()}
     * </p>
     *
     * @param disassociatePricingRulesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.billingconductor.model.DisassociatePricingRulesRequest.Builder} to
     *        create a request.
     * @return Result of the DisassociatePricingRules operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         You can cause an inconsistent state by updating or deleting a resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.DisassociatePricingRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/DisassociatePricingRules"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociatePricingRulesResponse disassociatePricingRules(
            Consumer<DisassociatePricingRulesRequest.Builder> disassociatePricingRulesRequest) throws ThrottlingException,
            ConflictException, AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, BillingconductorException {
        return disassociatePricingRules(DisassociatePricingRulesRequest.builder().applyMutation(disassociatePricingRulesRequest)
                .build());
    }

    /**
     * <p>
     * This is a paginated call to list linked accounts that are linked to the payer account for the specified time
     * period. If no information is provided, the current billing period is used. The response will optionally include
     * the billing group that's associated with the linked account.
     * </p>
     *
     * @param listAccountAssociationsRequest
     * @return Result of the ListAccountAssociations operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.ListAccountAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListAccountAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccountAssociationsResponse listAccountAssociations(ListAccountAssociationsRequest listAccountAssociationsRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This is a paginated call to list linked accounts that are linked to the payer account for the specified time
     * period. If no information is provided, the current billing period is used. The response will optionally include
     * the billing group that's associated with the linked account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccountAssociationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListAccountAssociationsRequest#builder()}
     * </p>
     *
     * @param listAccountAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.billingconductor.model.ListAccountAssociationsRequest.Builder} to
     *        create a request.
     * @return Result of the ListAccountAssociations operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.ListAccountAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListAccountAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccountAssociationsResponse listAccountAssociations(
            Consumer<ListAccountAssociationsRequest.Builder> listAccountAssociationsRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, BillingconductorException {
        return listAccountAssociations(ListAccountAssociationsRequest.builder().applyMutation(listAccountAssociationsRequest)
                .build());
    }

    /**
     * <p>
     * This is a paginated call to list linked accounts that are linked to the payer account for the specified time
     * period. If no information is provided, the current billing period is used. The response will optionally include
     * the billing group that's associated with the linked account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAccountAssociations(software.amazon.awssdk.services.billingconductor.model.ListAccountAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListAccountAssociationsIterable responses = client.listAccountAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.billingconductor.paginators.ListAccountAssociationsIterable responses = client
     *             .listAccountAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.billingconductor.model.ListAccountAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListAccountAssociationsIterable responses = client.listAccountAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccountAssociations(software.amazon.awssdk.services.billingconductor.model.ListAccountAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAccountAssociationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.ListAccountAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListAccountAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccountAssociationsIterable listAccountAssociationsPaginator(
            ListAccountAssociationsRequest listAccountAssociationsRequest) throws ThrottlingException, AccessDeniedException,
            ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            BillingconductorException {
        return new ListAccountAssociationsIterable(this, listAccountAssociationsRequest);
    }

    /**
     * <p>
     * This is a paginated call to list linked accounts that are linked to the payer account for the specified time
     * period. If no information is provided, the current billing period is used. The response will optionally include
     * the billing group that's associated with the linked account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAccountAssociations(software.amazon.awssdk.services.billingconductor.model.ListAccountAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListAccountAssociationsIterable responses = client.listAccountAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.billingconductor.paginators.ListAccountAssociationsIterable responses = client
     *             .listAccountAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.billingconductor.model.ListAccountAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListAccountAssociationsIterable responses = client.listAccountAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccountAssociations(software.amazon.awssdk.services.billingconductor.model.ListAccountAssociationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccountAssociationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListAccountAssociationsRequest#builder()}
     * </p>
     *
     * @param listAccountAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.billingconductor.model.ListAccountAssociationsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.ListAccountAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListAccountAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccountAssociationsIterable listAccountAssociationsPaginator(
            Consumer<ListAccountAssociationsRequest.Builder> listAccountAssociationsRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, BillingconductorException {
        return listAccountAssociationsPaginator(ListAccountAssociationsRequest.builder()
                .applyMutation(listAccountAssociationsRequest).build());
    }

    /**
     * <p>
     * A paginated call to retrieve a summary report of actual Amazon Web Services charges and the calculated Amazon Web
     * Services charges based on the associated pricing plan of a billing group.
     * </p>
     *
     * @param listBillingGroupCostReportsRequest
     * @return Result of the ListBillingGroupCostReports operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.ListBillingGroupCostReports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListBillingGroupCostReports"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBillingGroupCostReportsResponse listBillingGroupCostReports(
            ListBillingGroupCostReportsRequest listBillingGroupCostReportsRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, BillingconductorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A paginated call to retrieve a summary report of actual Amazon Web Services charges and the calculated Amazon Web
     * Services charges based on the associated pricing plan of a billing group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBillingGroupCostReportsRequest.Builder}
     * avoiding the need to create one manually via {@link ListBillingGroupCostReportsRequest#builder()}
     * </p>
     *
     * @param listBillingGroupCostReportsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.billingconductor.model.ListBillingGroupCostReportsRequest.Builder}
     *        to create a request.
     * @return Result of the ListBillingGroupCostReports operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.ListBillingGroupCostReports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListBillingGroupCostReports"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBillingGroupCostReportsResponse listBillingGroupCostReports(
            Consumer<ListBillingGroupCostReportsRequest.Builder> listBillingGroupCostReportsRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, BillingconductorException {
        return listBillingGroupCostReports(ListBillingGroupCostReportsRequest.builder()
                .applyMutation(listBillingGroupCostReportsRequest).build());
    }

    /**
     * <p>
     * A paginated call to retrieve a summary report of actual Amazon Web Services charges and the calculated Amazon Web
     * Services charges based on the associated pricing plan of a billing group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBillingGroupCostReports(software.amazon.awssdk.services.billingconductor.model.ListBillingGroupCostReportsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListBillingGroupCostReportsIterable responses = client.listBillingGroupCostReportsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.billingconductor.paginators.ListBillingGroupCostReportsIterable responses = client
     *             .listBillingGroupCostReportsPaginator(request);
     *     for (software.amazon.awssdk.services.billingconductor.model.ListBillingGroupCostReportsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListBillingGroupCostReportsIterable responses = client.listBillingGroupCostReportsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBillingGroupCostReports(software.amazon.awssdk.services.billingconductor.model.ListBillingGroupCostReportsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBillingGroupCostReportsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.ListBillingGroupCostReports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListBillingGroupCostReports"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBillingGroupCostReportsIterable listBillingGroupCostReportsPaginator(
            ListBillingGroupCostReportsRequest listBillingGroupCostReportsRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, BillingconductorException {
        return new ListBillingGroupCostReportsIterable(this, listBillingGroupCostReportsRequest);
    }

    /**
     * <p>
     * A paginated call to retrieve a summary report of actual Amazon Web Services charges and the calculated Amazon Web
     * Services charges based on the associated pricing plan of a billing group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBillingGroupCostReports(software.amazon.awssdk.services.billingconductor.model.ListBillingGroupCostReportsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListBillingGroupCostReportsIterable responses = client.listBillingGroupCostReportsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.billingconductor.paginators.ListBillingGroupCostReportsIterable responses = client
     *             .listBillingGroupCostReportsPaginator(request);
     *     for (software.amazon.awssdk.services.billingconductor.model.ListBillingGroupCostReportsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListBillingGroupCostReportsIterable responses = client.listBillingGroupCostReportsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBillingGroupCostReports(software.amazon.awssdk.services.billingconductor.model.ListBillingGroupCostReportsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBillingGroupCostReportsRequest.Builder}
     * avoiding the need to create one manually via {@link ListBillingGroupCostReportsRequest#builder()}
     * </p>
     *
     * @param listBillingGroupCostReportsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.billingconductor.model.ListBillingGroupCostReportsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.ListBillingGroupCostReports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListBillingGroupCostReports"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBillingGroupCostReportsIterable listBillingGroupCostReportsPaginator(
            Consumer<ListBillingGroupCostReportsRequest.Builder> listBillingGroupCostReportsRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, BillingconductorException {
        return listBillingGroupCostReportsPaginator(ListBillingGroupCostReportsRequest.builder()
                .applyMutation(listBillingGroupCostReportsRequest).build());
    }

    /**
     * <p>
     * A paginated call to retrieve a list of billing groups for the given billing period. If you don't provide a
     * billing group, the current billing period is used.
     * </p>
     *
     * @param listBillingGroupsRequest
     * @return Result of the ListBillingGroups operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.ListBillingGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListBillingGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBillingGroupsResponse listBillingGroups(ListBillingGroupsRequest listBillingGroupsRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A paginated call to retrieve a list of billing groups for the given billing period. If you don't provide a
     * billing group, the current billing period is used.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBillingGroupsRequest.Builder} avoiding the need
     * to create one manually via {@link ListBillingGroupsRequest#builder()}
     * </p>
     *
     * @param listBillingGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.billingconductor.model.ListBillingGroupsRequest.Builder} to create
     *        a request.
     * @return Result of the ListBillingGroups operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.ListBillingGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListBillingGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBillingGroupsResponse listBillingGroups(Consumer<ListBillingGroupsRequest.Builder> listBillingGroupsRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        return listBillingGroups(ListBillingGroupsRequest.builder().applyMutation(listBillingGroupsRequest).build());
    }

    /**
     * <p>
     * A paginated call to retrieve a list of billing groups for the given billing period. If you don't provide a
     * billing group, the current billing period is used.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBillingGroups(software.amazon.awssdk.services.billingconductor.model.ListBillingGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListBillingGroupsIterable responses = client.listBillingGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.billingconductor.paginators.ListBillingGroupsIterable responses = client
     *             .listBillingGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.billingconductor.model.ListBillingGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListBillingGroupsIterable responses = client.listBillingGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBillingGroups(software.amazon.awssdk.services.billingconductor.model.ListBillingGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBillingGroupsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.ListBillingGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListBillingGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBillingGroupsIterable listBillingGroupsPaginator(ListBillingGroupsRequest listBillingGroupsRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        return new ListBillingGroupsIterable(this, listBillingGroupsRequest);
    }

    /**
     * <p>
     * A paginated call to retrieve a list of billing groups for the given billing period. If you don't provide a
     * billing group, the current billing period is used.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBillingGroups(software.amazon.awssdk.services.billingconductor.model.ListBillingGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListBillingGroupsIterable responses = client.listBillingGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.billingconductor.paginators.ListBillingGroupsIterable responses = client
     *             .listBillingGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.billingconductor.model.ListBillingGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListBillingGroupsIterable responses = client.listBillingGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBillingGroups(software.amazon.awssdk.services.billingconductor.model.ListBillingGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBillingGroupsRequest.Builder} avoiding the need
     * to create one manually via {@link ListBillingGroupsRequest#builder()}
     * </p>
     *
     * @param listBillingGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.billingconductor.model.ListBillingGroupsRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.ListBillingGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListBillingGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBillingGroupsIterable listBillingGroupsPaginator(
            Consumer<ListBillingGroupsRequest.Builder> listBillingGroupsRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, BillingconductorException {
        return listBillingGroupsPaginator(ListBillingGroupsRequest.builder().applyMutation(listBillingGroupsRequest).build());
    }

    /**
     * <p>
     * A paginated call to get a list of all custom line item versions.
     * </p>
     *
     * @param listCustomLineItemVersionsRequest
     * @return Result of the ListCustomLineItemVersions operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.ListCustomLineItemVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListCustomLineItemVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomLineItemVersionsResponse listCustomLineItemVersions(
            ListCustomLineItemVersionsRequest listCustomLineItemVersionsRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            BillingconductorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A paginated call to get a list of all custom line item versions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCustomLineItemVersionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListCustomLineItemVersionsRequest#builder()}
     * </p>
     *
     * @param listCustomLineItemVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemVersionsRequest.Builder}
     *        to create a request.
     * @return Result of the ListCustomLineItemVersions operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.ListCustomLineItemVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListCustomLineItemVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomLineItemVersionsResponse listCustomLineItemVersions(
            Consumer<ListCustomLineItemVersionsRequest.Builder> listCustomLineItemVersionsRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            BillingconductorException {
        return listCustomLineItemVersions(ListCustomLineItemVersionsRequest.builder()
                .applyMutation(listCustomLineItemVersionsRequest).build());
    }

    /**
     * <p>
     * A paginated call to get a list of all custom line item versions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCustomLineItemVersions(software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListCustomLineItemVersionsIterable responses = client.listCustomLineItemVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.billingconductor.paginators.ListCustomLineItemVersionsIterable responses = client
     *             .listCustomLineItemVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListCustomLineItemVersionsIterable responses = client.listCustomLineItemVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCustomLineItemVersions(software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCustomLineItemVersionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.ListCustomLineItemVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListCustomLineItemVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomLineItemVersionsIterable listCustomLineItemVersionsPaginator(
            ListCustomLineItemVersionsRequest listCustomLineItemVersionsRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            BillingconductorException {
        return new ListCustomLineItemVersionsIterable(this, listCustomLineItemVersionsRequest);
    }

    /**
     * <p>
     * A paginated call to get a list of all custom line item versions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCustomLineItemVersions(software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListCustomLineItemVersionsIterable responses = client.listCustomLineItemVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.billingconductor.paginators.ListCustomLineItemVersionsIterable responses = client
     *             .listCustomLineItemVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListCustomLineItemVersionsIterable responses = client.listCustomLineItemVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCustomLineItemVersions(software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemVersionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCustomLineItemVersionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListCustomLineItemVersionsRequest#builder()}
     * </p>
     *
     * @param listCustomLineItemVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemVersionsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.ListCustomLineItemVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListCustomLineItemVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomLineItemVersionsIterable listCustomLineItemVersionsPaginator(
            Consumer<ListCustomLineItemVersionsRequest.Builder> listCustomLineItemVersionsRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            BillingconductorException {
        return listCustomLineItemVersionsPaginator(ListCustomLineItemVersionsRequest.builder()
                .applyMutation(listCustomLineItemVersionsRequest).build());
    }

    /**
     * <p>
     * A paginated call to get a list of all custom line items (FFLIs) for the given billing period. If you don't
     * provide a billing period, the current billing period is used.
     * </p>
     *
     * @param listCustomLineItemsRequest
     * @return Result of the ListCustomLineItems operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.ListCustomLineItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListCustomLineItems"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomLineItemsResponse listCustomLineItems(ListCustomLineItemsRequest listCustomLineItemsRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A paginated call to get a list of all custom line items (FFLIs) for the given billing period. If you don't
     * provide a billing period, the current billing period is used.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCustomLineItemsRequest.Builder} avoiding the
     * need to create one manually via {@link ListCustomLineItemsRequest#builder()}
     * </p>
     *
     * @param listCustomLineItemsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemsRequest.Builder} to
     *        create a request.
     * @return Result of the ListCustomLineItems operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.ListCustomLineItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListCustomLineItems"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomLineItemsResponse listCustomLineItems(
            Consumer<ListCustomLineItemsRequest.Builder> listCustomLineItemsRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, BillingconductorException {
        return listCustomLineItems(ListCustomLineItemsRequest.builder().applyMutation(listCustomLineItemsRequest).build());
    }

    /**
     * <p>
     * A paginated call to get a list of all custom line items (FFLIs) for the given billing period. If you don't
     * provide a billing period, the current billing period is used.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCustomLineItems(software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListCustomLineItemsIterable responses = client.listCustomLineItemsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.billingconductor.paginators.ListCustomLineItemsIterable responses = client
     *             .listCustomLineItemsPaginator(request);
     *     for (software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListCustomLineItemsIterable responses = client.listCustomLineItemsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCustomLineItems(software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCustomLineItemsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.ListCustomLineItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListCustomLineItems"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomLineItemsIterable listCustomLineItemsPaginator(ListCustomLineItemsRequest listCustomLineItemsRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        return new ListCustomLineItemsIterable(this, listCustomLineItemsRequest);
    }

    /**
     * <p>
     * A paginated call to get a list of all custom line items (FFLIs) for the given billing period. If you don't
     * provide a billing period, the current billing period is used.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCustomLineItems(software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListCustomLineItemsIterable responses = client.listCustomLineItemsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.billingconductor.paginators.ListCustomLineItemsIterable responses = client
     *             .listCustomLineItemsPaginator(request);
     *     for (software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListCustomLineItemsIterable responses = client.listCustomLineItemsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCustomLineItems(software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCustomLineItemsRequest.Builder} avoiding the
     * need to create one manually via {@link ListCustomLineItemsRequest#builder()}
     * </p>
     *
     * @param listCustomLineItemsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.ListCustomLineItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListCustomLineItems"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCustomLineItemsIterable listCustomLineItemsPaginator(
            Consumer<ListCustomLineItemsRequest.Builder> listCustomLineItemsRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, BillingconductorException {
        return listCustomLineItemsPaginator(ListCustomLineItemsRequest.builder().applyMutation(listCustomLineItemsRequest)
                .build());
    }

    /**
     * <p>
     * A paginated call to get pricing plans for the given billing period. If you don't provide a billing period, the
     * current billing period is used.
     * </p>
     *
     * @param listPricingPlansRequest
     * @return Result of the ListPricingPlans operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.ListPricingPlans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListPricingPlans"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPricingPlansResponse listPricingPlans(ListPricingPlansRequest listPricingPlansRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, BillingconductorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A paginated call to get pricing plans for the given billing period. If you don't provide a billing period, the
     * current billing period is used.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPricingPlansRequest.Builder} avoiding the need
     * to create one manually via {@link ListPricingPlansRequest#builder()}
     * </p>
     *
     * @param listPricingPlansRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.billingconductor.model.ListPricingPlansRequest.Builder} to create a
     *        request.
     * @return Result of the ListPricingPlans operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.ListPricingPlans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListPricingPlans"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPricingPlansResponse listPricingPlans(Consumer<ListPricingPlansRequest.Builder> listPricingPlansRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, BillingconductorException {
        return listPricingPlans(ListPricingPlansRequest.builder().applyMutation(listPricingPlansRequest).build());
    }

    /**
     * <p>
     * A paginated call to get pricing plans for the given billing period. If you don't provide a billing period, the
     * current billing period is used.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPricingPlans(software.amazon.awssdk.services.billingconductor.model.ListPricingPlansRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListPricingPlansIterable responses = client.listPricingPlansPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.billingconductor.paginators.ListPricingPlansIterable responses = client
     *             .listPricingPlansPaginator(request);
     *     for (software.amazon.awssdk.services.billingconductor.model.ListPricingPlansResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListPricingPlansIterable responses = client.listPricingPlansPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPricingPlans(software.amazon.awssdk.services.billingconductor.model.ListPricingPlansRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPricingPlansRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.ListPricingPlans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListPricingPlans"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPricingPlansIterable listPricingPlansPaginator(ListPricingPlansRequest listPricingPlansRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, BillingconductorException {
        return new ListPricingPlansIterable(this, listPricingPlansRequest);
    }

    /**
     * <p>
     * A paginated call to get pricing plans for the given billing period. If you don't provide a billing period, the
     * current billing period is used.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPricingPlans(software.amazon.awssdk.services.billingconductor.model.ListPricingPlansRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListPricingPlansIterable responses = client.listPricingPlansPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.billingconductor.paginators.ListPricingPlansIterable responses = client
     *             .listPricingPlansPaginator(request);
     *     for (software.amazon.awssdk.services.billingconductor.model.ListPricingPlansResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListPricingPlansIterable responses = client.listPricingPlansPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPricingPlans(software.amazon.awssdk.services.billingconductor.model.ListPricingPlansRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPricingPlansRequest.Builder} avoiding the need
     * to create one manually via {@link ListPricingPlansRequest#builder()}
     * </p>
     *
     * @param listPricingPlansRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.billingconductor.model.ListPricingPlansRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.ListPricingPlans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListPricingPlans"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPricingPlansIterable listPricingPlansPaginator(Consumer<ListPricingPlansRequest.Builder> listPricingPlansRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, BillingconductorException {
        return listPricingPlansPaginator(ListPricingPlansRequest.builder().applyMutation(listPricingPlansRequest).build());
    }

    /**
     * <p>
     * A list of the pricing plans that are associated with a pricing rule.
     * </p>
     *
     * @param listPricingPlansAssociatedWithPricingRuleRequest
     * @return Result of the ListPricingPlansAssociatedWithPricingRule operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.ListPricingPlansAssociatedWithPricingRule
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListPricingPlansAssociatedWithPricingRule"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPricingPlansAssociatedWithPricingRuleResponse listPricingPlansAssociatedWithPricingRule(
            ListPricingPlansAssociatedWithPricingRuleRequest listPricingPlansAssociatedWithPricingRuleRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A list of the pricing plans that are associated with a pricing rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListPricingPlansAssociatedWithPricingRuleRequest.Builder} avoiding the need to create one manually via
     * {@link ListPricingPlansAssociatedWithPricingRuleRequest#builder()}
     * </p>
     *
     * @param listPricingPlansAssociatedWithPricingRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.billingconductor.model.ListPricingPlansAssociatedWithPricingRuleRequest.Builder}
     *        to create a request.
     * @return Result of the ListPricingPlansAssociatedWithPricingRule operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.ListPricingPlansAssociatedWithPricingRule
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListPricingPlansAssociatedWithPricingRule"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPricingPlansAssociatedWithPricingRuleResponse listPricingPlansAssociatedWithPricingRule(
            Consumer<ListPricingPlansAssociatedWithPricingRuleRequest.Builder> listPricingPlansAssociatedWithPricingRuleRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        return listPricingPlansAssociatedWithPricingRule(ListPricingPlansAssociatedWithPricingRuleRequest.builder()
                .applyMutation(listPricingPlansAssociatedWithPricingRuleRequest).build());
    }

    /**
     * <p>
     * A list of the pricing plans that are associated with a pricing rule.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPricingPlansAssociatedWithPricingRule(software.amazon.awssdk.services.billingconductor.model.ListPricingPlansAssociatedWithPricingRuleRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListPricingPlansAssociatedWithPricingRuleIterable responses = client.listPricingPlansAssociatedWithPricingRulePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.billingconductor.paginators.ListPricingPlansAssociatedWithPricingRuleIterable responses = client
     *             .listPricingPlansAssociatedWithPricingRulePaginator(request);
     *     for (software.amazon.awssdk.services.billingconductor.model.ListPricingPlansAssociatedWithPricingRuleResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListPricingPlansAssociatedWithPricingRuleIterable responses = client.listPricingPlansAssociatedWithPricingRulePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPricingPlansAssociatedWithPricingRule(software.amazon.awssdk.services.billingconductor.model.ListPricingPlansAssociatedWithPricingRuleRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPricingPlansAssociatedWithPricingRuleRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.ListPricingPlansAssociatedWithPricingRule
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListPricingPlansAssociatedWithPricingRule"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPricingPlansAssociatedWithPricingRuleIterable listPricingPlansAssociatedWithPricingRulePaginator(
            ListPricingPlansAssociatedWithPricingRuleRequest listPricingPlansAssociatedWithPricingRuleRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        return new ListPricingPlansAssociatedWithPricingRuleIterable(this, listPricingPlansAssociatedWithPricingRuleRequest);
    }

    /**
     * <p>
     * A list of the pricing plans that are associated with a pricing rule.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPricingPlansAssociatedWithPricingRule(software.amazon.awssdk.services.billingconductor.model.ListPricingPlansAssociatedWithPricingRuleRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListPricingPlansAssociatedWithPricingRuleIterable responses = client.listPricingPlansAssociatedWithPricingRulePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.billingconductor.paginators.ListPricingPlansAssociatedWithPricingRuleIterable responses = client
     *             .listPricingPlansAssociatedWithPricingRulePaginator(request);
     *     for (software.amazon.awssdk.services.billingconductor.model.ListPricingPlansAssociatedWithPricingRuleResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListPricingPlansAssociatedWithPricingRuleIterable responses = client.listPricingPlansAssociatedWithPricingRulePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPricingPlansAssociatedWithPricingRule(software.amazon.awssdk.services.billingconductor.model.ListPricingPlansAssociatedWithPricingRuleRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListPricingPlansAssociatedWithPricingRuleRequest.Builder} avoiding the need to create one manually via
     * {@link ListPricingPlansAssociatedWithPricingRuleRequest#builder()}
     * </p>
     *
     * @param listPricingPlansAssociatedWithPricingRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.billingconductor.model.ListPricingPlansAssociatedWithPricingRuleRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.ListPricingPlansAssociatedWithPricingRule
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListPricingPlansAssociatedWithPricingRule"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPricingPlansAssociatedWithPricingRuleIterable listPricingPlansAssociatedWithPricingRulePaginator(
            Consumer<ListPricingPlansAssociatedWithPricingRuleRequest.Builder> listPricingPlansAssociatedWithPricingRuleRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        return listPricingPlansAssociatedWithPricingRulePaginator(ListPricingPlansAssociatedWithPricingRuleRequest.builder()
                .applyMutation(listPricingPlansAssociatedWithPricingRuleRequest).build());
    }

    /**
     * <p>
     * Describes a pricing rule that can be associated to a pricing plan, or set of pricing plans.
     * </p>
     *
     * @param listPricingRulesRequest
     * @return Result of the ListPricingRules operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.ListPricingRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListPricingRules"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPricingRulesResponse listPricingRules(ListPricingRulesRequest listPricingRulesRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, BillingconductorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a pricing rule that can be associated to a pricing plan, or set of pricing plans.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPricingRulesRequest.Builder} avoiding the need
     * to create one manually via {@link ListPricingRulesRequest#builder()}
     * </p>
     *
     * @param listPricingRulesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.billingconductor.model.ListPricingRulesRequest.Builder} to create a
     *        request.
     * @return Result of the ListPricingRules operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.ListPricingRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListPricingRules"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPricingRulesResponse listPricingRules(Consumer<ListPricingRulesRequest.Builder> listPricingRulesRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, BillingconductorException {
        return listPricingRules(ListPricingRulesRequest.builder().applyMutation(listPricingRulesRequest).build());
    }

    /**
     * <p>
     * Describes a pricing rule that can be associated to a pricing plan, or set of pricing plans.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPricingRules(software.amazon.awssdk.services.billingconductor.model.ListPricingRulesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListPricingRulesIterable responses = client.listPricingRulesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.billingconductor.paginators.ListPricingRulesIterable responses = client
     *             .listPricingRulesPaginator(request);
     *     for (software.amazon.awssdk.services.billingconductor.model.ListPricingRulesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListPricingRulesIterable responses = client.listPricingRulesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPricingRules(software.amazon.awssdk.services.billingconductor.model.ListPricingRulesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPricingRulesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.ListPricingRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListPricingRules"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPricingRulesIterable listPricingRulesPaginator(ListPricingRulesRequest listPricingRulesRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, BillingconductorException {
        return new ListPricingRulesIterable(this, listPricingRulesRequest);
    }

    /**
     * <p>
     * Describes a pricing rule that can be associated to a pricing plan, or set of pricing plans.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPricingRules(software.amazon.awssdk.services.billingconductor.model.ListPricingRulesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListPricingRulesIterable responses = client.listPricingRulesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.billingconductor.paginators.ListPricingRulesIterable responses = client
     *             .listPricingRulesPaginator(request);
     *     for (software.amazon.awssdk.services.billingconductor.model.ListPricingRulesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListPricingRulesIterable responses = client.listPricingRulesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPricingRules(software.amazon.awssdk.services.billingconductor.model.ListPricingRulesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPricingRulesRequest.Builder} avoiding the need
     * to create one manually via {@link ListPricingRulesRequest#builder()}
     * </p>
     *
     * @param listPricingRulesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.billingconductor.model.ListPricingRulesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.ListPricingRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListPricingRules"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPricingRulesIterable listPricingRulesPaginator(Consumer<ListPricingRulesRequest.Builder> listPricingRulesRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, BillingconductorException {
        return listPricingRulesPaginator(ListPricingRulesRequest.builder().applyMutation(listPricingRulesRequest).build());
    }

    /**
     * <p>
     * Lists the pricing rules that are associated with a pricing plan.
     * </p>
     *
     * @param listPricingRulesAssociatedToPricingPlanRequest
     * @return Result of the ListPricingRulesAssociatedToPricingPlan operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.ListPricingRulesAssociatedToPricingPlan
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListPricingRulesAssociatedToPricingPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPricingRulesAssociatedToPricingPlanResponse listPricingRulesAssociatedToPricingPlan(
            ListPricingRulesAssociatedToPricingPlanRequest listPricingRulesAssociatedToPricingPlanRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the pricing rules that are associated with a pricing plan.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListPricingRulesAssociatedToPricingPlanRequest.Builder} avoiding the need to create one manually via
     * {@link ListPricingRulesAssociatedToPricingPlanRequest#builder()}
     * </p>
     *
     * @param listPricingRulesAssociatedToPricingPlanRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.billingconductor.model.ListPricingRulesAssociatedToPricingPlanRequest.Builder}
     *        to create a request.
     * @return Result of the ListPricingRulesAssociatedToPricingPlan operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.ListPricingRulesAssociatedToPricingPlan
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListPricingRulesAssociatedToPricingPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPricingRulesAssociatedToPricingPlanResponse listPricingRulesAssociatedToPricingPlan(
            Consumer<ListPricingRulesAssociatedToPricingPlanRequest.Builder> listPricingRulesAssociatedToPricingPlanRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        return listPricingRulesAssociatedToPricingPlan(ListPricingRulesAssociatedToPricingPlanRequest.builder()
                .applyMutation(listPricingRulesAssociatedToPricingPlanRequest).build());
    }

    /**
     * <p>
     * Lists the pricing rules that are associated with a pricing plan.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPricingRulesAssociatedToPricingPlan(software.amazon.awssdk.services.billingconductor.model.ListPricingRulesAssociatedToPricingPlanRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListPricingRulesAssociatedToPricingPlanIterable responses = client.listPricingRulesAssociatedToPricingPlanPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.billingconductor.paginators.ListPricingRulesAssociatedToPricingPlanIterable responses = client
     *             .listPricingRulesAssociatedToPricingPlanPaginator(request);
     *     for (software.amazon.awssdk.services.billingconductor.model.ListPricingRulesAssociatedToPricingPlanResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListPricingRulesAssociatedToPricingPlanIterable responses = client.listPricingRulesAssociatedToPricingPlanPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPricingRulesAssociatedToPricingPlan(software.amazon.awssdk.services.billingconductor.model.ListPricingRulesAssociatedToPricingPlanRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPricingRulesAssociatedToPricingPlanRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.ListPricingRulesAssociatedToPricingPlan
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListPricingRulesAssociatedToPricingPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPricingRulesAssociatedToPricingPlanIterable listPricingRulesAssociatedToPricingPlanPaginator(
            ListPricingRulesAssociatedToPricingPlanRequest listPricingRulesAssociatedToPricingPlanRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        return new ListPricingRulesAssociatedToPricingPlanIterable(this, listPricingRulesAssociatedToPricingPlanRequest);
    }

    /**
     * <p>
     * Lists the pricing rules that are associated with a pricing plan.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPricingRulesAssociatedToPricingPlan(software.amazon.awssdk.services.billingconductor.model.ListPricingRulesAssociatedToPricingPlanRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListPricingRulesAssociatedToPricingPlanIterable responses = client.listPricingRulesAssociatedToPricingPlanPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.billingconductor.paginators.ListPricingRulesAssociatedToPricingPlanIterable responses = client
     *             .listPricingRulesAssociatedToPricingPlanPaginator(request);
     *     for (software.amazon.awssdk.services.billingconductor.model.ListPricingRulesAssociatedToPricingPlanResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListPricingRulesAssociatedToPricingPlanIterable responses = client.listPricingRulesAssociatedToPricingPlanPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPricingRulesAssociatedToPricingPlan(software.amazon.awssdk.services.billingconductor.model.ListPricingRulesAssociatedToPricingPlanRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListPricingRulesAssociatedToPricingPlanRequest.Builder} avoiding the need to create one manually via
     * {@link ListPricingRulesAssociatedToPricingPlanRequest#builder()}
     * </p>
     *
     * @param listPricingRulesAssociatedToPricingPlanRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.billingconductor.model.ListPricingRulesAssociatedToPricingPlanRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.ListPricingRulesAssociatedToPricingPlan
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListPricingRulesAssociatedToPricingPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPricingRulesAssociatedToPricingPlanIterable listPricingRulesAssociatedToPricingPlanPaginator(
            Consumer<ListPricingRulesAssociatedToPricingPlanRequest.Builder> listPricingRulesAssociatedToPricingPlanRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        return listPricingRulesAssociatedToPricingPlanPaginator(ListPricingRulesAssociatedToPricingPlanRequest.builder()
                .applyMutation(listPricingRulesAssociatedToPricingPlanRequest).build());
    }

    /**
     * <p>
     * List the resources that are associated to a custom line item.
     * </p>
     *
     * @param listResourcesAssociatedToCustomLineItemRequest
     * @return Result of the ListResourcesAssociatedToCustomLineItem operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.ListResourcesAssociatedToCustomLineItem
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListResourcesAssociatedToCustomLineItem"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourcesAssociatedToCustomLineItemResponse listResourcesAssociatedToCustomLineItem(
            ListResourcesAssociatedToCustomLineItemRequest listResourcesAssociatedToCustomLineItemRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the resources that are associated to a custom line item.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListResourcesAssociatedToCustomLineItemRequest.Builder} avoiding the need to create one manually via
     * {@link ListResourcesAssociatedToCustomLineItemRequest#builder()}
     * </p>
     *
     * @param listResourcesAssociatedToCustomLineItemRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.billingconductor.model.ListResourcesAssociatedToCustomLineItemRequest.Builder}
     *        to create a request.
     * @return Result of the ListResourcesAssociatedToCustomLineItem operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.ListResourcesAssociatedToCustomLineItem
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListResourcesAssociatedToCustomLineItem"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourcesAssociatedToCustomLineItemResponse listResourcesAssociatedToCustomLineItem(
            Consumer<ListResourcesAssociatedToCustomLineItemRequest.Builder> listResourcesAssociatedToCustomLineItemRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        return listResourcesAssociatedToCustomLineItem(ListResourcesAssociatedToCustomLineItemRequest.builder()
                .applyMutation(listResourcesAssociatedToCustomLineItemRequest).build());
    }

    /**
     * <p>
     * List the resources that are associated to a custom line item.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResourcesAssociatedToCustomLineItem(software.amazon.awssdk.services.billingconductor.model.ListResourcesAssociatedToCustomLineItemRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListResourcesAssociatedToCustomLineItemIterable responses = client.listResourcesAssociatedToCustomLineItemPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.billingconductor.paginators.ListResourcesAssociatedToCustomLineItemIterable responses = client
     *             .listResourcesAssociatedToCustomLineItemPaginator(request);
     *     for (software.amazon.awssdk.services.billingconductor.model.ListResourcesAssociatedToCustomLineItemResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListResourcesAssociatedToCustomLineItemIterable responses = client.listResourcesAssociatedToCustomLineItemPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourcesAssociatedToCustomLineItem(software.amazon.awssdk.services.billingconductor.model.ListResourcesAssociatedToCustomLineItemRequest)}
     * operation.</b>
     * </p>
     *
     * @param listResourcesAssociatedToCustomLineItemRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.ListResourcesAssociatedToCustomLineItem
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListResourcesAssociatedToCustomLineItem"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourcesAssociatedToCustomLineItemIterable listResourcesAssociatedToCustomLineItemPaginator(
            ListResourcesAssociatedToCustomLineItemRequest listResourcesAssociatedToCustomLineItemRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        return new ListResourcesAssociatedToCustomLineItemIterable(this, listResourcesAssociatedToCustomLineItemRequest);
    }

    /**
     * <p>
     * List the resources that are associated to a custom line item.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResourcesAssociatedToCustomLineItem(software.amazon.awssdk.services.billingconductor.model.ListResourcesAssociatedToCustomLineItemRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListResourcesAssociatedToCustomLineItemIterable responses = client.listResourcesAssociatedToCustomLineItemPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.billingconductor.paginators.ListResourcesAssociatedToCustomLineItemIterable responses = client
     *             .listResourcesAssociatedToCustomLineItemPaginator(request);
     *     for (software.amazon.awssdk.services.billingconductor.model.ListResourcesAssociatedToCustomLineItemResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListResourcesAssociatedToCustomLineItemIterable responses = client.listResourcesAssociatedToCustomLineItemPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourcesAssociatedToCustomLineItem(software.amazon.awssdk.services.billingconductor.model.ListResourcesAssociatedToCustomLineItemRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListResourcesAssociatedToCustomLineItemRequest.Builder} avoiding the need to create one manually via
     * {@link ListResourcesAssociatedToCustomLineItemRequest#builder()}
     * </p>
     *
     * @param listResourcesAssociatedToCustomLineItemRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.billingconductor.model.ListResourcesAssociatedToCustomLineItemRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.ListResourcesAssociatedToCustomLineItem
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListResourcesAssociatedToCustomLineItem"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourcesAssociatedToCustomLineItemIterable listResourcesAssociatedToCustomLineItemPaginator(
            Consumer<ListResourcesAssociatedToCustomLineItemRequest.Builder> listResourcesAssociatedToCustomLineItemRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        return listResourcesAssociatedToCustomLineItemPaginator(ListResourcesAssociatedToCustomLineItemRequest.builder()
                .applyMutation(listResourcesAssociatedToCustomLineItemRequest).build());
    }

    /**
     * <p>
     * A list the tags for a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A list the tags for a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.billingconductor.model.ListTagsForResourceRequest.Builder} to
     *        create a request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, BillingconductorException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Associates the specified tags to a resource with the specified <code>resourceArn</code>. If existing tags on a
     * resource are not specified in the request parameters, they are not changed.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, BillingconductorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates the specified tags to a resource with the specified <code>resourceArn</code>. If existing tags on a
     * resource are not specified in the request parameters, they are not changed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.billingconductor.model.TagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, BillingconductorException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Deletes specified tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, BillingconductorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes specified tags from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.billingconductor.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * This updates an existing billing group.
     * </p>
     *
     * @param updateBillingGroupRequest
     * @return Result of the UpdateBillingGroup operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         You can cause an inconsistent state by updating or deleting a resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.UpdateBillingGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/UpdateBillingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateBillingGroupResponse updateBillingGroup(UpdateBillingGroupRequest updateBillingGroupRequest)
            throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This updates an existing billing group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBillingGroupRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateBillingGroupRequest#builder()}
     * </p>
     *
     * @param updateBillingGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.billingconductor.model.UpdateBillingGroupRequest.Builder} to create
     *        a request.
     * @return Result of the UpdateBillingGroup operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         You can cause an inconsistent state by updating or deleting a resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.UpdateBillingGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/UpdateBillingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateBillingGroupResponse updateBillingGroup(Consumer<UpdateBillingGroupRequest.Builder> updateBillingGroupRequest)
            throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        return updateBillingGroup(UpdateBillingGroupRequest.builder().applyMutation(updateBillingGroupRequest).build());
    }

    /**
     * <p>
     * Update an existing custom line item in the current or previous billing period.
     * </p>
     *
     * @param updateCustomLineItemRequest
     * @return Result of the UpdateCustomLineItem operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.UpdateCustomLineItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/UpdateCustomLineItem"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCustomLineItemResponse updateCustomLineItem(UpdateCustomLineItemRequest updateCustomLineItemRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update an existing custom line item in the current or previous billing period.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCustomLineItemRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateCustomLineItemRequest#builder()}
     * </p>
     *
     * @param updateCustomLineItemRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.billingconductor.model.UpdateCustomLineItemRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateCustomLineItem operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.UpdateCustomLineItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/UpdateCustomLineItem"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCustomLineItemResponse updateCustomLineItem(
            Consumer<UpdateCustomLineItemRequest.Builder> updateCustomLineItemRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, BillingconductorException {
        return updateCustomLineItem(UpdateCustomLineItemRequest.builder().applyMutation(updateCustomLineItemRequest).build());
    }

    /**
     * <p>
     * This updates an existing pricing plan.
     * </p>
     *
     * @param updatePricingPlanRequest
     * @return Result of the UpdatePricingPlan operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         You can cause an inconsistent state by updating or deleting a resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.UpdatePricingPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/UpdatePricingPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdatePricingPlanResponse updatePricingPlan(UpdatePricingPlanRequest updatePricingPlanRequest)
            throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This updates an existing pricing plan.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePricingPlanRequest.Builder} avoiding the need
     * to create one manually via {@link UpdatePricingPlanRequest#builder()}
     * </p>
     *
     * @param updatePricingPlanRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.billingconductor.model.UpdatePricingPlanRequest.Builder} to create
     *        a request.
     * @return Result of the UpdatePricingPlan operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         You can cause an inconsistent state by updating or deleting a resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.UpdatePricingPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/UpdatePricingPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdatePricingPlanResponse updatePricingPlan(Consumer<UpdatePricingPlanRequest.Builder> updatePricingPlanRequest)
            throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        return updatePricingPlan(UpdatePricingPlanRequest.builder().applyMutation(updatePricingPlanRequest).build());
    }

    /**
     * <p>
     * Updates an existing pricing rule.
     * </p>
     *
     * @param updatePricingRuleRequest
     * @return Result of the UpdatePricingRule operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         You can cause an inconsistent state by updating or deleting a resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.UpdatePricingRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/UpdatePricingRule"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdatePricingRuleResponse updatePricingRule(UpdatePricingRuleRequest updatePricingRuleRequest)
            throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing pricing rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePricingRuleRequest.Builder} avoiding the need
     * to create one manually via {@link UpdatePricingRuleRequest#builder()}
     * </p>
     *
     * @param updatePricingRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.billingconductor.model.UpdatePricingRuleRequest.Builder} to create
     *        a request.
     * @return Result of the UpdatePricingRule operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         You can cause an inconsistent state by updating or deleting a resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.UpdatePricingRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/UpdatePricingRule"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdatePricingRuleResponse updatePricingRule(Consumer<UpdatePricingRuleRequest.Builder> updatePricingRuleRequest)
            throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        return updatePricingRule(UpdatePricingRuleRequest.builder().applyMutation(updatePricingRuleRequest).build());
    }

    /**
     * Create a {@link BillingconductorClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static BillingconductorClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link BillingconductorClient}.
     */
    static BillingconductorClientBuilder builder() {
        return new DefaultBillingconductorClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default BillingconductorServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
