/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupstorage.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backupstorage.BackupStorageAsyncClient;
import software.amazon.awssdk.services.backupstorage.internal.UserAgentUtils;
import software.amazon.awssdk.services.backupstorage.model.ListChunksRequest;
import software.amazon.awssdk.services.backupstorage.model.ListChunksResponse;

public class ListChunksPublisher
implements SdkPublisher<ListChunksResponse> {
    private final BackupStorageAsyncClient client;
    private final ListChunksRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListChunksPublisher(BackupStorageAsyncClient client, ListChunksRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListChunksPublisher(BackupStorageAsyncClient client, ListChunksRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListChunksResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListChunksResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListChunksResponseFetcher
    implements AsyncPageFetcher<ListChunksResponse> {
        private ListChunksResponseFetcher() {
        }

        public boolean hasNextPage(ListChunksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListChunksResponse> nextPage(ListChunksResponse previousPage) {
            if (previousPage == null) {
                return ListChunksPublisher.this.client.listChunks(ListChunksPublisher.this.firstRequest);
            }
            return ListChunksPublisher.this.client.listChunks((ListChunksRequest)((Object)ListChunksPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

