/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupstorage;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.backupstorage.BackupStorageAsyncClient;
import software.amazon.awssdk.services.backupstorage.BackupStorageAsyncClientBuilder;
import software.amazon.awssdk.services.backupstorage.BackupStorageServiceClientConfiguration;
import software.amazon.awssdk.services.backupstorage.DefaultBackupStorageAsyncClient;
import software.amazon.awssdk.services.backupstorage.DefaultBackupStorageBaseClientBuilder;
import software.amazon.awssdk.services.backupstorage.endpoints.BackupStorageEndpointProvider;

@SdkInternalApi
final class DefaultBackupStorageAsyncClientBuilder
extends DefaultBackupStorageBaseClientBuilder<BackupStorageAsyncClientBuilder, BackupStorageAsyncClient>
implements BackupStorageAsyncClientBuilder {
    DefaultBackupStorageAsyncClientBuilder() {
    }

    @Override
    public DefaultBackupStorageAsyncClientBuilder endpointProvider(BackupStorageEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final BackupStorageAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultBackupStorageAsyncClientBuilder.validateClientOptions(clientConfiguration);
        BackupStorageServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultBackupStorageAsyncClient client = new DefaultBackupStorageAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private BackupStorageServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return BackupStorageServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

