/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backupstorage.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutObjectResponse extends BackupStorageResponse implements
        ToCopyableBuilder<PutObjectResponse.Builder, PutObjectResponse> {
    private static final SdkField<String> INLINE_CHUNK_CHECKSUM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InlineChunkChecksum").getter(getter(PutObjectResponse::inlineChunkChecksum))
            .setter(setter(Builder::inlineChunkChecksum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InlineChunkChecksum").build())
            .build();

    private static final SdkField<String> INLINE_CHUNK_CHECKSUM_ALGORITHM_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InlineChunkChecksumAlgorithm")
            .getter(getter(PutObjectResponse::inlineChunkChecksumAlgorithmAsString))
            .setter(setter(Builder::inlineChunkChecksumAlgorithm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InlineChunkChecksumAlgorithm")
                    .build()).build();

    private static final SdkField<String> OBJECT_CHECKSUM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ObjectChecksum").getter(getter(PutObjectResponse::objectChecksum))
            .setter(setter(Builder::objectChecksum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectChecksum").build()).build();

    private static final SdkField<String> OBJECT_CHECKSUM_ALGORITHM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ObjectChecksumAlgorithm").getter(getter(PutObjectResponse::objectChecksumAlgorithmAsString))
            .setter(setter(Builder::objectChecksumAlgorithm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectChecksumAlgorithm").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INLINE_CHUNK_CHECKSUM_FIELD,
            INLINE_CHUNK_CHECKSUM_ALGORITHM_FIELD, OBJECT_CHECKSUM_FIELD, OBJECT_CHECKSUM_ALGORITHM_FIELD));

    private final String inlineChunkChecksum;

    private final String inlineChunkChecksumAlgorithm;

    private final String objectChecksum;

    private final String objectChecksumAlgorithm;

    private PutObjectResponse(BuilderImpl builder) {
        super(builder);
        this.inlineChunkChecksum = builder.inlineChunkChecksum;
        this.inlineChunkChecksumAlgorithm = builder.inlineChunkChecksumAlgorithm;
        this.objectChecksum = builder.objectChecksum;
        this.objectChecksumAlgorithm = builder.objectChecksumAlgorithm;
    }

    /**
     * Inline chunk checksum
     * 
     * @return Inline chunk checksum
     */
    public final String inlineChunkChecksum() {
        return inlineChunkChecksum;
    }

    /**
     * Inline chunk checksum algorithm
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #inlineChunkChecksumAlgorithm} will return {@link DataChecksumAlgorithm#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #inlineChunkChecksumAlgorithmAsString}.
     * </p>
     * 
     * @return Inline chunk checksum algorithm
     * @see DataChecksumAlgorithm
     */
    public final DataChecksumAlgorithm inlineChunkChecksumAlgorithm() {
        return DataChecksumAlgorithm.fromValue(inlineChunkChecksumAlgorithm);
    }

    /**
     * Inline chunk checksum algorithm
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #inlineChunkChecksumAlgorithm} will return {@link DataChecksumAlgorithm#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #inlineChunkChecksumAlgorithmAsString}.
     * </p>
     * 
     * @return Inline chunk checksum algorithm
     * @see DataChecksumAlgorithm
     */
    public final String inlineChunkChecksumAlgorithmAsString() {
        return inlineChunkChecksumAlgorithm;
    }

    /**
     * object checksum
     * 
     * @return object checksum
     */
    public final String objectChecksum() {
        return objectChecksum;
    }

    /**
     * object checksum algorithm
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #objectChecksumAlgorithm} will return {@link SummaryChecksumAlgorithm#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #objectChecksumAlgorithmAsString}.
     * </p>
     * 
     * @return object checksum algorithm
     * @see SummaryChecksumAlgorithm
     */
    public final SummaryChecksumAlgorithm objectChecksumAlgorithm() {
        return SummaryChecksumAlgorithm.fromValue(objectChecksumAlgorithm);
    }

    /**
     * object checksum algorithm
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #objectChecksumAlgorithm} will return {@link SummaryChecksumAlgorithm#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #objectChecksumAlgorithmAsString}.
     * </p>
     * 
     * @return object checksum algorithm
     * @see SummaryChecksumAlgorithm
     */
    public final String objectChecksumAlgorithmAsString() {
        return objectChecksumAlgorithm;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(inlineChunkChecksum());
        hashCode = 31 * hashCode + Objects.hashCode(inlineChunkChecksumAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(objectChecksum());
        hashCode = 31 * hashCode + Objects.hashCode(objectChecksumAlgorithmAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutObjectResponse)) {
            return false;
        }
        PutObjectResponse other = (PutObjectResponse) obj;
        return Objects.equals(inlineChunkChecksum(), other.inlineChunkChecksum())
                && Objects.equals(inlineChunkChecksumAlgorithmAsString(), other.inlineChunkChecksumAlgorithmAsString())
                && Objects.equals(objectChecksum(), other.objectChecksum())
                && Objects.equals(objectChecksumAlgorithmAsString(), other.objectChecksumAlgorithmAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutObjectResponse").add("InlineChunkChecksum", inlineChunkChecksum())
                .add("InlineChunkChecksumAlgorithm", inlineChunkChecksumAlgorithmAsString())
                .add("ObjectChecksum", objectChecksum()).add("ObjectChecksumAlgorithm", objectChecksumAlgorithmAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InlineChunkChecksum":
            return Optional.ofNullable(clazz.cast(inlineChunkChecksum()));
        case "InlineChunkChecksumAlgorithm":
            return Optional.ofNullable(clazz.cast(inlineChunkChecksumAlgorithmAsString()));
        case "ObjectChecksum":
            return Optional.ofNullable(clazz.cast(objectChecksum()));
        case "ObjectChecksumAlgorithm":
            return Optional.ofNullable(clazz.cast(objectChecksumAlgorithmAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutObjectResponse, T> g) {
        return obj -> g.apply((PutObjectResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupStorageResponse.Builder, SdkPojo, CopyableBuilder<Builder, PutObjectResponse> {
        /**
         * Inline chunk checksum
         * 
         * @param inlineChunkChecksum
         *        Inline chunk checksum
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inlineChunkChecksum(String inlineChunkChecksum);

        /**
         * Inline chunk checksum algorithm
         * 
         * @param inlineChunkChecksumAlgorithm
         *        Inline chunk checksum algorithm
         * @see DataChecksumAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataChecksumAlgorithm
         */
        Builder inlineChunkChecksumAlgorithm(String inlineChunkChecksumAlgorithm);

        /**
         * Inline chunk checksum algorithm
         * 
         * @param inlineChunkChecksumAlgorithm
         *        Inline chunk checksum algorithm
         * @see DataChecksumAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataChecksumAlgorithm
         */
        Builder inlineChunkChecksumAlgorithm(DataChecksumAlgorithm inlineChunkChecksumAlgorithm);

        /**
         * object checksum
         * 
         * @param objectChecksum
         *        object checksum
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectChecksum(String objectChecksum);

        /**
         * object checksum algorithm
         * 
         * @param objectChecksumAlgorithm
         *        object checksum algorithm
         * @see SummaryChecksumAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SummaryChecksumAlgorithm
         */
        Builder objectChecksumAlgorithm(String objectChecksumAlgorithm);

        /**
         * object checksum algorithm
         * 
         * @param objectChecksumAlgorithm
         *        object checksum algorithm
         * @see SummaryChecksumAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SummaryChecksumAlgorithm
         */
        Builder objectChecksumAlgorithm(SummaryChecksumAlgorithm objectChecksumAlgorithm);
    }

    static final class BuilderImpl extends BackupStorageResponse.BuilderImpl implements Builder {
        private String inlineChunkChecksum;

        private String inlineChunkChecksumAlgorithm;

        private String objectChecksum;

        private String objectChecksumAlgorithm;

        private BuilderImpl() {
        }

        private BuilderImpl(PutObjectResponse model) {
            super(model);
            inlineChunkChecksum(model.inlineChunkChecksum);
            inlineChunkChecksumAlgorithm(model.inlineChunkChecksumAlgorithm);
            objectChecksum(model.objectChecksum);
            objectChecksumAlgorithm(model.objectChecksumAlgorithm);
        }

        public final String getInlineChunkChecksum() {
            return inlineChunkChecksum;
        }

        public final void setInlineChunkChecksum(String inlineChunkChecksum) {
            this.inlineChunkChecksum = inlineChunkChecksum;
        }

        @Override
        public final Builder inlineChunkChecksum(String inlineChunkChecksum) {
            this.inlineChunkChecksum = inlineChunkChecksum;
            return this;
        }

        public final String getInlineChunkChecksumAlgorithm() {
            return inlineChunkChecksumAlgorithm;
        }

        public final void setInlineChunkChecksumAlgorithm(String inlineChunkChecksumAlgorithm) {
            this.inlineChunkChecksumAlgorithm = inlineChunkChecksumAlgorithm;
        }

        @Override
        public final Builder inlineChunkChecksumAlgorithm(String inlineChunkChecksumAlgorithm) {
            this.inlineChunkChecksumAlgorithm = inlineChunkChecksumAlgorithm;
            return this;
        }

        @Override
        public final Builder inlineChunkChecksumAlgorithm(DataChecksumAlgorithm inlineChunkChecksumAlgorithm) {
            this.inlineChunkChecksumAlgorithm(inlineChunkChecksumAlgorithm == null ? null : inlineChunkChecksumAlgorithm
                    .toString());
            return this;
        }

        public final String getObjectChecksum() {
            return objectChecksum;
        }

        public final void setObjectChecksum(String objectChecksum) {
            this.objectChecksum = objectChecksum;
        }

        @Override
        public final Builder objectChecksum(String objectChecksum) {
            this.objectChecksum = objectChecksum;
            return this;
        }

        public final String getObjectChecksumAlgorithm() {
            return objectChecksumAlgorithm;
        }

        public final void setObjectChecksumAlgorithm(String objectChecksumAlgorithm) {
            this.objectChecksumAlgorithm = objectChecksumAlgorithm;
        }

        @Override
        public final Builder objectChecksumAlgorithm(String objectChecksumAlgorithm) {
            this.objectChecksumAlgorithm = objectChecksumAlgorithm;
            return this;
        }

        @Override
        public final Builder objectChecksumAlgorithm(SummaryChecksumAlgorithm objectChecksumAlgorithm) {
            this.objectChecksumAlgorithm(objectChecksumAlgorithm == null ? null : objectChecksumAlgorithm.toString());
            return this;
        }

        @Override
        public PutObjectResponse build() {
            return new PutObjectResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
