/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backupstorage.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListChunksRequest extends BackupStorageRequest implements
        ToCopyableBuilder<ListChunksRequest.Builder, ListChunksRequest> {
    private static final SdkField<String> STORAGE_JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StorageJobId").getter(getter(ListChunksRequest::storageJobId)).setter(setter(Builder::storageJobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("jobId").build()).build();

    private static final SdkField<String> OBJECT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ObjectToken").getter(getter(ListChunksRequest::objectToken)).setter(setter(Builder::objectToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("objectToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListChunksRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("max-results").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListChunksRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("next-token").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORAGE_JOB_ID_FIELD,
            OBJECT_TOKEN_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final String storageJobId;

    private final String objectToken;

    private final Integer maxResults;

    private final String nextToken;

    private ListChunksRequest(BuilderImpl builder) {
        super(builder);
        this.storageJobId = builder.storageJobId;
        this.objectToken = builder.objectToken;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * Storage job id
     * 
     * @return Storage job id
     */
    public final String storageJobId() {
        return storageJobId;
    }

    /**
     * Object token
     * 
     * @return Object token
     */
    public final String objectToken() {
        return objectToken;
    }

    /**
     * Maximum number of chunks
     * 
     * @return Maximum number of chunks
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * Pagination token
     * 
     * @return Pagination token
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(storageJobId());
        hashCode = 31 * hashCode + Objects.hashCode(objectToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListChunksRequest)) {
            return false;
        }
        ListChunksRequest other = (ListChunksRequest) obj;
        return Objects.equals(storageJobId(), other.storageJobId()) && Objects.equals(objectToken(), other.objectToken())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListChunksRequest").add("StorageJobId", storageJobId()).add("ObjectToken", objectToken())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StorageJobId":
            return Optional.ofNullable(clazz.cast(storageJobId()));
        case "ObjectToken":
            return Optional.ofNullable(clazz.cast(objectToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListChunksRequest, T> g) {
        return obj -> g.apply((ListChunksRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupStorageRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListChunksRequest> {
        /**
         * Storage job id
         * 
         * @param storageJobId
         *        Storage job id
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageJobId(String storageJobId);

        /**
         * Object token
         * 
         * @param objectToken
         *        Object token
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectToken(String objectToken);

        /**
         * Maximum number of chunks
         * 
         * @param maxResults
         *        Maximum number of chunks
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * Pagination token
         * 
         * @param nextToken
         *        Pagination token
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BackupStorageRequest.BuilderImpl implements Builder {
        private String storageJobId;

        private String objectToken;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListChunksRequest model) {
            super(model);
            storageJobId(model.storageJobId);
            objectToken(model.objectToken);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getStorageJobId() {
            return storageJobId;
        }

        public final void setStorageJobId(String storageJobId) {
            this.storageJobId = storageJobId;
        }

        @Override
        public final Builder storageJobId(String storageJobId) {
            this.storageJobId = storageJobId;
            return this;
        }

        public final String getObjectToken() {
            return objectToken;
        }

        public final void setObjectToken(String objectToken) {
            this.objectToken = objectToken;
        }

        @Override
        public final Builder objectToken(String objectToken) {
            this.objectToken = objectToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListChunksRequest build() {
            return new ListChunksRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
