/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupgateway.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backupgateway.BackupGatewayAsyncClient;
import software.amazon.awssdk.services.backupgateway.model.ListVirtualMachinesRequest;
import software.amazon.awssdk.services.backupgateway.model.ListVirtualMachinesResponse;
import software.amazon.awssdk.services.backupgateway.model.VirtualMachine;

public class ListVirtualMachinesPublisher
implements SdkPublisher<ListVirtualMachinesResponse> {
    private final BackupGatewayAsyncClient client;
    private final ListVirtualMachinesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListVirtualMachinesPublisher(BackupGatewayAsyncClient client, ListVirtualMachinesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListVirtualMachinesPublisher(BackupGatewayAsyncClient client, ListVirtualMachinesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListVirtualMachinesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListVirtualMachinesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<VirtualMachine> virtualMachines() {
        Function<ListVirtualMachinesResponse, Iterator> getIterator = response -> {
            if (response != null && response.virtualMachines() != null) {
                return response.virtualMachines().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListVirtualMachinesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListVirtualMachinesResponseFetcher
    implements AsyncPageFetcher<ListVirtualMachinesResponse> {
        private ListVirtualMachinesResponseFetcher() {
        }

        public boolean hasNextPage(ListVirtualMachinesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListVirtualMachinesResponse> nextPage(ListVirtualMachinesResponse previousPage) {
            if (previousPage == null) {
                return ListVirtualMachinesPublisher.this.client.listVirtualMachines(ListVirtualMachinesPublisher.this.firstRequest);
            }
            return ListVirtualMachinesPublisher.this.client.listVirtualMachines((ListVirtualMachinesRequest)((Object)ListVirtualMachinesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

