/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartCopyJobResponse extends BackupResponse implements
        ToCopyableBuilder<StartCopyJobResponse.Builder, StartCopyJobResponse> {
    private static final SdkField<String> COPY_JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CopyJobId").getter(getter(StartCopyJobResponse::copyJobId)).setter(setter(Builder::copyJobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyJobId").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationDate").getter(getter(StartCopyJobResponse::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()).build();

    private static final SdkField<Boolean> IS_PARENT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsParent").getter(getter(StartCopyJobResponse::isParent)).setter(setter(Builder::isParent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsParent").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COPY_JOB_ID_FIELD,
            CREATION_DATE_FIELD, IS_PARENT_FIELD));

    private final String copyJobId;

    private final Instant creationDate;

    private final Boolean isParent;

    private StartCopyJobResponse(BuilderImpl builder) {
        super(builder);
        this.copyJobId = builder.copyJobId;
        this.creationDate = builder.creationDate;
        this.isParent = builder.isParent;
    }

    /**
     * <p>
     * Uniquely identifies a copy job.
     * </p>
     * 
     * @return Uniquely identifies a copy job.
     */
    public final String copyJobId() {
        return copyJobId;
    }

    /**
     * <p>
     * The date and time that a copy job is created, in Unix format and Coordinated Universal Time (UTC). The value of
     * <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday,
     * January 26, 2018 12:11:30.087 AM.
     * </p>
     * 
     * @return The date and time that a copy job is created, in Unix format and Coordinated Universal Time (UTC). The
     *         value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087
     *         represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public final Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * This is a returned boolean value indicating this is a parent (composite) copy job.
     * </p>
     * 
     * @return This is a returned boolean value indicating this is a parent (composite) copy job.
     */
    public final Boolean isParent() {
        return isParent;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(copyJobId());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(isParent());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartCopyJobResponse)) {
            return false;
        }
        StartCopyJobResponse other = (StartCopyJobResponse) obj;
        return Objects.equals(copyJobId(), other.copyJobId()) && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(isParent(), other.isParent());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartCopyJobResponse").add("CopyJobId", copyJobId()).add("CreationDate", creationDate())
                .add("IsParent", isParent()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CopyJobId":
            return Optional.ofNullable(clazz.cast(copyJobId()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "IsParent":
            return Optional.ofNullable(clazz.cast(isParent()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartCopyJobResponse, T> g) {
        return obj -> g.apply((StartCopyJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupResponse.Builder, SdkPojo, CopyableBuilder<Builder, StartCopyJobResponse> {
        /**
         * <p>
         * Uniquely identifies a copy job.
         * </p>
         * 
         * @param copyJobId
         *        Uniquely identifies a copy job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyJobId(String copyJobId);

        /**
         * <p>
         * The date and time that a copy job is created, in Unix format and Coordinated Universal Time (UTC). The value
         * of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents
         * Friday, January 26, 2018 12:11:30.087 AM.
         * </p>
         * 
         * @param creationDate
         *        The date and time that a copy job is created, in Unix format and Coordinated Universal Time (UTC). The
         *        value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087
         *        represents Friday, January 26, 2018 12:11:30.087 AM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * This is a returned boolean value indicating this is a parent (composite) copy job.
         * </p>
         * 
         * @param isParent
         *        This is a returned boolean value indicating this is a parent (composite) copy job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isParent(Boolean isParent);
    }

    static final class BuilderImpl extends BackupResponse.BuilderImpl implements Builder {
        private String copyJobId;

        private Instant creationDate;

        private Boolean isParent;

        private BuilderImpl() {
        }

        private BuilderImpl(StartCopyJobResponse model) {
            super(model);
            copyJobId(model.copyJobId);
            creationDate(model.creationDate);
            isParent(model.isParent);
        }

        public final String getCopyJobId() {
            return copyJobId;
        }

        public final void setCopyJobId(String copyJobId) {
            this.copyJobId = copyJobId;
        }

        @Override
        public final Builder copyJobId(String copyJobId) {
            this.copyJobId = copyJobId;
            return this;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final Boolean getIsParent() {
            return isParent;
        }

        public final void setIsParent(Boolean isParent) {
            this.isParent = isParent;
        }

        @Override
        public final Builder isParent(Boolean isParent) {
            this.isParent = isParent;
            return this;
        }

        @Override
        public StartCopyJobResponse build() {
            return new StartCopyJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
