/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.backup.model.BackupResponse;
import software.amazon.awssdk.services.backup.model.Framework;
import software.amazon.awssdk.services.backup.model.FrameworkListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListFrameworksResponse
extends BackupResponse
implements ToCopyableBuilder<Builder, ListFrameworksResponse> {
    private static final SdkField<List<Framework>> FRAMEWORKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Frameworks").getter(ListFrameworksResponse.getter(ListFrameworksResponse::frameworks)).setter(ListFrameworksResponse.setter(Builder::frameworks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Frameworks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Framework::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListFrameworksResponse.getter(ListFrameworksResponse::nextToken)).setter(ListFrameworksResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FRAMEWORKS_FIELD, NEXT_TOKEN_FIELD));
    private final List<Framework> frameworks;
    private final String nextToken;

    private ListFrameworksResponse(BuilderImpl builder) {
        super(builder);
        this.frameworks = builder.frameworks;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasFrameworks() {
        return this.frameworks != null && !(this.frameworks instanceof SdkAutoConstructList);
    }

    public final List<Framework> frameworks() {
        return this.frameworks;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFrameworks() ? this.frameworks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFrameworksResponse)) {
            return false;
        }
        ListFrameworksResponse other = (ListFrameworksResponse)((Object)obj);
        return this.hasFrameworks() == other.hasFrameworks() && Objects.equals(this.frameworks(), other.frameworks()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListFrameworksResponse").add("Frameworks", this.hasFrameworks() ? this.frameworks() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Frameworks": {
                return Optional.ofNullable(clazz.cast(this.frameworks()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFrameworksResponse, T> g) {
        return obj -> g.apply((ListFrameworksResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupResponse.BuilderImpl
    implements Builder {
        private List<Framework> frameworks = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFrameworksResponse model) {
            super(model);
            this.frameworks(model.frameworks);
            this.nextToken(model.nextToken);
        }

        public final List<Framework.Builder> getFrameworks() {
            List<Framework.Builder> result = FrameworkListCopier.copyToBuilder(this.frameworks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFrameworks(Collection<Framework.BuilderImpl> frameworks) {
            this.frameworks = FrameworkListCopier.copyFromBuilder(frameworks);
        }

        @Override
        public final Builder frameworks(Collection<Framework> frameworks) {
            this.frameworks = FrameworkListCopier.copy(frameworks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder frameworks(Framework ... frameworks) {
            this.frameworks(Arrays.asList(frameworks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder frameworks(Consumer<Framework.Builder> ... frameworks) {
            this.frameworks(Stream.of(frameworks).map(c -> (Framework)((Framework.Builder)Framework.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListFrameworksResponse build() {
            return new ListFrameworksResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BackupResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListFrameworksResponse> {
        public Builder frameworks(Collection<Framework> var1);

        public Builder frameworks(Framework ... var1);

        public Builder frameworks(Consumer<Framework.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

