/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backup.BackupClient;
import software.amazon.awssdk.services.backup.internal.UserAgentUtils;
import software.amazon.awssdk.services.backup.model.ListProtectedResourcesByBackupVaultRequest;
import software.amazon.awssdk.services.backup.model.ListProtectedResourcesByBackupVaultResponse;
import software.amazon.awssdk.services.backup.model.ProtectedResource;

public class ListProtectedResourcesByBackupVaultIterable
implements SdkIterable<ListProtectedResourcesByBackupVaultResponse> {
    private final BackupClient client;
    private final ListProtectedResourcesByBackupVaultRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListProtectedResourcesByBackupVaultIterable(BackupClient client, ListProtectedResourcesByBackupVaultRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListProtectedResourcesByBackupVaultResponseFetcher();
    }

    public Iterator<ListProtectedResourcesByBackupVaultResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ProtectedResource> results() {
        Function<ListProtectedResourcesByBackupVaultResponse, Iterator> getIterator = response -> {
            if (response != null && response.results() != null) {
                return response.results().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListProtectedResourcesByBackupVaultResponseFetcher
    implements SyncPageFetcher<ListProtectedResourcesByBackupVaultResponse> {
        private ListProtectedResourcesByBackupVaultResponseFetcher() {
        }

        public boolean hasNextPage(ListProtectedResourcesByBackupVaultResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListProtectedResourcesByBackupVaultResponse nextPage(ListProtectedResourcesByBackupVaultResponse previousPage) {
            if (previousPage == null) {
                return ListProtectedResourcesByBackupVaultIterable.this.client.listProtectedResourcesByBackupVault(ListProtectedResourcesByBackupVaultIterable.this.firstRequest);
            }
            return ListProtectedResourcesByBackupVaultIterable.this.client.listProtectedResourcesByBackupVault((ListProtectedResourcesByBackupVaultRequest)((Object)ListProtectedResourcesByBackupVaultIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

