/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.backup.model.CopyAction;
import software.amazon.awssdk.services.backup.model.CopyActionsCopier;
import software.amazon.awssdk.services.backup.model.Lifecycle;
import software.amazon.awssdk.services.backup.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BackupRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BackupRule> {
    private static final SdkField<String> RULE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleName").getter(BackupRule.getter(BackupRule::ruleName)).setter(BackupRule.setter(Builder::ruleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleName").build()}).build();
    private static final SdkField<String> TARGET_BACKUP_VAULT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetBackupVaultName").getter(BackupRule.getter(BackupRule::targetBackupVaultName)).setter(BackupRule.setter(Builder::targetBackupVaultName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetBackupVaultName").build()}).build();
    private static final SdkField<String> SCHEDULE_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScheduleExpression").getter(BackupRule.getter(BackupRule::scheduleExpression)).setter(BackupRule.setter(Builder::scheduleExpression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleExpression").build()}).build();
    private static final SdkField<Long> START_WINDOW_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("StartWindowMinutes").getter(BackupRule.getter(BackupRule::startWindowMinutes)).setter(BackupRule.setter(Builder::startWindowMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartWindowMinutes").build()}).build();
    private static final SdkField<Long> COMPLETION_WINDOW_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("CompletionWindowMinutes").getter(BackupRule.getter(BackupRule::completionWindowMinutes)).setter(BackupRule.setter(Builder::completionWindowMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionWindowMinutes").build()}).build();
    private static final SdkField<Lifecycle> LIFECYCLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Lifecycle").getter(BackupRule.getter(BackupRule::lifecycle)).setter(BackupRule.setter(Builder::lifecycle)).constructor(Lifecycle::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lifecycle").build()}).build();
    private static final SdkField<Map<String, String>> RECOVERY_POINT_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("RecoveryPointTags").getter(BackupRule.getter(BackupRule::recoveryPointTags)).setter(BackupRule.setter(Builder::recoveryPointTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecoveryPointTags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> RULE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleId").getter(BackupRule.getter(BackupRule::ruleId)).setter(BackupRule.setter(Builder::ruleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleId").build()}).build();
    private static final SdkField<List<CopyAction>> COPY_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CopyActions").getter(BackupRule.getter(BackupRule::copyActions)).setter(BackupRule.setter(Builder::copyActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyActions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CopyAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ENABLE_CONTINUOUS_BACKUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableContinuousBackup").getter(BackupRule.getter(BackupRule::enableContinuousBackup)).setter(BackupRule.setter(Builder::enableContinuousBackup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableContinuousBackup").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_NAME_FIELD, TARGET_BACKUP_VAULT_NAME_FIELD, SCHEDULE_EXPRESSION_FIELD, START_WINDOW_MINUTES_FIELD, COMPLETION_WINDOW_MINUTES_FIELD, LIFECYCLE_FIELD, RECOVERY_POINT_TAGS_FIELD, RULE_ID_FIELD, COPY_ACTIONS_FIELD, ENABLE_CONTINUOUS_BACKUP_FIELD));
    private static final long serialVersionUID = 1L;
    private final String ruleName;
    private final String targetBackupVaultName;
    private final String scheduleExpression;
    private final Long startWindowMinutes;
    private final Long completionWindowMinutes;
    private final Lifecycle lifecycle;
    private final Map<String, String> recoveryPointTags;
    private final String ruleId;
    private final List<CopyAction> copyActions;
    private final Boolean enableContinuousBackup;

    private BackupRule(BuilderImpl builder) {
        this.ruleName = builder.ruleName;
        this.targetBackupVaultName = builder.targetBackupVaultName;
        this.scheduleExpression = builder.scheduleExpression;
        this.startWindowMinutes = builder.startWindowMinutes;
        this.completionWindowMinutes = builder.completionWindowMinutes;
        this.lifecycle = builder.lifecycle;
        this.recoveryPointTags = builder.recoveryPointTags;
        this.ruleId = builder.ruleId;
        this.copyActions = builder.copyActions;
        this.enableContinuousBackup = builder.enableContinuousBackup;
    }

    public final String ruleName() {
        return this.ruleName;
    }

    public final String targetBackupVaultName() {
        return this.targetBackupVaultName;
    }

    public final String scheduleExpression() {
        return this.scheduleExpression;
    }

    public final Long startWindowMinutes() {
        return this.startWindowMinutes;
    }

    public final Long completionWindowMinutes() {
        return this.completionWindowMinutes;
    }

    public final Lifecycle lifecycle() {
        return this.lifecycle;
    }

    public final boolean hasRecoveryPointTags() {
        return this.recoveryPointTags != null && !(this.recoveryPointTags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> recoveryPointTags() {
        return this.recoveryPointTags;
    }

    public final String ruleId() {
        return this.ruleId;
    }

    public final boolean hasCopyActions() {
        return this.copyActions != null && !(this.copyActions instanceof SdkAutoConstructList);
    }

    public final List<CopyAction> copyActions() {
        return this.copyActions;
    }

    public final Boolean enableContinuousBackup() {
        return this.enableContinuousBackup;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetBackupVaultName());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.startWindowMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.completionWindowMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycle());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecoveryPointTags() ? this.recoveryPointTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCopyActions() ? this.copyActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.enableContinuousBackup());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BackupRule)) {
            return false;
        }
        BackupRule other = (BackupRule)obj;
        return Objects.equals(this.ruleName(), other.ruleName()) && Objects.equals(this.targetBackupVaultName(), other.targetBackupVaultName()) && Objects.equals(this.scheduleExpression(), other.scheduleExpression()) && Objects.equals(this.startWindowMinutes(), other.startWindowMinutes()) && Objects.equals(this.completionWindowMinutes(), other.completionWindowMinutes()) && Objects.equals(this.lifecycle(), other.lifecycle()) && this.hasRecoveryPointTags() == other.hasRecoveryPointTags() && Objects.equals(this.recoveryPointTags(), other.recoveryPointTags()) && Objects.equals(this.ruleId(), other.ruleId()) && this.hasCopyActions() == other.hasCopyActions() && Objects.equals(this.copyActions(), other.copyActions()) && Objects.equals(this.enableContinuousBackup(), other.enableContinuousBackup());
    }

    public final String toString() {
        return ToString.builder((String)"BackupRule").add("RuleName", (Object)this.ruleName()).add("TargetBackupVaultName", (Object)this.targetBackupVaultName()).add("ScheduleExpression", (Object)this.scheduleExpression()).add("StartWindowMinutes", (Object)this.startWindowMinutes()).add("CompletionWindowMinutes", (Object)this.completionWindowMinutes()).add("Lifecycle", (Object)this.lifecycle()).add("RecoveryPointTags", (Object)(this.recoveryPointTags() == null ? null : "*** Sensitive Data Redacted ***")).add("RuleId", (Object)this.ruleId()).add("CopyActions", this.hasCopyActions() ? this.copyActions() : null).add("EnableContinuousBackup", (Object)this.enableContinuousBackup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RuleName": {
                return Optional.ofNullable(clazz.cast(this.ruleName()));
            }
            case "TargetBackupVaultName": {
                return Optional.ofNullable(clazz.cast(this.targetBackupVaultName()));
            }
            case "ScheduleExpression": {
                return Optional.ofNullable(clazz.cast(this.scheduleExpression()));
            }
            case "StartWindowMinutes": {
                return Optional.ofNullable(clazz.cast(this.startWindowMinutes()));
            }
            case "CompletionWindowMinutes": {
                return Optional.ofNullable(clazz.cast(this.completionWindowMinutes()));
            }
            case "Lifecycle": {
                return Optional.ofNullable(clazz.cast(this.lifecycle()));
            }
            case "RecoveryPointTags": {
                return Optional.ofNullable(clazz.cast(this.recoveryPointTags()));
            }
            case "RuleId": {
                return Optional.ofNullable(clazz.cast(this.ruleId()));
            }
            case "CopyActions": {
                return Optional.ofNullable(clazz.cast(this.copyActions()));
            }
            case "EnableContinuousBackup": {
                return Optional.ofNullable(clazz.cast(this.enableContinuousBackup()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BackupRule, T> g) {
        return obj -> g.apply((BackupRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ruleName;
        private String targetBackupVaultName;
        private String scheduleExpression;
        private Long startWindowMinutes;
        private Long completionWindowMinutes;
        private Lifecycle lifecycle;
        private Map<String, String> recoveryPointTags = DefaultSdkAutoConstructMap.getInstance();
        private String ruleId;
        private List<CopyAction> copyActions = DefaultSdkAutoConstructList.getInstance();
        private Boolean enableContinuousBackup;

        private BuilderImpl() {
        }

        private BuilderImpl(BackupRule model) {
            this.ruleName(model.ruleName);
            this.targetBackupVaultName(model.targetBackupVaultName);
            this.scheduleExpression(model.scheduleExpression);
            this.startWindowMinutes(model.startWindowMinutes);
            this.completionWindowMinutes(model.completionWindowMinutes);
            this.lifecycle(model.lifecycle);
            this.recoveryPointTags(model.recoveryPointTags);
            this.ruleId(model.ruleId);
            this.copyActions(model.copyActions);
            this.enableContinuousBackup(model.enableContinuousBackup);
        }

        public final String getRuleName() {
            return this.ruleName;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public final String getTargetBackupVaultName() {
            return this.targetBackupVaultName;
        }

        public final void setTargetBackupVaultName(String targetBackupVaultName) {
            this.targetBackupVaultName = targetBackupVaultName;
        }

        @Override
        public final Builder targetBackupVaultName(String targetBackupVaultName) {
            this.targetBackupVaultName = targetBackupVaultName;
            return this;
        }

        public final String getScheduleExpression() {
            return this.scheduleExpression;
        }

        public final void setScheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
        }

        @Override
        public final Builder scheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
            return this;
        }

        public final Long getStartWindowMinutes() {
            return this.startWindowMinutes;
        }

        public final void setStartWindowMinutes(Long startWindowMinutes) {
            this.startWindowMinutes = startWindowMinutes;
        }

        @Override
        public final Builder startWindowMinutes(Long startWindowMinutes) {
            this.startWindowMinutes = startWindowMinutes;
            return this;
        }

        public final Long getCompletionWindowMinutes() {
            return this.completionWindowMinutes;
        }

        public final void setCompletionWindowMinutes(Long completionWindowMinutes) {
            this.completionWindowMinutes = completionWindowMinutes;
        }

        @Override
        public final Builder completionWindowMinutes(Long completionWindowMinutes) {
            this.completionWindowMinutes = completionWindowMinutes;
            return this;
        }

        public final Lifecycle.Builder getLifecycle() {
            return this.lifecycle != null ? this.lifecycle.toBuilder() : null;
        }

        public final void setLifecycle(Lifecycle.BuilderImpl lifecycle) {
            this.lifecycle = lifecycle != null ? lifecycle.build() : null;
        }

        @Override
        public final Builder lifecycle(Lifecycle lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        public final Map<String, String> getRecoveryPointTags() {
            if (this.recoveryPointTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.recoveryPointTags;
        }

        public final void setRecoveryPointTags(Map<String, String> recoveryPointTags) {
            this.recoveryPointTags = TagsCopier.copy(recoveryPointTags);
        }

        @Override
        public final Builder recoveryPointTags(Map<String, String> recoveryPointTags) {
            this.recoveryPointTags = TagsCopier.copy(recoveryPointTags);
            return this;
        }

        public final String getRuleId() {
            return this.ruleId;
        }

        public final void setRuleId(String ruleId) {
            this.ruleId = ruleId;
        }

        @Override
        public final Builder ruleId(String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        public final List<CopyAction.Builder> getCopyActions() {
            List<CopyAction.Builder> result = CopyActionsCopier.copyToBuilder(this.copyActions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCopyActions(Collection<CopyAction.BuilderImpl> copyActions) {
            this.copyActions = CopyActionsCopier.copyFromBuilder(copyActions);
        }

        @Override
        public final Builder copyActions(Collection<CopyAction> copyActions) {
            this.copyActions = CopyActionsCopier.copy(copyActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder copyActions(CopyAction ... copyActions) {
            this.copyActions(Arrays.asList(copyActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder copyActions(Consumer<CopyAction.Builder> ... copyActions) {
            this.copyActions(Stream.of(copyActions).map(c -> (CopyAction)((CopyAction.Builder)CopyAction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getEnableContinuousBackup() {
            return this.enableContinuousBackup;
        }

        public final void setEnableContinuousBackup(Boolean enableContinuousBackup) {
            this.enableContinuousBackup = enableContinuousBackup;
        }

        @Override
        public final Builder enableContinuousBackup(Boolean enableContinuousBackup) {
            this.enableContinuousBackup = enableContinuousBackup;
            return this;
        }

        public BackupRule build() {
            return new BackupRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BackupRule> {
        public Builder ruleName(String var1);

        public Builder targetBackupVaultName(String var1);

        public Builder scheduleExpression(String var1);

        public Builder startWindowMinutes(Long var1);

        public Builder completionWindowMinutes(Long var1);

        public Builder lifecycle(Lifecycle var1);

        default public Builder lifecycle(Consumer<Lifecycle.Builder> lifecycle) {
            return this.lifecycle((Lifecycle)((Lifecycle.Builder)Lifecycle.builder().applyMutation(lifecycle)).build());
        }

        public Builder recoveryPointTags(Map<String, String> var1);

        public Builder ruleId(String var1);

        public Builder copyActions(Collection<CopyAction> var1);

        public Builder copyActions(CopyAction ... var1);

        public Builder copyActions(Consumer<CopyAction.Builder> ... var1);

        public Builder enableContinuousBackup(Boolean var1);
    }
}

