/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backup.BackupAsyncClient;
import software.amazon.awssdk.services.backup.model.ListReportPlansRequest;
import software.amazon.awssdk.services.backup.model.ListReportPlansResponse;

public class ListReportPlansPublisher
implements SdkPublisher<ListReportPlansResponse> {
    private final BackupAsyncClient client;
    private final ListReportPlansRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListReportPlansPublisher(BackupAsyncClient client, ListReportPlansRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListReportPlansPublisher(BackupAsyncClient client, ListReportPlansRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListReportPlansResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListReportPlansResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListReportPlansResponseFetcher
    implements AsyncPageFetcher<ListReportPlansResponse> {
        private ListReportPlansResponseFetcher() {
        }

        public boolean hasNextPage(ListReportPlansResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListReportPlansResponse> nextPage(ListReportPlansResponse previousPage) {
            if (previousPage == null) {
                return ListReportPlansPublisher.this.client.listReportPlans(ListReportPlansPublisher.this.firstRequest);
            }
            return ListReportPlansPublisher.this.client.listReportPlans((ListReportPlansRequest)((Object)ListReportPlansPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

