/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RecoveryPointStatus {
    COMPLETED("COMPLETED"),
    PARTIAL("PARTIAL"),
    DELETING("DELETING"),
    EXPIRED("EXPIRED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RecoveryPointStatus> VALUE_MAP;
    private final String value;

    private RecoveryPointStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RecoveryPointStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RecoveryPointStatus> knownValues() {
        EnumSet<RecoveryPointStatus> knownValues = EnumSet.allOf(RecoveryPointStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RecoveryPointStatus.class, RecoveryPointStatus::toString);
    }
}

