/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Framework
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Framework> {
    private static final SdkField<String> FRAMEWORK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FrameworkName").getter(Framework.getter(Framework::frameworkName)).setter(Framework.setter(Builder::frameworkName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FrameworkName").build()}).build();
    private static final SdkField<String> FRAMEWORK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FrameworkArn").getter(Framework.getter(Framework::frameworkArn)).setter(Framework.setter(Builder::frameworkArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FrameworkArn").build()}).build();
    private static final SdkField<String> FRAMEWORK_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FrameworkDescription").getter(Framework.getter(Framework::frameworkDescription)).setter(Framework.setter(Builder::frameworkDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FrameworkDescription").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_CONTROLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfControls").getter(Framework.getter(Framework::numberOfControls)).setter(Framework.setter(Builder::numberOfControls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfControls").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(Framework.getter(Framework::creationTime)).setter(Framework.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<String> DEPLOYMENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeploymentStatus").getter(Framework.getter(Framework::deploymentStatus)).setter(Framework.setter(Builder::deploymentStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FRAMEWORK_NAME_FIELD, FRAMEWORK_ARN_FIELD, FRAMEWORK_DESCRIPTION_FIELD, NUMBER_OF_CONTROLS_FIELD, CREATION_TIME_FIELD, DEPLOYMENT_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String frameworkName;
    private final String frameworkArn;
    private final String frameworkDescription;
    private final Integer numberOfControls;
    private final Instant creationTime;
    private final String deploymentStatus;

    private Framework(BuilderImpl builder) {
        this.frameworkName = builder.frameworkName;
        this.frameworkArn = builder.frameworkArn;
        this.frameworkDescription = builder.frameworkDescription;
        this.numberOfControls = builder.numberOfControls;
        this.creationTime = builder.creationTime;
        this.deploymentStatus = builder.deploymentStatus;
    }

    public final String frameworkName() {
        return this.frameworkName;
    }

    public final String frameworkArn() {
        return this.frameworkArn;
    }

    public final String frameworkDescription() {
        return this.frameworkDescription;
    }

    public final Integer numberOfControls() {
        return this.numberOfControls;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String deploymentStatus() {
        return this.deploymentStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.frameworkName());
        hashCode = 31 * hashCode + Objects.hashCode(this.frameworkArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.frameworkDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfControls());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentStatus());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Framework)) {
            return false;
        }
        Framework other = (Framework)obj;
        return Objects.equals(this.frameworkName(), other.frameworkName()) && Objects.equals(this.frameworkArn(), other.frameworkArn()) && Objects.equals(this.frameworkDescription(), other.frameworkDescription()) && Objects.equals(this.numberOfControls(), other.numberOfControls()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.deploymentStatus(), other.deploymentStatus());
    }

    public final String toString() {
        return ToString.builder((String)"Framework").add("FrameworkName", (Object)this.frameworkName()).add("FrameworkArn", (Object)this.frameworkArn()).add("FrameworkDescription", (Object)this.frameworkDescription()).add("NumberOfControls", (Object)this.numberOfControls()).add("CreationTime", (Object)this.creationTime()).add("DeploymentStatus", (Object)this.deploymentStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FrameworkName": {
                return Optional.ofNullable(clazz.cast(this.frameworkName()));
            }
            case "FrameworkArn": {
                return Optional.ofNullable(clazz.cast(this.frameworkArn()));
            }
            case "FrameworkDescription": {
                return Optional.ofNullable(clazz.cast(this.frameworkDescription()));
            }
            case "NumberOfControls": {
                return Optional.ofNullable(clazz.cast(this.numberOfControls()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "DeploymentStatus": {
                return Optional.ofNullable(clazz.cast(this.deploymentStatus()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Framework, T> g) {
        return obj -> g.apply((Framework)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String frameworkName;
        private String frameworkArn;
        private String frameworkDescription;
        private Integer numberOfControls;
        private Instant creationTime;
        private String deploymentStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(Framework model) {
            this.frameworkName(model.frameworkName);
            this.frameworkArn(model.frameworkArn);
            this.frameworkDescription(model.frameworkDescription);
            this.numberOfControls(model.numberOfControls);
            this.creationTime(model.creationTime);
            this.deploymentStatus(model.deploymentStatus);
        }

        public final String getFrameworkName() {
            return this.frameworkName;
        }

        public final void setFrameworkName(String frameworkName) {
            this.frameworkName = frameworkName;
        }

        @Override
        @Transient
        public final Builder frameworkName(String frameworkName) {
            this.frameworkName = frameworkName;
            return this;
        }

        public final String getFrameworkArn() {
            return this.frameworkArn;
        }

        public final void setFrameworkArn(String frameworkArn) {
            this.frameworkArn = frameworkArn;
        }

        @Override
        @Transient
        public final Builder frameworkArn(String frameworkArn) {
            this.frameworkArn = frameworkArn;
            return this;
        }

        public final String getFrameworkDescription() {
            return this.frameworkDescription;
        }

        public final void setFrameworkDescription(String frameworkDescription) {
            this.frameworkDescription = frameworkDescription;
        }

        @Override
        @Transient
        public final Builder frameworkDescription(String frameworkDescription) {
            this.frameworkDescription = frameworkDescription;
            return this;
        }

        public final Integer getNumberOfControls() {
            return this.numberOfControls;
        }

        public final void setNumberOfControls(Integer numberOfControls) {
            this.numberOfControls = numberOfControls;
        }

        @Override
        @Transient
        public final Builder numberOfControls(Integer numberOfControls) {
            this.numberOfControls = numberOfControls;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        @Transient
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getDeploymentStatus() {
            return this.deploymentStatus;
        }

        public final void setDeploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
        }

        @Override
        @Transient
        public final Builder deploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
            return this;
        }

        public Framework build() {
            return new Framework(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Framework> {
        public Builder frameworkName(String var1);

        public Builder frameworkArn(String var1);

        public Builder frameworkDescription(String var1);

        public Builder numberOfControls(Integer var1);

        public Builder creationTime(Instant var1);

        public Builder deploymentStatus(String var1);
    }
}

