/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backup.model.BackupResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateBackupSelectionResponse
extends BackupResponse
implements ToCopyableBuilder<Builder, CreateBackupSelectionResponse> {
    private static final SdkField<String> SELECTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SelectionId").getter(CreateBackupSelectionResponse.getter(CreateBackupSelectionResponse::selectionId)).setter(CreateBackupSelectionResponse.setter(Builder::selectionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectionId").build()}).build();
    private static final SdkField<String> BACKUP_PLAN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupPlanId").getter(CreateBackupSelectionResponse.getter(CreateBackupSelectionResponse::backupPlanId)).setter(CreateBackupSelectionResponse.setter(Builder::backupPlanId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupPlanId").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationDate").getter(CreateBackupSelectionResponse.getter(CreateBackupSelectionResponse::creationDate)).setter(CreateBackupSelectionResponse.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SELECTION_ID_FIELD, BACKUP_PLAN_ID_FIELD, CREATION_DATE_FIELD));
    private final String selectionId;
    private final String backupPlanId;
    private final Instant creationDate;

    private CreateBackupSelectionResponse(BuilderImpl builder) {
        super(builder);
        this.selectionId = builder.selectionId;
        this.backupPlanId = builder.backupPlanId;
        this.creationDate = builder.creationDate;
    }

    public final String selectionId() {
        return this.selectionId;
    }

    public final String backupPlanId() {
        return this.backupPlanId;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.selectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupPlanId());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBackupSelectionResponse)) {
            return false;
        }
        CreateBackupSelectionResponse other = (CreateBackupSelectionResponse)((Object)obj);
        return Objects.equals(this.selectionId(), other.selectionId()) && Objects.equals(this.backupPlanId(), other.backupPlanId()) && Objects.equals(this.creationDate(), other.creationDate());
    }

    public final String toString() {
        return ToString.builder((String)"CreateBackupSelectionResponse").add("SelectionId", (Object)this.selectionId()).add("BackupPlanId", (Object)this.backupPlanId()).add("CreationDate", (Object)this.creationDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SelectionId": {
                return Optional.ofNullable(clazz.cast(this.selectionId()));
            }
            case "BackupPlanId": {
                return Optional.ofNullable(clazz.cast(this.backupPlanId()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateBackupSelectionResponse, T> g) {
        return obj -> g.apply((CreateBackupSelectionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupResponse.BuilderImpl
    implements Builder {
        private String selectionId;
        private String backupPlanId;
        private Instant creationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBackupSelectionResponse model) {
            super(model);
            this.selectionId(model.selectionId);
            this.backupPlanId(model.backupPlanId);
            this.creationDate(model.creationDate);
        }

        public final String getSelectionId() {
            return this.selectionId;
        }

        public final void setSelectionId(String selectionId) {
            this.selectionId = selectionId;
        }

        @Override
        @Transient
        public final Builder selectionId(String selectionId) {
            this.selectionId = selectionId;
            return this;
        }

        public final String getBackupPlanId() {
            return this.backupPlanId;
        }

        public final void setBackupPlanId(String backupPlanId) {
            this.backupPlanId = backupPlanId;
        }

        @Override
        @Transient
        public final Builder backupPlanId(String backupPlanId) {
            this.backupPlanId = backupPlanId;
            return this;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        @Transient
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        @Override
        public CreateBackupSelectionResponse build() {
            return new CreateBackupSelectionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BackupResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateBackupSelectionResponse> {
        public Builder selectionId(String var1);

        public Builder backupPlanId(String var1);

        public Builder creationDate(Instant var1);
    }
}

