/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscalingplans.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.autoscalingplans.model.ScalableDimension;
import software.amazon.awssdk.services.autoscalingplans.model.ScalingPoliciesCopier;
import software.amazon.awssdk.services.autoscalingplans.model.ScalingPolicy;
import software.amazon.awssdk.services.autoscalingplans.model.ScalingStatusCode;
import software.amazon.awssdk.services.autoscalingplans.model.ServiceNamespace;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScalingPlanResource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ScalingPlanResource> {
    private static final SdkField<String> SCALING_PLAN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScalingPlanName").getter(ScalingPlanResource.getter(ScalingPlanResource::scalingPlanName)).setter(ScalingPlanResource.setter(Builder::scalingPlanName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingPlanName").build()}).build();
    private static final SdkField<Long> SCALING_PLAN_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ScalingPlanVersion").getter(ScalingPlanResource.getter(ScalingPlanResource::scalingPlanVersion)).setter(ScalingPlanResource.setter(Builder::scalingPlanVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingPlanVersion").build()}).build();
    private static final SdkField<String> SERVICE_NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceNamespace").getter(ScalingPlanResource.getter(ScalingPlanResource::serviceNamespaceAsString)).setter(ScalingPlanResource.setter(Builder::serviceNamespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceNamespace").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(ScalingPlanResource.getter(ScalingPlanResource::resourceId)).setter(ScalingPlanResource.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()}).build();
    private static final SdkField<String> SCALABLE_DIMENSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScalableDimension").getter(ScalingPlanResource.getter(ScalingPlanResource::scalableDimensionAsString)).setter(ScalingPlanResource.setter(Builder::scalableDimension)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalableDimension").build()}).build();
    private static final SdkField<List<ScalingPolicy>> SCALING_POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ScalingPolicies").getter(ScalingPlanResource.getter(ScalingPlanResource::scalingPolicies)).setter(ScalingPlanResource.setter(Builder::scalingPolicies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingPolicies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ScalingPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SCALING_STATUS_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScalingStatusCode").getter(ScalingPlanResource.getter(ScalingPlanResource::scalingStatusCodeAsString)).setter(ScalingPlanResource.setter(Builder::scalingStatusCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingStatusCode").build()}).build();
    private static final SdkField<String> SCALING_STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScalingStatusMessage").getter(ScalingPlanResource.getter(ScalingPlanResource::scalingStatusMessage)).setter(ScalingPlanResource.setter(Builder::scalingStatusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingStatusMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCALING_PLAN_NAME_FIELD, SCALING_PLAN_VERSION_FIELD, SERVICE_NAMESPACE_FIELD, RESOURCE_ID_FIELD, SCALABLE_DIMENSION_FIELD, SCALING_POLICIES_FIELD, SCALING_STATUS_CODE_FIELD, SCALING_STATUS_MESSAGE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String scalingPlanName;
    private final Long scalingPlanVersion;
    private final String serviceNamespace;
    private final String resourceId;
    private final String scalableDimension;
    private final List<ScalingPolicy> scalingPolicies;
    private final String scalingStatusCode;
    private final String scalingStatusMessage;

    private ScalingPlanResource(BuilderImpl builder) {
        this.scalingPlanName = builder.scalingPlanName;
        this.scalingPlanVersion = builder.scalingPlanVersion;
        this.serviceNamespace = builder.serviceNamespace;
        this.resourceId = builder.resourceId;
        this.scalableDimension = builder.scalableDimension;
        this.scalingPolicies = builder.scalingPolicies;
        this.scalingStatusCode = builder.scalingStatusCode;
        this.scalingStatusMessage = builder.scalingStatusMessage;
    }

    public final String scalingPlanName() {
        return this.scalingPlanName;
    }

    public final Long scalingPlanVersion() {
        return this.scalingPlanVersion;
    }

    public final ServiceNamespace serviceNamespace() {
        return ServiceNamespace.fromValue(this.serviceNamespace);
    }

    public final String serviceNamespaceAsString() {
        return this.serviceNamespace;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final ScalableDimension scalableDimension() {
        return ScalableDimension.fromValue(this.scalableDimension);
    }

    public final String scalableDimensionAsString() {
        return this.scalableDimension;
    }

    public final boolean hasScalingPolicies() {
        return this.scalingPolicies != null && !(this.scalingPolicies instanceof SdkAutoConstructList);
    }

    public final List<ScalingPolicy> scalingPolicies() {
        return this.scalingPolicies;
    }

    public final ScalingStatusCode scalingStatusCode() {
        return ScalingStatusCode.fromValue(this.scalingStatusCode);
    }

    public final String scalingStatusCodeAsString() {
        return this.scalingStatusCode;
    }

    public final String scalingStatusMessage() {
        return this.scalingStatusMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingPlanName());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingPlanVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceNamespaceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalableDimensionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScalingPolicies() ? this.scalingPolicies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingStatusCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingStatusMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScalingPlanResource)) {
            return false;
        }
        ScalingPlanResource other = (ScalingPlanResource)obj;
        return Objects.equals(this.scalingPlanName(), other.scalingPlanName()) && Objects.equals(this.scalingPlanVersion(), other.scalingPlanVersion()) && Objects.equals(this.serviceNamespaceAsString(), other.serviceNamespaceAsString()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.scalableDimensionAsString(), other.scalableDimensionAsString()) && this.hasScalingPolicies() == other.hasScalingPolicies() && Objects.equals(this.scalingPolicies(), other.scalingPolicies()) && Objects.equals(this.scalingStatusCodeAsString(), other.scalingStatusCodeAsString()) && Objects.equals(this.scalingStatusMessage(), other.scalingStatusMessage());
    }

    public final String toString() {
        return ToString.builder((String)"ScalingPlanResource").add("ScalingPlanName", (Object)this.scalingPlanName()).add("ScalingPlanVersion", (Object)this.scalingPlanVersion()).add("ServiceNamespace", (Object)this.serviceNamespaceAsString()).add("ResourceId", (Object)this.resourceId()).add("ScalableDimension", (Object)this.scalableDimensionAsString()).add("ScalingPolicies", this.hasScalingPolicies() ? this.scalingPolicies() : null).add("ScalingStatusCode", (Object)this.scalingStatusCodeAsString()).add("ScalingStatusMessage", (Object)this.scalingStatusMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ScalingPlanName": {
                return Optional.ofNullable(clazz.cast(this.scalingPlanName()));
            }
            case "ScalingPlanVersion": {
                return Optional.ofNullable(clazz.cast(this.scalingPlanVersion()));
            }
            case "ServiceNamespace": {
                return Optional.ofNullable(clazz.cast(this.serviceNamespaceAsString()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "ScalableDimension": {
                return Optional.ofNullable(clazz.cast(this.scalableDimensionAsString()));
            }
            case "ScalingPolicies": {
                return Optional.ofNullable(clazz.cast(this.scalingPolicies()));
            }
            case "ScalingStatusCode": {
                return Optional.ofNullable(clazz.cast(this.scalingStatusCodeAsString()));
            }
            case "ScalingStatusMessage": {
                return Optional.ofNullable(clazz.cast(this.scalingStatusMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScalingPlanResource, T> g) {
        return obj -> g.apply((ScalingPlanResource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String scalingPlanName;
        private Long scalingPlanVersion;
        private String serviceNamespace;
        private String resourceId;
        private String scalableDimension;
        private List<ScalingPolicy> scalingPolicies = DefaultSdkAutoConstructList.getInstance();
        private String scalingStatusCode;
        private String scalingStatusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(ScalingPlanResource model) {
            this.scalingPlanName(model.scalingPlanName);
            this.scalingPlanVersion(model.scalingPlanVersion);
            this.serviceNamespace(model.serviceNamespace);
            this.resourceId(model.resourceId);
            this.scalableDimension(model.scalableDimension);
            this.scalingPolicies(model.scalingPolicies);
            this.scalingStatusCode(model.scalingStatusCode);
            this.scalingStatusMessage(model.scalingStatusMessage);
        }

        public final String getScalingPlanName() {
            return this.scalingPlanName;
        }

        public final void setScalingPlanName(String scalingPlanName) {
            this.scalingPlanName = scalingPlanName;
        }

        @Override
        public final Builder scalingPlanName(String scalingPlanName) {
            this.scalingPlanName = scalingPlanName;
            return this;
        }

        public final Long getScalingPlanVersion() {
            return this.scalingPlanVersion;
        }

        public final void setScalingPlanVersion(Long scalingPlanVersion) {
            this.scalingPlanVersion = scalingPlanVersion;
        }

        @Override
        public final Builder scalingPlanVersion(Long scalingPlanVersion) {
            this.scalingPlanVersion = scalingPlanVersion;
            return this;
        }

        public final String getServiceNamespace() {
            return this.serviceNamespace;
        }

        public final void setServiceNamespace(String serviceNamespace) {
            this.serviceNamespace = serviceNamespace;
        }

        @Override
        public final Builder serviceNamespace(String serviceNamespace) {
            this.serviceNamespace = serviceNamespace;
            return this;
        }

        @Override
        public final Builder serviceNamespace(ServiceNamespace serviceNamespace) {
            this.serviceNamespace(serviceNamespace == null ? null : serviceNamespace.toString());
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getScalableDimension() {
            return this.scalableDimension;
        }

        public final void setScalableDimension(String scalableDimension) {
            this.scalableDimension = scalableDimension;
        }

        @Override
        public final Builder scalableDimension(String scalableDimension) {
            this.scalableDimension = scalableDimension;
            return this;
        }

        @Override
        public final Builder scalableDimension(ScalableDimension scalableDimension) {
            this.scalableDimension(scalableDimension == null ? null : scalableDimension.toString());
            return this;
        }

        public final List<ScalingPolicy.Builder> getScalingPolicies() {
            List<ScalingPolicy.Builder> result = ScalingPoliciesCopier.copyToBuilder(this.scalingPolicies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScalingPolicies(Collection<ScalingPolicy.BuilderImpl> scalingPolicies) {
            this.scalingPolicies = ScalingPoliciesCopier.copyFromBuilder(scalingPolicies);
        }

        @Override
        public final Builder scalingPolicies(Collection<ScalingPolicy> scalingPolicies) {
            this.scalingPolicies = ScalingPoliciesCopier.copy(scalingPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scalingPolicies(ScalingPolicy ... scalingPolicies) {
            this.scalingPolicies(Arrays.asList(scalingPolicies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scalingPolicies(Consumer<ScalingPolicy.Builder> ... scalingPolicies) {
            this.scalingPolicies(Stream.of(scalingPolicies).map(c -> (ScalingPolicy)((ScalingPolicy.Builder)ScalingPolicy.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getScalingStatusCode() {
            return this.scalingStatusCode;
        }

        public final void setScalingStatusCode(String scalingStatusCode) {
            this.scalingStatusCode = scalingStatusCode;
        }

        @Override
        public final Builder scalingStatusCode(String scalingStatusCode) {
            this.scalingStatusCode = scalingStatusCode;
            return this;
        }

        @Override
        public final Builder scalingStatusCode(ScalingStatusCode scalingStatusCode) {
            this.scalingStatusCode(scalingStatusCode == null ? null : scalingStatusCode.toString());
            return this;
        }

        public final String getScalingStatusMessage() {
            return this.scalingStatusMessage;
        }

        public final void setScalingStatusMessage(String scalingStatusMessage) {
            this.scalingStatusMessage = scalingStatusMessage;
        }

        @Override
        public final Builder scalingStatusMessage(String scalingStatusMessage) {
            this.scalingStatusMessage = scalingStatusMessage;
            return this;
        }

        public ScalingPlanResource build() {
            return new ScalingPlanResource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ScalingPlanResource> {
        public Builder scalingPlanName(String var1);

        public Builder scalingPlanVersion(Long var1);

        public Builder serviceNamespace(String var1);

        public Builder serviceNamespace(ServiceNamespace var1);

        public Builder resourceId(String var1);

        public Builder scalableDimension(String var1);

        public Builder scalableDimension(ScalableDimension var1);

        public Builder scalingPolicies(Collection<ScalingPolicy> var1);

        public Builder scalingPolicies(ScalingPolicy ... var1);

        public Builder scalingPolicies(Consumer<ScalingPolicy.Builder> ... var1);

        public Builder scalingStatusCode(String var1);

        public Builder scalingStatusCode(ScalingStatusCode var1);

        public Builder scalingStatusMessage(String var1);
    }
}

