/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTerminationPolicyTypesResponse extends AutoScalingResponse implements
        ToCopyableBuilder<DescribeTerminationPolicyTypesResponse.Builder, DescribeTerminationPolicyTypesResponse> {
    private static final SdkField<List<String>> TERMINATION_POLICY_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TerminationPolicyTypes")
            .getter(getter(DescribeTerminationPolicyTypesResponse::terminationPolicyTypes))
            .setter(setter(Builder::terminationPolicyTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminationPolicyTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(TERMINATION_POLICY_TYPES_FIELD));

    private final List<String> terminationPolicyTypes;

    private DescribeTerminationPolicyTypesResponse(BuilderImpl builder) {
        super(builder);
        this.terminationPolicyTypes = builder.terminationPolicyTypes;
    }

    /**
     * For responses, this returns true if the service returned a value for the TerminationPolicyTypes property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasTerminationPolicyTypes() {
        return terminationPolicyTypes != null && !(terminationPolicyTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The termination policies supported by Amazon EC2 Auto Scaling: <code>OldestInstance</code>,
     * <code>OldestLaunchConfiguration</code>, <code>NewestInstance</code>, <code>ClosestToNextInstanceHour</code>,
     * <code>Default</code>, <code>OldestLaunchTemplate</code>, and <code>AllocationStrategy</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTerminationPolicyTypes} method.
     * </p>
     * 
     * @return The termination policies supported by Amazon EC2 Auto Scaling: <code>OldestInstance</code>,
     *         <code>OldestLaunchConfiguration</code>, <code>NewestInstance</code>,
     *         <code>ClosestToNextInstanceHour</code>, <code>Default</code>, <code>OldestLaunchTemplate</code>, and
     *         <code>AllocationStrategy</code>.
     */
    public final List<String> terminationPolicyTypes() {
        return terminationPolicyTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTerminationPolicyTypes() ? terminationPolicyTypes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTerminationPolicyTypesResponse)) {
            return false;
        }
        DescribeTerminationPolicyTypesResponse other = (DescribeTerminationPolicyTypesResponse) obj;
        return hasTerminationPolicyTypes() == other.hasTerminationPolicyTypes()
                && Objects.equals(terminationPolicyTypes(), other.terminationPolicyTypes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeTerminationPolicyTypesResponse")
                .add("TerminationPolicyTypes", hasTerminationPolicyTypes() ? terminationPolicyTypes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TerminationPolicyTypes":
            return Optional.ofNullable(clazz.cast(terminationPolicyTypes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTerminationPolicyTypesResponse, T> g) {
        return obj -> g.apply((DescribeTerminationPolicyTypesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AutoScalingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeTerminationPolicyTypesResponse> {
        /**
         * <p>
         * The termination policies supported by Amazon EC2 Auto Scaling: <code>OldestInstance</code>,
         * <code>OldestLaunchConfiguration</code>, <code>NewestInstance</code>, <code>ClosestToNextInstanceHour</code>,
         * <code>Default</code>, <code>OldestLaunchTemplate</code>, and <code>AllocationStrategy</code>.
         * </p>
         * 
         * @param terminationPolicyTypes
         *        The termination policies supported by Amazon EC2 Auto Scaling: <code>OldestInstance</code>,
         *        <code>OldestLaunchConfiguration</code>, <code>NewestInstance</code>,
         *        <code>ClosestToNextInstanceHour</code>, <code>Default</code>, <code>OldestLaunchTemplate</code>, and
         *        <code>AllocationStrategy</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminationPolicyTypes(Collection<String> terminationPolicyTypes);

        /**
         * <p>
         * The termination policies supported by Amazon EC2 Auto Scaling: <code>OldestInstance</code>,
         * <code>OldestLaunchConfiguration</code>, <code>NewestInstance</code>, <code>ClosestToNextInstanceHour</code>,
         * <code>Default</code>, <code>OldestLaunchTemplate</code>, and <code>AllocationStrategy</code>.
         * </p>
         * 
         * @param terminationPolicyTypes
         *        The termination policies supported by Amazon EC2 Auto Scaling: <code>OldestInstance</code>,
         *        <code>OldestLaunchConfiguration</code>, <code>NewestInstance</code>,
         *        <code>ClosestToNextInstanceHour</code>, <code>Default</code>, <code>OldestLaunchTemplate</code>, and
         *        <code>AllocationStrategy</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminationPolicyTypes(String... terminationPolicyTypes);
    }

    static final class BuilderImpl extends AutoScalingResponse.BuilderImpl implements Builder {
        private List<String> terminationPolicyTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTerminationPolicyTypesResponse model) {
            super(model);
            terminationPolicyTypes(model.terminationPolicyTypes);
        }

        public final Collection<String> getTerminationPolicyTypes() {
            if (terminationPolicyTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return terminationPolicyTypes;
        }

        public final void setTerminationPolicyTypes(Collection<String> terminationPolicyTypes) {
            this.terminationPolicyTypes = TerminationPoliciesCopier.copy(terminationPolicyTypes);
        }

        @Override
        public final Builder terminationPolicyTypes(Collection<String> terminationPolicyTypes) {
            this.terminationPolicyTypes = TerminationPoliciesCopier.copy(terminationPolicyTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder terminationPolicyTypes(String... terminationPolicyTypes) {
            terminationPolicyTypes(Arrays.asList(terminationPolicyTypes));
            return this;
        }

        @Override
        public DescribeTerminationPolicyTypesResponse build() {
            return new DescribeTerminationPolicyTypesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
