/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingGroup;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingGroupsCopier;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAutoScalingGroupsResponse
extends AutoScalingResponse
implements ToCopyableBuilder<Builder, DescribeAutoScalingGroupsResponse> {
    private static final SdkField<List<AutoScalingGroup>> AUTO_SCALING_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AutoScalingGroups").getter(DescribeAutoScalingGroupsResponse.getter(DescribeAutoScalingGroupsResponse::autoScalingGroups)).setter(DescribeAutoScalingGroupsResponse.setter(Builder::autoScalingGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AutoScalingGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeAutoScalingGroupsResponse.getter(DescribeAutoScalingGroupsResponse::nextToken)).setter(DescribeAutoScalingGroupsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_SCALING_GROUPS_FIELD, NEXT_TOKEN_FIELD));
    private final List<AutoScalingGroup> autoScalingGroups;
    private final String nextToken;

    private DescribeAutoScalingGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.autoScalingGroups = builder.autoScalingGroups;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAutoScalingGroups() {
        return this.autoScalingGroups != null && !(this.autoScalingGroups instanceof SdkAutoConstructList);
    }

    public final List<AutoScalingGroup> autoScalingGroups() {
        return this.autoScalingGroups;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAutoScalingGroups() ? this.autoScalingGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAutoScalingGroupsResponse)) {
            return false;
        }
        DescribeAutoScalingGroupsResponse other = (DescribeAutoScalingGroupsResponse)((Object)obj);
        return this.hasAutoScalingGroups() == other.hasAutoScalingGroups() && Objects.equals(this.autoScalingGroups(), other.autoScalingGroups()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAutoScalingGroupsResponse").add("AutoScalingGroups", this.hasAutoScalingGroups() ? this.autoScalingGroups() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoScalingGroups": {
                return Optional.ofNullable(clazz.cast(this.autoScalingGroups()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAutoScalingGroupsResponse, T> g) {
        return obj -> g.apply((DescribeAutoScalingGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AutoScalingResponse.BuilderImpl
    implements Builder {
        private List<AutoScalingGroup> autoScalingGroups = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAutoScalingGroupsResponse model) {
            super(model);
            this.autoScalingGroups(model.autoScalingGroups);
            this.nextToken(model.nextToken);
        }

        public final List<AutoScalingGroup.Builder> getAutoScalingGroups() {
            List<AutoScalingGroup.Builder> result = AutoScalingGroupsCopier.copyToBuilder(this.autoScalingGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAutoScalingGroups(Collection<AutoScalingGroup.BuilderImpl> autoScalingGroups) {
            this.autoScalingGroups = AutoScalingGroupsCopier.copyFromBuilder(autoScalingGroups);
        }

        @Override
        public final Builder autoScalingGroups(Collection<AutoScalingGroup> autoScalingGroups) {
            this.autoScalingGroups = AutoScalingGroupsCopier.copy(autoScalingGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoScalingGroups(AutoScalingGroup ... autoScalingGroups) {
            this.autoScalingGroups(Arrays.asList(autoScalingGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoScalingGroups(Consumer<AutoScalingGroup.Builder> ... autoScalingGroups) {
            this.autoScalingGroups(Stream.of(autoScalingGroups).map(c -> (AutoScalingGroup)((AutoScalingGroup.Builder)AutoScalingGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeAutoScalingGroupsResponse build() {
            return new DescribeAutoScalingGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AutoScalingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAutoScalingGroupsResponse> {
        public Builder autoScalingGroups(Collection<AutoScalingGroup> var1);

        public Builder autoScalingGroups(AutoScalingGroup ... var1);

        public Builder autoScalingGroups(Consumer<AutoScalingGroup.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

