/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ScalingActivityStatusCode {
    PENDING_SPOT_BID_PLACEMENT("PendingSpotBidPlacement"),
    WAITING_FOR_SPOT_INSTANCE_REQUEST_ID("WaitingForSpotInstanceRequestId"),
    WAITING_FOR_SPOT_INSTANCE_ID("WaitingForSpotInstanceId"),
    WAITING_FOR_INSTANCE_ID("WaitingForInstanceId"),
    PRE_IN_SERVICE("PreInService"),
    IN_PROGRESS("InProgress"),
    WAITING_FOR_ELB_CONNECTION_DRAINING("WaitingForELBConnectionDraining"),
    MID_LIFECYCLE_ACTION("MidLifecycleAction"),
    WAITING_FOR_INSTANCE_WARMUP("WaitingForInstanceWarmup"),
    SUCCESSFUL("Successful"),
    FAILED("Failed"),
    CANCELLED("Cancelled"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ScalingActivityStatusCode> VALUE_MAP;
    private final String value;

    private ScalingActivityStatusCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ScalingActivityStatusCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ScalingActivityStatusCode> knownValues() {
        EnumSet<ScalingActivityStatusCode> knownValues = EnumSet.allOf(ScalingActivityStatusCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ScalingActivityStatusCode.class, ScalingActivityStatusCode::toString);
    }
}

