/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingRequest;
import software.amazon.awssdk.services.autoscaling.model.InstanceReusePolicy;
import software.amazon.awssdk.services.autoscaling.model.WarmPoolState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutWarmPoolRequest
extends AutoScalingRequest
implements ToCopyableBuilder<Builder, PutWarmPoolRequest> {
    private static final SdkField<String> AUTO_SCALING_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoScalingGroupName").getter(PutWarmPoolRequest.getter(PutWarmPoolRequest::autoScalingGroupName)).setter(PutWarmPoolRequest.setter(Builder::autoScalingGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingGroupName").build()}).build();
    private static final SdkField<Integer> MAX_GROUP_PREPARED_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxGroupPreparedCapacity").getter(PutWarmPoolRequest.getter(PutWarmPoolRequest::maxGroupPreparedCapacity)).setter(PutWarmPoolRequest.setter(Builder::maxGroupPreparedCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxGroupPreparedCapacity").build()}).build();
    private static final SdkField<Integer> MIN_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinSize").getter(PutWarmPoolRequest.getter(PutWarmPoolRequest::minSize)).setter(PutWarmPoolRequest.setter(Builder::minSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinSize").build()}).build();
    private static final SdkField<String> POOL_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PoolState").getter(PutWarmPoolRequest.getter(PutWarmPoolRequest::poolStateAsString)).setter(PutWarmPoolRequest.setter(Builder::poolState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolState").build()}).build();
    private static final SdkField<InstanceReusePolicy> INSTANCE_REUSE_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InstanceReusePolicy").getter(PutWarmPoolRequest.getter(PutWarmPoolRequest::instanceReusePolicy)).setter(PutWarmPoolRequest.setter(Builder::instanceReusePolicy)).constructor(InstanceReusePolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceReusePolicy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_SCALING_GROUP_NAME_FIELD, MAX_GROUP_PREPARED_CAPACITY_FIELD, MIN_SIZE_FIELD, POOL_STATE_FIELD, INSTANCE_REUSE_POLICY_FIELD));
    private final String autoScalingGroupName;
    private final Integer maxGroupPreparedCapacity;
    private final Integer minSize;
    private final String poolState;
    private final InstanceReusePolicy instanceReusePolicy;

    private PutWarmPoolRequest(BuilderImpl builder) {
        super(builder);
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.maxGroupPreparedCapacity = builder.maxGroupPreparedCapacity;
        this.minSize = builder.minSize;
        this.poolState = builder.poolState;
        this.instanceReusePolicy = builder.instanceReusePolicy;
    }

    public final String autoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public final Integer maxGroupPreparedCapacity() {
        return this.maxGroupPreparedCapacity;
    }

    public final Integer minSize() {
        return this.minSize;
    }

    public final WarmPoolState poolState() {
        return WarmPoolState.fromValue(this.poolState);
    }

    public final String poolStateAsString() {
        return this.poolState;
    }

    public final InstanceReusePolicy instanceReusePolicy() {
        return this.instanceReusePolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxGroupPreparedCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.minSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.poolStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceReusePolicy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutWarmPoolRequest)) {
            return false;
        }
        PutWarmPoolRequest other = (PutWarmPoolRequest)((Object)obj);
        return Objects.equals(this.autoScalingGroupName(), other.autoScalingGroupName()) && Objects.equals(this.maxGroupPreparedCapacity(), other.maxGroupPreparedCapacity()) && Objects.equals(this.minSize(), other.minSize()) && Objects.equals(this.poolStateAsString(), other.poolStateAsString()) && Objects.equals(this.instanceReusePolicy(), other.instanceReusePolicy());
    }

    public final String toString() {
        return ToString.builder((String)"PutWarmPoolRequest").add("AutoScalingGroupName", (Object)this.autoScalingGroupName()).add("MaxGroupPreparedCapacity", (Object)this.maxGroupPreparedCapacity()).add("MinSize", (Object)this.minSize()).add("PoolState", (Object)this.poolStateAsString()).add("InstanceReusePolicy", (Object)this.instanceReusePolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoScalingGroupName": {
                return Optional.ofNullable(clazz.cast(this.autoScalingGroupName()));
            }
            case "MaxGroupPreparedCapacity": {
                return Optional.ofNullable(clazz.cast(this.maxGroupPreparedCapacity()));
            }
            case "MinSize": {
                return Optional.ofNullable(clazz.cast(this.minSize()));
            }
            case "PoolState": {
                return Optional.ofNullable(clazz.cast(this.poolStateAsString()));
            }
            case "InstanceReusePolicy": {
                return Optional.ofNullable(clazz.cast(this.instanceReusePolicy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutWarmPoolRequest, T> g) {
        return obj -> g.apply((PutWarmPoolRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AutoScalingRequest.BuilderImpl
    implements Builder {
        private String autoScalingGroupName;
        private Integer maxGroupPreparedCapacity;
        private Integer minSize;
        private String poolState;
        private InstanceReusePolicy instanceReusePolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(PutWarmPoolRequest model) {
            super(model);
            this.autoScalingGroupName(model.autoScalingGroupName);
            this.maxGroupPreparedCapacity(model.maxGroupPreparedCapacity);
            this.minSize(model.minSize);
            this.poolState(model.poolState);
            this.instanceReusePolicy(model.instanceReusePolicy);
        }

        public final String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final Integer getMaxGroupPreparedCapacity() {
            return this.maxGroupPreparedCapacity;
        }

        public final void setMaxGroupPreparedCapacity(Integer maxGroupPreparedCapacity) {
            this.maxGroupPreparedCapacity = maxGroupPreparedCapacity;
        }

        @Override
        public final Builder maxGroupPreparedCapacity(Integer maxGroupPreparedCapacity) {
            this.maxGroupPreparedCapacity = maxGroupPreparedCapacity;
            return this;
        }

        public final Integer getMinSize() {
            return this.minSize;
        }

        public final void setMinSize(Integer minSize) {
            this.minSize = minSize;
        }

        @Override
        public final Builder minSize(Integer minSize) {
            this.minSize = minSize;
            return this;
        }

        public final String getPoolState() {
            return this.poolState;
        }

        public final void setPoolState(String poolState) {
            this.poolState = poolState;
        }

        @Override
        public final Builder poolState(String poolState) {
            this.poolState = poolState;
            return this;
        }

        @Override
        public final Builder poolState(WarmPoolState poolState) {
            this.poolState(poolState == null ? null : poolState.toString());
            return this;
        }

        public final InstanceReusePolicy.Builder getInstanceReusePolicy() {
            return this.instanceReusePolicy != null ? this.instanceReusePolicy.toBuilder() : null;
        }

        public final void setInstanceReusePolicy(InstanceReusePolicy.BuilderImpl instanceReusePolicy) {
            this.instanceReusePolicy = instanceReusePolicy != null ? instanceReusePolicy.build() : null;
        }

        @Override
        public final Builder instanceReusePolicy(InstanceReusePolicy instanceReusePolicy) {
            this.instanceReusePolicy = instanceReusePolicy;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutWarmPoolRequest build() {
            return new PutWarmPoolRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AutoScalingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutWarmPoolRequest> {
        public Builder autoScalingGroupName(String var1);

        public Builder maxGroupPreparedCapacity(Integer var1);

        public Builder minSize(Integer var1);

        public Builder poolState(String var1);

        public Builder poolState(WarmPoolState var1);

        public Builder instanceReusePolicy(InstanceReusePolicy var1);

        default public Builder instanceReusePolicy(Consumer<InstanceReusePolicy.Builder> instanceReusePolicy) {
            return this.instanceReusePolicy((InstanceReusePolicy)((InstanceReusePolicy.Builder)InstanceReusePolicy.builder().applyMutation(instanceReusePolicy)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

