/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.autoscaling.model.AdjustmentType;
import software.amazon.awssdk.services.autoscaling.model.AdjustmentTypesCopier;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAdjustmentTypesResponse
extends AutoScalingResponse
implements ToCopyableBuilder<Builder, DescribeAdjustmentTypesResponse> {
    private static final SdkField<List<AdjustmentType>> ADJUSTMENT_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdjustmentTypes").getter(DescribeAdjustmentTypesResponse.getter(DescribeAdjustmentTypesResponse::adjustmentTypes)).setter(DescribeAdjustmentTypesResponse.setter(Builder::adjustmentTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdjustmentTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AdjustmentType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADJUSTMENT_TYPES_FIELD));
    private final List<AdjustmentType> adjustmentTypes;

    private DescribeAdjustmentTypesResponse(BuilderImpl builder) {
        super(builder);
        this.adjustmentTypes = builder.adjustmentTypes;
    }

    public final boolean hasAdjustmentTypes() {
        return this.adjustmentTypes != null && !(this.adjustmentTypes instanceof SdkAutoConstructList);
    }

    public final List<AdjustmentType> adjustmentTypes() {
        return this.adjustmentTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdjustmentTypes() ? this.adjustmentTypes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAdjustmentTypesResponse)) {
            return false;
        }
        DescribeAdjustmentTypesResponse other = (DescribeAdjustmentTypesResponse)((Object)obj);
        return this.hasAdjustmentTypes() == other.hasAdjustmentTypes() && Objects.equals(this.adjustmentTypes(), other.adjustmentTypes());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAdjustmentTypesResponse").add("AdjustmentTypes", this.hasAdjustmentTypes() ? this.adjustmentTypes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdjustmentTypes": {
                return Optional.ofNullable(clazz.cast(this.adjustmentTypes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAdjustmentTypesResponse, T> g) {
        return obj -> g.apply((DescribeAdjustmentTypesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AutoScalingResponse.BuilderImpl
    implements Builder {
        private List<AdjustmentType> adjustmentTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAdjustmentTypesResponse model) {
            super(model);
            this.adjustmentTypes(model.adjustmentTypes);
        }

        public final List<AdjustmentType.Builder> getAdjustmentTypes() {
            List<AdjustmentType.Builder> result = AdjustmentTypesCopier.copyToBuilder(this.adjustmentTypes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdjustmentTypes(Collection<AdjustmentType.BuilderImpl> adjustmentTypes) {
            this.adjustmentTypes = AdjustmentTypesCopier.copyFromBuilder(adjustmentTypes);
        }

        @Override
        public final Builder adjustmentTypes(Collection<AdjustmentType> adjustmentTypes) {
            this.adjustmentTypes = AdjustmentTypesCopier.copy(adjustmentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adjustmentTypes(AdjustmentType ... adjustmentTypes) {
            this.adjustmentTypes(Arrays.asList(adjustmentTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adjustmentTypes(Consumer<AdjustmentType.Builder> ... adjustmentTypes) {
            this.adjustmentTypes(Stream.of(adjustmentTypes).map(c -> (AdjustmentType)((AdjustmentType.Builder)AdjustmentType.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeAdjustmentTypesResponse build() {
            return new DescribeAdjustmentTypesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AutoScalingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAdjustmentTypesResponse> {
        public Builder adjustmentTypes(Collection<AdjustmentType> var1);

        public Builder adjustmentTypes(AdjustmentType ... var1);

        public Builder adjustmentTypes(Consumer<AdjustmentType.Builder> ... var1);
    }
}

