/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.auditmanager.AuditManagerAsyncClient;
import software.amazon.awssdk.services.auditmanager.internal.UserAgentUtils;
import software.amazon.awssdk.services.auditmanager.model.ListControlDomainInsightsRequest;
import software.amazon.awssdk.services.auditmanager.model.ListControlDomainInsightsResponse;

public class ListControlDomainInsightsPublisher
implements SdkPublisher<ListControlDomainInsightsResponse> {
    private final AuditManagerAsyncClient client;
    private final ListControlDomainInsightsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListControlDomainInsightsPublisher(AuditManagerAsyncClient client, ListControlDomainInsightsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListControlDomainInsightsPublisher(AuditManagerAsyncClient client, ListControlDomainInsightsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListControlDomainInsightsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListControlDomainInsightsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListControlDomainInsightsResponseFetcher
    implements AsyncPageFetcher<ListControlDomainInsightsResponse> {
        private ListControlDomainInsightsResponseFetcher() {
        }

        public boolean hasNextPage(ListControlDomainInsightsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListControlDomainInsightsResponse> nextPage(ListControlDomainInsightsResponse previousPage) {
            if (previousPage == null) {
                return ListControlDomainInsightsPublisher.this.client.listControlDomainInsights(ListControlDomainInsightsPublisher.this.firstRequest);
            }
            return ListControlDomainInsightsPublisher.this.client.listControlDomainInsights((ListControlDomainInsightsRequest)((Object)ListControlDomainInsightsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

