/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteAssessmentFrameworkShareRequest extends AuditManagerRequest implements
        ToCopyableBuilder<DeleteAssessmentFrameworkShareRequest.Builder, DeleteAssessmentFrameworkShareRequest> {
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("requestId").getter(getter(DeleteAssessmentFrameworkShareRequest::requestId))
            .setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("requestId").build()).build();

    private static final SdkField<String> REQUEST_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("requestType").getter(getter(DeleteAssessmentFrameworkShareRequest::requestTypeAsString))
            .setter(setter(Builder::requestType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("requestType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_ID_FIELD,
            REQUEST_TYPE_FIELD));

    private final String requestIdValue;

    private final String requestType;

    private DeleteAssessmentFrameworkShareRequest(BuilderImpl builder) {
        super(builder);
        this.requestIdValue = builder.requestIdValue;
        this.requestType = builder.requestType;
    }

    /**
     * <p>
     * The unique identifier for the share request to be deleted.
     * </p>
     * 
     * @return The unique identifier for the share request to be deleted.
     */
    public final String requestId() {
        return requestIdValue;
    }

    /**
     * <p>
     * Specifies whether the share request is a sent request or a received request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #requestType} will
     * return {@link ShareRequestType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #requestTypeAsString}.
     * </p>
     * 
     * @return Specifies whether the share request is a sent request or a received request.
     * @see ShareRequestType
     */
    public final ShareRequestType requestType() {
        return ShareRequestType.fromValue(requestType);
    }

    /**
     * <p>
     * Specifies whether the share request is a sent request or a received request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #requestType} will
     * return {@link ShareRequestType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #requestTypeAsString}.
     * </p>
     * 
     * @return Specifies whether the share request is a sent request or a received request.
     * @see ShareRequestType
     */
    public final String requestTypeAsString() {
        return requestType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(requestTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAssessmentFrameworkShareRequest)) {
            return false;
        }
        DeleteAssessmentFrameworkShareRequest other = (DeleteAssessmentFrameworkShareRequest) obj;
        return Objects.equals(requestId(), other.requestId())
                && Objects.equals(requestTypeAsString(), other.requestTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteAssessmentFrameworkShareRequest").add("RequestId", requestId())
                .add("RequestType", requestTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "requestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "requestType":
            return Optional.ofNullable(clazz.cast(requestTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteAssessmentFrameworkShareRequest, T> g) {
        return obj -> g.apply((DeleteAssessmentFrameworkShareRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AuditManagerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteAssessmentFrameworkShareRequest> {
        /**
         * <p>
         * The unique identifier for the share request to be deleted.
         * </p>
         * 
         * @param requestIdValue
         *        The unique identifier for the share request to be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestIdValue);

        /**
         * <p>
         * Specifies whether the share request is a sent request or a received request.
         * </p>
         * 
         * @param requestType
         *        Specifies whether the share request is a sent request or a received request.
         * @see ShareRequestType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShareRequestType
         */
        Builder requestType(String requestType);

        /**
         * <p>
         * Specifies whether the share request is a sent request or a received request.
         * </p>
         * 
         * @param requestType
         *        Specifies whether the share request is a sent request or a received request.
         * @see ShareRequestType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShareRequestType
         */
        Builder requestType(ShareRequestType requestType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AuditManagerRequest.BuilderImpl implements Builder {
        private String requestIdValue;

        private String requestType;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAssessmentFrameworkShareRequest model) {
            super(model);
            requestId(model.requestIdValue);
            requestType(model.requestType);
        }

        public final String getRequestId() {
            return requestIdValue;
        }

        public final void setRequestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
        }

        @Override
        public final Builder requestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
            return this;
        }

        public final String getRequestType() {
            return requestType;
        }

        public final void setRequestType(String requestType) {
            this.requestType = requestType;
        }

        @Override
        public final Builder requestType(String requestType) {
            this.requestType = requestType;
            return this;
        }

        @Override
        public final Builder requestType(ShareRequestType requestType) {
            this.requestType(requestType == null ? null : requestType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteAssessmentFrameworkShareRequest build() {
            return new DeleteAssessmentFrameworkShareRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
