/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListControlInsightsByControlDomainResponse extends AuditManagerResponse implements
        ToCopyableBuilder<ListControlInsightsByControlDomainResponse.Builder, ListControlInsightsByControlDomainResponse> {
    private static final SdkField<List<ControlInsightsMetadataItem>> CONTROL_INSIGHTS_METADATA_FIELD = SdkField
            .<List<ControlInsightsMetadataItem>> builder(MarshallingType.LIST)
            .memberName("controlInsightsMetadata")
            .getter(getter(ListControlInsightsByControlDomainResponse::controlInsightsMetadata))
            .setter(setter(Builder::controlInsightsMetadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controlInsightsMetadata").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ControlInsightsMetadataItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(ControlInsightsMetadataItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListControlInsightsByControlDomainResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONTROL_INSIGHTS_METADATA_FIELD, NEXT_TOKEN_FIELD));

    private final List<ControlInsightsMetadataItem> controlInsightsMetadata;

    private final String nextToken;

    private ListControlInsightsByControlDomainResponse(BuilderImpl builder) {
        super(builder);
        this.controlInsightsMetadata = builder.controlInsightsMetadata;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ControlInsightsMetadata property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasControlInsightsMetadata() {
        return controlInsightsMetadata != null && !(controlInsightsMetadata instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The control analytics data that the <code>ListControlInsightsByControlDomain</code> API returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasControlInsightsMetadata} method.
     * </p>
     * 
     * @return The control analytics data that the <code>ListControlInsightsByControlDomain</code> API returned.
     */
    public final List<ControlInsightsMetadataItem> controlInsightsMetadata() {
        return controlInsightsMetadata;
    }

    /**
     * <p>
     * The pagination token that's used to fetch the next set of results.
     * </p>
     * 
     * @return The pagination token that's used to fetch the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasControlInsightsMetadata() ? controlInsightsMetadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListControlInsightsByControlDomainResponse)) {
            return false;
        }
        ListControlInsightsByControlDomainResponse other = (ListControlInsightsByControlDomainResponse) obj;
        return hasControlInsightsMetadata() == other.hasControlInsightsMetadata()
                && Objects.equals(controlInsightsMetadata(), other.controlInsightsMetadata())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListControlInsightsByControlDomainResponse")
                .add("ControlInsightsMetadata", hasControlInsightsMetadata() ? controlInsightsMetadata() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "controlInsightsMetadata":
            return Optional.ofNullable(clazz.cast(controlInsightsMetadata()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListControlInsightsByControlDomainResponse, T> g) {
        return obj -> g.apply((ListControlInsightsByControlDomainResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AuditManagerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListControlInsightsByControlDomainResponse> {
        /**
         * <p>
         * The control analytics data that the <code>ListControlInsightsByControlDomain</code> API returned.
         * </p>
         * 
         * @param controlInsightsMetadata
         *        The control analytics data that the <code>ListControlInsightsByControlDomain</code> API returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlInsightsMetadata(Collection<ControlInsightsMetadataItem> controlInsightsMetadata);

        /**
         * <p>
         * The control analytics data that the <code>ListControlInsightsByControlDomain</code> API returned.
         * </p>
         * 
         * @param controlInsightsMetadata
         *        The control analytics data that the <code>ListControlInsightsByControlDomain</code> API returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlInsightsMetadata(ControlInsightsMetadataItem... controlInsightsMetadata);

        /**
         * <p>
         * The control analytics data that the <code>ListControlInsightsByControlDomain</code> API returned.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.auditmanager.model.ControlInsightsMetadataItem.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.auditmanager.model.ControlInsightsMetadataItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.auditmanager.model.ControlInsightsMetadataItem.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #controlInsightsMetadata(List<ControlInsightsMetadataItem>)}.
         * 
         * @param controlInsightsMetadata
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.auditmanager.model.ControlInsightsMetadataItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #controlInsightsMetadata(java.util.Collection<ControlInsightsMetadataItem>)
         */
        Builder controlInsightsMetadata(Consumer<ControlInsightsMetadataItem.Builder>... controlInsightsMetadata);

        /**
         * <p>
         * The pagination token that's used to fetch the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The pagination token that's used to fetch the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AuditManagerResponse.BuilderImpl implements Builder {
        private List<ControlInsightsMetadataItem> controlInsightsMetadata = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListControlInsightsByControlDomainResponse model) {
            super(model);
            controlInsightsMetadata(model.controlInsightsMetadata);
            nextToken(model.nextToken);
        }

        public final List<ControlInsightsMetadataItem.Builder> getControlInsightsMetadata() {
            List<ControlInsightsMetadataItem.Builder> result = ControlInsightsMetadataCopier
                    .copyToBuilder(this.controlInsightsMetadata);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setControlInsightsMetadata(Collection<ControlInsightsMetadataItem.BuilderImpl> controlInsightsMetadata) {
            this.controlInsightsMetadata = ControlInsightsMetadataCopier.copyFromBuilder(controlInsightsMetadata);
        }

        @Override
        public final Builder controlInsightsMetadata(Collection<ControlInsightsMetadataItem> controlInsightsMetadata) {
            this.controlInsightsMetadata = ControlInsightsMetadataCopier.copy(controlInsightsMetadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder controlInsightsMetadata(ControlInsightsMetadataItem... controlInsightsMetadata) {
            controlInsightsMetadata(Arrays.asList(controlInsightsMetadata));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder controlInsightsMetadata(Consumer<ControlInsightsMetadataItem.Builder>... controlInsightsMetadata) {
            controlInsightsMetadata(Stream.of(controlInsightsMetadata)
                    .map(c -> ControlInsightsMetadataItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListControlInsightsByControlDomainResponse build() {
            return new ListControlInsightsByControlDomainResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
