/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The deregistration policy for the data that's stored in Audit Manager. You can use this attribute to determine how
 * your data is handled when you <a
 * href="https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeregisterAccount.html">deregister Audit
 * Manager</a>.
 * </p>
 * <p>
 * By default, Audit Manager retains evidence data for two years from the time of its creation. Other Audit Manager
 * resources (including assessments, custom controls, and custom frameworks) remain in Audit Manager indefinitely, and
 * are available if you <a
 * href="https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_RegisterAccount.html">re-register Audit
 * Manager</a> in the future. For more information about data retention, see <a
 * href="https://docs.aws.amazon.com/audit-manager/latest/userguide/data-protection.html">Data Protection</a> in the
 * <i>Audit Manager User Guide</i>.
 * </p>
 * <important>
 * <p>
 * If you choose to delete all data, this action permanently deletes all evidence data in your account within seven
 * days. It also deletes all of the Audit Manager resources that you created, including assessments, custom controls,
 * and custom frameworks. Your data will not be available if you re-register Audit Manager in the future.
 * </p>
 * </important>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeregistrationPolicy implements SdkPojo, Serializable,
        ToCopyableBuilder<DeregistrationPolicy.Builder, DeregistrationPolicy> {
    private static final SdkField<String> DELETE_RESOURCES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deleteResources").getter(getter(DeregistrationPolicy::deleteResourcesAsString))
            .setter(setter(Builder::deleteResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deleteResources").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELETE_RESOURCES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String deleteResources;

    private DeregistrationPolicy(BuilderImpl builder) {
        this.deleteResources = builder.deleteResources;
    }

    /**
     * <p>
     * Specifies which Audit Manager data will be deleted when you deregister Audit Manager.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you set the value to <code>ALL</code>, all of your data is deleted within seven days of deregistration.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you set the value to <code>DEFAULT</code>, none of your data is deleted at the time of deregistration.
     * However, keep in mind that the Audit Manager data retention policy still applies. As a result, any evidence data
     * will be deleted two years after its creation date. Your other Audit Manager resources will continue to exist
     * indefinitely.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deleteResources}
     * will return {@link DeleteResources#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deleteResourcesAsString}.
     * </p>
     * 
     * @return Specifies which Audit Manager data will be deleted when you deregister Audit Manager.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         If you set the value to <code>ALL</code>, all of your data is deleted within seven days of
     *         deregistration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you set the value to <code>DEFAULT</code>, none of your data is deleted at the time of deregistration.
     *         However, keep in mind that the Audit Manager data retention policy still applies. As a result, any
     *         evidence data will be deleted two years after its creation date. Your other Audit Manager resources will
     *         continue to exist indefinitely.
     *         </p>
     *         </li>
     * @see DeleteResources
     */
    public final DeleteResources deleteResources() {
        return DeleteResources.fromValue(deleteResources);
    }

    /**
     * <p>
     * Specifies which Audit Manager data will be deleted when you deregister Audit Manager.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you set the value to <code>ALL</code>, all of your data is deleted within seven days of deregistration.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you set the value to <code>DEFAULT</code>, none of your data is deleted at the time of deregistration.
     * However, keep in mind that the Audit Manager data retention policy still applies. As a result, any evidence data
     * will be deleted two years after its creation date. Your other Audit Manager resources will continue to exist
     * indefinitely.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deleteResources}
     * will return {@link DeleteResources#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deleteResourcesAsString}.
     * </p>
     * 
     * @return Specifies which Audit Manager data will be deleted when you deregister Audit Manager.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         If you set the value to <code>ALL</code>, all of your data is deleted within seven days of
     *         deregistration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you set the value to <code>DEFAULT</code>, none of your data is deleted at the time of deregistration.
     *         However, keep in mind that the Audit Manager data retention policy still applies. As a result, any
     *         evidence data will be deleted two years after its creation date. Your other Audit Manager resources will
     *         continue to exist indefinitely.
     *         </p>
     *         </li>
     * @see DeleteResources
     */
    public final String deleteResourcesAsString() {
        return deleteResources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deleteResourcesAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeregistrationPolicy)) {
            return false;
        }
        DeregistrationPolicy other = (DeregistrationPolicy) obj;
        return Objects.equals(deleteResourcesAsString(), other.deleteResourcesAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeregistrationPolicy").add("DeleteResources", deleteResourcesAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deleteResources":
            return Optional.ofNullable(clazz.cast(deleteResourcesAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeregistrationPolicy, T> g) {
        return obj -> g.apply((DeregistrationPolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeregistrationPolicy> {
        /**
         * <p>
         * Specifies which Audit Manager data will be deleted when you deregister Audit Manager.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you set the value to <code>ALL</code>, all of your data is deleted within seven days of deregistration.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you set the value to <code>DEFAULT</code>, none of your data is deleted at the time of deregistration.
         * However, keep in mind that the Audit Manager data retention policy still applies. As a result, any evidence
         * data will be deleted two years after its creation date. Your other Audit Manager resources will continue to
         * exist indefinitely.
         * </p>
         * </li>
         * </ul>
         * 
         * @param deleteResources
         *        Specifies which Audit Manager data will be deleted when you deregister Audit Manager.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you set the value to <code>ALL</code>, all of your data is deleted within seven days of
         *        deregistration.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you set the value to <code>DEFAULT</code>, none of your data is deleted at the time of
         *        deregistration. However, keep in mind that the Audit Manager data retention policy still applies. As a
         *        result, any evidence data will be deleted two years after its creation date. Your other Audit Manager
         *        resources will continue to exist indefinitely.
         *        </p>
         *        </li>
         * @see DeleteResources
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeleteResources
         */
        Builder deleteResources(String deleteResources);

        /**
         * <p>
         * Specifies which Audit Manager data will be deleted when you deregister Audit Manager.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you set the value to <code>ALL</code>, all of your data is deleted within seven days of deregistration.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you set the value to <code>DEFAULT</code>, none of your data is deleted at the time of deregistration.
         * However, keep in mind that the Audit Manager data retention policy still applies. As a result, any evidence
         * data will be deleted two years after its creation date. Your other Audit Manager resources will continue to
         * exist indefinitely.
         * </p>
         * </li>
         * </ul>
         * 
         * @param deleteResources
         *        Specifies which Audit Manager data will be deleted when you deregister Audit Manager.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you set the value to <code>ALL</code>, all of your data is deleted within seven days of
         *        deregistration.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you set the value to <code>DEFAULT</code>, none of your data is deleted at the time of
         *        deregistration. However, keep in mind that the Audit Manager data retention policy still applies. As a
         *        result, any evidence data will be deleted two years after its creation date. Your other Audit Manager
         *        resources will continue to exist indefinitely.
         *        </p>
         *        </li>
         * @see DeleteResources
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeleteResources
         */
        Builder deleteResources(DeleteResources deleteResources);
    }

    static final class BuilderImpl implements Builder {
        private String deleteResources;

        private BuilderImpl() {
        }

        private BuilderImpl(DeregistrationPolicy model) {
            deleteResources(model.deleteResources);
        }

        public final String getDeleteResources() {
            return deleteResources;
        }

        public final void setDeleteResources(String deleteResources) {
            this.deleteResources = deleteResources;
        }

        @Override
        public final Builder deleteResources(String deleteResources) {
            this.deleteResources = deleteResources;
            return this;
        }

        @Override
        public final Builder deleteResources(DeleteResources deleteResources) {
            this.deleteResources(deleteResources == null ? null : deleteResources.toString());
            return this;
        }

        @Override
        public DeregistrationPolicy build() {
            return new DeregistrationPolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
