/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A collection of attributes that's used to create a delegation for an assessment in Audit Manager.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDelegationRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<CreateDelegationRequest.Builder, CreateDelegationRequest> {
    private static final SdkField<String> COMMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("comment")
            .getter(getter(CreateDelegationRequest::comment)).setter(setter(Builder::comment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comment").build()).build();

    private static final SdkField<String> CONTROL_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("controlSetId").getter(getter(CreateDelegationRequest::controlSetId))
            .setter(setter(Builder::controlSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controlSetId").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(CreateDelegationRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> ROLE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleType").getter(getter(CreateDelegationRequest::roleTypeAsString)).setter(setter(Builder::roleType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMENT_FIELD,
            CONTROL_SET_ID_FIELD, ROLE_ARN_FIELD, ROLE_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String comment;

    private final String controlSetId;

    private final String roleArn;

    private final String roleType;

    private CreateDelegationRequest(BuilderImpl builder) {
        this.comment = builder.comment;
        this.controlSetId = builder.controlSetId;
        this.roleArn = builder.roleArn;
        this.roleType = builder.roleType;
    }

    /**
     * <p>
     * A comment that's related to the delegation request.
     * </p>
     * 
     * @return A comment that's related to the delegation request.
     */
    public final String comment() {
        return comment;
    }

    /**
     * <p>
     * The unique identifier for the control set.
     * </p>
     * 
     * @return The unique identifier for the control set.
     */
    public final String controlSetId() {
        return controlSetId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The type of customer persona.
     * </p>
     * <note>
     * <p>
     * In <code>CreateAssessment</code>, <code>roleType</code> can only be <code>PROCESS_OWNER</code>.
     * </p>
     * <p>
     * In <code>UpdateSettings</code>, <code>roleType</code> can only be <code>PROCESS_OWNER</code>.
     * </p>
     * <p>
     * In <code>BatchCreateDelegationByAssessment</code>, <code>roleType</code> can only be <code>RESOURCE_OWNER</code>.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #roleType} will
     * return {@link RoleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #roleTypeAsString}.
     * </p>
     * 
     * @return The type of customer persona. </p> <note>
     *         <p>
     *         In <code>CreateAssessment</code>, <code>roleType</code> can only be <code>PROCESS_OWNER</code>.
     *         </p>
     *         <p>
     *         In <code>UpdateSettings</code>, <code>roleType</code> can only be <code>PROCESS_OWNER</code>.
     *         </p>
     *         <p>
     *         In <code>BatchCreateDelegationByAssessment</code>, <code>roleType</code> can only be
     *         <code>RESOURCE_OWNER</code>.
     *         </p>
     * @see RoleType
     */
    public final RoleType roleType() {
        return RoleType.fromValue(roleType);
    }

    /**
     * <p>
     * The type of customer persona.
     * </p>
     * <note>
     * <p>
     * In <code>CreateAssessment</code>, <code>roleType</code> can only be <code>PROCESS_OWNER</code>.
     * </p>
     * <p>
     * In <code>UpdateSettings</code>, <code>roleType</code> can only be <code>PROCESS_OWNER</code>.
     * </p>
     * <p>
     * In <code>BatchCreateDelegationByAssessment</code>, <code>roleType</code> can only be <code>RESOURCE_OWNER</code>.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #roleType} will
     * return {@link RoleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #roleTypeAsString}.
     * </p>
     * 
     * @return The type of customer persona. </p> <note>
     *         <p>
     *         In <code>CreateAssessment</code>, <code>roleType</code> can only be <code>PROCESS_OWNER</code>.
     *         </p>
     *         <p>
     *         In <code>UpdateSettings</code>, <code>roleType</code> can only be <code>PROCESS_OWNER</code>.
     *         </p>
     *         <p>
     *         In <code>BatchCreateDelegationByAssessment</code>, <code>roleType</code> can only be
     *         <code>RESOURCE_OWNER</code>.
     *         </p>
     * @see RoleType
     */
    public final String roleTypeAsString() {
        return roleType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        hashCode = 31 * hashCode + Objects.hashCode(controlSetId());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(roleTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDelegationRequest)) {
            return false;
        }
        CreateDelegationRequest other = (CreateDelegationRequest) obj;
        return Objects.equals(comment(), other.comment()) && Objects.equals(controlSetId(), other.controlSetId())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(roleTypeAsString(), other.roleTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDelegationRequest").add("Comment", comment()).add("ControlSetId", controlSetId())
                .add("RoleArn", roleArn()).add("RoleType", roleTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "comment":
            return Optional.ofNullable(clazz.cast(comment()));
        case "controlSetId":
            return Optional.ofNullable(clazz.cast(controlSetId()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "roleType":
            return Optional.ofNullable(clazz.cast(roleTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDelegationRequest, T> g) {
        return obj -> g.apply((CreateDelegationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CreateDelegationRequest> {
        /**
         * <p>
         * A comment that's related to the delegation request.
         * </p>
         * 
         * @param comment
         *        A comment that's related to the delegation request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);

        /**
         * <p>
         * The unique identifier for the control set.
         * </p>
         * 
         * @param controlSetId
         *        The unique identifier for the control set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlSetId(String controlSetId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The type of customer persona.
         * </p>
         * <note>
         * <p>
         * In <code>CreateAssessment</code>, <code>roleType</code> can only be <code>PROCESS_OWNER</code>.
         * </p>
         * <p>
         * In <code>UpdateSettings</code>, <code>roleType</code> can only be <code>PROCESS_OWNER</code>.
         * </p>
         * <p>
         * In <code>BatchCreateDelegationByAssessment</code>, <code>roleType</code> can only be
         * <code>RESOURCE_OWNER</code>.
         * </p>
         * </note>
         * 
         * @param roleType
         *        The type of customer persona. </p> <note>
         *        <p>
         *        In <code>CreateAssessment</code>, <code>roleType</code> can only be <code>PROCESS_OWNER</code>.
         *        </p>
         *        <p>
         *        In <code>UpdateSettings</code>, <code>roleType</code> can only be <code>PROCESS_OWNER</code>.
         *        </p>
         *        <p>
         *        In <code>BatchCreateDelegationByAssessment</code>, <code>roleType</code> can only be
         *        <code>RESOURCE_OWNER</code>.
         *        </p>
         * @see RoleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RoleType
         */
        Builder roleType(String roleType);

        /**
         * <p>
         * The type of customer persona.
         * </p>
         * <note>
         * <p>
         * In <code>CreateAssessment</code>, <code>roleType</code> can only be <code>PROCESS_OWNER</code>.
         * </p>
         * <p>
         * In <code>UpdateSettings</code>, <code>roleType</code> can only be <code>PROCESS_OWNER</code>.
         * </p>
         * <p>
         * In <code>BatchCreateDelegationByAssessment</code>, <code>roleType</code> can only be
         * <code>RESOURCE_OWNER</code>.
         * </p>
         * </note>
         * 
         * @param roleType
         *        The type of customer persona. </p> <note>
         *        <p>
         *        In <code>CreateAssessment</code>, <code>roleType</code> can only be <code>PROCESS_OWNER</code>.
         *        </p>
         *        <p>
         *        In <code>UpdateSettings</code>, <code>roleType</code> can only be <code>PROCESS_OWNER</code>.
         *        </p>
         *        <p>
         *        In <code>BatchCreateDelegationByAssessment</code>, <code>roleType</code> can only be
         *        <code>RESOURCE_OWNER</code>.
         *        </p>
         * @see RoleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RoleType
         */
        Builder roleType(RoleType roleType);
    }

    static final class BuilderImpl implements Builder {
        private String comment;

        private String controlSetId;

        private String roleArn;

        private String roleType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDelegationRequest model) {
            comment(model.comment);
            controlSetId(model.controlSetId);
            roleArn(model.roleArn);
            roleType(model.roleType);
        }

        public final String getComment() {
            return comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final String getControlSetId() {
            return controlSetId;
        }

        public final void setControlSetId(String controlSetId) {
            this.controlSetId = controlSetId;
        }

        @Override
        public final Builder controlSetId(String controlSetId) {
            this.controlSetId = controlSetId;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getRoleType() {
            return roleType;
        }

        public final void setRoleType(String roleType) {
            this.roleType = roleType;
        }

        @Override
        public final Builder roleType(String roleType) {
            this.roleType = roleType;
            return this;
        }

        @Override
        public final Builder roleType(RoleType roleType) {
            this.roleType(roleType == null ? null : roleType.toString());
            return this;
        }

        @Override
        public CreateDelegationRequest build() {
            return new CreateDelegationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
