/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.auditmanager.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a share request for a custom framework in Audit Manager.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssessmentFrameworkShareRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<AssessmentFrameworkShareRequest.Builder, AssessmentFrameworkShareRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(AssessmentFrameworkShareRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> FRAMEWORK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("frameworkId").getter(getter(AssessmentFrameworkShareRequest::frameworkId))
            .setter(setter(Builder::frameworkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frameworkId").build()).build();

    private static final SdkField<String> FRAMEWORK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("frameworkName").getter(getter(AssessmentFrameworkShareRequest::frameworkName))
            .setter(setter(Builder::frameworkName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frameworkName").build()).build();

    private static final SdkField<String> FRAMEWORK_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("frameworkDescription").getter(getter(AssessmentFrameworkShareRequest::frameworkDescription))
            .setter(setter(Builder::frameworkDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frameworkDescription").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(AssessmentFrameworkShareRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> SOURCE_ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceAccount").getter(getter(AssessmentFrameworkShareRequest::sourceAccount))
            .setter(setter(Builder::sourceAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceAccount").build()).build();

    private static final SdkField<String> DESTINATION_ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("destinationAccount").getter(getter(AssessmentFrameworkShareRequest::destinationAccount))
            .setter(setter(Builder::destinationAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationAccount").build())
            .build();

    private static final SdkField<String> DESTINATION_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("destinationRegion").getter(getter(AssessmentFrameworkShareRequest::destinationRegion))
            .setter(setter(Builder::destinationRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationRegion").build()).build();

    private static final SdkField<Instant> EXPIRATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("expirationTime").getter(getter(AssessmentFrameworkShareRequest::expirationTime))
            .setter(setter(Builder::expirationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expirationTime").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime").getter(getter(AssessmentFrameworkShareRequest::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdated").getter(getter(AssessmentFrameworkShareRequest::lastUpdated))
            .setter(setter(Builder::lastUpdated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdated").build()).build();

    private static final SdkField<String> COMMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("comment")
            .getter(getter(AssessmentFrameworkShareRequest::comment)).setter(setter(Builder::comment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comment").build()).build();

    private static final SdkField<Integer> STANDARD_CONTROLS_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("standardControlsCount").getter(getter(AssessmentFrameworkShareRequest::standardControlsCount))
            .setter(setter(Builder::standardControlsCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("standardControlsCount").build())
            .build();

    private static final SdkField<Integer> CUSTOM_CONTROLS_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("customControlsCount").getter(getter(AssessmentFrameworkShareRequest::customControlsCount))
            .setter(setter(Builder::customControlsCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customControlsCount").build())
            .build();

    private static final SdkField<String> COMPLIANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("complianceType").getter(getter(AssessmentFrameworkShareRequest::complianceType))
            .setter(setter(Builder::complianceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("complianceType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, FRAMEWORK_ID_FIELD,
            FRAMEWORK_NAME_FIELD, FRAMEWORK_DESCRIPTION_FIELD, STATUS_FIELD, SOURCE_ACCOUNT_FIELD, DESTINATION_ACCOUNT_FIELD,
            DESTINATION_REGION_FIELD, EXPIRATION_TIME_FIELD, CREATION_TIME_FIELD, LAST_UPDATED_FIELD, COMMENT_FIELD,
            STANDARD_CONTROLS_COUNT_FIELD, CUSTOM_CONTROLS_COUNT_FIELD, COMPLIANCE_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String frameworkId;

    private final String frameworkName;

    private final String frameworkDescription;

    private final String status;

    private final String sourceAccount;

    private final String destinationAccount;

    private final String destinationRegion;

    private final Instant expirationTime;

    private final Instant creationTime;

    private final Instant lastUpdated;

    private final String comment;

    private final Integer standardControlsCount;

    private final Integer customControlsCount;

    private final String complianceType;

    private AssessmentFrameworkShareRequest(BuilderImpl builder) {
        this.id = builder.id;
        this.frameworkId = builder.frameworkId;
        this.frameworkName = builder.frameworkName;
        this.frameworkDescription = builder.frameworkDescription;
        this.status = builder.status;
        this.sourceAccount = builder.sourceAccount;
        this.destinationAccount = builder.destinationAccount;
        this.destinationRegion = builder.destinationRegion;
        this.expirationTime = builder.expirationTime;
        this.creationTime = builder.creationTime;
        this.lastUpdated = builder.lastUpdated;
        this.comment = builder.comment;
        this.standardControlsCount = builder.standardControlsCount;
        this.customControlsCount = builder.customControlsCount;
        this.complianceType = builder.complianceType;
    }

    /**
     * <p>
     * The unique identifier for the share request.
     * </p>
     * 
     * @return The unique identifier for the share request.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The unique identifier for the shared custom framework.
     * </p>
     * 
     * @return The unique identifier for the shared custom framework.
     */
    public final String frameworkId() {
        return frameworkId;
    }

    /**
     * <p>
     * The name of the custom framework that the share request is for.
     * </p>
     * 
     * @return The name of the custom framework that the share request is for.
     */
    public final String frameworkName() {
        return frameworkName;
    }

    /**
     * <p>
     * The description of the shared custom framework.
     * </p>
     * 
     * @return The description of the shared custom framework.
     */
    public final String frameworkDescription() {
        return frameworkDescription;
    }

    /**
     * <p>
     * The status of the share request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ShareRequestStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the share request.
     * @see ShareRequestStatus
     */
    public final ShareRequestStatus status() {
        return ShareRequestStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the share request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ShareRequestStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the share request.
     * @see ShareRequestStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The Amazon Web Services account of the sender.
     * </p>
     * 
     * @return The Amazon Web Services account of the sender.
     */
    public final String sourceAccount() {
        return sourceAccount;
    }

    /**
     * <p>
     * The Amazon Web Services account of the recipient.
     * </p>
     * 
     * @return The Amazon Web Services account of the recipient.
     */
    public final String destinationAccount() {
        return destinationAccount;
    }

    /**
     * <p>
     * The Amazon Web Services Region of the recipient.
     * </p>
     * 
     * @return The Amazon Web Services Region of the recipient.
     */
    public final String destinationRegion() {
        return destinationRegion;
    }

    /**
     * <p>
     * The time when the share request expires.
     * </p>
     * 
     * @return The time when the share request expires.
     */
    public final Instant expirationTime() {
        return expirationTime;
    }

    /**
     * <p>
     * The time when the share request was created.
     * </p>
     * 
     * @return The time when the share request was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * Specifies when the share request was last updated.
     * </p>
     * 
     * @return Specifies when the share request was last updated.
     */
    public final Instant lastUpdated() {
        return lastUpdated;
    }

    /**
     * <p>
     * An optional comment from the sender about the share request.
     * </p>
     * 
     * @return An optional comment from the sender about the share request.
     */
    public final String comment() {
        return comment;
    }

    /**
     * <p>
     * The number of standard controls that are part of the shared custom framework.
     * </p>
     * 
     * @return The number of standard controls that are part of the shared custom framework.
     */
    public final Integer standardControlsCount() {
        return standardControlsCount;
    }

    /**
     * <p>
     * The number of custom controls that are part of the shared custom framework.
     * </p>
     * 
     * @return The number of custom controls that are part of the shared custom framework.
     */
    public final Integer customControlsCount() {
        return customControlsCount;
    }

    /**
     * <p>
     * The compliance type that the shared custom framework supports, such as CIS or HIPAA.
     * </p>
     * 
     * @return The compliance type that the shared custom framework supports, such as CIS or HIPAA.
     */
    public final String complianceType() {
        return complianceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(frameworkId());
        hashCode = 31 * hashCode + Objects.hashCode(frameworkName());
        hashCode = 31 * hashCode + Objects.hashCode(frameworkDescription());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sourceAccount());
        hashCode = 31 * hashCode + Objects.hashCode(destinationAccount());
        hashCode = 31 * hashCode + Objects.hashCode(destinationRegion());
        hashCode = 31 * hashCode + Objects.hashCode(expirationTime());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        hashCode = 31 * hashCode + Objects.hashCode(standardControlsCount());
        hashCode = 31 * hashCode + Objects.hashCode(customControlsCount());
        hashCode = 31 * hashCode + Objects.hashCode(complianceType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssessmentFrameworkShareRequest)) {
            return false;
        }
        AssessmentFrameworkShareRequest other = (AssessmentFrameworkShareRequest) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(frameworkId(), other.frameworkId())
                && Objects.equals(frameworkName(), other.frameworkName())
                && Objects.equals(frameworkDescription(), other.frameworkDescription())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(sourceAccount(), other.sourceAccount())
                && Objects.equals(destinationAccount(), other.destinationAccount())
                && Objects.equals(destinationRegion(), other.destinationRegion())
                && Objects.equals(expirationTime(), other.expirationTime())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(lastUpdated(), other.lastUpdated())
                && Objects.equals(comment(), other.comment())
                && Objects.equals(standardControlsCount(), other.standardControlsCount())
                && Objects.equals(customControlsCount(), other.customControlsCount())
                && Objects.equals(complianceType(), other.complianceType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssessmentFrameworkShareRequest").add("Id", id()).add("FrameworkId", frameworkId())
                .add("FrameworkName", frameworkName()).add("FrameworkDescription", frameworkDescription())
                .add("Status", statusAsString()).add("SourceAccount", sourceAccount())
                .add("DestinationAccount", destinationAccount()).add("DestinationRegion", destinationRegion())
                .add("ExpirationTime", expirationTime()).add("CreationTime", creationTime()).add("LastUpdated", lastUpdated())
                .add("Comment", comment()).add("StandardControlsCount", standardControlsCount())
                .add("CustomControlsCount", customControlsCount())
                .add("ComplianceType", complianceType() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "frameworkId":
            return Optional.ofNullable(clazz.cast(frameworkId()));
        case "frameworkName":
            return Optional.ofNullable(clazz.cast(frameworkName()));
        case "frameworkDescription":
            return Optional.ofNullable(clazz.cast(frameworkDescription()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "sourceAccount":
            return Optional.ofNullable(clazz.cast(sourceAccount()));
        case "destinationAccount":
            return Optional.ofNullable(clazz.cast(destinationAccount()));
        case "destinationRegion":
            return Optional.ofNullable(clazz.cast(destinationRegion()));
        case "expirationTime":
            return Optional.ofNullable(clazz.cast(expirationTime()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "lastUpdated":
            return Optional.ofNullable(clazz.cast(lastUpdated()));
        case "comment":
            return Optional.ofNullable(clazz.cast(comment()));
        case "standardControlsCount":
            return Optional.ofNullable(clazz.cast(standardControlsCount()));
        case "customControlsCount":
            return Optional.ofNullable(clazz.cast(customControlsCount()));
        case "complianceType":
            return Optional.ofNullable(clazz.cast(complianceType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssessmentFrameworkShareRequest, T> g) {
        return obj -> g.apply((AssessmentFrameworkShareRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssessmentFrameworkShareRequest> {
        /**
         * <p>
         * The unique identifier for the share request.
         * </p>
         * 
         * @param id
         *        The unique identifier for the share request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The unique identifier for the shared custom framework.
         * </p>
         * 
         * @param frameworkId
         *        The unique identifier for the shared custom framework.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frameworkId(String frameworkId);

        /**
         * <p>
         * The name of the custom framework that the share request is for.
         * </p>
         * 
         * @param frameworkName
         *        The name of the custom framework that the share request is for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frameworkName(String frameworkName);

        /**
         * <p>
         * The description of the shared custom framework.
         * </p>
         * 
         * @param frameworkDescription
         *        The description of the shared custom framework.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frameworkDescription(String frameworkDescription);

        /**
         * <p>
         * The status of the share request.
         * </p>
         * 
         * @param status
         *        The status of the share request.
         * @see ShareRequestStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShareRequestStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the share request.
         * </p>
         * 
         * @param status
         *        The status of the share request.
         * @see ShareRequestStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShareRequestStatus
         */
        Builder status(ShareRequestStatus status);

        /**
         * <p>
         * The Amazon Web Services account of the sender.
         * </p>
         * 
         * @param sourceAccount
         *        The Amazon Web Services account of the sender.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceAccount(String sourceAccount);

        /**
         * <p>
         * The Amazon Web Services account of the recipient.
         * </p>
         * 
         * @param destinationAccount
         *        The Amazon Web Services account of the recipient.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationAccount(String destinationAccount);

        /**
         * <p>
         * The Amazon Web Services Region of the recipient.
         * </p>
         * 
         * @param destinationRegion
         *        The Amazon Web Services Region of the recipient.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationRegion(String destinationRegion);

        /**
         * <p>
         * The time when the share request expires.
         * </p>
         * 
         * @param expirationTime
         *        The time when the share request expires.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expirationTime(Instant expirationTime);

        /**
         * <p>
         * The time when the share request was created.
         * </p>
         * 
         * @param creationTime
         *        The time when the share request was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * Specifies when the share request was last updated.
         * </p>
         * 
         * @param lastUpdated
         *        Specifies when the share request was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdated(Instant lastUpdated);

        /**
         * <p>
         * An optional comment from the sender about the share request.
         * </p>
         * 
         * @param comment
         *        An optional comment from the sender about the share request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);

        /**
         * <p>
         * The number of standard controls that are part of the shared custom framework.
         * </p>
         * 
         * @param standardControlsCount
         *        The number of standard controls that are part of the shared custom framework.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder standardControlsCount(Integer standardControlsCount);

        /**
         * <p>
         * The number of custom controls that are part of the shared custom framework.
         * </p>
         * 
         * @param customControlsCount
         *        The number of custom controls that are part of the shared custom framework.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customControlsCount(Integer customControlsCount);

        /**
         * <p>
         * The compliance type that the shared custom framework supports, such as CIS or HIPAA.
         * </p>
         * 
         * @param complianceType
         *        The compliance type that the shared custom framework supports, such as CIS or HIPAA.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceType(String complianceType);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String frameworkId;

        private String frameworkName;

        private String frameworkDescription;

        private String status;

        private String sourceAccount;

        private String destinationAccount;

        private String destinationRegion;

        private Instant expirationTime;

        private Instant creationTime;

        private Instant lastUpdated;

        private String comment;

        private Integer standardControlsCount;

        private Integer customControlsCount;

        private String complianceType;

        private BuilderImpl() {
        }

        private BuilderImpl(AssessmentFrameworkShareRequest model) {
            id(model.id);
            frameworkId(model.frameworkId);
            frameworkName(model.frameworkName);
            frameworkDescription(model.frameworkDescription);
            status(model.status);
            sourceAccount(model.sourceAccount);
            destinationAccount(model.destinationAccount);
            destinationRegion(model.destinationRegion);
            expirationTime(model.expirationTime);
            creationTime(model.creationTime);
            lastUpdated(model.lastUpdated);
            comment(model.comment);
            standardControlsCount(model.standardControlsCount);
            customControlsCount(model.customControlsCount);
            complianceType(model.complianceType);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getFrameworkId() {
            return frameworkId;
        }

        public final void setFrameworkId(String frameworkId) {
            this.frameworkId = frameworkId;
        }

        @Override
        public final Builder frameworkId(String frameworkId) {
            this.frameworkId = frameworkId;
            return this;
        }

        public final String getFrameworkName() {
            return frameworkName;
        }

        public final void setFrameworkName(String frameworkName) {
            this.frameworkName = frameworkName;
        }

        @Override
        public final Builder frameworkName(String frameworkName) {
            this.frameworkName = frameworkName;
            return this;
        }

        public final String getFrameworkDescription() {
            return frameworkDescription;
        }

        public final void setFrameworkDescription(String frameworkDescription) {
            this.frameworkDescription = frameworkDescription;
        }

        @Override
        public final Builder frameworkDescription(String frameworkDescription) {
            this.frameworkDescription = frameworkDescription;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ShareRequestStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getSourceAccount() {
            return sourceAccount;
        }

        public final void setSourceAccount(String sourceAccount) {
            this.sourceAccount = sourceAccount;
        }

        @Override
        public final Builder sourceAccount(String sourceAccount) {
            this.sourceAccount = sourceAccount;
            return this;
        }

        public final String getDestinationAccount() {
            return destinationAccount;
        }

        public final void setDestinationAccount(String destinationAccount) {
            this.destinationAccount = destinationAccount;
        }

        @Override
        public final Builder destinationAccount(String destinationAccount) {
            this.destinationAccount = destinationAccount;
            return this;
        }

        public final String getDestinationRegion() {
            return destinationRegion;
        }

        public final void setDestinationRegion(String destinationRegion) {
            this.destinationRegion = destinationRegion;
        }

        @Override
        public final Builder destinationRegion(String destinationRegion) {
            this.destinationRegion = destinationRegion;
            return this;
        }

        public final Instant getExpirationTime() {
            return expirationTime;
        }

        public final void setExpirationTime(Instant expirationTime) {
            this.expirationTime = expirationTime;
        }

        @Override
        public final Builder expirationTime(Instant expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastUpdated() {
            return lastUpdated;
        }

        public final void setLastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        @Override
        public final Builder lastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        public final String getComment() {
            return comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final Integer getStandardControlsCount() {
            return standardControlsCount;
        }

        public final void setStandardControlsCount(Integer standardControlsCount) {
            this.standardControlsCount = standardControlsCount;
        }

        @Override
        public final Builder standardControlsCount(Integer standardControlsCount) {
            this.standardControlsCount = standardControlsCount;
            return this;
        }

        public final Integer getCustomControlsCount() {
            return customControlsCount;
        }

        public final void setCustomControlsCount(Integer customControlsCount) {
            this.customControlsCount = customControlsCount;
        }

        @Override
        public final Builder customControlsCount(Integer customControlsCount) {
            this.customControlsCount = customControlsCount;
            return this;
        }

        public final String getComplianceType() {
            return complianceType;
        }

        public final void setComplianceType(String complianceType) {
            this.complianceType = complianceType;
        }

        @Override
        public final Builder complianceType(String complianceType) {
            this.complianceType = complianceType;
            return this;
        }

        @Override
        public AssessmentFrameworkShareRequest build() {
            return new AssessmentFrameworkShareRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
