/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class URL
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, URL> {
    private static final SdkField<String> HYPERLINK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("hyperlinkName").getter(URL.getter(URL::hyperlinkName)).setter(URL.setter(Builder::hyperlinkName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hyperlinkName").build()}).build();
    private static final SdkField<String> LINK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("link").getter(URL.getter(URL::link)).setter(URL.setter(Builder::link)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("link").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HYPERLINK_NAME_FIELD, LINK_FIELD));
    private static final long serialVersionUID = 1L;
    private final String hyperlinkName;
    private final String link;

    private URL(BuilderImpl builder) {
        this.hyperlinkName = builder.hyperlinkName;
        this.link = builder.link;
    }

    public final String hyperlinkName() {
        return this.hyperlinkName;
    }

    public final String link() {
        return this.link;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hyperlinkName());
        hashCode = 31 * hashCode + Objects.hashCode(this.link());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof URL)) {
            return false;
        }
        URL other = (URL)obj;
        return Objects.equals(this.hyperlinkName(), other.hyperlinkName()) && Objects.equals(this.link(), other.link());
    }

    public final String toString() {
        return ToString.builder((String)"URL").add("HyperlinkName", (Object)this.hyperlinkName()).add("Link", (Object)this.link()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "hyperlinkName": {
                return Optional.ofNullable(clazz.cast(this.hyperlinkName()));
            }
            case "link": {
                return Optional.ofNullable(clazz.cast(this.link()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<URL, T> g) {
        return obj -> g.apply((URL)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String hyperlinkName;
        private String link;

        private BuilderImpl() {
        }

        private BuilderImpl(URL model) {
            this.hyperlinkName(model.hyperlinkName);
            this.link(model.link);
        }

        public final String getHyperlinkName() {
            return this.hyperlinkName;
        }

        public final void setHyperlinkName(String hyperlinkName) {
            this.hyperlinkName = hyperlinkName;
        }

        @Override
        public final Builder hyperlinkName(String hyperlinkName) {
            this.hyperlinkName = hyperlinkName;
            return this;
        }

        public final String getLink() {
            return this.link;
        }

        public final void setLink(String link) {
            this.link = link;
        }

        @Override
        public final Builder link(String link) {
            this.link = link;
            return this;
        }

        public URL build() {
            return new URL(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, URL> {
        public Builder hyperlinkName(String var1);

        public Builder link(String var1);
    }
}

