/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.arczonalshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetManagedResourceResponse extends ArcZonalShiftResponse implements
        ToCopyableBuilder<GetManagedResourceResponse.Builder, GetManagedResourceResponse> {
    private static final SdkField<Map<String, Float>> APPLIED_WEIGHTS_FIELD = SdkField
            .<Map<String, Float>> builder(MarshallingType.MAP)
            .memberName("appliedWeights")
            .getter(getter(GetManagedResourceResponse::appliedWeights))
            .setter(setter(Builder::appliedWeights))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appliedWeights").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Float> builder(MarshallingType.FLOAT)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(GetManagedResourceResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetManagedResourceResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<ZonalShiftInResource>> ZONAL_SHIFTS_FIELD = SdkField
            .<List<ZonalShiftInResource>> builder(MarshallingType.LIST)
            .memberName("zonalShifts")
            .getter(getter(GetManagedResourceResponse::zonalShifts))
            .setter(setter(Builder::zonalShifts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("zonalShifts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ZonalShiftInResource> builder(MarshallingType.SDK_POJO)
                                            .constructor(ZonalShiftInResource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLIED_WEIGHTS_FIELD,
            ARN_FIELD, NAME_FIELD, ZONAL_SHIFTS_FIELD));

    private final Map<String, Float> appliedWeights;

    private final String arn;

    private final String name;

    private final List<ZonalShiftInResource> zonalShifts;

    private GetManagedResourceResponse(BuilderImpl builder) {
        super(builder);
        this.appliedWeights = builder.appliedWeights;
        this.arn = builder.arn;
        this.name = builder.name;
        this.zonalShifts = builder.zonalShifts;
    }

    /**
     * For responses, this returns true if the service returned a value for the AppliedWeights property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAppliedWeights() {
        return appliedWeights != null && !(appliedWeights instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A collection of key-value pairs that indicate whether resources are active in Availability Zones or not. The key
     * name is the Availability Zone where the resource is deployed. The value is 1 or 0.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAppliedWeights} method.
     * </p>
     * 
     * @return A collection of key-value pairs that indicate whether resources are active in Availability Zones or not.
     *         The key name is the Availability Zone where the resource is deployed. The value is 1 or 0.
     */
    public final Map<String, Float> appliedWeights() {
        return appliedWeights;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the resource.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the resource.
     * </p>
     * 
     * @return The name of the resource.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the ZonalShifts property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasZonalShifts() {
        return zonalShifts != null && !(zonalShifts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The zonal shifts that are currently active for a resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasZonalShifts} method.
     * </p>
     * 
     * @return The zonal shifts that are currently active for a resource.
     */
    public final List<ZonalShiftInResource> zonalShifts() {
        return zonalShifts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAppliedWeights() ? appliedWeights() : null);
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasZonalShifts() ? zonalShifts() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetManagedResourceResponse)) {
            return false;
        }
        GetManagedResourceResponse other = (GetManagedResourceResponse) obj;
        return hasAppliedWeights() == other.hasAppliedWeights() && Objects.equals(appliedWeights(), other.appliedWeights())
                && Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && hasZonalShifts() == other.hasZonalShifts() && Objects.equals(zonalShifts(), other.zonalShifts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetManagedResourceResponse")
                .add("AppliedWeights", hasAppliedWeights() ? appliedWeights() : null).add("Arn", arn()).add("Name", name())
                .add("ZonalShifts", hasZonalShifts() ? zonalShifts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appliedWeights":
            return Optional.ofNullable(clazz.cast(appliedWeights()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "zonalShifts":
            return Optional.ofNullable(clazz.cast(zonalShifts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetManagedResourceResponse, T> g) {
        return obj -> g.apply((GetManagedResourceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ArcZonalShiftResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetManagedResourceResponse> {
        /**
         * <p>
         * A collection of key-value pairs that indicate whether resources are active in Availability Zones or not. The
         * key name is the Availability Zone where the resource is deployed. The value is 1 or 0.
         * </p>
         * 
         * @param appliedWeights
         *        A collection of key-value pairs that indicate whether resources are active in Availability Zones or
         *        not. The key name is the Availability Zone where the resource is deployed. The value is 1 or 0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appliedWeights(Map<String, Float> appliedWeights);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the resource.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) for the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the resource.
         * </p>
         * 
         * @param name
         *        The name of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The zonal shifts that are currently active for a resource.
         * </p>
         * 
         * @param zonalShifts
         *        The zonal shifts that are currently active for a resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zonalShifts(Collection<ZonalShiftInResource> zonalShifts);

        /**
         * <p>
         * The zonal shifts that are currently active for a resource.
         * </p>
         * 
         * @param zonalShifts
         *        The zonal shifts that are currently active for a resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zonalShifts(ZonalShiftInResource... zonalShifts);

        /**
         * <p>
         * The zonal shifts that are currently active for a resource.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.arczonalshift.model.ZonalShiftInResource.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.arczonalshift.model.ZonalShiftInResource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.arczonalshift.model.ZonalShiftInResource.Builder#build()} is called
         * immediately and its result is passed to {@link #zonalShifts(List<ZonalShiftInResource>)}.
         * 
         * @param zonalShifts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.arczonalshift.model.ZonalShiftInResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #zonalShifts(java.util.Collection<ZonalShiftInResource>)
         */
        Builder zonalShifts(Consumer<ZonalShiftInResource.Builder>... zonalShifts);
    }

    static final class BuilderImpl extends ArcZonalShiftResponse.BuilderImpl implements Builder {
        private Map<String, Float> appliedWeights = DefaultSdkAutoConstructMap.getInstance();

        private String arn;

        private String name;

        private List<ZonalShiftInResource> zonalShifts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetManagedResourceResponse model) {
            super(model);
            appliedWeights(model.appliedWeights);
            arn(model.arn);
            name(model.name);
            zonalShifts(model.zonalShifts);
        }

        public final Map<String, Float> getAppliedWeights() {
            if (appliedWeights instanceof SdkAutoConstructMap) {
                return null;
            }
            return appliedWeights;
        }

        public final void setAppliedWeights(Map<String, Float> appliedWeights) {
            this.appliedWeights = AppliedWeightsCopier.copy(appliedWeights);
        }

        @Override
        public final Builder appliedWeights(Map<String, Float> appliedWeights) {
            this.appliedWeights = AppliedWeightsCopier.copy(appliedWeights);
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<ZonalShiftInResource.Builder> getZonalShifts() {
            List<ZonalShiftInResource.Builder> result = ZonalShiftsInResourceCopier.copyToBuilder(this.zonalShifts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setZonalShifts(Collection<ZonalShiftInResource.BuilderImpl> zonalShifts) {
            this.zonalShifts = ZonalShiftsInResourceCopier.copyFromBuilder(zonalShifts);
        }

        @Override
        public final Builder zonalShifts(Collection<ZonalShiftInResource> zonalShifts) {
            this.zonalShifts = ZonalShiftsInResourceCopier.copy(zonalShifts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder zonalShifts(ZonalShiftInResource... zonalShifts) {
            zonalShifts(Arrays.asList(zonalShifts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder zonalShifts(Consumer<ZonalShiftInResource.Builder>... zonalShifts) {
            zonalShifts(Stream.of(zonalShifts).map(c -> ZonalShiftInResource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetManagedResourceResponse build() {
            return new GetManagedResourceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
