/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appstream.AppStreamClient;
import software.amazon.awssdk.services.appstream.model.DescribeImagePermissionsRequest;
import software.amazon.awssdk.services.appstream.model.DescribeImagePermissionsResponse;

public class DescribeImagePermissionsIterable
implements SdkIterable<DescribeImagePermissionsResponse> {
    private final AppStreamClient client;
    private final DescribeImagePermissionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeImagePermissionsIterable(AppStreamClient client, DescribeImagePermissionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeImagePermissionsResponseFetcher();
    }

    public Iterator<DescribeImagePermissionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class DescribeImagePermissionsResponseFetcher
    implements SyncPageFetcher<DescribeImagePermissionsResponse> {
        private DescribeImagePermissionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeImagePermissionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeImagePermissionsResponse nextPage(DescribeImagePermissionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeImagePermissionsIterable.this.client.describeImagePermissions(DescribeImagePermissionsIterable.this.firstRequest);
            }
            return DescribeImagePermissionsIterable.this.client.describeImagePermissions((DescribeImagePermissionsRequest)((Object)DescribeImagePermissionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

