/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appstream.AppStreamClient;
import software.amazon.awssdk.services.appstream.internal.UserAgentUtils;
import software.amazon.awssdk.services.appstream.model.DescribeAppBlockBuildersRequest;
import software.amazon.awssdk.services.appstream.model.DescribeAppBlockBuildersResponse;

public class DescribeAppBlockBuildersIterable
implements SdkIterable<DescribeAppBlockBuildersResponse> {
    private final AppStreamClient client;
    private final DescribeAppBlockBuildersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeAppBlockBuildersIterable(AppStreamClient client, DescribeAppBlockBuildersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeAppBlockBuildersResponseFetcher();
    }

    public Iterator<DescribeAppBlockBuildersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class DescribeAppBlockBuildersResponseFetcher
    implements SyncPageFetcher<DescribeAppBlockBuildersResponse> {
        private DescribeAppBlockBuildersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeAppBlockBuildersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeAppBlockBuildersResponse nextPage(DescribeAppBlockBuildersResponse previousPage) {
            if (previousPage == null) {
                return DescribeAppBlockBuildersIterable.this.client.describeAppBlockBuilders(DescribeAppBlockBuildersIterable.this.firstRequest);
            }
            return DescribeAppBlockBuildersIterable.this.client.describeAppBlockBuilders((DescribeAppBlockBuildersRequest)((Object)DescribeAppBlockBuildersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

